#ifndef _FW_I18N_H
#define _FW_I18N_H

#include "zcore_type.h"
#include "os_type.h"

#ifdef __cplusplus
extern "C" {
#endif  

typedef struct msg_domain
{
    const ZCHAR*		name;
    ZUINT32 		nstrings;
    ZCHAR**				orig_tab;
    ZCHAR**				trans_tab;
    ZUINT32 		hash_size;
    ZUINT32*	hash_tab;
};


#define _(msgid)   tp_i18n_get_text(msgid)
#define N_(msgid)   msgid

/**
* ƣtp_i18n_reg_textdomain 
* ӵб 
* ˵ 
(IN)dms				:		Ϣṹָ 
(OUT)<>
*   ֵ עɹTRUEʧܷFALSE
* ˵ ע(,Ӣ,,....)
**/
ZBOOL tp_i18n_reg_textdomain(struct msg_domain **dms);



/**
* ƣtp_i18n_set_language 
*  
* ˵ 
(IN) language	:		
(OUT) <>
*   ֵ	ɹ TRUE򷵻FALSE
* ˵
**/
ZBOOL tp_i18n_set_language(const ZCHAR *language);


/**
* ƣtp_i18n_get_language
* ȡǰ
* ˵ 
(IN) <>
(OUT) <>
*   ֵ ǰ
* ˵<> 
**/
const ZCHAR* tp_i18n_get_language();


/**
* ƣtp_i18n_get_text 
* Դִȡִ
* ˵ 
(IN)msgid:ԭַϢ
 (OUT) <>
*   ֵ ַ
* ˵ <> 
**/
const ZCHAR* tp_i18n_get_text(const ZCHAR *msgid);

#ifdef __cplusplus
}
#endif  

#endif

