#ifndef _APP_GLOBAL_DEFINES_H_
#define _APP_GLOBAL_DEFINES_H_

/*
 * define app debug switch	macro
 */
#define _APP_DEBUG_SWITCH_

/*
 * define phone screen size control macro
 */
//#define PHONE_SCREEN_240_320

/*
 * redefined key value code
 */
// ּ
#define KEY_1              SCANCODE_1    // 1
#define KEY_2              SCANCODE_2    // 2
#define KEY_3              SCANCODE_3    // 3
#define KEY_4              SCANCODE_4    // 4
#define KEY_5              SCANCODE_5    // 5
#define KEY_6              SCANCODE_6    // 6
#define KEY_7              SCANCODE_7    // 7
#define KEY_8              SCANCODE_8    // 8
#define KEY_9              SCANCODE_9    // 9
#define KEY_0              SCANCODE_0    // 0
#define KEY_ASTERISK       SCANCODE_F6	// *
#define KEY_NUMBERSIGN     SCANCODE_F7	// #

// ܼ
#define KEY_LSK			SCANCODE_F2    // 
#define KEY_RSK			SCANCODE_F3    // 
#define KEY_UP			SCANCODE_CURSORBLOCKUP		// ()
#define KEY_DOWN		SCANCODE_CURSORBLOCKDOWN		// ()
#define KEY_LEFT			SCANCODE_CURSORBLOCKLEFT		// ()
#define KEY_RIGHT		SCANCODE_CURSORBLOCKRIGHT		// ()
#define KEY_SEND		SCANCODE_F1   		// ż
#define KEY_POWER		SCANCODE_ESCAPE 	// һ(POWER)
#define KEY_REDIAL		SCANCODE_F5			// ز(P910A1P950VP)
#define KEY_SPEAKER		SCANCODE_F11		// (P910A1)

// 
#define KEY_FAST_DIAL_1		SCANCODE_RIGHTCONTROL 	// 1(P910A1)
#define KEY_FAST_DIAL_2		SCANCODE_CONTROL		// 2(P910A1)
#define KEY_FAST_DIAL_3		SCANCODE_KEYPADDIVIDE	// 3(P910A1)
#define KEY_FAST_DIAL_4		SCANCODE_PRINTSCREEN	// 4(P910A1)
#define KEY_FAST_DIAL_5		SCANCODE_LESS		// 5(P910A1)
#define KEY_FAST_DIAL_6		SCANCODE_KEYPADENTER	// (P910A1)
#define KEY_SHORTCUT		SCANCODE_F8				// ü(P910A1)
#define KEY_VOLUME			SCANCODE_F9				// (P910A1)
#define KEY_FORECAST		SCANCODE_F12			// Ԥ(P910A1)
#define KEY_SMS				SCANCODE_F10			// ż(P910A1)
#define KEY_IPCODE			SCANCODE_PAGEUP		// 12580(P910A1)
#define KEY_SOS				SCANCODE_HOME			// SOS(P910A1)


#define KEY_OK			SCANCODE_F4
#define KEY_VP			SCANCODE_F5
#define KEY_PTT			SCANCODE_F5
#define KEY_SK1			SCANCODE_F8
#define KEY_SK2			SCANCODE_F9
#define KEY_SK3         SCANCODE_F10
#define KEY_SK4         SCANCODE_F11
#define KEY_BACK        SCANCODE_F12
#define KEY_CLEAR       SCANCODE_BACKSPACE
#define KEY_SIDE_UP     KEY_SK2
#define KEY_SIDE_DOWN   KEY_SK4
#define KEY_CAMERA      KEY_SK3
#define KEY_CALLTONE    KEY_CAMERA
#define KEY_FAST_DIAL_7 SCANCODE_7

/*
 * define switch applications key
 */
#define KEY_SWITCH       KEY_POWER

/*
 * define phone window region size
 */

#define PHONEWIN_WIDTH            128
#define PHONEWIN_HEIGHT           128
#define CAPTIONBAR_H               0
#define SOFTKEYBAR_H               18
#define MENU_ITEM_H                18
#define WIN_TITLE_H                32

#ifndef SCREEN_W
#define SCREEN_W                    PHONEWIN_WIDTH
#endif

#ifndef SCREEN_H
#define SCREEN_H                    PHONEWIN_HEIGHT
#endif

#define SOFTKEY_H                   SOFTKEYBAR_H

#define MAINWINDOW_LX             0
#define MAINWINDOW_TY             CAPTIONBAR_H
#define MAINWINDOW_W              PHONEWIN_WIDTH
#define MAINWINDOW_H              (PHONEWIN_HEIGHT - CAPTIONBAR_H - SOFTKEYBAR_H)



#define MSGBOX_LX                   15
#define MSGBOX_TY                   40
#define MSGBOX_W                    210
#define MSGBOX_H                    201

/*
 * define system and user config file path
 */
#define APP_SYSTEM_PATH	          "/flash/app2/system/"
#define APP_USER_PATH	          "/flash/app2/user/"

#define APP_RESCFG_APPLICATIONS    APP_SYSTEM_PATH"rescfg/applications/"
#define APP_RESCFG_SETTINGS        APP_SYSTEM_PATH"rescfg/settings/"
#define APP_RESCFG_PUBLIC          APP_SYSTEM_PATH"rescfg/public/"
#define APP_RESCFG_SERVER          APP_SYSTEM_PATH"rescfg/server/"
#define APP_RESCFG_TESTING         APP_SYSTEM_PATH"rescfg/testing/"


/*
 * define app general error code
 */
#define APP_ERR_SUCCESS             0x00000000
#define APP_ERR_FAILURE             0xffffffff

/*
 * only for handle some specific case
 */
#define APP_ERR_NO_DEFAULT         1000

/*
 * define max app file name length(bytes)
 */
#define APP_FILE_NAME_MAX_LEN      255

/*
 * define max app main window number
 */
#define APP_MAIN_WIN_MAX_NUM        32

/*
 * define invalid app id value
 */
#define APP_ID_INVALID             0x00

/*
 * app debug info output macro
 */
#ifdef _APP_DEBUG_SWITCH_
#define APP_OUTPUT_DEBUG_INFO(a)  \
  	     printf(a)
#else
#define APP_OUTPUT_DEBUG_INFO(a)
#endif


#include "fw_i18n.h"

#define APP_STR_OK                           N_("Ok")          /*ȷ*/
#define APP_STR_CANCEL                       N_("Cancel")      /*ȡ*/
#define APP_STR_YES                          N_("Yes")         /**/
#define APP_STR_NO                           N_("No")          /**/
#define APP_STR_SELECT                       N_("Select")      /*ѡ*/
#define APP_STR_BACK                         N_("Back")        /**/
#define APP_STR_NULL                         N_(" ")           /* */
#define APP_STR_OPTIONS                      N_("Opt.")     /*ѡ*/
#define APP_STR_CLEAN                        N_("Clean_global")/**/
#define APP_STR_SAVE                         N_("Save")	       /**/

#define APP_STR_VERSION                   N_("V1.0.0")

#ifndef ZTE_NO_MANUAL_SELNET_IN_SET
#define APP_GD_NET_CHOOSE 1
#endif

#endif /* _APP_GLOBAL_DEFINES_H_ */
