/************************************************
*FileName      : os_type.h
*Description   :
*Note          :
*
*Change History:
************************************************/
#ifndef OS_TYPE_H
#define OS_TYPE_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>

/*-------------------------- extern variable declaration-----------------------*/

/*--------------------------- variable declaration ----------------------------*/

/*-------------------- constants and data type declaration ---------------------*/
//typedef char CHAR;
typedef signed char SINT8;
typedef signed short int SINT16;
#ifdef WIN32
#ifdef _2D_EFFECTS 
typedef signed long SINT32;//typedef signed long int SINT32;
#else
typedef signed long int SINT32;
#endif
#else
typedef signed long int SINT32;
#endif

#ifndef TYPE_UINT8
#define TYPE_UINT8
typedef unsigned char UINT8;
#endif

#ifndef TYPE_UINT16
#define TYPE_UINT16
typedef unsigned short int UINT16;
#endif

typedef unsigned long int UINT32;
typedef unsigned long long    UINT64;

/* typedef void          VOID; */
#define VOID void

typedef float FLOAT32;
typedef double FLOAT64;

/*consant definitions*/
#ifndef BOOL
#define BOOL int

#ifndef TRUE
#define TRUE (BOOL)1
#endif
#ifndef FALSE
#define FALSE (BOOL)0
#endif

#endif

/*-----------macro declaration-------------------------------------*/
/*enum type redefinition*/
#ifndef ENUM 
#define ENUM enum
#endif

/*union type redefinition*/
#ifndef UNION 
#define UNION union
#endif

/*const qualify keyword*/
#ifndef TYPE_CONST 
#define TYPE_CONST
#define CONST const
#endif

#ifndef EXTERN 
#define EXTERN extern
#endif

#if 1

/* STATIC DEFINATION */
#ifndef STATIC 
#define STATIC static
#endif  /* STATIC */

/* INLINE DEFINATION */
#ifndef INLINE
#define INLINE __inline
#endif  /* INLINE */

#else  /* #if 0 */

/*static -- qualifid macro definition*/
#ifndef STATIC
#ifdef DEBUG_SWITCH
#define STATIC
#else
#define STATIC static
#endif
#endif

/*inline -- qualified macro definition*/
#ifdef DEBUG_SWITCH 
#define INLINE 
#else /*#ifdef DEBUG_SWITCH*/
#define INLINE 
#endif

#endif  /* #if 0 */

/*null pointer*/
#define NULLPTR (void *)0
#define OS_NULLPTR (void *)0

#ifndef NULL
#define NULL NULLPTR
#endif


//typedef UINT32 OS_STATUS;
//typedef SINT32 OS_FD;

//typedef VOID (*OS_THREAD_ENTRY)(VOID* param);
typedef VOID (*OS_FUNC_ENTRY)(VOID *);


#define OS_MAX_NAME_LEN 32


/* API input parameters and general constants.  */
#define OS_NO_WAIT          0x00000000
#define OS_WAIT_FOREVER     0xffffffff
#define OS_AUTO_ACTIVATE    0x1
#define OS_DONT_ACTIVATE    0x0
#define OS_AUTO_LOAD        0x2
#define OS_DONT_LOAD        0x0
#ifndef OS_TRUE
#define OS_TRUE             1
#endif
#ifndef OS_FALSE
#define OS_FALSE            0
#endif

#ifndef OS_AVAILABLE
#define OS_AVAILABLE        1
#endif
#ifndef OS_UNAVAILABLE
#define OS_UNAVAILABLE      0
#endif


/*the macro created to define the state of timer*/
#define OS_TIMER_ACTIVE 1
#define OS_TIMER_STOP 0


/* API return values.  */
#ifndef OS_SUCCESS
#define OS_SUCCESS          0x00000000
#endif
#ifndef OS_FAILURE
#define OS_FAILURE          0xffffffff
#endif


#ifndef NSIG 
#define NSIG    32
#endif


#ifndef SIG_BLOCK
#define SIG_BLOCK           1   /* Block signals.  */
#endif

#ifndef SIG_UNBLOCK
#define SIG_UNBLOCK     2       /* Unblock signals.  */
#endif

#ifndef SIG_SETMASK
#define SIG_SETMASK     3       /* Set the set of blocked signals.  */
#endif

#endif

