#ifndef DISPLAY_H
#define DISPLAY_H
#include "zcore_type.h"
/*Message Id*/
/********************************************************************
*Name: TPM_LCD_COVER_OPEN
*Purpose: this message is send when phone cover opened from close state
*Param: N/A
*********************************************************************/
#define TPM_LCD_COVER_OPEN        (MSG_ID_MAN_DISPLAY_BASE + 1)
 
/********************************************************************
*Name: TPM_LCD_COVER_CLOSE
*Purpose: this message is send when phone cover closed from open state
*Param: N/A
*********************************************************************/
#define TPM_LCD_COVER_CLOSE       (MSG_ID_MAN_DISPLAY_BASE + 2) 
#define TPM_LCD_BACKLIGHT_END     (MSG_ID_MAN_DISPLAY_BASE + 3) //ںʱϲ㷢Ϣ
#define TPM_LCD_BACKLIGHT_START   (MSG_ID_MAN_DISPLAY_BASE + 4) //ڵĻʱϲ㷢Ϣ
/*-------------------------- extern variable declaration-----------------------*/

/*------------------ constants and data type declaration ----------------------*/

typedef enum _MAN_PIXEL_FORMAT_
{
        PIX_FMT_RGB565 = 1,      /* RGB565 color format for 16 bpp */
        PIX_FMT_RGB332 ,         /* RGB332 color format for 8 bpp*/
        PIX_FMT_RGB666 ,         /* RGB666 color format for 18 bpp, 260k colors*/
        PIX_FMT_RGB555,          /* always stored in cpu endianness, most significant bit to 1 */
        PIX_FMT_YUV420P,         /* Planar YUV 4:2:0 (1 Cr & Cb sample per 2x2 Y samples)*/
        PIX_FMT_YUV422,    
        PIX_FMT_RGB24,           /* Packed pixel, 3 bytes per pixel, RGBRGB...*/
        PIX_FMT_BGR24,           /*  Packed pixel, 3 bytes per pixel, BGRBGR...*/
        PIX_FMT_YUV422P,         /*  Planar YUV 4:2:2 (1 Cr & Cb sample per 2x1 Y samples)*/
        PIX_FMT_YUV444P,         /*  Planar YUV 4:4:4 (1 Cr & Cb sample per 1x1 Y samples)*/
        PIX_FMT_RGBA32,          /*  Packed pixel, 4 bytes per pixel, BGRABGRA..., stored in cpu endianness*/
        PIX_FMT_YUV410P,         /*  Planar YUV 4:1:0 (1 Cr & Cb sample per 4x4 Y samples)*/
        PIX_FMT_YUV411P,         /*  Planar YUV 4:1:1 (1 Cr & Cb sample per 4x1 Y samples)*/
        PIX_FMT_GRAY8,
        PIX_FMT_MONOWHITE,       /*  0 is white */
        PIX_FMT_MONOBLACK,       /*  0 is black */
        PIX_FMT_PAL8,            /*  8 bit with RGBA palette */
        PIX_FMT_YUVJ420P,        /*  Planar YUV 4:2:0 full scale (jpeg)*/
        PIX_FMT_YUVJ422P,        /*  Planar YUV 4:2:2 full scale (jpeg)*/
        PIX_FMT_YUVJ444P,        /*  Planar YUV 4:4:4 full scale (jpeg)*/
        PIX_FMT_XVMC_MPEG2_MC,   /*  XVideo Motion Acceleration via common packet passing*/
        PIX_FMT_XVMC_MPEG2_IDCT,
        PIX_FMT_NB              /*  the undefined pixel format*/
} MAN_PIXEL_FORMAT;

/* info of lcd hardware  */
typedef struct _MAN_LCD_SCREEN_
{
        ZUINT16              width;      /*LCD width*/
        ZUINT16              height;     /*LCD height*/
        MAN_PIXEL_FORMAT    type;       /*LCD pixel format*/
        ZUINT16              bpp;        /*LCD color depth(bits/pixel) */
        ZUINT16              rlen;       /*LCD Length of one raster line in bytes*/
        ZCHAR                *fb_ptr;    /*LCD frame buffer ptr*/
}MAN_LCD_SCREEN;

/* info of lcd refresh screen  */
typedef struct  _MAN_LCD_REFRESH_
{    
        ZUINT16     startX;
        ZUINT16     startY;
        ZUINT16     width;
        ZUINT16     height;
}MAN_LCD_REFRESH;

/* the working mode of lcd*/
typedef enum _MAN_LCD_MODE_
{
    FULL,       /* full working mode */
    STANDBY     /* saving power mode */
}MAN_LCD_MODE;

typedef VOID (*TP_LCD_BACKLIGHT_START_FUN)(VOID);
typedef VOID (*TP_LCD_BACKLIGHT_END_FUN)(VOID);
/*--------------------------- variable declaration ----------------------------*/

/*------------------------------ function prototype ---------------------------*/
/* the display function*/
ZSINT32 tp_man_lcd_init(ZVOID);
ZSINT32 tp_man_lcd_release(ZVOID);
ZSINT32 tp_man_lcd_get_info(MAN_LCD_SCREEN *screen_ptr);
ZSINT32 tp_man_lcd_refresh(MAN_LCD_REFRESH *area_ptr);

/* the function about main lcd workmode management*/
MAN_LCD_MODE  tp_man_lcd_get_mode(ZVOID);
ZSINT32 tp_man_lcd_set_mode(MAN_LCD_MODE mode_en);
/* the function about main lcd backlight management*/
ZBOOL   tp_man_lcd_backlight_state(ZVOID);
ZSINT32 tp_man_lcd_backlight_start(ZUINT32 brightlight);
ZSINT32 tp_man_lcd_backlight_end(ZVOID);
VOID tp_man_lcd_backlight_register_fun(TP_LCD_BACKLIGHT_START_FUN startFun, TP_LCD_BACKLIGHT_END_FUN endFun);
ZBOOL   tp_man_lcd_set_flag(ZBOOL param);

/* the function about sub lcd workmode management */
MAN_LCD_MODE  tp_man_sublcd_get_mode(ZVOID);
ZSINT32 tp_man_sublcd_set_mode(MAN_LCD_MODE mode_en);
/* the function about sub lcd backlight management */
ZBOOL   tp_man_sublcd_backlight_state(ZVOID);
ZSINT32 tp_man_sublcd_backlight_start(ZUINT32 brightlight);
ZSINT32 tp_man_sublcd_backlight_end(ZVOID);
ZSINT32 tp_man_lcd_backlight_get_value(ZUINT16 *param);

#endif /*DISPLAY_H*/

