#ifndef _LOGIC_LAYER__H
#define _LOGIC_LAYER__H

#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
#define LAYER_NORMAL       0x0001
#define LAYER_PRIMARY      0x0002

#define LAYER_COLORKEY     0x0010
#define LAYER_ALPHA        0x0020
#define LAYER_MASK         0x0040
#define LAYER_BLENDINGRECT 0x0080

#define PRIMARY_LOGICLAYER_ID 0
/* ߼ͼ */
#define MAX_LOGIC_LAYERS      8

/*
* Լ:
* desktopϢʱʱҪ layer idģ SendMessage(),
* PostMessage()ЩӿûжĲɹãʿmessage id 
* 4λǰ͵Ϣlayer id .
* ϵͳûϢʹߵ 4 bitsmsg 31 -- 28 λ .
*/
#define GET_LOGICLAYER_ID(msg) ((msg>>28)&0xF)
#define MASK_MSG(msg)     (0x0FFFFFFF & msg)
#define MAKE_MSG(msg,id)  (((0xF&id)<<28)|(0x0FFFFFFF & msg))


/**************************************************************************
 *                                                                *
 **************************************************************************/
typedef ZUINT32 HLOGICLAYER;

typedef enum _rotate_angle
{
    ROTATE_ANGLE_0   = 0,
    ROTATE_ANGLE_90  = 90,
    ROTATE_ANGLE_180 = 180,
    ROTATE_ANGLE_270 = 270
}ROTATE_ANGLE;

typedef struct _WindowStack
{
    struct _LogicLayer_T* pLayer;        //ջ߼ͼ

    ZORDERINFO sg_MainWinZOrder;         //ͨջ
    ZORDERINFO sg_MiddleWinZOrder;       //м򴰿ջ
    ZORDERINFO sg_TopMostWinZOrder;      //öջ

    RECT       g_rcScr;                  //ǰջ߼ͼС
    GCRINFO    sg_ScrGCRInfo;            //ǰջ߼ͼȫּ

    PMAINWIN   __mgs_old_under_pointer;  //
    PMAINWIN   __mgs_captured_main_win;  //
    PMAINWIN   __mg_active_mainwnd;      //ǰջĻ
    HWND       __mg_ime_wnd;             //IME
    HWND       sg_hCaretWnd;             //
    ZUINT      sg_uCaretBTime;           //˸ʱ
    ZBOOL      g_IsCaretStoped;

    HWND       __mg_capture_wnd;         //capture
    ZBOOL      __mg_capture_stop;        //
    HWND       _mgs_old_under_p;         //

    T_DCMgt_DC g_tDCMgtDeviceDC;         //ǰջȫDC
}WindowStack;

/* LOGICLAYER ʹõ͸ȱϢ */
typedef struct _LogicLayerMask
{
    ZCHAR    *pBits;  //͸ȱڴַ

    ZSINT32  iWidth;  //͸ȱڴ
    ZSINT32  iHeight; //͸ȱڴ߶
    
    ZSINT32  BPP;     //͸ȱÿһռõֽһΪ[1]
    ZSINT32  pitch;   //͸Ϣڴһռõֽ
}LOGICLAYERMASK;

/*****************************************************
* Layer  caps ˵:
* 
* layercolorkeyLAYER_COLORKEYԣ
*
* layerȫalpha(layerϵÿһ
* 㶼ʹͬ͸ֵ)ҪLAYER_ALPHAԣ
*
* layer͸maskϢҪ
* LAYER_MASKԣ
*
* ԵȼΪ
*
* (LAYER_COLORKEY = LAYER_ALPHA) < LAYER_MASK
*
*****************************************************/
typedef struct _LogicLayer_T
{
    ZSINT32   id;             //߼ͼID
    ZUINT32   caps;           //߼ͼ
    ZCHAR     description[16];//߼ͼ
    ZSINT32   enabled;        //߼ͼǷñ־
    ZUINT32   width;          //߼ͼ
    ZUINT32   height;         //߼ͼ߶
    ZSINT32   rotation;       //߼ͼתǶ
    GC*       pGC;            //߼ͼӦGC

    ZUINT32   lock;           //߼ͼ㻥
    ZSINT32   exclusive;      //߼ͼǷռ

    WindowStack* pWinStack;   //߼ͼ㴰ջ
    ZVOID*    pAddData;       //߼ͼ㸽

    ZUINT32   colorkey;       //߼ͼ͸ɫ
    ZUINT32   opacity;        //߼ͼȫ͸ֵ
    LOGICLAYERMASK mask;      //߼ͼʹõ͸ȱ
    RECT      blendingRect;   //߼ͼ
    ZSINT32   AttachID;       //߼󶨵ɻͼ
}LOGICLAYER;
typedef LOGICLAYER* PLOGICLAYER;


typedef struct _LogicLayerInfo
{
    ZUINT32 type;          //߼ͼظʽ
    ZSINT32 width;         //߼ͼ
    ZSINT32 height;        //߼ͼ߶
    ZSINT32 BytesPerPixel; //߼ͼÿռֽ
    ZSINT32 bpp;           //߼ͼÿռõı
    ZSINT32 rlen;          //߼ͼÿռֽ
    ZUINT8 *fb_ptr;        //߼ͼ㻺ַ
}LOGICLAYERINFO;

typedef struct _LogicLcdInfo
{
    ZBOOL IsInit;         //ʼʶ
    ZUINT32 type;         //LCDظʽ
    ZSINT32 width;        //LCD
    ZSINT32 height;       //LCD߶
    ZSINT32 BytesPerPixel;//LCDÿռõֽ
    ZSINT32 BitsPerPixel; //LCDÿռõı
    ZSINT32 pitch;        //LCDÿռõֽ
    ZUINT8 *pLcdMem;      //LCDԴַ

    ZUINT32 softLayer;    //ǷΪͼ
    ZUINT32 layerNums;    //ͼ

    LOGICLAYERINFO layers[MAX_LOGIC_LAYERS]; //߼ͼϢ
    ZUINT8* layersBackBuf[MAX_LOGIC_LAYERS]; //߼ͼʱ
}LOGICLCDINFO;

/**************************************************************************
 *                        ȫֺԭ                                    *
 **************************************************************************/
HLOGICLAYER CreateLogicLayer(ZSINT32 width,ZSINT32 height,ZSINT32 depth);
ZBOOL DestroyLogicLayer(HLOGICLAYER phLayer);
ZVOID DestroyAllLogicLayers(ZVOID);
ZVOID FreeFlipGC(ZVOID);

WindowStack* GetWindowStack(HWND hWnd);
PLOGICLAYER  GetLogicLayerOfWindow(HWND hWnd);
LOGICLAYER*  GetActiveLogicLayer(ZVOID);
LOGICLAYER*  GetPrimaryLogicLayer(ZVOID);

ZVOID TransXYViewToOrg(ZSINT32 angle,ZSINT32 *x,ZSINT32 *y);
ZVOID TransCoordXY2Wnd(HWND hWnd,ZSINT32 *x, ZSINT32 *y);
ZVOID TransRectOrgToView(ZSINT32 angle,RECT *pSrcRct,RECT *pDstRct);
ZVOID TransRectViewToOrg(ZSINT32 angle,RECT *pSrcRct,RECT *pDstRct);
ZVOID TransRectOfWnd(HWND hWnd, PRECT pRct);
ZVOID TransRectWnd2Wnd(HWND srcWnd, HWND dstWnd, PRECT pRct);

ZBOOL SetGC(HDC hdc, HWND hWnd);
ZBOOL GetWndDataFromGC(HDC hdc);
ZBOOL GetWndDataFromGCByRect(HWND hWnd, PRECT pRct);
ZBOOL PutWndDataToGC(HDC hdc);
ZBOOL PutWndDataToGCByRect(HWND hWnd, PRECT pRct);
ZBOOL SetGCRgnOfDC(HDC hdc, HWND hWnd);
ZBOOL IsRotationValid(ZSINT32 rotation);
ZBOOL IsLogicLayerIDValid(ZSINT32 layerID);

ZBOOL GetLayerDefaultInfo(LOGICLAYERINFO *pLcdInfo);
ZVOID MergeLayers(ZVOID);

#ifdef __cplusplus
}
#endif
#endif  /* _LOGIC_LAYER__H */
