#ifndef	os_net_socket_H
#define	os_net_socket_H

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
 #include "zcore_type.h"
#include "os_type.h"
#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
 *                                                                    *
 **************************************************************************/
#ifndef FD_SETSIZE
#define FD_SETSIZE      192
#endif /* FD_SETSIZE */


 /**************************************************************************
 *                         궨                                         *
 **************************************************************************/
#if 1

#define os_socket(a,b,c) socket(a,b,c)
#define os_bind(a,b,c) bind(a,b,c)
#define os_connect(a,b,c) connect(a,b,c)
#define os_listen(a,b) listen(a,b)
#define os_accept(a,b,c) accept(a,b,c)
#define os_send(a,b,c,d) send(a,b,c,d)
#define os_recv(a,b,c,d) recv(a,b,c,d)
#define os_sendto(a,b,c,d,e,f) sendto(a,b,c,d,e,f)
#define os_recvfrom(a,b,c,d,e,f) recvfrom(a,b,c,d,e,f)
#define os_close(a) close(a)
#define os_setsockopt(a,b,c,d,e) setsockopt(a,b,c,d,e)
#define os_htonl(a) htonl(a)
#define os_htons(a) htons(a)
#define os_ntohl(a) ntohl(a)
#define os_ntohs(a) ntohs(a)
#define os_inet_addr(a) inet_addr(a)
#define os_inet_ntoa(a) inet_ntoa(a)
#define os_inet_aton(a,b) inet_ntoa(a,b)
#define os_fcntl(a,b) fcntl(a,b)
#define os_ioctl(a,b) ioctl(a,b)
#define os_getsockname(a,b,c) getsockname(a,b,c)
#define os_setsockname(a,b,c) setsockname(a,b,c)
#define os_select select

/* get and set errno */
UINT32 os_net_get_errno();
OS_STATUS os_net_set_errno(UINT32 err);
#endif




/**************************************************************************
 *                         ṹͶ                                    *
 **************************************************************************/


/*
 * Structure used in select() call, taken from the BSD file sys/time.h.
 */

#ifndef socklen_t
#define socklen_t ZSINT32
#endif
/**************************************************************************
 *                        ԭ                                     *
 **************************************************************************/

/* get and set errno */
UINT32 os_net_get_errno();
OS_STATUS os_net_set_errno(UINT32 err);

/********************************* select  ******************/

// typedef struct fd_set {
//         unsigned int fd_count;               /* how many are SET? */
//         int  fd_array[((FD_SETSIZE-1)>>5)+1];   /* an array of SOCKETs */
// } fd_set;

#undef  FD_SET
#define FD_SET(fd, fdsetp) \
                (((fd_set *)fdsetp)->fd_array[fd >> 5] |= (1<<(fd & 31)))
 
#undef  FD_CLR
#define FD_CLR(fd, fdsetp) \
                (((fd_set *)fdsetp)->fd_array[fd >> 5] &= ~(1<<(fd & 31)))

#undef  FD_ISSET
#define FD_ISSET(fd, fdsetp) \
                ((((fd_set *)fdsetp)->fd_array[fd >> 5] & (1<<(fd & 31))) != 0)

#undef  FD_ZERO
#define FD_ZERO(fdsetp) \
                (tp_os_mem_set(fdsetp, 0, sizeof (*(fd_set *)fdsetp)))

// int select(int n, fd_set *inp, fd_set *outp, fd_set *exp, struct timeval *tvp);

#define    tp_os_net_get_errno os_net_get_errno
#define   tp_os_net_set_errno os_net_set_errno
 
#ifdef __cplusplus
}
#endif

#endif  /* os_net_socket_H */
