#ifndef _OS_API_FW_H_
#define _OS_API_FW_H_

#include "zcore_type.h"
#include "fw_adapter.h"
#include "os_type.h"

#define COMM_CHANNEL_NAME_MAX_LEN   64

#define MSG_COMM    (AMS_CHNL_MSG_ID_BASE + 0x05)//whb
#define AMS_CHNL_MSG_ID_BASE            (MSG_ID_FW + 0x010)

#define APP_CHANNEL_NAME_DEFAULT_PREFIX  "AMS_APP_DEF_CHNL_"
//#include <time.h>
typedef struct
{
    ZCHAR ChanName[COMM_CHANNEL_NAME_MAX_LEN + 1];
    ZUINT32 msgID;//msg id
    ZUINT32* data;//msg content
    ZUINT32 len;//msg content size
    ZSINT32 (*callback)(ZUINT32 id, const ZVOID *data, ZUINT32 size, ZVOID *add_data);//channel callback function
    ZUINT32 addition;//additional data
}T_COMM_DATA;

typedef struct _tm
{

    ZUINT32 tm_sec;
    ///Seconds after minute (0 C 59). 
    ZUINT32 tm_min; 
    ///Minutes after hour (0 C 59). 
    ZUINT32 tm_hour; 
    ///Hours after midnight (0 C 23). 
    ZUINT32 tm_mday; 
    ///Day of month (1 C 31). 
    ZUINT32 tm_mon; 
    ///Month (0 C 11; January = 0). 
    ZUINT32 tm_year; 
    ///Year (current year minus 1900). 
    ZUINT32 tm_wday; 
    ///Day of week (0 C 6; Sunday = 0). 
    ZUINT32 tm_yday; 
    ///Day of year (0 C 365; January 1 = 0). 
    ZUINT32 tm_isdst; 
    //// Positive value if daylight saving time is in effect; 0 if daylight saving time is not in effect; negative value if status of daylight saving time is unknown. 
}tm;

#ifndef TYPE_CONST 
#define TYPE_CONST
#define CONST const
#endif

#ifndef OS_MAX_NAME_LEN
#define OS_MAX_NAME_LEN 4
#endif

//++++++++++++++++++++++The following part is porting form the data.h++++++++++++
/*----------------------------- micor declaration -----------------------------*/
/*Message Id*/
/********************************************************************
*Name: TPM_DATE_APP_ALARM
*Purpose: this message is send when alarm_clock time arrived
*Param: 
*   Name		 Type		In/Out 		Description							   
* -------- 	     --- 	   ------   	----------- 				       
*  alarm_time	 time_t    	 out        current alarm time setted by dd 
*********************************************************************/
#define TPM_DATE_APP_ALARM (MSG_ID_MAN_DATE_BASE+1)

/*Message Id*/
/********************************************************************
*Name: TPM_DATE_APP_UPDATE
*Purpose: this message is send when minate_update time arrived 
*Param: N/A	    
*********************************************************************/
#define TPM_DATE_APP_UPDATE (MSG_ID_MAN_DATE_BASE+2)

/*-------------------------- extern variable declaration-----------------------*/

/*------------------ constants and data type declaration ----------------------*/

typedef struct _MAN_RTC_DATE_
{
    ZUINT16 year;  /* 1752~2999 */
    ZUINT8  month; /* 1~12 */
    ZUINT8  day;   /* 1~31 */
}MAN_RTC_DATE;

typedef struct _MAN_RTC_TIME_
{
    ZUINT8 hour; /* 0~23 */
    ZUINT8 min;  /* 0~59 */
    ZUINT8 sec;  /* 0~59 */
}MAN_RTC_TIME;

/*--------------------------- variable declaration ----------------------------*/


/*------------------------------ function prototype ---------------------------*/
/*globle function*/
ZSINT32 tp_man_date_time_init(ZVOID);
ZSINT32 tp_man_date_time_release(ZVOID);
/*set and get date and time*/
ZSINT32 tp_man_date_set(MAN_RTC_DATE date_st);
ZSINT32 tp_man_date_get(MAN_RTC_DATE *date_ptr);
ZSINT32 tp_man_date_week_day(MAN_RTC_DATE date_st);
ZSINT32 tp_man_time_set(MAN_RTC_TIME time_st);
ZSINT32 tp_man_time_get(MAN_RTC_TIME *time_ptr);
/* alarm management function*/
ZSINT32 tp_man_alarm_set(MAN_RTC_DATE date_st, MAN_RTC_TIME time_st);
ZSINT32 tp_man_alarm_get_on_power(time_t *time_ptr);
/* other function*/
ZSINT32 tp_man_alarm_power_off(ZBOOL enable);
ZSINT32 tp_man_alarm_clear_poweron_status(ZVOID);
ZSINT32 tp_man_date_min_message(ZBOOL enable);

ZSINT32 tp_man_time_elapsed_from_poweron(UINT32 *timeptr);

/* ADS ANSI C function time() */
extern time_t time(time_t *timeptr);

//++++++++++++++++++++++The following part is porting form the rtcpub.h++++++++++++
/*  Enrtc irq  State Type Declarations */
typedef enum _DD_RTC_IRQ_STATE_
{
    DD_RTC_UPDATE=1, //irq when  per minute happen
    DD_RTC_ALARMINT //irq when alarm event happen
}DD_RTC_IRQ_STATE;
/*-------RTC update mode------*/
typedef enum _RTC_UPDATE_MOD_
{
    RTC_PERSECOND = 1,
    RTC_PERMININT, 
    RTC_PERHOUR,
    RTC_PERMONTH
}RTC_UPDATE_MOD;
/*--------RTC alarm mode--------*/
typedef enum _RTC_ALARM_MOD_
{   
    RTC_ALARMINT_MOD1 = 1, 
    RTC_ALARMINT_MOD2
}RTC_ALARM_MOD;
/*--------HOUR format------------*/
typedef enum _RTC_HOUR_FORMAT_
{
     RTC_24FORMAT = 1,
     RTC_12FORMAT
}RTC_HOUR_FORMAT;
/* rtc command   macros Declarations */    

#define	DD_RTC_IOCTL_AIE_DISABLE        1  /*mask RTC ALARM INT bit*/
#define	DD_RTC_IOCTL_AIE_ENABLE         2  /*unmask RTC ALARM INT bit*/
#define	DD_RTC_IOCTL_TIMER_DISABLE      3  /*mask RTC TIMER INT bit*/
#define	DD_RTC_IOCTL_TIMER_ENABLE       4  /*unmask RTC TIMER INT bit*/
#define  DD_RTC_IOCTL_POWALM_DISABLE    5  /*alarm after power off*/
#define  DD_RTC_IOCTL_POWALM_ENABLE     6
#define  DD_RTC_IOCTL_ALM_MOD           7  /*rtc alarm mode*/
#define  DD_RTC_IOCTL_UPDATE_MOD        8  /*rtc update mode*/
#define  DD_RTC_IOCTL_HOUR_MOD          9  /*rtc 12/24 hour mode*/
#define  DD_RTC_IOCTL_ADJUST            10 /*rtc comensation*/
#define	DD_RTC_IOCTL_READ_DATE          11 /*date read*/
#define  DD_RTC_IOCTL_READ_TIME         12
#define	DD_RTC_IOCTL_READ_ALM           13 /*ALARM read*/
#define	DD_RTC_IOCTL_SET_TIME           14 /*TIMER SET*/
#define  DD_RTC_IOCTL_SET_DATE          15
#define	DD_RTC_IOCTL_SET_ALM            16 /*ALM SET*/

#define DD_RTC_IOCTL_CLEAR_ALMSTATUS 17 /*clear poweron regisger*/

/* rtc_time   Type Declarations */
typedef struct  _DD_RTC_TIME_
{
   ZUINT16        year;
   ZUINT8         month;
   ZUINT8         mday;
   ZUINT8         week;   
   ZUINT16        day;
   ZUINT8         hour;
   ZUINT8         minute;
   ZUINT8         second;
   ZUINT16        yday;   
}DD_RTC_TIME;

typedef struct  _TRACE_RTC_TIME_
{
   ZUINT16        year;
   ZUINT8         month;
   ZUINT8         day;
   ZUINT8         hour;
   ZUINT8         minute;
   ZUINT8         second;
}TRACE_RTC_TIME;
#ifdef ZTE_GUI_DEBUG
extern ZVOID zte_gui_assert(ZVOID);
#endif
/* ------------ Public Function Declarations ---------------*/
#ifdef WIN32
#define FW_ASSERT(expr)

#else
#define FW_ASSERT(expr)  
#if 0
    { \
        if(!(expr))  {  zte_gui_assert();} \
    }
    */
#endif

#endif
#endif
