#ifndef _EFFECT_COMMON_H
#define _EFFECT_COMMON_H
    
#ifdef __cplusplus
extern "C"
{
#endif
    
/*******************************************************************************
*                                      ͷļ
*******************************************************************************/
#include "zcore_type.h"
#include "gui_common.h"
#include "EffectEngine.h"
    
/*******************************************************************************
*                                      
*******************************************************************************/
   
/*******************************************************************************
*                                      ݽṹ
*******************************************************************************/
/* ÿռֽ */
typedef enum
{
    BPPBEGAIN = 1,
    BPP2,           //16λɫ
    BPP3,           //24λɫ
    BPP4,           //32λɫ
    BPPEND
}E_BPP;

/* ͼڴָ֮򿽱  */
typedef struct  _IMAGEMEMCOPY
{
    ZCHAR *srcBuf;                      //Դͼڴ
    ZSINT32 srcX;                       //ԴX
    ZSINT32 srcY;                       //ԴY
    ZSINT32 srcImageWidth;              //Դͼ
    ZSINT32 srcImageHeight;             //Դͼ

    ZCHAR *dstBuf;                      //Ŀڴ
    ZSINT32 dstX;                       //Ŀĵx
    ZSINT32 dstY;                       //ĿĵY
    ZSINT32 dstImageWidth;              //Ŀͼ
    ZSINT32 dstImageHeight;             //Ŀͼ

    E_BPP bpp;                          //ͼɫ
    ZSINT32 copyWidth;                  //
    ZSINT32 copyHeight;                 //߶
}T_IMAGEMEMCOPY; 

/*******************************************************************************
*                                      ȫֺ
*******************************************************************************/
/*******************************************************************************
* : SetEffectControlerState
* : 趨Ч״̬
* ˵: (IN)state           趨״̬
*   ֵ: 
* ˵: 
*******************************************************************************/
ZVOID SetEffectControlerState(EffectState state);

/*******************************************************************************
* : CheckEffectControlerState
* : Ч״̬
* ˵: (IN)state           ״̬
*   ֵ: TRUE                ״̬״̬һ
*           FALSE               ״̬״̬һ
* ˵: 
*******************************************************************************/
ZBOOL CheckEffectControlerState(EffectState state);

/*******************************************************************************
* : CaptureScreen
* : ׽ĻԴ
* ˵: (IN/OUT)pStartBuf               ʼָ
*           (IN/OUT)pEndBuf                 ָ
*           (IN)capturePrimaryLayerOnly     ֻ׽ͼ־
*   ֵ: 
* ˵: 
*******************************************************************************/
ZVOID CaptureScreen(ZCHAR *pStartBuf, ZCHAR *pEndBuf, ZBOOL capturePrimaryLayerOnly);

/*******************************************************************************
* : SwitchDrawBuf
* : лϵͳ򻺴
* ˵: (IN)bUser               лû־
*           (IN)pBuf                лĻ
*   ֵ: 
* ˵: 
*******************************************************************************/
ZVOID  SwitchDrawBuf(ZBOOL bUser, ZCHAR *pBuf);

/*******************************************************************************
* : EngineDelay
* : ӳʱ
* ˵: 
*   ֵ: 
* ˵: 
*******************************************************************************/
ZVOID EngineDelay(ZUINT32 ms);

/*******************************************************************************
* : GetEffectMem
* : ȡЧڴ
* ˵: (IN/OUT)pStart              ʼָָ
*           (IN/OUT)pEnd                ָָ
*   ֵ: TRUE                        ȡɹ
*           FALSE                       ȡʧ
* ˵: 
*******************************************************************************/
ZBOOL GetEffectMem(ZCHAR **pStart, ZCHAR **pEnd);

/*******************************************************************************
* : IsEffectEnabled
* : ЧǷʹ
* ˵: 
*   ֵ: TRUE                        Чʹ
*           FALSE                       Чδʹ
* ˵: 
*******************************************************************************/
ZBOOL IsEffectEnabled(ZVOID);

/*******************************************************************************
* : ComputeCourseValue
* : ֵĹֵ
* ˵: (IN)start       ʼֵ
*           (IN)end         ֵ
*           (IN)index       ֵڵλ
*           (IN)num         ֵ
*   ֵ: ֵ 
* ˵: 
*******************************************************************************/
extern ZSINT32 ComputeCourseValue(ZSINT32 start, ZSINT32 end, ZUINT32 index, ZUINT32 num);

/*******************************************************************************
* : CopySpecificRectOfImage
* : ͼڴ֮ضĿ
* ˵: (IN/OUT)pCopy Ϣָ
*   ֵ: TRUE ɹ
*           FALSE ʧ
* ˵: 
*******************************************************************************/
extern ZBOOL CopySpecificRectOfImage(T_IMAGEMEMCOPY *pCopy);

/*******************************************************************************
* : IsZoomAttachIconFly
* : жdwStyleǷΪСҸicon
* ˵: (IN)dwStyle             Ч
*   ֵ: TRUE                
*           FALSE                  
* ˵: 
*******************************************************************************/
extern ZBOOL IsZoomAttachIconFly(ZSINT32 dwStyle);

/*******************************************************************************
* : ResizeEffectRectByEffectZoom
* : С趨ЧĴС
* ˵: (IN)dwStyle             Ч
*           (OUT)pRect              趨ָ
*   ֵ: TRUE                    趨
*           FALSE                   δ趨
* ˵: 
*******************************************************************************/
ZBOOL ResizeEffectRectByEffectZoom(ZSINT32 dwStyle, RECT *pRect);

/*******************************************************************************
* : EngineRectIsInScreen
* : жǷĻ
* ˵: (IN)pRect               жָ
*   ֵ: TRUE                    Ļ
*           FALSE                   ȫĻ
* ˵: 
*******************************************************************************/
ZBOOL EngineRectIsInScreen(RECT *pRect);

/*******************************************************************************
*                                      ȫֱ
*******************************************************************************/
    
    
#ifdef __cplusplus
}
#endif
    
#endif

