#ifndef REGION_I_H
#define REGION_I_H

/****************************************ͷļ**************************************/
#include "zcore_type.h"
#include "Region_e.h"
#include "Rect_e.h"
/*********************************************************************/

/***********************************궨*******************************/

#define 	BLK_FREE        		0x0000
#define 	BLK_SPECIAL     		0x0001
#define 	BLK_USED        		0x0002


#define EXTENTCHECK(r1, r2) \
        ((r1)->right > (r2)->left && \
         (r1)->left < (r2)->right && \
         (r1)->bottom > (r2)->top && \
         (r1)->top < (r2)->bottom)

#define NEWCLIPRECT(region, rect) \
       {\
            rect = (PT_RECT_CLIPRECT)BlockDataAlloc(region->heap);\
            rect->next = NULL;\
            rect->prev = region->tail;\
            if (region->tail)\
                region->tail->next = rect;\
            region->tail = rect;\
            if (region->head == NULL)\
                region->head = rect;\
       }

#define REGION_NOT_EMPTY(region) region->head

#define INRECT(r, x, y) \
      ( ( ((r).right >  x)) && \
        ( ((r).left <= x)) && \
        ( ((r).bottom >  y)) && \
        ( ((r).top <= y)) )

#define MERGERECT(r) \
    if ((region->head) &&  \
        (region->tail->rc.top == top) &&  \
        (region->tail->rc.bottom == bottom) &&  \
        (region->tail->rc.right >= r->rc.left))  \
    {  \
        if (region->tail->rc.right < r->rc.right)  \
        {  \
            region->tail->rc.right = r->rc.right;  \
        }  \
    }  \
    else  \
    {  \
        NEWCLIPRECT(region, newcliprect);  \
        newcliprect->rc.top = top;  \
        newcliprect->rc.bottom = bottom;  \
        newcliprect->rc.left = r->rc.left;  \
        newcliprect->rc.right = r->rc.right;  \
    }  \
    r = r->next;
#define NEWCLIPRECTANDINIT(lt,tp,rt,bm);\
{\
	NEWCLIPRECT(region, newcliprect);\
	newcliprect->rc.right = rt;\
	newcliprect->rc.left = lt;\
	newcliprect->rc.top = tp;\
	newcliprect->rc.bottom = bm;\
}
#define JUDGACCORDINGXDIRECTION();\
{ \
	left = r2->rc.right;\
	if (left >= r1->rc.right)\
	{\
  		r1 = r1->next;\
   		if (r1 != r1End)\
   		left = r1->rc.left;\
	}\
	else\
	{\
  		r2 = r2->next;\
	}\
}
	

typedef void (*voidProcp1)(CLIPRGN *region, const PT_RECT_CLIPRECT r1, const PT_RECT_CLIPRECT r1End,
                          const PT_RECT_CLIPRECT r2, const PT_RECT_CLIPRECT r2End, int top, int bottom);
typedef void (*voidProcp2)(CLIPRGN *region, const PT_RECT_CLIPRECT r, const PT_RECT_CLIPRECT rEnd,
                          int top, int bottom);
        
/****************************************************************************/
static void Region_IntersectO (CLIPRGN *region,  PT_RECT_CLIPRECT r1,  PT_RECT_CLIPRECT r1End,
                         PT_RECT_CLIPRECT r2,   PT_RECT_CLIPRECT r2End, int top, int bottom);

static void Region_SetExtents (CLIPRGN *region);

static void Region_SubtractNonO1 (CLIPRGN *region,   PT_RECT_CLIPRECT r,   PT_RECT_CLIPRECT rEnd,
                        int top, int bottom);

static void Region_SubtractO (CLIPRGN *region,   PT_RECT_CLIPRECT r1,  PT_RECT_CLIPRECT r1End,
                         PT_RECT_CLIPRECT r2,   PT_RECT_CLIPRECT r2End,  int top, int bottom);

static PT_RECT_CLIPRECT  Region_Coalesce( CLIPRGN *region, PT_RECT_CLIPRECT prevStart,  PT_RECT_CLIPRECT curStart   ) ; 
static void Region_UnionO(CLIPRGN *region,  PT_RECT_CLIPRECT r1,  PT_RECT_CLIPRECT r1End,
                            PT_RECT_CLIPRECT r2,  PT_RECT_CLIPRECT r2End, int top, int bottom);
static void Region_UnionNonO (CLIPRGN *region,  PT_RECT_CLIPRECT r,  PT_RECT_CLIPRECT rEnd, int top, int bottom);

static void Region_RegionOp( CLIPRGN *newReg, CLIPRGN *reg1, CLIPRGN *reg2,voidProcp1 overlapFunc, 
									  voidProcp2 nonOverlap1Func,  voidProcp2 nonOverlap2Func  ) ;

extern 	ZBOOL regionLPtoSP (PT_DCMgt_DC pdc, ZSINT32 *iX, ZSINT32 *iY);
extern	ZBOOL regionSPtoLP (PT_DCMgt_DC pdc, ZSINT32 *iX, ZSINT32 *iY);
extern	ZBOOL RegionGenerateECRgn(PT_DCMgt_DC pdc, ZBOOL fForce);
extern ZVOID PdcDealCtrl(PT_DCMgt_DC pdc);
extern PT_DCMgt_DC GetActiveLayerGlobalDC(ZVOID);
extern PT_DCMgt_DC GetActiveLogicLayerGlobalDC(ZVOID);
BOOL GUIAPI SubtractRegion (CLIPRGN *rgnD,  CLIPRGN *rgnM,  CLIPRGN *rgnS);
BOOL GUIAPI UnionRegion (CLIPRGN *dst,  CLIPRGN *src1,  CLIPRGN *src2);
BOOL GUIAPI ClipRgnIntersect (CLIPRGN *dst,  CLIPRGN *src1,  CLIPRGN *src2);
extern T_DCMgt_DC	g_tDCMgtDeviceDC;
#endif
