##########################################################################
# makefile:         wm.mk
# File:             wm.mk
# Version:	    V0.1
# Author:           xuxin194245 -2011.9.14
##########################################################################
ENVDIR = ../../../../../../../ws
include	$(ENVDIR)/makeenv.mk
CONFIG_HOME = ../../../../../../../ws
include $(CONFIG_HOME)/config.mk

OS_SRCDIR = ../src
OS_OBJDIR = ../lib

OS_SRC := $(notdir $(wildcard $(OS_SRCDIR)/*.c)) 
OS_OBJS := $(patsubst %.c,%.o,$(OS_SRC))
OS_COBJECTS := $(addprefix $(OS_OBJDIR)/,$(OS_OBJS))  


OS_OBJS = $(OS_COBJECTS)

OS_LOCAL_INCLUDE  = -I../../wm/inc \
                    -I../../adapter/Linux/inc \
                    -I../../bmp/inc \
                    -I../../ctrl/inc \
                    -I../../gdi/inc \
                    -I../../effect/inc \
                    -I../../../../inc/gui \
                    -I../../../../inc/gal \
                    -I../../../../inc/os \
                    -I../../../../../../inc/zCore/kernel \
                    -I../../../../../../inc/zCore/os \
                    -I../../../../../../inc/zCore/gui \
                    -I../../../../../../inc/zCore/gui/ctrl \
                    -I../../../../../../inc/zCore/gui/effect \
                    -I../../../../../../inc/zCore/gui/ext


all: $(OS_COBJECTS) ar

$(OS_COBJECTS): $(OS_OBJDIR)/%.o: $(OS_SRCDIR)/%.c
	$(OS_CC) -c $(OS_CFLAGS) $(OS_LOCAL_CFLAGS) $(OS_LOCAL_INCLUDE) $< -o $@

ar:
	$(OS_AR) $(OS_OBJDIR)/wm.a $(OS_OBJS)
	ranlib $(OS_OBJDIR)/wm.a

.PHONY :clean

clean:
	$(OS_RM) $(OS_OBJDIR)/wm.a $(OS_OBJS)
 


