#ifndef _ZCORE_GUI_COMMON_H_
#define _ZCORE_GUI_COMMON_H_
#include "zcore_type.h"
#include "gui_common.h"
#include "zcore_ial.h"


#if !defined(__STRICT_ANSI__)
#if defined(__GNUC__)
#define MGUI_HAS_64BIT_TYPE	
typedef ZSLONG64 Sint64;  
typedef ZULONG64 Uint64;

#endif
#if defined(__CC_ARM)
#define MGUI_HAS_64BIT_TYPE	
typedef ZSLONG64 Sint64;
typedef ZULONG64 Uint64;

#endif
#if defined(_MSC_VER)
#define MGUI_HAS_64BIT_TYPE 
typedef __ZUINT64  Uint64;
typedef __ZSINT64  Sint64;


#endif
#endif /* !__STRICT_ANSI__ */

#define MGUI_LIL_ENDIAN  1234
#define MGUI_BIG_ENDIAN  4321

#if  defined(__i386__) || defined(__ia64__) || \
    (defined(__alpha__) || defined(__alpha)) || \
     defined(__arm__) || \
    (defined(__CC_ARM) && !defined(__BIG_ENDIAN)) || \
    (defined(__mips__) && defined(__MIPSEL__)) || \
     defined(__LITTLE_ENDIAN__) || \
    defined(WIN32)
#define MGUI_BYTEORDER   MGUI_LIL_ENDIAN
#else
#define MGUI_BYTEORDER   MGUI_BIG_ENDIAN
#endif


#ifndef _TYPE_ZBOOL
#define _TYPE_ZBOOL
typedef ZSINT32 ZBOOL;
#endif

#define MGEXT_EXPORT

typedef ZUINT32 HPALETTE;


#ifndef _HAVE_TYPE_BYTE
#define _HAVE_TYPE_BYTE
typedef ZUINT8   BYTE;
#endif
typedef ZSINT8     SBYTE;

#ifndef _HAVE_TYPE_WORD
#define _HAVE_TYPE_WORD
typedef ZUINT16  WORD;
#endif


#ifndef _HAVE_TYPE_SWORD
#define _HAVE_TYPE_SWORD
typedef ZSINT16    SWORD;
#endif

#ifndef _HAVE_TYPE_DWORD
#define _HAVE_TYPE_DWORD
typedef ZULONG   DWORD;
#endif

#ifndef _HAVE_TYPE_SDWORD
#define _HAVE_TYPE_SDWORD
typedef ZSLONG     SDWORD;
#endif

#ifndef _HAVE_TYPE_UINT
#define _HAVE_TYPE_UINT
#endif

#ifndef _HAVE_TYPE_LONG
#define _HAVE_TYPE_LONG
#endif


#define GetRValue(rgb)      ((ZBYTE)(rgb))
#define GetGValue(rgb)      ((ZBYTE)(((ZWORD)(rgb)) >> 8))
#define GetBValue(rgb)      ((ZBYTE)((rgb) >> 16))

#define MakeRGB(r, g, b)    (((ZDWORD)((ZBYTE)(r))) | ((ZDWORD)((ZBYTE)(g)) << 8) \
                | ((ZDWORD)((ZBYTE)(b)) << 16))

typedef DWORD RGBCOLOR;

#define KS_CAPTURED                     0x00000400
#define KS_IMEPOST                      0x00000200
#define KS_CAPSLOCK                     0x00000100
#define KS_NUMLOCK                      0x00000080
#define KS_SCROLLLOCK                   0x00000040
#define KS_LEFTCTRL                     0x00000020
#define KS_RIGHTCTRL                    0x00000010
#define KS_CTRL                         0x00000030
#define KS_LEFTALT                      0x00000008
#define KS_RIGHTALT                     0x00000004
#define KS_ALT                          0x0000000C
#define KS_LEFTSHIFT                    0x00000002
#define KS_RIGHTSHIFT                   0x00000001
#define KS_SHIFT                        0x00000003
#define MASK_KS_SHIFTKEYS               0x00000FFF

#define KS_LEFTBUTTON                   0x00001000
#define KS_RIGHTBUTTON                  0x00002000
#define KS_MIDDLBUTTON                  0x00004000
#define MASK_KS_BUTTONS                 0x0000F000

#define ERR_NO_ENGINE           	-22

#define ERR_INPUT_ENGINE        	-21

#define ERR_GFX_ENGINE          	-20

#define ERR_FILE_IO             	-19

#define ERR_CONFIG_FILE         	-18

#define ERR_IME_NOIMEWND            -17

#define ERR_IME_NOSUCHIMEWND    	-16

#define ERR_IME_TOOMUCHIMEWND   	-15

#define ERR_BAD_OWNER           	-14

#define ERR_NO_MATCH            	-13

#define ERR_ALREADY_EXIST       	-12

#define ERR_CTRLCLASS_INUSE     	-11

#define ERR_CTRLCLASS_MEM       	-10

#define ERR_CTRLCLASS_INVLEN    	-9

#define ERR_CTRLCLASS_INVNAME   	-8

#define ERR_RES_ALLOCATION      	-7

#define ERR_INVALID_ID          	-6

#define ERR_INVALID_POS         	-5

#define ERR_INVALID_HMENU       	-4

#define ERR_INVALID_HANDLE      	-3

#define ERR_QUEUE_FULL          	-2

#define ERR_INV_HWND            	-1

#define ERR_OK                   	0

#ifndef __THREADX__
#ifndef WIN32
#ifdef __CC_ARM
#define ENOMEM      200
#define EINVAL      201
#define EBUSY       202
#define EAGAIN      203
#define ESRCH       204
#define ENOTSUP     206
#endif
#endif /* WIN32 */
#endif /* __THREADX__ */
#define TABLESIZE(table)    (sizeof(table)/sizeof(table[0]))

#ifndef ABS
#define ABS(x)              (((x)<0) ? -(x) : (x))
#endif

/* Commonly used definitions */
#ifndef __NOUNIX__
#include <dirent.h>
#endif

#ifndef PATH_MAX
#ifndef __VXWORKS__ /*FIXME*/
    #define PATH_MAX    256
#endif
#endif

#ifndef NAME_MAX
#ifndef __VXWORKS__ /*FIXME*/
    #define NAME_MAX    64
#endif
#endif


#define MAX_PATH        PATH_MAX
#define MAX_NAME        NAME_MAX


#ifdef __cplusplus
extern "C" {
#endif

#if defined (__THREADX__) && defined (__TARGET_VFANVIL__)

#include  "tx_api.h"
#include  "os_type.h"
#include  "os_file_api.h"


#undef assert 
#define _HAVE_ASSERT 1 

#define assert(e) do {              \
                         e;      \
                     } while(0);  

#undef stdin
#undef stdout
#undef stderr

#define stdin ((FILE*)0)
#define stdout ((FILE*)1)
#define stderr ((FILE*)2)

#endif

#define fopen   tp_fopen
#define fclose   tp_fclose
#define fwrite  tp_fwrite
#define fread   tp_fread
#define fseek   tp_fseek
#ifndef WIN32
#define feof    tp_feof
#endif
ZVOID Comm_Lock_Screen (ZVOID);
ZVOID Comm_Unlock_Screen (ZVOID);

#ifdef __UCOSII__

#undef HAVE_STRDUP
#define strdup own_strdup

ZSINT32 zcoregui_entry (ZSINT32 argc, const ZCHAR* argv[]);
ZSINT32 ucos2_posix_pthread_init (ZVOID);
ZSINT32 ucos2_malloc_init (ZVOID);

#endif

#ifndef TYPE_MG_EXPORT    
#define TYPE_MG_EXPORT
#define MG_EXPORT extern
#endif

#ifndef HAVE_STRDUP
#else
#ifdef WIN32
#include <string.h>
#else
extern ZCHAR *strdup(const ZCHAR *s);
#endif
#endif

#ifndef HAVE_STRCASECMP
MG_EXPORT ZSINT32 strcasecmp(const ZCHAR *s1, const ZCHAR *s2);
#endif

#ifdef __cplusplus
};  /* end of extern "C" */
#endif

#ifdef _USE_OWN_MALLOC

#define USE_DL_PREFIX

#include "own_malloc.h"

#define calloc      dlcalloc
#define free        dlfree
#define malloc      dlmalloc
#define memalign    dlmemalign
#define realloc     dlrealloc
#define valloc      dlvalloc

#endif

#if defined(__CC_ARM)
#   undef HAVE_ALLOCA
#   undef HAVE_ALLOCA_H

#endif

#ifdef HAVE_ALLOCA_H

#   include <alloca.h>
#   define ALLOCATE_LOCAL(size)    alloca((ZSINT32)(size))
#   define DEALLOCATE_LOCAL(ptr)   /* as nothing */
#else
#   define ALLOCATE_LOCAL(size)    malloc((ZSINT32)(size))
#   define DEALLOCATE_LOCAL(ptr)   free(ptr)
#endif

#if defined(__GNUC__)
#ifdef _DEBUG_MSG
#   define _MG_PRINTF(fmt...) fprintf (stderr, fmt)
#else
#   define _MG_PRINTF(fmt...)
#endif
#else /* __GNUC__ */

#ifdef WIN32 
#define inline __inline 
static inline ZVOID _MG_PRINTF(const ZCHAR* fmt, ...)
{
#ifdef _DEBUG_MSG
    va_list ap;
    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n");
    va_end(ap);
#endif
}
#endif

#endif /* __GNUC__ */


#ifndef _LITE_VERSION
#if defined(_USE_OWN_PTHREAD) && defined(__MINIGUI_LIB__)

#if __UCOSII__
  #include "ucos2_pthread.h"
  #include "ucos2_semaphore.h"
#elif __THREADX__
  #include "threadx_pthread.h"
  #include "threadx_semaphore.h"
#elif __NUCLEUS__
  #include "nucleus_pthread.h"
  #include "nucleus_semaphore.h"
#else
#error No own pthread implementation for this OS!
#endif

#else

#endif /* !_USE_OWN_PTHREAD */
#endif /* !_LITE_VERSION */


#endif /* _ZCORE_GUI_COMMON_H_ */

