#ifndef _ZCORE_CTRL_BUTTON_H_
#define _ZCORE_CTRL_BUTTON_H_
#include "zcore_type.h" 
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */


/**
 * \def CTRL_BUTTON
 * \brief The class name of button control.
 */
#define CTRL_BUTTON         ("button")

#define BS_LEFT               (0x1L<<8)
#define BS_RIGHT             (0x2L<<8)
#define BS_CENTER           (0x3L<<8)
#define BS_TOP                 (0x4L<<8)
#define BS_BOTTOM           (0x8L<<8)
#define BS_VCENTER          (0xCL<<8)
#define BS_REALSIZEIMAGE    (0xFL<<8)
#define BS_ALIGNMASK        (0xFL<<8)

#define BS_PUSHBUTTON       0x00000000L
#define BS_DEFPUSHBUTTON    0x00000001L
#define BS_CHECKBOX         0x00000002L

#define BS_AUTOCHECKBOX     0x00000003L
#define BS_RADIOBUTTON      0x00000004L
#define BS_3STATE           0x00000005L

#define BS_AUTO3STATE       0x00000006L
#define BS_GROUPBOX         0x00000007L
#define BS_USERBUTTON       0x00000008L

#define BS_CHECKED          0x00004000L
#define BS_FLAT             0x00008000L
#define BS_NOBORDER         0x00010000L
#define BS_RIGHTBUTTON      BS_LEFTTEXT


#define BM_GETCHECK             0xF0F0
#define BM_SETCHECK             0xF0F1
#define BM_GETSTATE             0xF0F2
#define BM_SETSTATE             0xF0F3
#define BM_SETSTYLE             0xF0F4
#define BM_CLICK                0xF0F5
#define BM_GETIMAGE             0xF0F6

#define BST_UNCHECKED       0x0000
#define BST_CHECKED         0x0001
#define BST_INDETERMINATE   0x0002
#define BST_PUSHED          0x0004
#define BST_FOCUS           0x0008

#define BM_IMAGE_BITMAP         1
#define BM_IMAGE_ICON           2

#define BS_AUTORADIOBUTTON  0x00000009L
#define BS_OWNERDRAW        0x0000000BL
#define BS_TYPEMASK         0x0000000FL

#define BS_PUSHLIKE         0x00001000L
#define BS_MULTLINE         0x00002000L
#define BS_NOTIFY           0x00004000L
    
#define BM_SETIMAGE             0xF0F7

#define BM_MSGMAX               0xF100

#define BN_CLICKED          0

#define BN_PAINT            1   /* not supported */
#define BN_HILITE           2
#define BN_UNHILITE         3
#define BN_DISABLE          4   /* not supported */
#define BN_DOUBLECLICKED    5

#define BN_PUSHED           BN_HILITE

#define BN_UNPUSHED         BN_UNHILITE

#define BN_DBLCLK           BN_DOUBLECLICKED

#define BN_SETFOCUS         6

#define BN_KILLFOCUS        7

#define BS_TEXT             0x00000000L
#define BS_LEFTTEXT         0x00000020L
#define BS_ICON             0x00000040L
#define BS_BITMAP           0x00000080L
#define BS_CONTENTMASK      0x000000F0L

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif

