#ifndef _ZCORE_GUI_CLIPBOARD_H_
#define _ZCORE_GUI_CLIPBOARD_H_
#include "zcore_type.h"
#include "zcoregui.h"

#define CLIPBOARD_BUFFLENGTH	1024

#ifdef _cplusplus
extern "C" {
#endif /* _cplusplus */

/**
* ¶а幦
* 
**/

#define LEN_CLIPBOARD_NAME      15
#define NR_CLIPBOARDS         1  



#define CBERR_OK        0
#define CBERR_BADNAME   1
#define CBERR_NOMEM     2

#define CBOP_NORMAL     0
#define CBOP_APPEND     1

/**
 * ƣ CreateClipBoard
 * һа
 * ˵(IN) cb_name  а
 *                           (IN) sizeа峤
 *   ֵ  CBERR_OKʾɹ;CBERR_BADNAMEʾͬа
 *                          CBERR_NOMEMʾڴ治
 * ˵ 
 */
MG_EXPORT ZSINT32 GUIAPI CreateClipBoard (const ZCHAR* cb_name, size_t size);

/**
 * ƣ DestroyClipBoard
 * һа
 * ˵(IN) cb_name  а
 *   ֵ  CBERR_OKʾٳɹ;CBERR_BADNAMEʾûͬа
 * ˵ 
 */
MG_EXPORT ZSINT32 GUIAPI DestroyClipBoard (const ZCHAR* cb_name);

MG_EXPORT int GUIAPI SetClipBoardData (const char* cb_name, 
                void* data, size_t n, int cbop);

MG_EXPORT size_t GUIAPI GetClipBoardDataLen (const char* cb_name);

MG_EXPORT size_t GUIAPI GetClipBoardData (const char* cb_name, 
                void* data, size_t n);

MG_EXPORT ZSINT32 GUIAPI GetClipBoardByte (const ZCHAR* cb_name, 
                ZSINT32 index, ZUINT8* byte);


ZVOID InitClipBoard(ZVOID);
ZVOID TerminateClipBoard(ZVOID);
size_t GUIAPI ClipBoardHasENChar(const ZCHAR *cb_name);
size_t GUIAPI ClipBoardHasCNChar(const ZCHAR *cb_name);
size_t GUIAPI ClipBoardHasDigit(const ZCHAR *cb_name);
#ifdef _cplusplus
}
#endif /* _cplusplus */


#endif
