#ifndef _ZCORE_CTRL_CTRLHELPER_H_
#define _ZCORE_CTRL_CTRLHELPER_H_
#include "zcore_type.h" 
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

typedef enum
{
  SB_POLICY_ALWAYS,
  SB_POLICY_AUTOMATIC,
  SB_POLICY_NEVER
} SBPolicyType;

ZSINT32 EditOnEraseBackground (HWND hWnd, HDC hdc, const RECT* pClipRect);

MG_EXPORT ZVOID GUIAPI DrawBoxFromBitmap (HDC hdc, const RECT* box, const BITMAP* bmp, ZBOOL h_v, ZBOOL do_clip);

#define DF_3DBOX_NORMAL     0x0000
#define DF_3DBOX_PRESSED    0x0001
#define DF_3DBOX_STATEMASK  0x000F
#define DF_3DBOX_NOTFILL    0x0000
#define DF_3DBOX_FILL       0x0010

MG_EXPORT ZVOID GUIAPI Draw3DControlFrameEx (HDC hdc, HWND hwnd, ZSINT32 x0, ZSINT32 y0, ZSINT32 x1, ZSINT32 y1, 
            ZDWORD flags, gal_pixel fillc);

#define Draw3DControlFrame(hdc, l, t, r, b, fillc, updown) \
            Draw3DControlFrameEx(hdc, HWND_DESKTOP, l, t, r, b, \
            (updown?DF_3DBOX_NORMAL:DF_3DBOX_PRESSED) | ((fillc)?DF_3DBOX_FILL:0), fillc)

MG_EXPORT ZVOID GUIAPI DrawFlatControlFrameEx (HDC hdc, HWND hwnd, ZSINT32 x0, ZSINT32 y0, ZSINT32 x1, ZSINT32 y1, 
            ZSINT32 corner, ZDWORD flags, gal_pixel fillc);

#define DrawFlatControlFrame(hdc, x0, y0, x1, y1, fillc, updown) \
            DrawFlatControlFrameEx(hdc, HWND_DESKTOP, x0, y0, x1, y1, 3, \
            (updown?DF_3DBOX_NORMAL:DF_3DBOX_PRESSED) | ((fillc)?DF_3DBOX_FILL:0), fillc)

MG_EXPORT ZVOID GUIAPI Draw3DThickFrameEx (HDC hdc, HWND hwnd,
                ZSINT32 l, ZSINT32 t, ZSINT32 r, ZSINT32 b, ZDWORD flags, gal_pixel fillc);

#define Draw3DUpThickFrame(hdc, l, t, r, b, fillc) \
            Draw3DThickFrameEx(hdc, HWND_DESKTOP, l, t, r, b, DF_3DBOX_NORMAL | ((fillc)?DF_3DBOX_FILL:0), fillc)

#define Draw3DDownThickFrame(hdc, l, t, r, b, fillc) \
            Draw3DThickFrameEx(hdc, HWND_DESKTOP, l, t, r, b, DF_3DBOX_PRESSED | ((fillc)?DF_3DBOX_FILL:0), fillc)

#define Draw3DUpFrame   Draw3DUpThickFrame
#define Draw3DDownFrame Draw3DDownThickFrame

MG_EXPORT ZVOID GUIAPI Draw3DThinFrameEx (HDC hdc, HWND hwnd,
                ZSINT32 l, ZSINT32 t, ZSINT32 r, ZSINT32 b, ZDWORD flags, gal_pixel fillc);

#define Draw3DUpThinFrame(hdc, l, t, r, b, fillc) \
            Draw3DThinFrameEx(hdc, HWND_DESKTOP, l, t, r, b, DF_3DBOX_NORMAL | ((fillc)?DF_3DBOX_FILL:0), fillc)

#define Draw3DDownThinFrame(hdc, l, t, r, b, fillc) \
            Draw3DThinFrameEx(hdc, HWND_DESKTOP, l, t, r, b, DF_3DBOX_PRESSED | ((fillc)?DF_3DBOX_FILL:0), fillc)

MG_EXPORT ZVOID GUIAPI Draw3DBorderEx (HDC hdc, HWND hwnd, ZSINT32 l, ZSINT32 t, ZSINT32 r, ZSINT32 b);

#define Draw3DBorder(hdc, l, t, r, b)   \
            Draw3DBorderEx(hdc, HWND_DESKTOP, l, t, r, b)

MG_EXPORT ZVOID GUIAPI DisabledTextOutEx (HDC hdc, HWND hwnd, ZSINT32 x, ZSINT32 y, const ZCHAR* szText);

MG_EXPORT ZVOID GUIAPI NotifyParentEx (HWND hwnd, ZSINT32 id, ZSINT32 code, ZDWORD add_data);

#define NotifyParent(hwnd, id, code) \
                NotifyParentEx(hwnd, id, code, 0)

typedef ZSINT32 (*STRCMP) (const ZCHAR* s1, const ZCHAR* s2, size_t n);

MG_EXPORT ZSINT32 GUIAPI DefaultPageProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif

