#ifndef _ZCORE_CTRL_TEXT_H_
#define _ZCORE_CTRL_TEXT_H_

#include "zcore_type.h"
#include "zcore_mem.h"

#ifdef __cplusplus
extern "C"
{
#endif

#define inline __inline

typedef struct strbuffer_s
{
    ZUINT8 *string;
    ZSINT32           txtlen;
    ZSINT32           blocksize;
    ZSINT32           buffsize;
} StrBuffer;

#define te_alloc                         tp_os_mem_malloc
#define te_free                          tp_os_mem_free
#define te_realloc(ptr, size, cpysize)   realloc(ptr, size)

static inline ZVOID* testr_alloc (StrBuffer *txtbuff, size_t len, size_t blocksize)
{
    txtbuff->buffsize = (len + 1) + (blocksize - (len + 1)%blocksize);
    txtbuff->string = (ZUINT8 *)te_alloc (txtbuff->buffsize);
    txtbuff->blocksize = blocksize;
    return txtbuff->string;
}

static inline ZVOID* testr_realloc (StrBuffer *txtbuff, size_t len)
{
    if (len + 1 > (size_t)txtbuff->buffsize ||
            len + 1 < (size_t)(txtbuff->buffsize - txtbuff->blocksize))
    {
        size_t old_size;
        old_size  = txtbuff->buffsize;
        txtbuff->buffsize = (len + 1) + (txtbuff->blocksize -
                                         (len + 1)%txtbuff->blocksize);
        txtbuff->string = (ZUINT8 *)te_realloc (txtbuff->string, txtbuff->buffsize, old_size);
    }

    return txtbuff->string;
}

static inline ZVOID testr_free (StrBuffer *txtbuff)
{
    if (txtbuff)
    {
        te_free (txtbuff->string);
    }
}

static inline ZVOID
testr_setstr (StrBuffer *txtbuff, const ZCHAR *newstring, ZSINT32 len)
{
    ZSINT32 datalen;

    if (len < 0 || !newstring)
    {
        return;
    }

    datalen = MIN(len, txtbuff->buffsize-1);
    memcpy (txtbuff->string, newstring, datalen);
    txtbuff->string[datalen] = '\0';
    txtbuff->txtlen = datalen;
}

static inline ZSINT32 testr_getCharLen (ZUINT8 *CurStr,ZSINT32 CurStrLen, ZCHAR Char_notCount)
{
    ZSINT32  CharCount = 0;
    ZSINT32  loop =0;

    for(loop = 0; loop<CurStrLen; loop++)
    {
        if(CurStr[loop] == Char_notCount)
        {
            loop++;
            continue;
        }
        if((CurStr[loop] > 127) /*|| (CurStr[loop] < 0)*/)
        {
            CharCount++;
            loop++;
        }
        else
        {
            CharCount++;
        }
    }
    return CharCount;
}

static inline StrBuffer* testr_copy (StrBuffer *des, StrBuffer *src)
{
    if (!des || !src)
    {
        return NULL;
    }

    testr_free (des);
    testr_alloc (des, src->txtlen, des->blocksize);
    testr_setstr (des, (const ZCHAR *)src->string, src->txtlen);
    return des;
}
static inline StrBuffer* testr_dup (StrBuffer *s1)
{
    StrBuffer *s2;

    if (!s1)
    {
        return NULL;
    }

    s2 = malloc (sizeof(StrBuffer));
    if (s2) {
        testr_alloc (s2, s1->txtlen, s1->blocksize);
        testr_setstr (s2, (const ZCHAR *)s1->string, s1->txtlen);
    }
    return s2;
}
static inline StrBuffer* testr_dup2 (StrBuffer *s2, StrBuffer *s1)
{
    if (!s1 || !s2)
    {
        return NULL;
    }

    testr_alloc (s2, s1->txtlen, s1->blocksize);
    testr_setstr (s2, (const ZCHAR *)s1->string, s1->txtlen);
    return s2;
}

ZSINT32 GetLastMCharLen (PLOGFONT log_font, const ZCHAR* mstr, ZSINT32 len);

#define CHLENPREV(pStr, pIns) \
        ( GetLastMCharLen (GetWindowFont(hWnd), (const ZCHAR *)pStr, (const ZCHAR *)pIns - (const ZCHAR *)pStr) )

#define CHLENNEXT(pIns, len) \
        ( GetFirstMCharLen (GetWindowFont(hWnd), (const ZCHAR*)pIns, len) )


#ifdef __cplusplus
}
#endif  /* __cplusplus */


#endif  /* _ZCORE_CTRL_TEXT_H_ */

