#ifndef _TURNTABLE_H
#define _TURNTABLE_H

#ifdef __cplusplus
extern "C"
{
#endif
#include "zcore_type.h"
#include "gdi.h"
#include "window.h"
#include "cliprect.h"
#include "internals.h"


#define     SUPPORT_FOCUS   


#define CTRL_TURNTABLE ("Turntable") 

#define DT_STYLE_TEXT 0x0000001L
#define DT_STYLE_PIC 0x0000002L

#define DT_STYLE_HORIZON  0x00000004L
#define DT_STYLE_VERTICAL 0x00000008L

#define DT_STYLE_AUTOWRAP 0x00000010L
#define DT_STYLE_DYNAMIC   0x00000020L
#define DT_STYLE_ZERO_EXPAND   0x00000040L


#define DTM_SET_CURRENTINDEX 0xFF01
#define DTM_GET_CURRENTINDEX 0xFF02
#define DTM_SET_BACKGROUND_IMAGE 0xFF03
#define DTM_SET_TEXT_ATTR        0xFF04
#define DTM_SET_BOUND       0xFF05

#ifdef SUPPORT_FOCUS
#define DTM_SET_HILIGHT_IMAGE 0xFF06

typedef enum
{
	NORMAL_IMAGE,
	FOCUS_IMAGE
	
}HilightImage;

#endif

#define DT_INDEXCHANGED  0x0100

typedef enum
{
	DT_LAYOUT_VERTICAL,
	DT_LAYOUT_HORIZON
	
}DTLayoutType;


typedef enum
{
	DT_DRAWMODE_TEXT,
	DT_DRAWMODE_PIC
	
}DTDrawMode;

typedef struct
{
	ZSINT32 count;                                    /*ֻλͼܸ*/
       ZSINT32 CoveredCount;                          /*ָֹǵķΧʾֻͼƬĸ*/
    	ZSINT32 UpperBound;                         /*ıģʽʾֵϽֵ */
	ZSINT32 LowerBound;                         /*ıģʽʾֵ½ֵ*/
    
       PBITMAP pBackgroundImage;    /*ؼıͼƬ*/
       PBITMAP *pBitmapArray;            /*ָλͼָ룬ģʽ¸ֶЧ*/

#ifdef SUPPORT_FOCUS
       PBITMAP pNormalImage;             /*ʾʱָʾͼƬ*/
       PBITMAP pFocusImage;              /*۽󣬹ָʾͼƬ*/
#endif

}DTCtrlData;


typedef struct _TurntableData
{
	ZSINT32 index;                           /*ǰIndexֵ*/
	ZSINT32 UpperBound;                /*IndexֵͼƬģʽֵû */
	ZSINT32 LowerBound;                /*IndexֵͼƬģʽֵû*/
	ZSINT32 CoveredCount;             /*ֹҪʾĿܸ*/
       ZSINT32 count;                           /*ֻλͼܸ*/
       ZSINT32 MidCount;                     /*ֹмֵλ*/
	
	ZBOOL bAutoWrap;              /*ǷԶ״̬*/
	ZBOOL bTurnable;               /*Ƿڿɹ״̬*/
	ZBOOL bDynUpdate;            /*Ƿʵʱϱǰindex*/	
       ZBOOL bZeroExpand;          /*indexС0ʱʾʱǷindex֮ǰ*/	
       ZSINT32 MouseMoveCount;        /*ƶϢ*/	
	POINT LatestPoint;            /*ǰλ*/
	POINT StartPoint;              /*ǰһֹʼλ*/

#ifdef SUPPORT_FOCUS    
       ZBOOL bFocus;                    /*Ƿʾ۽*/
       RECT FocusRect;               /*ֵֹľ۽*/
       ZBOOL bSelfScroll;              /*Թģʽ*/
       ZBOOL bFocusHitOn;           /*Ƿ˾۽*/

       PBITMAP pNormalImage;    /*ʾʱָʾͼƬ*/
       PBITMAP pFocusImage;     /*۽󣬹ָʾͼƬ*/
#endif

	ZSINT32 trace;
    ZUINT32 LatestTick;

	DTLayoutType Layout;        /**/
	DTDrawMode    DrawMode; /*ָƷʽʹıʹͼƬͼ*/

       RECT ViewRect;                 /*ǰindexڵ*/

       Pixel TextColor;                /*ıģʽ£ʾɫ*/
       ZSINT32 TextSize;                     /*ıģʽ£ִС*/

       PBITMAP pBackgroundImage;   /*ؼıͼ*/
	PBITMAP *pBitmapArray;            /*ͼ*/	
}TurntableData;
typedef TurntableData* PTurntableData;


#ifdef __cplusplus
}
#endif

#endif
