#ifndef EXT_SPINBOX_H
#define EXT_SPINBOX_H

#include "zcore_type.h"
#ifdef  __cplusplus
extern "C" {
#endif

#define CTRL_SPINBOX                ("SpinBox")

/** Structure of the spinbox info */
typedef struct _SPININFO
{
    ZSINT32 max;
    ZSINT32 min;
    ZSINT32 cur;
} SPININFO;
typedef SPININFO *PSPININFO;

ZVOID GetSpinBoxSize (DWORD dwStyle, ZSINT32* w, ZSINT32* h);

#define SPS_AUTOSCROLL          0x00000001L

#define SPS_HORIZONTAL          0x00000010L

#define SPS_TYPE_NORMAL         0x00000000L

#define SPS_TYPE_UPARROW        0x00000100L

#define SPS_TYPE_DOWNARROW      0x00000200L

#define SPS_TYPE_MASK           0x00000F00L

#define KS_SPINPOST             0x00010000

#define SPM_SETTARGET           0xF300
#define SPM_GETTARGET           0xF301

#define SPM_SETINFO             0xF302
#define SPM_GETINFO             0xF303

#define SPM_DISABLEUP           0xF304

#define SPM_DISABLEDOWN         0xF305

#define SPM_ENABLEUP            0xF306

#define SPM_ENABLEDOWN          0xF307

#define SPM_SETCUR              0xF308

#define SPM_GETCUR              0xF309

#define SPN_REACHMIN            1

#define SPN_REACHMAX            2

#ifdef  __cplusplus
}
#endif

#endif /* EXT_SPINBOX_H */

