#ifndef GUI_FONT_NAME_H
    #define GUI_FONT_NAME_H
#include "zcore_type.h"
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

ZSINT32 fontGetFontTypeFromName (const ZCHAR* name);
ZSINT32 fontGetTypeNameFromName (const ZCHAR* name, ZCHAR* type);
ZSINT32 fontConvertFontType (const ZCHAR* type);

ZBOOL fontGetFamilyFromName (const ZCHAR* name, ZCHAR* family);

ZBOOL fontCopyStyleFromName (const ZCHAR* name, ZCHAR* style);
DWORD fontGetStyleFromName (const ZCHAR* name);
DWORD fontConvertStyle (const ZCHAR* style_part);

ZSINT32 fontGetWidthFromName (const ZCHAR* name);
ZSINT32 fontGetHeightFromName (const ZCHAR* name);
ZBOOL fontGetCharsetFromName (const ZCHAR* name, ZCHAR* charset);
ZBOOL fontGetCompatibleCharsetFromName (const ZCHAR* name, ZCHAR* charset);

ZBOOL fontGetCharsetPartFromName (const ZCHAR* name, ZCHAR* charset);
ZSINT32 charsetGetCharsetsNumber (const ZCHAR* charsets);
ZBOOL charsetGetSpecificCharset (const ZCHAR* charsets, ZSINT32 index, ZCHAR* charset);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif // GUI_FONT_NAME_H

