#ifndef MALLOC_270_H
#define MALLOC_270_H
#include "zcore_type.h"
#ifdef __cplusplus
extern "C" {
#endif

#include <stddef.h>   

#ifndef USE_DL_PREFIX
ZVOID*  malloc(size_t);
#else
ZVOID*  dlmalloc(size_t);
#endif

#ifndef USE_DL_PREFIX
ZVOID     free(ZVOID*);
#else
ZVOID     dlfree(ZVOID*);
#endif

#ifndef USE_DL_PREFIX
ZVOID*  calloc(size_t, size_t);
#else
ZVOID*  dlcalloc(size_t, size_t);
#endif


#ifndef USE_DL_PREFIX
ZVOID*  realloc(ZVOID*, size_t);
#else
ZVOID*  dlrealloc(ZVOID*, size_t);
#endif

#ifndef USE_DL_PREFIX
ZVOID*  memalign(size_t, size_t);
#else
ZVOID*  dlmemalign(size_t, size_t);
#endif


#ifndef USE_DL_PREFIX
ZVOID*  valloc(size_t);
#else
ZVOID*  dlvalloc(size_t);
#endif

#ifndef M_MXFAST
#define M_MXFAST  1
#endif


#define M_TRIM_THRESHOLD    -1


#define M_TOP_PAD           -2

#define M_MMAP_THRESHOLD    -3


#define M_MMAP_MAX          -4


#ifndef M_NBLKS
#define M_NLBLKS  2    /* UNUSED in this malloc */
#endif
#ifndef M_GRAIN
#define M_GRAIN   3    /* UNUSED in this malloc */
#endif
#ifndef M_KEEP
#define M_KEEP    4    /* UNUSED in this malloc */
#endif


#ifndef _ALLOCA_H
extern ZVOID* alloca(size_t);
#endif

#ifdef __cplusplus
};  /* end of extern "C" */
#endif

#endif
