#ifndef _ZCORE_GUI_TIMER_H
#define _ZCORE_GUI_TIMER_H

#include "zcore_type.h"
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#define MAX_TIMERS      DEF_NR_TIMERS

#define USEC_1S         1000000
#define USEC_10MS       10000

typedef struct _timer {
    HWND    hWnd;
    ZSINT32     id;
    ZUINT32 speed;
    ZUINT32 count;
}TIMER;
typedef TIMER* PTIMER;

ZBOOL InitTimer (ZVOID);
ZVOID TerminateTimer (ZVOID);
ZVOID DispatchTimerMessage (ZUINT32 inter);

HWND get_timer_hwnd (ZSINT32 slot);
ZSINT32  get_timer_id (ZSINT32 slot);

ZBOOL HaveFreeTimer (ZVOID);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* _ZCORE_GUI_TIMER_H */

