#ifndef _ZCORE_BITMAP_ICON_H
#define _ZCORE_BITMAP_ICON_H

#include "zcore_type.h"
/************************************************************************
*                ͼģس
************************************************************************/

/* LOADBITMAP Ĵ붨 */
#define ERR_BMP_OK              (ZSINT32)0
#define ERR_BMP_IMAGE_TYPE      (ZSINT32)(-1)
#define ERR_BMP_UNKNOWN_TYPE    (ZSINT32)(-2)
#define ERR_BMP_CANT_READ       (ZSINT32)(-3)
#define ERR_BMP_CANT_SAVE       (ZSINT32)(-4)
#define ERR_BMP_NOT_SUPPORTED   (ZSINT32)(-5)   
#define ERR_BMP_MEM             (ZSINT32)(-6)
#define ERR_BMP_LOAD            (ZSINT32)(-7)
#define ERR_BMP_FILEIO          (ZSINT32)(-8)
#define ERR_BMP_OTHER           (ZSINT32)(-9)
#define ERR_BMP_ERROR_SOURCE    (ZSINT32)(-10)

/*豸޹λͼ*/
#define MYBMP_TYPE_NORMAL       (ZDWORD)0x00000000
#define MYBMP_TYPE_RLE4         (ZDWORD)0x00000001
#define MYBMP_TYPE_RLE8         (ZDWORD)0x00000002
#define MYBMP_TYPE_RGB          (ZDWORD)0x00000003
#define MYBMP_TYPE_BGR          (ZDWORD)0x00000004
#define MYBMP_TYPE_RGBA         (ZDWORD)0x00000005
#define MYBMP_TYPE_MASK         (ZDWORD)0x0000000F

#define MYBMP_FLOW_DOWN         (ZDWORD)0x00000010
#define MYBMP_FLOW_UP           (ZDWORD)0x00000020
#define MYBMP_FLOW_MASK         (ZDWORD)0x000000F0

#define MYBMP_TRANSPARENT       (ZDWORD)0x00000100
#define MYBMP_ALPHACHANNEL      (ZDWORD)0x00000200
#define MYBMP_ALPHA             (ZDWORD)0x00000400

#define MYBMP_RGBSIZE_3         (ZDWORD)0x00001000
#define MYBMP_RGBSIZE_4         (ZDWORD)0x00002000

#define MYBMP_LOAD_GRAYSCALE    (ZDWORD)0x00010000
#define MYBMP_LOAD_ALLOCATE_ONE (ZDWORD)0x00020000
#define MYBMP_LOAD_NONE         (ZDWORD)0x00000000

/*豸λͼ*/
#define BMP_TYPE_NORMAL         (ZBYTE)0x00
#define BMP_TYPE_RLE            (ZBYTE)0x01
#define BMP_TYPE_ALPHA          (ZBYTE)0x02
#define BMP_TYPE_ALPHACHANNEL   (ZBYTE)0x04
#define BMP_TYPE_COLORKEY       (ZBYTE)0x10
#define BMP_TYPE_PRIV_PIXEL     (ZBYTE)0x20

#define GetRValue(rgb)      ((ZBYTE)(rgb))
#define GetGValue(rgb)      ((ZBYTE)(((ZWORD)(rgb)) >> 8))
#define GetBValue(rgb)      ((ZBYTE)((rgb) >> 16))



/************************************************************************
*                ͼģݽṹ
************************************************************************/
/*豸޹λͼṹ */
typedef struct _MYBITMAP
{
     /* Bitmap */
     /*ȡֵ:
     *  - MYBMP_TYPE_NORMAL\n
        ͨɫλͼ.
     *  - MYBMP_TYPE_RGB\n
         RGB λͼ
     *  - MYBMP_TYPE_RGBA\n
         RGBA λͼ
     *  - MYBMP_FLOW_DOWN\n
        ɨϵ.
     *  - MYBMP_FLOW_UP\n
        ɨµ.
     *  - MYBMP_TRANSPARENT\n
        ͸(transparent )ֵ
      *  - MYBMP_ALPHACHANNEL\n
    	   alpha channel.   .
      *  - MYBMP_ALPHA\n
         еλصalpha ֵ.
      *  - MYBMP_RGBSIZE_3\n
          ÿRGB triple SIZE 3 bytes.  
     *  - MYBMP_RGBSIZE_4\n
          ÿRGB triple SIZE 4 bytes.  
     *  - MYBMP_LOAD_GRAYSCALE\n
          ֪bitmap һҶֵ(grayscale).
     *  - MYBMP_LOAD_ALLOCATE_ONE\n
          ֪bitmap Ϊһscanlineռ
     */
    ZDWORD flags;
/*ṹ(frames)  */
    ZSINT32   frames;
 /* */
    ZBYTE depth;
/* alpha channel ֵ*/
    ZBYTE alpha;
/* λ*/
    ZBYTE reserved [2];
 /*͸ */
    ZDWORD transparent;
/*bitmap. */
    ZDWORD w;
/*bitmap. ߶*/
    ZDWORD h;
/*bitmap. pitch*/
    ZDWORD pitch;
/*bitmap. bits С*/
    ZDWORD size;
/*bitmap bits ָ */
    ZBYTE* bits;
};
#ifndef _TYPE_MYBITMAP
#define _TYPE_MYBITMAP
typedef struct _MYBITMAP MYBITMAP;
#endif


/*豸λͼݽṹ */ 
typedef struct T_BITMAP
{
/* Bitmap */
/*ȡֵ:
     *  - BMP_TYPE_NORMAL\n
        ͨλͼ, ûalpha color key.
     *  - BMP_TYPE_RLE\n
        RLE  bitmap, δʹ.
     *  - BMP_TYPE_ALPHA\n
        λͼеĵλصalpha .
     *  - BMP_TYPE_ALPHACHANNEL\n
         bmAlpha is a Чalpha channel ֵ.
     *  - BMP_TYPE_COLORKEY\n
         bmColorKey һЧcolor key ֵ.
     *  - BMP_TYPE_PRIV_PIXEL\n
        λͼӵԼ˽еؽṹ
*/
    ZBYTE   bmType;
/*ÿصBitsֵ*/
    ZBYTE   bmBitsPerPixel;
/*ÿصBytesֵ*/
    ZBYTE   bmBytesPerPixel;
/*Alpha ֵͨ*/
    ZBYTE   bmAlpha;
/*ؼɫ,νؼɫ,͸ɫ,
ֻҪؼɫغϵɫͲ
Ƴ*/
    ZDWORD  bmColorKey;
/*ͼֵ*/
    ZDWORD  bmWidth;
/*ͼ߶ֵ*/
    ZDWORD  bmHeight;
/*ͼȶֵ,
   widthָڴλͼһߵ
   ʼͽλõڴַ֮
   ֻڴλͼĿȣ
   λͼеһ߿ʼλ
   Ҫκζڴ档
   pitchָڴλͼһߵ
   һ߿ʼλõڴַ֮*/
    ZDWORD  bmPitch;
/*ͼBitMap*/
    ZUINT8*   bmBits;
/*˽ؽṹ */
    ZVOID*   bmAlphaPixelFormat;
}BITMAP;
#ifndef _TYPE_PBITMAP
#define _TYPE_PBITMAP
typedef BITMAP*  PBITMAP;
#endif

/*****************************************************************************
 *			FillBox
 *			ָɫˢָ
 *		HDC hdc豸
										int x, int yBOXʼ
										int wBOXĿ
										int h BOXĸ߶
 *		
 *	ֵ˵void
 *	˵	
 *****************************************************************************/
 MG_EXPORT ZVOID GUIAPI FillBox (HDC hdc, ZSINT32 x, ZSINT32 y, ZSINT32 w, ZSINT32 h);


/*****************************************************************************
 *			FillBoxWithBitmap
 *				ʹͼָ
 *		HDC hdc豸
										int x, int yBOXʼ
										int wBOXĿ
										int h BOXĸ߶
										const BITMAP *bmpBOXͼ 
								     
 *		
 *	ֵ˵TRUE ɹ,  FALSE.ʧ
 *	˵	ͼƥ䣬췽ʽ
 *****************************************************************************/
MG_EXPORT ZBOOL GUIAPI FillBoxWithBitmap (HDC hdc, ZSINT32 x, ZSINT32 y, ZSINT32 w, ZSINT32 h,
                const BITMAP *bmp);



/*****************************************************************************
 *			FillBoxWithBitmapPart
 *				ʹָͼһָ
 *		HDC hdc豸
										int x, int yBOXʼ
										int wBOXĿ
										int h BOXĸ߶
										const BITMAP *bmpBOXͼ 
								       int bw λͼĿ
								            [Ϊ0ʾΪBITMAPĿ]
								       int bw λͼĸ߶
								            [Ϊ0ʾΪBITMAPĸ߶]	 
         							   const BITMAP* bmp ͼָ
         							   int xo, int yo ʹͼϽǵʼλ
 *		
 *	ֵ˵void
 *	˵	
 *****************************************************************************/
MG_EXPORT ZBOOL GUIAPI FillBoxWithBitmapPart (HDC hdc, ZSINT32 x, ZSINT32 y, ZSINT32 w, ZSINT32 h,
                ZSINT32 bw, ZSINT32 bh, const BITMAP* bmp, ZSINT32 xo, ZSINT32 yo);



/*****************************************************************************
 *			BitBlt
 *				ָԴ豸еؽλ飨bit_blockת
                            Դ͵Ŀ豸
 *		HDC hsdcԴ豸
										int dx, int dyԴ豸Ͻǵ
										int swԴĿ
										int sh       Դ ĸ߶
										HDC hddc  Ŀ豸?
								       int dx , int dy Ŀ豸Ͻǵ    
         							   ZDWORD dwRop תʽĿǰ֧
 *		
 *	ֵ˵void
 *	˵	úĿǰֲֻ֧ת
                                  Դ豸Ŀ豸һ
 *****************************************************************************/

MG_EXPORT ZVOID GUIAPI BitBlt (HDC hsdc, ZSINT32 sx, ZSINT32 sy, ZSINT32 sw, ZSINT32 sh, 
                HDC hddc, ZSINT32 dx, ZSINT32 dy, ZDWORD dwRop);


/*****************************************************************************
 *			LoadBitmapFromFile
 *				ûṩ·
                            ͼļת豸λͼ
 *		HDC hdc,  豸
                                  const char* spFileName ͼļ·
 *		PBITMAP pBitmap豸λͼ
 *	ֵ˵:ض
 *	˵	LoadBitmap Լbits ռ;
                                  λͼʹϣӦUnloadBitmap ͷ
 *****************************************************************************/
#define LoadBitmap LoadBitmapFromFile
MG_EXPORT ZSINT32 GUIAPI LoadBitmapFromFile (HDC hdc, PBITMAP pBitmap, const ZCHAR* spFileName);


/*****************************************************************************
*         LoadBitmapToFitSize
*           ļϵͳмλͼû趨ߴŴ
*       HDC hdc  豸
*                 const ZCHAR* file_name  ͼļ·
*                 ZSINT32 user_w,user_h   û趨ųߴ
*       PBITMAP bmp 豸λͼ
*   ֵ˵  ERR_BMP_OKɹ
*                 ERR_BMP_MEM ڴʧ
*                 ERR_BMP_OTHER 
*   ˵    λͼʹӦUnloadBitmapͷ
*                 1λͼ߾ <= user_w,user_h,λͼֱ
*                 2λͼ߾ >= user_w,user_h,ȡԴλͼзϱ
*                    ԺΪ
*                 3λͼ<=user_w,λͼ>user_h,ȡλͼһ
*                 4λͼ>user_w,λͼ<=user_h,ȡλͼһ
*****************************************************************************/
ZSINT32 GUIAPI LoadBitmapToFitSize(HDC hdc, BITMAP *bmp, const ZCHAR* file_name,ZSINT32 user_w,ZSINT32 user_h);


/*****************************************************************************
 *			ExpandMyBitmap
 *				û豸޹λͼת
                            豸λͼ
 *		HDC hdc,  豸
                                  const MYBITMAP* pMyBitmap 豸޹λͼ
                                  const RGB* pal ɫ  
 *		PBITMAP pBitmap豸λͼ
 *	ֵ˵:ض
 *	˵	LoadBitmap Լbits ռ;
                                  λͼʹϣӦUnloadBitmap ͷ
 *****************************************************************************/
ZSINT32 GUIAPI ExpandMyBitmap (HDC hdc, const MYBITMAP* pMyBitmap, const RGB* pal, PBITMAP pBitmap,ZBOOL freeBmp);

/*****************************************************************************
 *			InitBitmap
 *				ûṩĲͨBITMAP
 *		 HDC hdc 豸
										Uint32 w, BITMAPĿ
										Uint32 h,  BITMAPĸ߶
										Uint32 pitch BITMAP 
										ZBYTE* bits BITMAPָ									
 *		 PBITMAP bmp ɵλͼ
 *	ֵ˵BOOL TRUEɹFALSEʧ
 *	˵	LoadBitmap ԼΪPBITMAP ռ䣬InitBitmap
                                  λͼʹϣӦUnloadBitmap ͷ
 *****************************************************************************/
 MG_EXPORT ZBOOL GUIAPI InitBitmap (HDC hdc, ZDWORD w, ZDWORD h, ZDWORD pitch, ZBYTE* bits, PBITMAP bmp);



/*****************************************************************************
 *			UnloadBitmap
 *				úͷָλͼռ
 *		PBITMAP pBitmap豸λͼ
 *		 
 *	ֵ˵
 *	˵	
 *****************************************************************************/
MG_EXPORT ZVOID GUIAPI UnloadBitmap (PBITMAP pBitmap);

/*****************************************************************************
 *			PutSavedBoxOnDC
 *				
 *		HDC hsdcԴ豸
										int x, int y, int w, int h, С
										ݳߴƥ
								       void* vbuf ָ
								       (ΪͼBitMapbmp.bmBits)
								       modified by ZhengQing 189951 CQNJ00118065
 *		
 *	ֵ˵void
 *	˵	
 *****************************************************************************/
ZVOID GUIAPI PutSavedBoxOnDC (HDC hdc, ZSINT32 x, ZSINT32 y, ZSINT32 w, ZSINT32 h, ZVOID* vbuf);


  /*****************************************************************************
 *			IMGMGT_GetPixelInBitmap
 *			ȡλͼָصֵ
 *		const BITMAP* bmp,λͼָ
 									  int x, int y    (x,y)        
 *		
 *	ֵ˵gal_pixel صɫֵ,Χ0
 *	˵	bmp ΪNULLֱӳ򱨴
 *****************************************************************************/
MG_EXPORT gal_pixel GUIAPI GetPixelInBitmap (const BITMAP* bmp, ZSINT32 x, ZSINT32 y);

 /*****************************************************************************
 *			IMGMGT_SetBitmapKeyColor
 *			趨ָλͼKEYCOLOR
 *		PBITMAP bmp,λͼָ
 									  Uint8 r, Uint8 g, Uint8 b RGB        
 *		
 *	ֵ˵  ɹ͸ɫطֵʧܷ0
 *	˵	뱣֤bmp ֵȷ;λͼĳֵõֵȣ
 *                ˵㲻ʾ(͸)
 *****************************************************************************/
 MG_EXPORT ZSINT32 GUIAPI SetBitmapKeyColor( PBITMAP bmp, ZBYTE r, ZBYTE g, ZBYTE b);

  /*****************************************************************************
 *			StretchPaintImageFromFile
 *			ļȡһͼ֪豸
 *		HDC hsdc豸
                                  const char* spFileName,ͼļ·
 									  int x, int y    (x,y)   
 									  int w, int h   Χ
 *		
 *	ֵ˵0ɹʧ
 *	˵	
 *****************************************************************************/
MG_EXPORT ZSINT32 GUIAPI StretchPaintImageFromFile (HDC hdc, ZSINT32 x, ZSINT32 y, 
                ZSINT32 w, ZSINT32 h, const ZCHAR* spFileName);

   /*****************************************************************************
 *			GetBitmapFromDC
 *			ָ豸ϻȡָΧͼϢ
 *		HDC hsdc豸
 									  int x, int y    (x,y)   
 									  int w, int h   Χ
 									  BITMAP* bmp 洢ͼλͼ
 *		
 *	ֵ˵TRUE,ɹFALSEʧ
 *	˵	bmp->bits ɸúڴ棬ʹú
                                  UnloadBitmap ͷŵ
 *****************************************************************************/
MG_EXPORT ZBOOL GUIAPI GetBitmapFromDC (HDC hdc, 
                ZSINT32 x, ZSINT32 y, ZSINT32 w, ZSINT32 h, BITMAP* bmp);


   /*****************************************************************************
 *			LoadIconFromFile
 *			ȡָWindows ICO ļһicon 
 *		HDC hdc豸
 									  const char* szFileName ļ  
 									  int iWhich ȡĸͼ
 *		
 *	ֵ˵0ʧܣICON ָ
 *	˵	úܹLOAD mono-  16-color ͼꡣ
   			һЩWindows ICO	ļ2 Сͬͼꡣͨ
   			iWhich ֪ȡһ[0һ1ڶ]
   			ͨͼǴͼꡣ
   			ڵ˽ӿںDestroyIcon()ͷԴ//added by zhuhaiyan093442
 *****************************************************************************/
MG_EXPORT HICON GUIAPI LoadIconFromFile (HDC hdc, const ZCHAR* szFileName, ZSINT32 iWhich);


 /*****************************************************************************
 *			LoadIconFromMem
 *			ȡָڴ򣬲һicon 
 *		HDC hdc豸
 									  onst void* area ڴָ  
 									  int iWhich ȡĸͼ
 *		
 *	ֵ˵0ʧܣICON ָ?
 *	˵	úܹLOAD mono-  16-color ͼꡣ
   			һЩWindows ICO	ļ2 Сͬͼꡣͨ
   			iWhich ֪ȡһ[0һ1ڶ]
   			ͨͼǴͼꡣ
 *****************************************************************************/
MG_EXPORT HICON GUIAPI LoadIconFromMem (HDC hdc, const ZVOID* pArea, ZSINT32 iWhich);


  /*****************************************************************************
 *			CreateIcon
 *			һicon 
 *		HDC hdc, 
 									  int w, int h, 
                        				const ZBYTE* pbAndBits, 
                        				const ZBYTE* pbXorBits, 
                        				int iColorNum
 *		
 *	ֵ˵0ʧܣICON ָ
 *	˵	úڴݶļһicon
 *  nt w, int h ֱicon Ŀ͸ߣpbAndBits pbXorBits ͼ
 *  AND XOR [bitmask]ǰ֧ mono-color ָ  16-color ͼꡣ
 *  int iColorNum ͼλ[] :1 ,mono-color;4,16-color.
 *  w  h pbAndBits  pbXorBits ĴСƥ䣬
 *****************************************************************************/
MG_EXPORT HICON  GUIAPI CreateIcon (HDC hdc, ZSINT32 w, ZSINT32 h, const ZBYTE* pbAndBits, 
                        const ZBYTE* pbXorBits, ZSINT32 iColorNum);


  /*****************************************************************************
 *			DestroyIcon
 *			ݻһicon 
 *		HICON hicon
 *		
 *	ֵ˵TRUE,ɹFALSEʧ
 *	˵	
 *****************************************************************************/
MG_EXPORT ZBOOL GUIAPI DestroyIcon (HICON hicon);


  /*****************************************************************************
 *			DestroyIcon
 *			ȡicon SIZE
 *		HICON hicon
 *		 int* w, int* h
 *	ֵ˵TRUE,ɹFALSEʧ
 *	˵	
 *****************************************************************************/
MG_EXPORT ZBOOL GUIAPI GetIconSize (HICON hicon, ZSINT32* w, ZSINT32* h);


/*****************************************************************************
 *			DrawIcon
 *			icon ͼ
 *		HDC hdc, 
									 int x, int y, 
									 int w, int h, 
									 HICON hicon
 *		 
 *	ֵ˵
 *	˵	
 *****************************************************************************/
MG_EXPORT ZVOID GUIAPI DrawIcon (HDC hdc, ZSINT32 x, ZSINT32 y, ZSINT32 w, ZSINT32 h, HICON hicon);

#endif //_ZCORE_BITMAP_ICON_H
