#ifndef _ZCORE_REGION_H
#define _ZCORE_REGION_H
#include "zcore_type.h"
#include "os_type.h"
typedef struct _T_REGION_BLOCKHEAP
{
    ZSINT32				iLock;					/* ÿblockĳߴ */
    ZSINT32             sBlockSize;				/* ÿblockĳߴ */
    ZSINT32             sBlockTotalNum;			/* ܹblock */
    ZSINT32             iFree;					/* ʣblockʼλ */
    ZVOID*           ptRegionHeap;				/* ָ */
} T_REGION_BLOCKHEAP;
typedef T_REGION_BLOCKHEAP* PT_REGION_BLOCKHEAP;


typedef struct _T_RECT_CLIPRECT
{
    RECT rc;
    struct _T_RECT_CLIPRECT *next;
    struct _T_RECT_CLIPRECT *prev;
} T_RECT_CLIPRECT;
typedef T_RECT_CLIPRECT* PT_RECT_CLIPRECT;
typedef PT_RECT_CLIPRECT PCLIPRECT;

typedef struct _T_REGION_CLIPRGN
{
    RECT            	rcBound;
    PT_RECT_CLIPRECT      	head;
    PT_RECT_CLIPRECT      	tail;
    PT_REGION_BLOCKHEAP   	heap;
} T_REGION_CLIPRGN;
typedef T_REGION_CLIPRGN* PT_REGION_CLIPRGN;



#ifndef _TYPE_OS_SEMA_ID
#define _TYPE_OS_SEMA_ID
typedef UINT32 OS_SEMA_ID;
#endif

#ifndef _TYPE_OS_MUTEX_ID
#define _TYPE_OS_MUTEX_ID
typedef UINT32 OS_MUTEX_ID;
#endif

typedef struct _T_WM_WGINFO
{
    OS_MUTEX_ID                 lock;
    T_REGION_CLIPRGN         	crgn;
    ZSINT32                     age;
} T_WM_WGINFO;
typedef T_WM_WGINFO* PT_WM_WGINFO;

typedef T_REGION_BLOCKHEAP BLOCKHEAP;
typedef T_REGION_CLIPRGN CLIPRGN;

typedef struct tagINVRGN
{
    OS_MUTEX_ID  lock;
    CLIPRGN         rgn;
    ZSINT32             frozen;
} INVRGN;
typedef INVRGN* PINVRGN;

typedef T_WM_WGINFO GCRINFO;
typedef T_WM_WGINFO* PGCRINFO;


typedef BLOCKHEAP* PBLOCKHEAP;

extern 	ZBOOL Region_ExcludeClipRect (HDC hdc, RECT *prc);
extern 	ZBOOL Region_IncludeClipRect (HDC hdc, RECT *prc);
extern 	ZBOOL Region_ClipRectIntersect (HDC hdc, RECT *prc);
extern	ZBOOL Region_IntersectClipRect (PT_REGION_CLIPRGN pRgn, RECT *pRect);
extern	ZBOOL Region_SelectClipRect (HDC hdc, RECT *prc);
extern	ZBOOL Region_SubtractClipRect (PT_REGION_CLIPRGN pRgn, RECT *ptRc);
extern 	ZBOOL Region_SelectClipRegion (HDC hdc, T_REGION_CLIPRGN *pRgn);
extern 	ZBOOL Region_EvaluateBoundRect (PT_REGION_CLIPRGN pRgn);
extern 	ZBOOL Region_InitClipRgn (PT_REGION_CLIPRGN pRgn, PT_REGION_BLOCKHEAP ptRegionHeap);
extern 	ZBOOL Region_SetClipRgn (PT_REGION_CLIPRGN pRgn, RECT *pRect);
extern	ZBOOL Region_SetRgnEmpty (PT_REGION_CLIPRGN pRgn);
extern	ZBOOL Region_AddClipRect (PT_REGION_CLIPRGN pRgn, RECT *prc);
extern	ZBOOL Region_ClipRgnCopy (PT_REGION_CLIPRGN pDstRgn, PT_REGION_CLIPRGN pSrcRgn);

extern 	ZVOID   ExcludeClipRect (HDC hdc, const RECT* prc);
extern 	ZVOID   IncludeClipRect (HDC hdc, const RECT* prc);
extern 	ZVOID   ClipRectIntersect (HDC hdc, const RECT* prc);
typedef PT_REGION_CLIPRGN PCLIPRGN;
//typedef T_REGION_BLOCKHEAP BLOCKHEAP;
//typedef BLOCKHEAP* PBLOCKHEAP;
//typedef T_REGION_CLIPRGN CLIPRGN;
extern	ZBOOL  IntersectClipRect (PCLIPRGN pRgn, const RECT* pRect);
extern	ZVOID  SelectClipRect (HDC hdc, const RECT* prc);
extern	ZBOOL SubtractClipRect (PCLIPRGN pRgn, const RECT* pRect);
extern 	ZVOID SelectClipRegion (HDC hdc, const CLIPRGN* pRgn);
extern ZVOID  InitClipRgn (PCLIPRGN pRgn, PBLOCKHEAP pFreeList);
extern 	ZBOOL  SetClipRgn (PCLIPRGN pRgn, const RECT* pRect);
extern	ZBOOL  AddClipRect (PCLIPRGN pRgn, const RECT* pRect);
extern	ZBOOL  ClipRgnCopy (PCLIPRGN pDstRgn, const CLIPRGN* pSrcRgn);
extern ZVOID  EmptyClipRgn (PCLIPRGN pRgn);

#endif//_ZCORE_REGION_H
