#ifndef _ZCORE_TEXT_H
#define _ZCORE_TEXT_H
#include "zcore_type.h"

/*************SIZE سSTART*{***********/
/*Ŀǰִ֧СΪ121624 */
#define FONT_MAX_SIZE               (ZWORD)256
#define FONT_MIN_SIZE               (ZWORD)4
/*************SIZE سEND*}***********/

/*************START*{***********/
#define LEN_FONT_NAME               (ZBYTE)15
/*************END*}***********/

/**************************************************************/

/************************************************************************
*                 غ궨
************************************************************************/
/*************ʽʶSTART{*************/
#define FONT_CHAR_NULL '\0'
#define FONT_CHAR_STAR '*'
#define FONT_CHAR_c 'c'
#define FONT_CHAR_b 'b'
#define FONT_CHAR_k 'k'
#define FONT_CHAR_d 'd'
#define FONT_CHAR_l 'l'
#define FONT_CHAR_m 'm'
#define FONT_CHAR_r 'r'
#define FONT_CHAR_i 'i'
#define FONT_CHAR_o 'o'
#define FONT_CHAR_s 's'
#define FONT_CHAR_n 'n'
#define FONT_CHAR_p 'p'
#define FONT_CHAR_u 'u'
#define FONT_CHAR_S 'S'
#define FONT_CHAR_N 'N'
#define FONT_CHAR_K 'K'
#define FONT_CHAR_R 'R'
#define FONT_CHAR_P 'P'
#define FONT_CHAR_Q 'Q'


/*******************************************
*ĺ궨ʶֽ׶
 *   Ҫʽͣ
 *ü
 *******************************************/
#define FONT_WEIGHT_NIL                 FONT_CHAR_NULL //'\0'
#define FONT_WEIGHT_ALL                 FONT_CHAR_STAR //'*'
#define FONT_WEIGHT_BLACK               FONT_CHAR_c //'c'
#define FONT_WEIGHT_BOLD                FONT_CHAR_b //'b'
#define FONT_WEIGHT_BOOK                FONT_CHAR_k //'k'
#define FONT_WEIGHT_DEMIBOLD            FONT_CHAR_d //'d'
#define FONT_WEIGHT_LIGHT               FONT_CHAR_l //'l'
#define FONT_WEIGHT_MEDIUM              FONT_CHAR_m //'m'
#define FONT_WEIGHT_REGULAR             FONT_CHAR_r //'r'

#define FONT_SLANT_NIL                  FONT_CHAR_NULL //'\0'
#define FONT_SLANT_ALL                  FONT_CHAR_STAR//'*'
#define FONT_SLANT_ITALIC               FONT_CHAR_i //'i'
#define FONT_SLANT_OBLIQUE              FONT_CHAR_o //'o'
#define FONT_SLANT_ROMAN                FONT_CHAR_r //'r'

#define FONT_SETWIDTH_NIL               FONT_CHAR_NULL //'\0'
#define FONT_SETWIDTH_ALL               FONT_CHAR_STAR //'*'
#define FONT_SETWIDTH_BOLD              FONT_CHAR_b //'b'
#define FONT_SETWIDTH_CONDENSED         FONT_CHAR_c //'c'
#define FONT_SETWIDTH_SEMICONDENSED     FONT_CHAR_s //'s'
#define FONT_SETWIDTH_NORMAL            FONT_CHAR_n //'n'

#define FONT_SPACING_NIL                FONT_CHAR_NULL //'\0'
#define FONT_SPACING_ALL                FONT_CHAR_STAR//'*'
#define FONT_SPACING_MONOSPACING        FONT_CHAR_m //'m'
#define FONT_SPACING_PROPORTIONAL       FONT_CHAR_p //'p'
#define FONT_SPACING_CHARCELL           FONT_CHAR_c //'c'

#define FONT_UNDERLINE_NIL              FONT_CHAR_NULL //'\0'
#define FONT_UNDERLINE_ALL              FONT_CHAR_STAR //'*'
#define FONT_UNDERLINE_LINE             FONT_CHAR_u //'u'
#define FONT_UNDERLINE_NONE             FONT_CHAR_n //'n'

#define FONT_STRUCKOUT_NIL              FONT_CHAR_NULL //'\0'
#define FONT_STRUCKOUT_ALL              FONT_CHAR_STAR //'*'
#define FONT_STRUCKOUT_LINE             FONT_CHAR_s //'s'
#define FONT_STRUCKOUT_NONE             FONT_CHAR_n //'n'

#define FONT_OTHER_NIL                  FONT_CHAR_NULL //'\0'
#define FONT_OTHER_AUTOSCALE            FONT_CHAR_S //'S'
#define FONT_OTHER_TTFNOCACHE           FONT_CHAR_N //'N'
#define FONT_OTHER_TTFKERN              FONT_CHAR_K //'K'
#define FONT_OTHER_TTFNOCACHEKERN       FONT_CHAR_R //'R'
#define FONT_OTHER_LCDPORTRAIT          FONT_CHAR_P //'P'
#define FONT_OTHER_LCDPORTRAITKERN      FONT_CHAR_Q //'Q'

#define FS_WEIGHT_MASK                  0xFF
#define FS_WEIGHT_BLACK                 0x1
#define FS_WEIGHT_BOLD                  0x2
#define FS_WEIGHT_BOOK                  0x4
#define FS_WEIGHT_DEMIBOLD              0x6
#define FS_WEIGHT_LIGHT                 0x10
#define FS_WEIGHT_MEDIUM                0x20
#define FS_WEIGHT_REGULAR               0x0

#define FS_SLANT_MASK                   0xF00
#define FS_SLANT_ITALIC                 0x100
#define FS_SLANT_OBLIQUE                0x200
#define FS_SLANT_ROMAN                  0x0

#define FS_SETWIDTH_MASK                0xF000
#define FS_SETWIDTH_BOLD                0x1000
#define FS_SETWIDTH_CONDENSED           0x2000
#define FS_SETWIDTH_SEMICONDENSED       0x4000
#define FS_SETWIDTH_NORMAL              0x0

#define FS_SPACING_MASK                 0xF0000
#define FS_SPACING_MONOSPACING          0x10000
#define FS_SPACING_PROPORTIONAL         0x20000
#define FS_SPACING_CHARCELL             0x0

#define FS_UNDERLINE_MASK               0xF00000
#define FS_UNDERLINE_LINE               0x100000
#define FS_UNDERLINE_NONE               0x0

#define FS_STRUCKOUT_MASK               0xF000000
#define FS_STRUCKOUT_LINE               0x1000000
#define FS_STRUCKOUT_NONE               0x0

#define FS_OTHER_MASK                   0xFF0000
#define FS_OTHER_AUTOSCALE              0x10000
#define FS_OTHER_TTFNOCACHE             0x20000
#define FS_OTHER_TTFKERN                0x40000
#define FS_OTHER_TTFNOCACHEKERN         0x60000
#define FS_OTHER_LCDPORTRAIT            0x100000
#define FS_OTHER_LCDPORTRAITKERN        0x140000
/*************ʽʶEND***********}*/


/*************ͱʶSTART{*************/

/*******************************************
 *ĺ궨ʶֽ׶ 
 *Ҫ[]
 *ü
 *******************************************/

/*ԭʼbitmap */
#define FONT_TYPE_NAME_BITMAP_RAW   "rbf"
/*bitmap */
#define FONT_TYPE_NAME_BITMAP_VAR   "vbf"
/*ԭʼbitmap   bitmap */
#define FONT_TYPE_NAME_BITMAP_QPF   "qpf"
/*TrueType<ݲʵ>*/
#define FONT_TYPE_NAME_SCALE_TTF    "ttf"
 /*Adobe Type1<ݲʵ>*/
#define FONT_TYPE_NAME_SCALE_T1F    "t1f"
/* 壻*/
#define FONT_TYPE_NAME_ALL          "*"

/*******************************************
/*ĺʶ߼ṹеͣ
 *ʸʹ
 *ü
 *******************************************/
#define FONT_TYPE_BITMAP_RAW            (ZBYTE)0x1  /*"rbf" */
#define FONT_TYPE_BITMAP_VAR            (ZBYTE)0x2  /*"vbf" */
#define FONT_TYPE_BITMAP_QPF            (ZBYTE)0x3  /*"qpf" */
#define FONT_TYPE_SCALE_TTF             (ZBYTE)0x10  /*"ttf" */
#define FONT_TYPE_SCALE_T1F             (ZBYTE)0x11  /*"t1f" */
#define FONT_TYPE_ALL                   (ZBYTE)0xFF  /*"all" */

/*************ͱʶEND***********}*/

/************ַʶSTART{*************/

/*******************************************
*ĺ궨ʶֽ׶ 
 *Ҫַ뼯
 *ü
 *******************************************/
///////////////////////////////////////////////////////
#define FONT_CHARSET_KSC5636_0          "KSC5636-0"
#define FONT_CHARSET_KSC5601_0          "KSC5601-0"
///////////////////////////////////////////////////////
#define FONT_CHARSET_EUCJP              "EUC-JP"
#define FONT_CHARSET_JISX0201_0         "JISX0201-0"
#define FONT_CHARSET_JISX0208_0         "JISX0208-0"
///////////////////////////////////////////////////////
#define FONT_CHARSET_SHIFTJIS           "SHIFT-JIS"
#define FONT_CHARSET_JISX0201_1         "JISX0201-1"
#define FONT_CHARSET_JISX0208_1         "JISX0208-1"
///////////////////////////////////////////////////////
#define FONT_CHARSET_ISO_10646_1        "ISO-10646-1"
#define FONT_CHARSET_UTF8               "UTF-8"
///////////////////////////////////////////////////////
#define FONT_CHARSET_EUC_CN             "EUC-CN"
#define FONT_CHARSET_GB1988_0           "GB1988-0"
#define FONT_CHARSET_GB2312_0           "GB2312-0"
///////////////////////////////////////////////////////
#define FONT_CHARSET_GBK                "GBK"
#define FONT_CHARSET_GB18030_0          "GB18030-0"
///////////////////////////////////////////////////////
#define FONT_CHARSET_BIG5               "BIG5"
#define FONT_CHARSET_EUCTW              "EUC-TW"
#define FONT_CHARSET_EUCKR              "EUC-KR"
///////////////////////////////////////////////////////
#define FONT_CHARSET_US_ASCII           "US-ASCII"

///////////////////////////////////////////////////////
#define FONT_ISO8859_PREFIX "ISO8859"
#define FONT_CHARSET_ISO8859_1          FONT_ISO8859_PREFIX"-1"
#define FONT_CHARSET_ISO8859_2          FONT_ISO8859_PREFIX"-2"
#define FONT_CHARSET_ISO8859_3          FONT_ISO8859_PREFIX"-3"
#define FONT_CHARSET_ISO8859_4          FONT_ISO8859_PREFIX"-4"
#define FONT_CHARSET_ISO8859_5          FONT_ISO8859_PREFIX"-5"
#define FONT_CHARSET_ISO8859_6          FONT_ISO8859_PREFIX"-6"
#define FONT_CHARSET_ISO8859_7          FONT_ISO8859_PREFIX"-7"
#define FONT_CHARSET_ISO8859_8          FONT_ISO8859_PREFIX"-8"
#define FONT_CHARSET_ISO8859_9          FONT_ISO8859_PREFIX"-9"
#define FONT_CHARSET_ISO8859_10         FONT_ISO8859_PREFIX"-10"
#define FONT_CHARSET_ISO8859_11         FONT_ISO8859_PREFIX"-11"
#define FONT_CHARSET_ISO8859_12         FONT_ISO8859_PREFIX"-12"
#define FONT_CHARSET_ISO8859_13         FONT_ISO8859_PREFIX"-13"
#define FONT_CHARSET_ISO8859_14         FONT_ISO8859_PREFIX"-14"
#define FONT_CHARSET_ISO8859_15         FONT_ISO8859_PREFIX"-15"
#define FONT_CHARSET_ISO8859_16         FONT_ISO8859_PREFIX"-16"


/*************ַʶEND***********}*/

/************ϵͳ궨START{*****************/

/*******************************************************/
/*ĺ궨ҪǱʶϵͳ
ֵ壻洢ϵͳ
g_SysLogFont[]ͬȷϵͳ߼
˴üݲʵ
 *******************************************************/
#define SYSLOGFONT_DEFAULT          (ZSINT32)0
#define SYSLOGFONT_WCHAR_DEF         (ZSINT32)1
#define SYSLOGFONT_FIXED            (ZSINT32) 2
#define SYSLOGFONT_CAPTION           (ZSINT32)3
#define SYSLOGFONT_MENU              (ZSINT32)4
#define SYSLOGFONT_CONTROL           (ZSINT32)5
#define NR_SYSLOGFONTS               (ZSINT32)6

/*************ϵͳ궨END}*************/
/*******************************************************/
/*õʸֿ
 *******************************************************/
#define  FONT_FAMILY_HEI  (ZSINT32)0
#define  FONT_FAMILY_STROKE  (ZSINT32)1
#define  FONT_FAMILY_KATONG  (ZSINT32)1


/**************************************************************/

/************************************************************************
*                 غ궨                                       
************************************************************************/
/***************************ʼ***************************************/

/************ıʽSTART{*****************/

/*******************************************************
*ĺ궨ʶı
 *ҪʵͣҪṩ
 *DrawTextEx2 еĺ궨ʹá
 *üDrawTextEx2Ǻʵֵĺ
 *******************************************************/
#define DT_TOP              0x0
#define DT_LEFT             0x0
#define DT_CENTER           0x1
#define DT_RIGHT            0x2
#define DT_VCENTER          0x4
#define DT_BOTTOM           0x8
#define DT_WORDBREAK        0x10
#define DT_SINGLELINE       0x20
#define DT_EXPANDTABS       0x40
#define DT_TABSTOP          0x80
#define DT_NOCLIP           0x100
#define DT_EXTERNALLPADING  0x200
#define DT_CALCRECT         0x400
#define DT_NOPREFIX         0x800
#define DT_INTERNAL         0x1000

/*************ıʽEND}*************/


/**************************************************************/

/************************************************************************
*                  ݽṹ                                
************************************************************************/
/***************************ʼ***********************************

/************************************************************************
*                                ߼ṹ                                                
************************************************************************/

/*********************************************
߼GDIϲĽӿ
 ûCreateLogFont Զ崴
 SelectFont ѡı߼
DestroyLogFont ͷ
 *********************************************/

/*{***********߼ṹSTART*************/

typedef struct _LOGFONT
{
    /*߼*/
    ZCHAR szType [LEN_FONT_NAME + 1];/*ֽ׶οΪĬ*/	
    /*߼ļ<""> */
    ZCHAR szFamily [LEN_FONT_NAME + 1];
    /*߼ѡַ뼯*/
    ZCHAR acCharset [LEN_FONT_NAME + 1];
    /*߼ʽ*/
    ZDWORD style;
    /*߼С*/
    ZSINT32 size;
    /* ߼תǶ*/
    ZSINT32 iRotation;
/*Ϊʸ*/
	/*߼*/
	ZFLOAT32 stretch;
	/*ǷӰЧ*/
	ZBOOL shadow;
	/*ǷοЧ*/
	ZBOOL outline;
/*end*/
    /** The scale factor of sbc device font. */
    ZUINT16 sbc_scale;
    /** The scale factor of mbc device font. */
    ZUINT16 mbc_scale;
	/*Ϊ߼ƥĵֽֿ⣻ϲ㿪*/
    ZVOID* ptSBDevfont;
	/*Ϊ߼ƥĶֽֿ⣻ϲ㿪*/
    ZVOID* ptMBDevfont;
} LOGFONT;
typedef LOGFONT*    PLOGFONT;

/*************߼ṹEND***********}*/


/*{***********߼ṹSTART*************/

/*********************************************
*ýṹҪ
*ŰصĶϢ
 *********************************************/

/*òݿɲüݻʵ*/

typedef struct _FONTMETRICS
{
    /*߼ĸ߶ */
    ZSINT32 font_height;
    /*߼ascent */
    ZSINT32 ascent;
    /*߼descent*/
    ZSINT32 descent;

    /*߼*/
    ZSINT32 max_width;
    /*߼ƽ */
    ZSINT32 ave_width;
} FONTMETRICS;

/*************߼ṹEND***********}*/


/**********DTFIRSTLINE  ṹSTART{*********/
/*ṹDTFIRSTLINE¼ǹıĵһе
ϢҪDrawTextEx2 ʹãṩû
ʽıĵһϢ*/
typedef struct _DTFIRSTLINE
{   
    /*һеַ*/
    ZSINT32 iCharsNum;
    /*һx  */
    ZSINT32 iStartX;
    /*һy   */
    ZSINT32 iStartY;
    /*һ  */
    ZSINT32 iWidth;
    /*һ߶*/
    ZSINT32 iHeight;
} DTFIRSTLINE;

/**********DTFIRSTLINE ṹEND}************************/

/**********ZWORD Ϣ  ṹSTART{*********/

/*һЩַصĲУ
ýṹᱻ*/
typedef struct _WORDINFO
{
    /*ʳ */
    ZSINT32 iLen;
    /*õʺķָ */
    ZUINT8 cDelimiter;
    /*õ֮ķָĿ*/
    ZSINT32 iDelimitersNum;
};
#ifndef _TYPE_WORDINFO
#define _TYPE_WORDINFO
typedef struct _WORDINFO WORDINFO;
#endif
/**********ZWORD Ϣ  ṹEND}*********/

/*************************************************************** *********
*                                  ֿϢݽṹ                             
********************************************************************* **/

/*{********ֿϢṹSTART**********/
typedef struct T_TXTMGT_VMAP_INFO
{
	/*߼*/
    ZBYTE bType;
	/*߼ļ<""> */
    ZCHAR szFamily [LEN_FONT_NAME + 1];
	/*ֿʽ*/
	ZDWORD dwStyle;
    /*ֿӦַ*/
    ZCHAR* pcCharset;
    /*ֿе*/	
    ZSINT32 iWidth;
	/*ֿе߶*/	
    ZSINT32 iHeight;
	/*ֿ*/	
    const ZUINT8* pcFont;
} TXTMGT_VMAP_INFO;
typedef TXTMGT_VMAP_INFO TXTMGT_RMAP_INFO ;
/**********ֿϢṹEND********}*/

/*{********ֿϢṹSTART**********/
typedef struct
{
    ZUINT8   version;        /* font version */
    const ZCHAR*     name;           /* font name */
    ZUINT8   max_width;      /* max width in pixels */
    ZUINT8   ave_width;      /* average width in pixels */
    ZSINT32             height;         /* height in pixels */
    ZSINT32             descent;        /* pixels below the base line */
    ZUINT8   first_char;     /* first character in this font */
    ZUINT8   last_char;      /* last character in this font */
    ZUINT8   def_char;       /* default character in this font */
    const ZUINT16* offset;   /* character glyph offsets into bitmap data or NULL */
    const ZUINT8*  width;    /* character widths or NULL */
    const ZUINT8*  bits;     /* 8-bit right-padded bitmap data */
    ZUINT32    font_size;      /* used by mmap. It should be zero for in-core vbfs. */
    ZSINT32*            bbox_x;
    ZSINT32*            bbox_y;
    ZSINT32*            bbox_w;
    ZSINT32*            bbox_h;
} VBFINFO;
/**********ֿϢṹEND********}*/

/************************************************************************
{*                  ıݽṹ                                */
/************************************************************************/
/***************************ʼ***********************************/

/**************************************************************/

/***********************************************************************/
/*                 ϲӿں < GDI API  >                */
/***********************************************************************/
/***************************ʼ***********************************/

/**************************************************************************
* ƣ txtmgtInitFonts
*  ʼ豸
* ˵ (IN)
             (OUT)
*   ֵ TRUE ɹFALSEʧ
* ˵ ѡ
**************************************************************************/
ZBOOL TxtMgt_InitFonts(ZVOID);


/*****************************************************************************
 *			CreateLogFont
 *			һ߼
 *		@ const char* type 
                                     ͣȡֵΧ:
												* FONT_TYPE_NAME_BITMAP_RAW\n
										          һԭʼbitmap 豸߼壻
										       * FONT_TYPE_NAME_BITMAP_VAR\n
										         һñbitmap 豸߼壻
										       * FONT_TYPE_NAME_SCALE_TTF\n
										         һÿTrueType豸߼<ݲʵ>
										       * FONT_TYPE_NAME_SCALE_T1F\n
										         һÿAdobe Type1豸߼<ݲʵ>
										       * FONT_TYPE_NAME_ALL\n
										         һ豸߼
										  @ const char* family
										     ߼ļƣ"song"ȵ
										  @const char* charset
										     ߼õַ뼯
										     һַֽ"ISO8859-1"
										     ҲǶַֽ"GB2312"
										  @char weight 
										      ߼ȡֵΧ:
										       * FONT_WEIGHT_ALL\n
										           
											   *  FONT_WEIGHT_REGULAR\n
											        
											   * FONT_WEIGHT_BOLD\n
											        
										   @ char slant
										      ߼бȡֵΧ:
												*  FONT_SLANT_ALL\n
												     
												*  FONT_SLANT_ROMAN\n
												     
												*  FONT_SLANT_ITALIC\n
												     б
										   @ char set_width
										       Ŀ<δʹãɲü>
										   @ char spacing
										       ļ<δʹãɲü>										       
										   @ char underline
										        е»<ݲʵ>	ȡֵΧ:
												*  FONT_UNDERLINE_ALL\n
												     
												*  FONT_UNDERLINE_LINE\n
												     »
												*  FONT_UNDERLINE_NONE\n
												     »			
										   @ char struckout
										        еɾ<ݲʵ>	ȡֵΧ:
												*  FONT_STRUCKOUT_ALL\n
												     
												*  FONT_STRUCKOUT_LINE\n
												     ɾ
												*  FONT_STRUCKOUT_NONE\n
												     ɾ		
										   @ int size
										        ߼sizeGDIֻѡһ֮Ϊӽ
										        豸Ϊʵ
										  @ int rotation
										        ߼תǶ<ɲü>								     
		
 *		
 *	ֵ˵PLOGFONT:  ɹ:߼ָ룻ʧ:NULL
 *	˵	߼岢ЧҪSelectFontʹ
 *****************************************************************************/
PLOGFONT CreateLogFont (const ZCHAR* type, const ZCHAR* family,
        const ZCHAR* charset, ZCHAR weight, ZCHAR slant, ZCHAR set_width, 
        ZCHAR spacing, ZCHAR underline, ZCHAR struckout, 
        ZSINT32 size, ZSINT32 rotation);

/*졢ӰοյЧʸ(ЧֻʸԵ)*/
PLOGFONT CreateStretchLogFont (const ZCHAR* family,
        const ZCHAR* charset, ZCHAR weight, ZCHAR slant, ZCHAR set_width, 
        ZCHAR spacing, ZCHAR underline, ZCHAR struckout, 
        ZSINT32 size, ZFLOAT32 stretch, ZBOOL shadow, ZBOOL outline);

/*****************************************************************************
 *			CreateLogFontIndirect
 *			ָLOGFONT ṹ崴߼
 *		LOGFONT* logfont ָ߼ָ
 *		
 *	ֵ˵PLOGFONT:  ɹ:߼ָ룻ʧ:NULL
 *	˵	ͬCreateLogFont һ,ҲSelectFont
 *****************************************************************************/
PLOGFONT CreateLogFontIndirect(LOGFONT * logfont) ;

/*****************************************************************************
 *			DestroyLogFont
 *			ɾ߼
 *		PLOGFONT log_font Ҫɾ߼								     
 *		
 *	ֵ˵void
 *	˵	ܴݻʹõ߼
 *****************************************************************************/
ZVOID DestroyLogFont (PLOGFONT log_font);


/*****************************************************************************
 *			GetCurFont
 *			õǰʹõ߼
 *		HDC hdc 豸								     
 *		
 *	ֵ˵PLOGFONT ǰָ
 *	˵	
 *****************************************************************************/
PLOGFONT GetCurFont (HDC hdc);


/*****************************************************************************
 *			SelectFont
 *			ѡһµ߼Ϊǰ
 *		HDC hdc 豸
                                  PLOGFONT log_font ѡ߼
 *		
 *	ֵ˵PLOGFONT ɵ߼ָ
 *	˵	
 *****************************************************************************/
PLOGFONT SelectFont (HDC hdc, PLOGFONT log_font);


/*****************************************************************************
 *			GetFontHeight
 *			ȡǰ߶
 *		HDC hdc 豸
 *		
 *	ֵ˵int صǰ߶
 *	˵	
 *****************************************************************************/
ZSINT32 GetFontHeight (HDC hdc);

ZVOID GetFontMetrics(LOGFONT* log_font, FONTMETRICS* font_metrics);
/*****************************************************************************
 *			GetMaxFontWidth
 *			ȡǰ
 *		HDC hdc 豸
 *		
 *	ֵ˵int صǰ
 *	˵	
 *****************************************************************************/
ZSINT32 GetMaxFontWidth (HDC hdc);

/**************************************************************************
* ƣTXTMGT_CreateLogFontByName
*  ߼ӿ
                                 <ݴ߼>
* ˵ (IN)const char* font_name ߼
             (OUT)
*   ֵ PTXTMGT_LOGFONTEX ɵ߼<豸>
* ˵ ýӿΪƥؽӿ
**************************************************************************/
PLOGFONT CreateLogFontByName (const ZCHAR* szFontName);


/*****************************************************************************
 *			GetLogFontInfo
 *			ȡ߼꾡Ϣ
 *		HDC hdc 豸
 *		LOGFONT* logfont  洢߼Ϣָ
 *	ֵ˵NULL
 *	˵	GetCurFont Ĳ֮ͬڣҪ
                                  ϲûṩ洢ַݻʵ
 *****************************************************************************/
ZVOID GetLogFontInfo (HDC hdc, LOGFONT* log_font);

/*****************************************************************************
 *			GetTextExtent
 *			ȡıΧ
 *		HDC hdc 豸
                                  const char* text ַ
                                  int len 
 *		SIZE* size       
 *	ֵ˵VOID
 *	˵	
 *****************************************************************************/
ZVOID GetTextExtent (HDC hdc, const ZCHAR* spText, ZSINT32 len, SIZE* pSize);


/*****************************************************************************
 *			GetSystemFont
 *			ȡϵͳ߼
 *		int font_id ϵͳIDغ궨
 *		
 *	ֵ˵ȷָ룻NULL
 *	˵	
 *****************************************************************************/
PLOGFONT GetSystemFont (ZSINT32 font_id);

/*****************************************************************************
 *			GetSysFontMaxWidth
 *			ȡϵͳ
 *		int font_id ϵͳIDغ궨
 *		
 *	ֵ˵Ĭϵͳĵֽ
 *	˵	
 *****************************************************************************/
ZSINT32 GetSysFontMaxWidth (ZSINT32 font_id);

/*****************************************************************************
 *			GetSysFontAveWidth
 *			ȡϵͳƽ
 *		int font_id ϵͳIDغ궨
 *		
 *	ֵ˵Ĭϵͳĵֽƽ
 *	˵	
 *****************************************************************************/
ZSINT32 GetSysFontAveWidth (ZSINT32 font_id);

/*****************************************************************************
 *			GetSysFontHeight
 *			ȡϵͳĸ߶
 *		int font_id ϵͳIDغ궨
 *		
 *	ֵ˵Ĭϵͳĵֽڸ߶
 *	˵	
 *****************************************************************************/
ZSINT32 GetSysFontHeight (ZSINT32 font_id);

 /**
 * ƣ SetSysFontHeight
 *  ϵͳĸ߶
 * ˵ int font_size ϵͳĴС 
 *   ֵ
 * ˵ 
 */
ZVOID SetSysFontHeight (ZSINT32 font_size);

/*****************************************************************************
 *			GetSysCharset
 *			ȡϵͳַ뼯
 *		BOOL wchar Ƿֵֿ֧
 *		
 *	ֵ˵ַֻ뼯
                                     ֿ֧֣ܷNULL
                                     (ϵͳ֧)
 *	˵	
 *****************************************************************************/
const ZCHAR* GetSysCharset (ZBOOL wchar);

/*****************************************************************************
 *			GetSysCharHeight
 *			ȡĬϵͳĸ߶
 *		VOID
 *		VOID
 *	ֵ˵Ĭĸ߶
 *	˵	
 *****************************************************************************/
ZSINT32 GetSysCharHeight (ZVOID);

/*****************************************************************************
 *			GetSysCharWidth
 *			ȡĬϵͳ嵥ַֽĿ
 *		VOID
 *		VOID
 *	ֵ˵Ĭ嵥ַֽĿ
 *	˵	
 *****************************************************************************/
ZSINT32 GetSysCharWidth (ZVOID);

/*****************************************************************************
 *			GetSysCharWidth
 *			ȡĬϵͳַֽĿ
 *		VOID
 *		VOID
 *	ֵ˵ĬַֽĿ
 *	˵	
 *****************************************************************************/
ZSINT32 GetSysCCharWidth (ZVOID);


/*****************************************************************************
 *			GetTextMCharInfo
 *			ȡַַָֽеλ
 *		PLOGFONT log_font ߼
                                  const char* mstr ַ
                                  int len                             
 *		int* pos_chars 洢ֽλõָ
 *	ֵ˵ıжֽеַ
 *	˵	
 *****************************************************************************/
ZSINT32 GetTextMCharInfo (PLOGFONT log_font, const ZCHAR* mstr, ZSINT32 len, ZSINT32* pos_chars);

/*****************************************************************************
 *			GetTextMCharInfo
 *			ȡַָֽеλ
 *		PLOGFONT log_font ߼
                                  const char* mstr ַֽ
                                  int len ַ  
 *		int* int* pos_words 洢λõָ
									  WORDINFO* info_words 洢Ϣָ
 *	ֵ˵ıжֽеĵʸ
 *	˵	
 *****************************************************************************/
ZSINT32 GetTextWordInfo (PLOGFONT log_font, const ZCHAR* mstr, ZSINT32 len,
                ZSINT32* pos_words, WORDINFO* info_words);

/*****************************************************************************
 *			GetFirstMCharLen
 *			ȡıַıеһַĳ
 *		PLOGFONT log_font ߼
                                  const char* mstr ַ
                                  int len                             
 *		
 *	ֵ˵ػııеһַĳ
 *	˵	
 *****************************************************************************/
ZSINT32 GetFirstMCharLen (PLOGFONT log_font, const ZCHAR* mstr, ZSINT32 len);

/*****************************************************************************
 *			TXTMGT_GetLastMCharLen
 *			ȡıַıһַĳ
 *		PLOGFONT log_font ߼
                                  const char* mstr ַ
                                  int len                             
 *		
 *	ֵ˵ػııһַĳ
 *	˵	
 *****************************************************************************/
ZSINT32 GetLastMCharLen (PLOGFONT log_font, const ZCHAR* mstr, ZSINT32 len);

/*****************************************************************************
 *			GetFirstWord
 *			ȡıַıеһʵϢ
 *		PLOGFONT log_font ߼
                                  const char* mstr ַ
                                  int len                             
 *		WORDINFO* word_info 洢Ϣ
 *	ֵ˵ػıеһʵĳ
 *	˵	
 *****************************************************************************/
ZSINT32 GetFirstWord (PLOGFONT log_font, const ZCHAR* mstr, ZSINT32 len, WORDINFO* word_info);


/*****************************************************************************
 *			GetTextExtentPoint
 *			ڸֽıʱ
                         ַһĿȵУ
                            ַÿַڵֽλá
                            ÿַλãԼʵʵ߶ȺͿȡ
 *		HDC hdc 豸
                                  const char* text ַ
                                  int len     
                                  int max_extent ƿռĿ
 *		int* fit_chars ʵַ
                                 int* pos_chars ÿַַеλ
                                 int* dx_chars ÿַλãؼƣ
                                 SIZE* size ı     
 *	ֵ˵ʵʿַֽ
 *	˵	
 *****************************************************************************/
ZSINT32 GetTextExtentPoint (HDC hdc, const ZCHAR* text, ZSINT32 len, ZSINT32 max_extent,
                ZSINT32* fit_chars, ZSINT32* pos_chars, ZSINT32* dx_chars, SIZE* size);

/**************************************************************/


/***********************************************************************/
/*                  ıϲӿں < GDI API  >                */
/***********************************************************************/
/***************************ʼ***********************************/

/*****************************************************************************
 *			TextOutLen
 *			ָλ(x,y)ָ(ilen )ı(spText)
 *		HDC hdc 豸
                                   int x, int y λ
                                   const char* spText ַָ
                                   int len ıȣС0ĬspText
                                     Ϊַ
 *		
 *	ֵ˵int ı
 *	˵	ú\t,\nַҪ
 *                                 ַʹTabbedTextOutLen
 *****************************************************************************/
ZSINT32 TextOutLen (HDC hdc, ZSINT32 x, ZSINT32 y, const ZCHAR* spText, ZSINT32 len);

#define TextOut(hdc, x, y, text)    TextOutLen (hdc, x, y, text, -1)


/*****************************************************************************
 *			GetTextExtent
 *			ȡıΧ
 *		HDC hdc 豸
                                  const char* text ַ
                                  int len     
 *		SIZE* size       
 *	ֵ˵VOID
 *	˵	
 *****************************************************************************/
ZVOID GetTextExtent (HDC hdc, const ZCHAR* spText, ZSINT32 len, SIZE* pSize);


/*****************************************************************************
 *			DrawTextEx2
 *			ָΧ(pRect)Ƹʽı(pText)
                          ָʽ(ͨnFormatչTAB еȵ)
                          Ű
 *		     @HDC hdc 豸
                                 @const char* pText ʽ֮ı
                                 @int nCount ıȣС0ĬspText
                                     Ϊַ
                                 @RECT* pRect ο
                                 @ int nIndent 1еֵ
                                 @ UINT nFormat ڸʽıķ:
                                    *  - DT_TOP\n
										        ϶().
										 *  - DT_LEFT\n
										 		 
										 *  - DT_CENTER\n
										        ж
										 *  - DT_RIGHT\n
										        Ҷ
										 *  - DT_VCENTER\n
										       ֱ ().
										 *  - DT_BOTTOM\n
										      ¶룬DT_SINGLELINEʹ
										 *  - DT_WORDBREAK\n
										 *    ԶСҪһʻ
										        ָķΧԶڵ֮任С
										        һسзͬеЧ
										 *  - DT_SINGLELINE\n
										        ڵʾıзسʹ֮
										 *  - DT_EXPANDTABS\n
										       չƱÿƱĬΪ8ַ
										 *  - DT_TABSTOP\n
										 *  - DT_NOCLIP\n
										       ǼСиԵø
 										*  - DT_CALCRECT\n
 										        ⶨıĿȺ͸߶ȡú
 										        ʹò(RECT* pRect)Ŀȣչ߶һ
 										        һúȷұ߽硣
 										        òúʱĽ
 										        ı
 										        
 *		 @ DTFIRSTLINE *firstline ֵΪNULLúֻıһе
                                        ΣַͿ
 *	ֵ˵int ı߶
 *	˵	
 *****************************************************************************/
ZSINT32 DrawTextEx2 (HDC hdc, const ZCHAR* pText, ZSINT32 nCount,
                RECT* pRect, ZSINT32 nIndent, ZDWORD nFormat, DTFIRSTLINE *firstline);

/*****************************************************************************
 *			DrawToBuffer
 *			ָλãָָıBuffer
 *		hWndھ    
 					colorıɫ
					in_clip_rectΧ
					destBufferҪĿBuffer
					destBufferHoriz: ĿBufferĺ
					destBufferVert: ĿBuffer߶
					xyƵ
					textҪƵıʽuc16
					textLenҪƵı
					ptLogfont ʱʹõ߼
    
 *		 0 ɹ
				   1 ʧ
 *	˵	׶δʵ
 *****************************************************************************/
ZSINT32 DrawToBuffer (HWND hWnd,
                      ZUINT32 color,
                      RECT* in_clip_rect,
                      ZVOID* destBuffer,
                      ZSINT32 destBufferHoriz,
                      ZSINT32 x,
                      ZSINT32 y,
                      const ZUINT16* text,
                      ZSINT32 textLen,
                      ZSINT32 in_font);

ZSINT32 DrawToJavaBuffer (HWND hWnd,
                          ZUINT32 color,
                          RECT* in_clip_rect,
                          ZVOID* destBuffer,
                          ZSINT32 destBufferHoriz,
                          ZSINT32 x,
                          ZSINT32 y,
                          const ZUINT16* text,
                          ZSINT32 textLen,
                          ZSINT32 in_font);


/*****************************************************************************
 *			txtmgtGetProperStr
 *			ȡΪbytesַЧַĳȣַпܺз
 *                浥ַֽһһַ
 *		hdc: 豸
                  str: ַ
                  bytes:  
 *		 dest_len Чַֽڳ
 *	ֵ˵ȡȷ0򷵻-1
 *	˵	
 *****************************************************************************/
ZSINT32 txtmgtGetProperStr(HDC hdc, const ZCHAR* str, ZSINT32 bytes, ZSINT32* dest_len);

/*****************************************************************************
 *			DrawScrollText
 *			 ıĹʾӿ
 *                浥ַֽһһַ
 *		hdc: ͼ豸ľ
				 pText: ҪƵ
				 iCount: ַܸ
				 pRect: 
				 nFormat: ʽ
				 iPos:  ʼƵλ
 *		
 *	ֵ˵  
 *	˵	
 *****************************************************************************/
ZVOID DrawScrollText(HDC hdc, const ZCHAR *pText, ZSINT32 iCount, RECT *pRect, ZDWORD nFormat, ZSINT32 *iPos);
 /*****************************************************************************
 *			DrawEllipsisText
 *			ıʡʾӿ
 *                浥ַֽһһַ
 *		hdc: ͼ豸ľ
				 pText: ҪƵ
				 iCount: ַܸ
				 pRect: 
				 nFormat: ʽ
 *		 
 *	ֵ˵
 *	˵	
 *****************************************************************************/
 ZVOID DrawEllipsisText(HDC hdc, const ZCHAR *pText, ZSINT32 iCount, RECT *pRect, ZDWORD nFormat);

#define DrawText(hdc, text, n, rc, format)      DrawTextEx2 (hdc, text, n, rc, 0, format, NULL)
#define DrawTextEx(hdc, text, n, rc, indent, format)      DrawTextEx2 (hdc, text, n, rc, indent, format, NULL)
/*****************************************************************************
*       GetLastTextOutPos
*         ȡı
*    HDC hdc ϵͳ豸
*     POINT* pt ַ
*   ֵ˵VOID
*   ˵ 
*****************************************************************************/
ZVOID GetLastTextOutPos (HDC hdc, POINT* pt);
/*****************************************************************************
*       GetCurPenPos
*         ȡǰĻ
*    HDC hdc ϵͳ豸
*     POINT* pt ַ
*   ֵ˵VOID
*   ˵ 
*****************************************************************************/
ZVOID GetCurPenPos (HDC hdc, POINT* pt);
/*****************************************************************************
 *      GetTabbedTextExtentPoint
 *        ڸռֽıʱ
                  ַÿַڵֽλá
                  ÿַλãԼʵʵ߶ȺͿȡ
 *   HDC hdc 豸
                  const char* szText ַ
                  int iLen ַ
                  int iMaxExtent ƿռĿ
 *    int* iCharsFit ʵַ
                  int* iCharsPos ÿַַеλ
                  int* piCharsDX ÿַλãؼƣ
                  SIZE* ptSize ַ
 *  ֵ˵ʵʿַֽ
 *  ˵ 
 *****************************************************************************/
ZSINT32 GetTabbedTextExtentPoint (HDC hdc, const ZCHAR* szText, ZSINT32 iLen, ZSINT32 iMaxExtent,
                                  ZSINT32* iCharsFit, ZSINT32* iCharsPos, ZSINT32* piCharsDX, SIZE* ptSize);


/*****************************************************************************
 * ƣ TabbedTextOutLen
 *  ıƽӿ
 * ˵ (IN) HDC hdc  ָ
            int x, int y  Ƶ
            const char* spText  ҪƵı
            int len  ҪƵıֽ
 *   ֵı
 * ˵
 *****************************************************************************/
ZSINT32 TabbedTextOutLen (HDC hdc, ZSINT32 x, ZSINT32 y, const ZCHAR* spText, ZSINT32 len);

/*****************************************************************************
 *      txtmgtGetTabWidth
 *        ȡtabС
 *        @HDC hdc 豸
                                 @ UINT nFormat ڸʽıķ:
 *    
 *  ֵ˵int tabַ
 *  ˵ 
 *****************************************************************************/

ZSINT32 txtmgtGetTabWidth(HDC hdc,  ZDWORD nFormat);


#define TabbedTextOut(hdc, x, y, text)  TabbedTextOutLen (hdc, x, y, text, -1)

/**
 * ƣ DynSetWinSysFont
 *  ϵͳ
 * ˵ PLOGFONT LogFontҪõ߼
 *   ֵTRUE or FALSE
 * ˵ 
 */
ZBOOL DynSetWinSysFont(PLOGFONT LogFont);

/**
 *	GetJavaBufferTextWidth
 *	ܣJava  ӦKMX DC  Ϣ
 			   MMI  ϲֿͬ
 *	hWndھ
 					in_fontС
 					textƵı
 					text_lenıֽڳ
 *	ı
 *	˵
**/
ZSINT32 GetJavaBufferTextWidth(HWND hWnd, ZSINT32 in_font, ZUINT16 *text, ZSINT32  text_len);

#endif //_ZCORE_TEXT_H
