#ifndef _YRE_H_
#define _YRE_H_
#pragma once
#pragma pack(4)

#define YREE_SUCCEEDED(c)               ((c) == YREE_NoError)

#define YREE_NoError                    0x0
#define YREE_InvalidHandle              0x1
#define YREE_InvalidParam               0x2
#define YREE_InvalidGroupId             0x3
#define YREE_OutOfMemory                0x4
#define YREE_DifferentCharSet           0x5

#define YRE_PFLAG_CaseInsensitive       0x1
#define YRE_PFLAG_SingleLine            0x2
#define YRE_PFLAG_MultiLine             0x4

#define YREE_UnbalancedParenthesis      0x10
#define YREE_InvalidSyntax              0x11
#define YREE_InvalidEscapeSequence      0x12
#define YREE_SoManyGrouping             0x13
#define YREE_CannotReferToOpenGroup     0x14
#define YREE_RedefineNamedGroup         0x15
#define YREE_UnknownGroupNameOrIdx      0x16
#define YREE_MoreThanTwoBranches        0x17
#define YREE_NotFixedWidthLookBehind    0x18
#define YREE_TooBigNumber               0x19
#define YREE_BadRange                   0x1A
#define YREE_NothingToRepeat            0x1B
#define YREE_BadRepetition              0x1C
#define YREE_TooBigRepetition           0x1D
#define YREE_UnknownCharacterName       0x1E

#define YREE_CannotMatch                0x20
#define YREE_InvalidGroupName           0x21
#define YREE_NotNamedGroupId            0x22

#ifdef __cplusplus
extern "C"
{
#endif

struct _YREData;
typedef struct _YREData*    YREHandle;

typedef unsigned char       UI8;
typedef unsigned short      UI16;
typedef unsigned long       UI32;
typedef char                SI8;
typedef short               SI16;
typedef long                SI32;
typedef char*               PCHR;
typedef const char*         PCCHR;

#define EMPTY_GROUP                     0xffffffff

typedef struct
{
    UI32    uiStart;        
    UI32    uiCharSize;
} YREGroup;

UI32 YRE_CompileA(YREHandle *pRetRes, PCCHR sPattern, UI32 uiSize, UI32 uiFlags, UI32 *pErrPos);

UI32 YRE_MatchA(YREHandle hRes, PCCHR str, UI32 uiSize, YREGroup *pPos);

UI32 YRE_SearchA(YREHandle hRes, PCCHR str, UI32 uiSize, UI32 uiStart, YREGroup *pPos);

UI32 YRE_GetPatternA(YREHandle hRes, PCHR sPattern, UI32 *puiSize);

UI32 YRE_SetPFlag(YREHandle hRes, UI32 uiFlag);
UI32 YRE_GetPFlag(YREHandle hRes, UI32 *puiFlag);

UI32 YRE_GetGroupIdByNameA(YREHandle hRes, PCCHR szName, UI32 uiNameSize, UI32 *puid);

UI32 YRE_GetNameByGroupIdA(YREHandle hRes, UI32 id, PCHR szName, UI32 *puiSize);


UI32 YRE_GetGroup(YREHandle hRes, UI32 id, YREGroup *pGrps, UI32 *puiSize);

UI32 YRE_GetGroups(YREHandle hRes, YREGroup *pGrps, UI32 *puiSize);

UI32 YRE_DuplicateHandle(YREHandle hRes, YREHandle *phRet);
void YRE_FreeHandle(YREHandle hRes);

#ifdef __cplusplus
}
#endif

#endif //_YRE_LOCAL_H_
