#ifndef MMI_GM_TAB_LIST_H
#define MMI_GM_TAB_LIST_H

#ifdef FEATURE_ZTE_DEVGUI_WLAN
#include "wlan_sam.h"
#include "dhcp_server_defs.h"
#endif

/**************************************************************************
 *                        ͷļ                                       *
 **************************************************************************/

/**************************************************************************
 *                                                                 *
 **************************************************************************/
 /**************************************************************************
 *                         ȫֱ                                       *
 **************************************************************************/
	

/**************************************************************************
 *                         궨                                          *
 **************************************************************************/

#define MMI_GM_TLS_ITEM_ENABLED     0x00000000
#define MMI_GM_TLS_ITEM_CHECKED     0x00000008
#define MMI_GM_TLS_ITEM_DISABLED    0x00000004
#define MMI_GM_TLS_ITEM_HINT_LEFT   0x00000000
#define MMI_GM_TLS_ITEM_HINT_RIGHT  0x00000010
#define MMI_GM_TLS_ITEM_NO_TRANS    0x00000020
#define MMI_GM_TLS_ITEM_HINT_CENTER  0x00000040
#define MMI_GM_TLS_ITEM_C_COLOR  0x00000080//ԶĿɫ

/* page style */
#define MMI_GM_TLS_PAGE_LIST        0x0000//ıб
#define MMI_GM_TLS_PAGE_HINT_LIST   0x0001//˫
#define MMI_GM_TLS_PAGE_RADIO_LIST  0x0002//ѡ
#define MMI_GM_TLS_SORTABLE         0x0010
#define MMI_GM_TLS_PAGE_CHECK         0x0020//бǹ

#define MMI_GM_TLS_PAGE_TYPE_MASK   0x000f

#define TL_MAKE_STYLE(type, style) (((type) & MMI_GM_TLS_PAGE_TYPE_MASK) | (style))
#define TL_GET_TYPE(s)             ((s) & MMI_GM_TLS_PAGE_TYPE_MASK)
#define TL_GET_STYLE(s)            ((s) & ~(UINT32)MMI_GM_TLS_PAGE_TYPE_MASK)

/* event */
#define MMI_GM_TLE_KEYDOWN          0x0001
#define MMI_GM_TLE_DESTROY          0x0002
#define MMI_GM_TLE_ACTIVE           0x0003
#define MMI_GM_TLE_PAGE_INIT        0x0004
#define MMI_GM_TLE_PAGE_DESTROY     0x0005
#define MMI_GM_TLE_PAGE_SELCHG      0x0006
#define MMI_GM_TLE_ITEM_COMP        0x0007
#define MMI_GM_TLE_ITEM_SELCHG      0x0008
#define MMI_GM_TLE_ITEM_DESTROY     0x0009
#define MMI_GM_TLE_ITEM_SELECTED    0x000a
#define MMI_GM_TLE_PAINTED	0x000f	//paint(hdc)ơ޼¼

#define MMI_GM_TL_TITLE_MAX_LEN	50//Իʱֵ󳤶

/**************************************************************************
 *                         Ͷ                                    *
 **************************************************************************/

/* бϢ */
typedef struct
{
    UINT32          uiStyle;
    const CHAR      *szName;
    const BITMAP    *pIcon;
    UINT32          uiAddData;
    /* only used with hint style list */
    const CHAR      *szInfo;
    const BITMAP    *pRightIcon;//Ҳͼ
    UINT32          dwColor;//ĿǾ۽ʱɫ
    UINT32          dwOnColor;//Ŀ۽ʱɫ

    UINT32          bmpIconId;//ͼid
    UINT32          bmpRightIconId;//ͼid

} T_TabListItem;


typedef struct
{
    const T_TabListItem     *pItem1;
    const T_TabListItem     *pItem2;
} T_TabListItemCmp;

/* ǩҳϢ */
typedef struct
{
    UINT32  id;
    UINT32  uiStyle;
    const CHAR  *szTitle;
    const BITMAP    *pIcon;
    UINT32  uiAddData;
    UINT32  bmpIconId;//ͼid
    UINT32  bmpIconOnId;//ͼѡid
} T_TabListPage;

/* ݽṹ */
typedef struct
{
    const CHAR      *szTitle;
    const BITMAP    *pbmpTitle;
    int (*OnEvent)(HWND hList, UINT32 uiEvent, int iPage, UINT32 uiParam);
    UINT32      uiAddData;
    UINT32      uiBmpTitleId;   //ͼƬid
    BOOL        tablist_longpress;
} T_TabListData;

/* Ϣ */
typedef struct
{
    const BITMAP	*pBmp;
    CHAR    szText[MMI_GM_TL_TITLE_MAX_LEN+1];//
    RECT    rcText;
    CHAR    szSubText[MMI_GM_TL_TITLE_MAX_LEN+1];// "n/m"
    RECT    rcSubText;
    UINT32  uiBmpId; //ͼƬid
} T_TabListTitle;

/* Ϣ */
typedef struct
{
    int     iCurIndex;
    int     iCount;
} T_TabListScrollbar;

/* ڷϢ */
typedef struct
{
    int iTitleHeight;   //߶
    int iItemHeight;    //еĿ߶
} T_TabListWinStyle;

#ifdef FEATURE_ZTE_DEVGUI_WLAN

typedef struct
{
  /** SSID of the AP */
  unsigned char  ssid[WLAN_SAM_SSID_MAX_SIZE];  
  /** Length of SSID */
  unsigned char  ssid_len;  
  
  /** Set if the AP is not advertizing SSID in the beacon */
  boolean  hidden_ssid; 
  
  /** Wireless phyical layer mode */   
  wlan_sam_tech_enum_type phy_mode;  

  /** If 11d enabled, what is the country code to be advertised in the 11d IE; 
  *  the value is ignored by core driver if [0] is 0.*/
  unsigned char     country_code[WLAN_SAM_COUNTRY_CODE_LEN]; 
  
  /** Operation channel, 0 is AUTO, in that case lower layer decides the channel */   
  uint32    channel;    
  uint32   max_num_sta;

  boolean  privacy_separator; 
  uint32   auto_shutdown_period;
} ZTE_wlan_sap_basic_params_s_type;

typedef struct
{
    char              nickname[36];
    uint8             MACAddress[6];   /** sta MAC Address */
    uint32            IPAddress;       /** dhcpͻIPַ */   
    uint8             client_hostname[DHCP_SERVER_MGR_MAX_HOST_NAME_LEN];
    uint32            client_hostname_len;
    uint32            client_conn_time;
    int               is_static;
}ZTE_wlan_bigoled_params_s_type;

typedef struct
{
  uint16  nb_members;
  ZTE_wlan_bigoled_params_s_type   member_list[WLAN_SAM_MAX_STA];
}ZTE_wlan_bigoled_sta_params_s_type;

typedef enum
{
  WLAN_WPS_START_SUCCESS                = 0,/**< Request sucess */
  WLAN_WPS_SEC_CHECK_FAILURE            = 1,/**< Request failure */
  WLAN_WPA_SEC_NOT_START                = 2,/**< Request for not supported item */
  WLAN_WPS_ALREADY_START                = 3,/**< Requested when system is not yet initialized */
  WLAN_WPS_START_FAIURE                 = 4,
}wlan_sam_wps_start_enum_type;

#endif

typedef void (*ITEMCALLBACK)(HWND);

/**************************************************************************
 *                        ȫֱ                                     *
 **************************************************************************/


/**************************************************************************
 *                        ԭ                                         *
 **************************************************************************/ 

/* ǩҳģ */
extern HWND mmiGmCreateTabList(HWND hHost, const T_TabListData *pData, WNDPROC fpProc);

/* رձǩҳģ */
extern void mmiGmCloseTabList(HWND hList);

/* ǩҳģĬϴڹ */
extern int mmiGmTabListDefaultProc(HWND hList, int iMsg, WPARAM wParam, LPARAM lParam);

/* һǩҳ */
extern int mmiGmTabListAddPage(HWND hList, const T_TabListPage *pPage, int iPos);

/* ɾһǩҳ */
extern int mmiGmTabListDelPage(HWND hList, int iPage);

/* ɾбǩҳ */
extern int mmiGmTabListDelAllPages(HWND hList);

/* ȡǰǩҳidϢ */
extern int mmiGmTabListGetCurPage(HWND hList, T_TabListPage *pPage);

/* õǰǩҳid */
extern int mmiGmTabListSetCurPage(HWND hList, int iPage);

/* ȡǩҳϢ */
extern const T_TabListPage* mmiGmTabListGetPageData(HWND hList, int iPage);

/* ñǩҳϢ */
extern int mmiGmTabListSetPageData(HWND hList, int iPage, const T_TabListPage *pPage);

/* ˢĳǩҳ */
extern void mmiGmTabListRefreshPage(HWND hList, int iPage);

/* ȡǩҳ */
extern int mmiGmTabListGetPageCount(HWND hList);

/* ĳǩҳĿ */
extern int mmiGmTabListAddItem(HWND hList, const T_TabListItem *pItem, int iPage, int iPos,ITEMCALLBACK itemcallback);
/* ĳǩҳĿ ,̬*/

extern int mmiGmTabListAddItem_addnew(HWND hList, const T_TabListItem *pItem, int iPage, int iPos,ITEMCALLBACK itemcallback);

/* ĳǩҳɾĿ */
extern int mmiGmTabListDelItem(HWND hList, int iPage, int iIndex);

/* ɾĳǩҳеĿ */
extern int mmiGmTabListDelAllItems(HWND hList, int iPage);

/* ȡĳǩҳеĵǰĿ */
extern int mmiGmTabListGetCurSel(HWND hList, int iPage, T_TabListItem *pItem);

/* ĳǩҳеĵǰĿ */
extern int mmiGmTabListSetCurSel(HWND hList, int iPage, int iIndex);

/* ȡĿ */
extern UINT32 mmiGmTabListGetItemStyle(HWND hList, int iPage, int iIndex);

/* Ŀ */
extern int mmiGmTabListSetItemStyle(HWND hList, int iPage, int iIndex, UINT32 uiStyle);

/* ȡĿϢ */
extern const T_TabListItem* mmiGmTabListGetItem(HWND hList, int iPage, int iIndex);

/* ĿϢ */
extern int mmiGmTabListSetItem(HWND hList, int iPage, int iIndex, const T_TabListItem *pItem);

/* ˢĳĿ */
extern int mmiGmTabListRefreshItem(HWND hList, int iPage, int iIndex);

/* ȡĳҳĿ */
extern int mmiGmTabListGetItemCount(HWND hList, int iPage);

/* ñ */
extern int mmiGmTabListSetTitle(HWND hList, char * szTitle);

/* ñԻģʽ */
extern int mmiGmTabListSetCDrawTitle(HWND hList, BOOL bIsCDraw);

/* ӦԼƱ */ 
extern int mmiGmTabListDrawTitle(HWND hList, T_TabListTitle tTitle);

/* Լƹ */
extern int mmiGmTabListSetCDrawScrollbar(HWND hList, BOOL bIsCDraw);

/* ӦԼƹ */ 
extern int mmiGmTabListDrawScrollbar(HWND hList, T_TabListScrollbar tScrollbar);

/* ø */
extern void mmiGmTabListSetAddData(HWND hList, UINT32 uiAddData);

/* ȡ */
extern UINT32 mmiGmTabListGetAddData(HWND hList);

/* ӦԼĴڷ */ 
extern int mmiGmTabListSetWinStyle(HWND hList, T_TabListWinStyle tWinStyle);

/* ñĹ */
extern int mmiGmTabListSetTitleScroll(HWND hList);

/* ƹʱGetActiveWindow,ӶʹĻ˸ */
extern BOOL mmiGmTabListSetScrollbarType1(HWND hWnd, BOOL bDisCall);

extern int mmiGmTablistSetContPos(HWND hList, int iPage,int iContX,int iContY);
extern int mmiGmTablistMakePosVisible(HWND hList, int iPage,int iContX,int iContY);
extern int mmiGmTablistGetContPos(HWND hList, int iPage);
extern int mmiGmTablistGetItemListHeight(HWND hList, int iPage);
/* ǷҪƱǩҳ */
extern void mmiGmTabListSetPageStyle(HWND hList, BOOL bNoTab);

/* ıǩҳ */
extern int mmiGmTabListSetPageStyle2(HWND hList, int iPage, UINT32 uiStyle);

#endif

