#ifndef	SDEV_I_H
#define	SDEV_I_H

/****************************************ͷļ**************************************/
#include "zcore_type.h"
#include "SDEV_e.h"
#ifdef WIN32
#include "lcd_e.h"
#else
#include "display.h" 
#endif
/***********************************궨*******************************/
#define MODE_SET    			0    	/* ʾģʽ */
#define MODE_XOR    			1    	/* ʾģʽ XOR */
#define MODE_OR     			2    	/* ʾģʽ OR */
#define MODE_AND    			3    	/* ʾģʽ AND */


#define OPT_AND    				0    	/* ɫ AND */
#define OPT_OR    				1    	/* ɫ OR */

/****************************************************************************/
typedef struct 
{
	ZBOOL	(*DrawPixel)(PGC psd, ZSINT32 iStartX, ZSINT32 iStartY, Pixel pixColor);
	Pixel	(*ReadPixel)(PGC psd, ZSINT32 iStartX, ZSINT32 iStartY);
	ZBOOL	(*DrawHLine)(PGC psd, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, Pixel pixColor);
	ZBOOL	(*DrawVLine)(PGC psd, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iHeight, Pixel pixColor);
	ZBOOL 	(*Blit)(PGC dstpsd, ZSINT32 dstx, ZSINT32 dsty, ZSINT32 w, ZSINT32 h, PGC srcpsd, ZSINT32 srcx, ZSINT32 srcy);
	ZBOOL	(*PutBox)(PGC psd,  ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth,  ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch);
	ZBOOL	(*GetBox)(PGC psd, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch);
	ZBOOL	(*PutBoxMask)(PGC psd, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch,Pixel pixColor);
	ZBOOL 	(*CopyBox)(PGC psd,ZSINT32 iSrcX, ZSINT32 iSrcY, ZSINT32 iWidth, ZSINT32 iHeight, ZSINT32 iDstX, ZSINT32 iDstY);

	ZBOOL    (*FillRect)(PGC psd, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, Pixel pixColor);
	ZBOOL    (*PutBoxPart)(PGC psd,  ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth,  ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch,ZSINT32 iX, ZSINT32 iY);
	ZBOOL    (*PutBoxPartMask)(PGC psd, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch,Pixel pixColor,ZSINT32 iX, ZSINT32 iY);
} SUBDRIVER, *PSUBDRIVER;


/*******************************ԭ*******************************/
extern 	PGC  SDev_Open(PGC psd);
extern	ZBOOL SDev_Close(PGC psd);
extern	PGC  SDev_AllocateMemGC(PGC psd);
extern	ZBOOL SDev_FreeMemGC(PGC psd);
extern	ZBOOL SDev_MapMemGc(PGC mempsd,ZSINT32 w,ZSINT32 h,ZSINT32 planes,ZSINT32 bpp, ZSINT32 linelen,ZSINT32 size,ZVOID *addr);
extern	ZSINT32  SDev_ClipPoint(PGC psd, ZSINT32 x ,ZSINT32 y);
extern	ZBOOL SDev_UpdateRect(PGC psd);
extern 	ZBOOL SDevFormatBox(PGC psd, ZSINT32 *ipStartX, ZSINT32 *ipStartY, ZSINT32 *ipWidth, ZSINT32 *ipHeight);
extern	ZBOOL SDevLineTo(PGC psd, ZSINT32 x1, ZSINT32 y1, ZSINT32 x2, ZSINT32 y2, ZBOOL bDrawLastPoint);
extern	ZBOOL SDevCalculateMemGc(PGC psd, ZUINT32 width, ZUINT32 height, ZSINT32 planes,ZSINT32 bpp, ZSINT32 *psize, ZSINT32 *plinelen);
extern	ZBOOL SDevInitMemGc(PGC psd, ZSINT32 w,ZSINT32 h,ZSINT32 planes,ZSINT32 bpp,ZSINT32 linelen, ZSINT32 size,ZVOID *addr);
extern	PSUBDRIVER SDevSelectSubDriver(PGC psd);

ZVOID UpdateScreen_Thread_Entry(ZVOID *para);
ZBOOL SDevSetSubDriver(PGC psd, PSUBDRIVER subdriver);


ZVOID UpdateLayer(MAN_LCD_REFRESH *area_ptr);
#endif
