#ifndef _UGUI_WINDOW_H
#define _UGUI_WINDOW_H

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */
#include "zcore_type.h"
#include "gui_g.h"
#include "WM_g.h"
#include "zcore_winmsg.h"
#include "txtmgt_e.h"

#include "WM_date_e.h"
#include "imgmgt_e.h" 
// PBITMAP
#include "zcore_2d.h"
#include "zcore_window.h"
#include "zcore_winres.h"
#include "zcore_scrollbar.h"
#include "zcore_control.h"
#include "zcore_timer.h"
#include "zcore_ime.h"
#include "zcore_caret.h"
#include "zcore_dlg.h"

#define SBS_NORMAL      0x00
#define SBS_DISABLED    0x01
#define SBS_HIDE        0x02

#define IDC_STATIC    0
#define IDOK          1
#define IDCANCEL      2
#define IDABORT       3
#define IDRETRY       4
#define IDIGNORE      5
#define IDYES         6
#define IDNO          7
#define IDC_VSCROLLBAR 8

gal_pixel GUIAPI SetWindowElementColorEx (HWND hwnd, ZUINT16 item, gal_pixel new_value);
ZBOOL BlinkCaret (HWND hWnd);
ZVOID GetCaretBitmaps (PCARETINFO pCaretInfo);
MG_EXPORT ZVOID GUIAPI GetCursorPos (POINT* ppt);
MG_EXPORT ZVOID GUIAPI Draw3DBorderEx (HDC hdc, HWND hwnd, ZSINT32 l, ZSINT32 t, ZSINT32 r, ZSINT32 b);
MG_EXPORT ZVOID GUIAPI Draw3DThickFrameEx (HDC hdc, HWND hwnd,
                ZSINT32 l, ZSINT32 t, ZSINT32 r, ZSINT32 b, ZDWORD flags, gal_pixel fillc);

struct _THREADINFO
{
    PMSGQUEUE           pMsgQueue;    /* pointer to message queue of the thread */
 //   pthread_t           th;         /* the thread id */
	ZCORE_OS_THREAD_ID           th;  
    PMAINWIN            pMainWin;     /* Top level main window of this thread */

    ZDWORD               dwState;     /* current thread status */
    OS_MUTEX_ID     lock;             /* access lock */

    struct _THREADINFO  *next;

    //TODO ...
};
//typedef struct _THREADINFO THREADINFO; //zhangchao
typedef THREADINFO* PTHREADINFO;
THREADINFO*   InitThreadInfo    (ZVOID);
ZVOID          FreeThreadInfo    (THREADINFO *thi);

THREADINFO*   GetThreadInfo (ZCORE_OS_THREAD_ID thread);
PMSGQUEUE     GetThreadMsgQueue (ZCORE_OS_THREAD_ID thread);
extern     ZVOID PdcDealCtrl(PT_DCMgt_DC pdc);

#ifdef _TOUCHWIZ_EFFECTS
#define LWA_COLORKEY    0x00000001
#define LWA_ALPHA       0x00000002
#define LWA_BITMAP_MASK 0x00000004
#endif


ZBOOL wndInvalidateRect (HWND hWnd, const RECT* prc, ZBOOL bEraseBkgnd);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /* _MGUI_WINDOW_H */
