#ifndef SURFACE_H
#define SURFACE_H

#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
#define WED_SURFACE           32

#define SURFACE_NORMAL       0x02
#define SURFACE_PRIMARY      0x01

#define SURFACE_BACKBUFFER   0x10
#define SURFACE_COLORKEY     0x20
#define SURFACE_ALPHA        0x40

#define SURFACE_SPECIAL_GC  0x80000000

/**************************************************************************
 *                                                                *
 **************************************************************************/
/* surfaceṹĶ */
typedef struct _surface_t
{
    UINT32  flag;        /* surface */
    ZSINT32 width;       /* surface */
    ZSINT32 height;      /* surface߶ */
    ZSINT32 pitch;       /* surfaceÿռõֽ */
    ZUINT8* pFrontBuffer;/* ǰ */
    ZUINT8* pBackBuffer; /* 󻺴 */
    UINT32  lock;        /*  */
    PGC     pGC;         /* ӦsurfaceGCṹ */

    UINT32 BitsPerPixel; /* ÿռõı */
    UINT32 BytesPerPixel;/* ÿռõֽ */
    Pixel  colorkey;     /* ͸ɫ */
    UINT32 opacity;      /* ͸ֵ */
}SURFACE;

typedef struct _surface_t* PSURFACE;

/**************************************************************************
 *                        ȫֺԭ                                     *
 **************************************************************************/
PSURFACE CreateSurface(UINT32 width,UINT32 height, UINT32 bpp);
ZBOOL    ResizeSurface(PSURFACE pSurface,ZSINT32 width,ZSINT32 height);
ZBOOL    FreeSurface(PSURFACE surface);
ZBOOL    CreateSurfaceForWindow(HWND hWnd);
PSURFACE GetWindowSurface(HWND hWnd);
ZSINT32  InitDCBySurface(HDC hdc,HWND hWnd, ZBOOL bIsClient);
ZBOOL    GenerateECRgnForPaint(HDC hdc);
ZBOOL    ReleaseSurfaceDC(HDC hdc);

#ifdef __cplusplus
}
#endif
#endif  /* SURFACE_H */
