#ifndef	os_exception_H
#define	os_exception_H
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "zcore_type.h"
#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
 *                                                                    *
 **************************************************************************/

/**************************************************************************
*                         궨                                         *
**************************************************************************/
#define EXCEP_TMP_BUFFER_SIZE  ((UINT32)256)/*ʱС*/
#define OS_INHERIT             (UINT32)(1)  /*ȼȡ*/
#define OS_NO_INHERIT          (UINT32)(0)  /*˳ȡ.*/
#define TRACE_PRINT_STATUS              0   /* ӡ̬ */
/**************************************************************************
 *                         ṹͶ                                    *
 **************************************************************************/

typedef struct _T_Trace_PrintContext
{
    UINT32      printStatus;                           /* ǰ״̬,ʼ̬ߴӡ̬ */
    ZBOOL        isFirstLinkKeep;                       /* ǰǷǵһյEVENT_PRN_LINKKEEP */
    //UINT8  PrnMdlInfo[TRACE_MAX_PRNMDL_NUM + 1];  /* ӡϢ */
    ZCHAR       *prnBuf;                              /* ӡ */
    FILE       *printFileHandle;                     /* ӡļļ */
    OS_MUTEX_ID gTracePrnMutexID;                      /* ӡ壬ӡ */
    OS_SEMA_ID  gTracePrnSemID;                        /* ӡź֤ӡʧ */
}T_Trace_PrintContext;

typedef struct _T_PrnBuffer
{
    UINT32  readIndex;   /*  */
    UINT32  writeIndex;  /* д */
    ZCHAR   *buf;         /* ȫֵĴӡ */
} T_PrnBuffer;
/**************************************************************************
 *                        ԭ                                     *
 **************************************************************************/
 
 
/**************************************************************************
* ƣ OS_Exception_Handler
*  OS_ASSERT
* ˵ pExp:zOss_ASSERTıʽ
	     pcFileNameļ
	     pcFuncNameĺ
	     dwLineNum ڵ
*   ֵ
* ˵
**************************************************************************/
ZVOID    OS_Exception_Handler(ZCHAR *pExp,
                             const ZCHAR *pcFileName,
                             const ZCHAR *pcFuncName,
                             SINT32 dwLineNum);
OS_STATUS  OS_Exception_Init(ZVOID);

/**************************************************************************
* ƣ os_assert
*  
* ˵ ʽ
*   ֵ 
* ˵ 
**************************************************************************/
#define os_assert(exp) assert(exp);

#if defined WIN32
#define OS_ASSERT(_EXP)  do{if(!(_EXP))  OS_Exception_Handler(#_EXP,__FILE__,NULL,__LINE__);}while(0)
#elif defined _OS_ARENA
#define OS_ASSERT(_EXP)  do{if(!(_EXP))  OS_Exception_Handler(#_EXP,(ZCHAR *) __FILE__,(ZCHAR *)__func__,__LINE__);}while(0)
#elif defined _OS_T
#define OS_ASSERT(_EXP)  do{if(!(_EXP))  OS_Exception_Handler(#_EXP,(ZCHAR *) __FILE__,(ZCHAR *)NULL,__LINE__);}while(0)
#else
#define OS_ASSERT(_EXP)  do{if(!(_EXP))  OS_Exception_Handler(#_EXP,(ZCHAR *)__FILE__,(ZCHAR *)__func__,__LINE__);}while(0)
#endif

#define OS_ASSERTEx(condition, code)                                            \
					{                                           \
						if (!(condition))  	            \
						{                                   \
							OS_ASSERT((condition));   \
							return code;               \
						}                                   \
					}
 #define OS_ASSERTExN(condition)                                            \
					{                                           \
						if (!(condition))  	            \
						{                                   \
							OS_ASSERT((condition));   \
							return;                 \
						}                                   \
					}
 
 
 
 
#ifdef __cplusplus
}
#endif

#endif  /* os_exception_H */
