#ifndef __MTCSYSTEM_H__
#define __MTCSYSTEM_H__


#include "zcore_type.h"
/******************************************************************************/
/*                                                                            */
/* FUNCTION DESCRIPTION                                                       */
/*                                                                            */
/* Implement interface what MTC_ALLOC and MTC_FREE by macro or function.      */
/*                                                                            */
/* Example:                                                                   */
/*                                                                            */
/* #define MTC_ALLOC(size)                  malloc(size)                      */
/* #define MTC_FREE(buffer)                 free(buffer)                      */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* Macro Defines                                                              */
/*                                                                            */
/******************************************************************************/

#define MTC_MEMORY_POOL_SIZE 0x4000 /* 16KB */

/******************************************************************************/
/*                                                                            */
/* Global Variables Defines                                                   */
/*                                                                            */
/******************************************************************************/

static ZUINT8 mtc_memory_pool[MTC_MEMORY_POOL_SIZE];

static ZUINT8 *mtc_pointer = mtc_memory_pool;

/******************************************************************************/
/*                                                                            */
/* Cache Memory Management Interface Defines                                  */
/*                                                                            */
/******************************************************************************/

ZVOID * MTC_ALLOC(ZSINT32 size) {
	ZVOID *ptr;
	ZSINT32 sizeofint = sizeof(ZSINT32);

	if (size % sizeofint) {
		size += sizeofint - (size % sizeofint);
	}

	if ((ZUINT32)mtc_pointer % sizeofint) {
		mtc_pointer += sizeofint - ((ZUINT32)mtc_pointer % sizeofint);
	}

	if (size > MTC_MEMORY_POOL_SIZE) {
		return NULL;
	}

	if ((ZUINT32)(mtc_memory_pool + MTC_MEMORY_POOL_SIZE) - (ZUINT32)mtc_pointer < (ZUINT32)size) {
		mtc_pointer = (ZUINT8 *)mtc_memory_pool;
	}

	ptr = (ZVOID *)mtc_pointer;
	mtc_pointer += size;

	return ptr;
}

ZVOID MTC_FREE(ZVOID *ptr) {
	/* do nothing */
	ptr = ptr;
}

#endif /* __MTCSYSTEM_H__ */
