#include "zte_web_interface.h"
#include "zte_web_httpshare.h"
#include "../server/webs.h"
#include "sqlite3.h"
#include <sys/wait.h>
#include "cfg_api.h"

USER_COMMON_INFOR  pp_header;

static char file_buf_memory[FILE_BUFFER_LEN] = {0};
static char *file_buf_memory_ptr = NULL;
static int tcard_file_size = 0;
static BOOL file_end = FALSE;
char download_file[ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1] = {0};

void zte_httpshare_check_upload_file();

static char* neutralize(char *path);

int  zte_httpshare_call_system(char * cmd)
{
	if (NULL == cmd) {
		slog(MISC_PRINT,SLOG_DEBUG,"[httpshare]httpshare_call_system: NULL-------------------------------\n");
		return -1;
	}
	slog(MISC_PRINT,SLOG_NORMAL,"[httpshare]httpshare_call_system: [%s] \n", cmd);
#if 0
	return system(cmd);
#else
    return  zxic_system(cmd);
#endif
}

static int  zte_httpshare_call_system_echo(char * cmd)
{
	if (NULL == cmd) {
		slog(MISC_PRINT,SLOG_DEBUG,"[httpshare]httpshare_call_system_echo: NULL-------------------------------\n");
		return -1;
	}
	slog(MISC_PRINT,SLOG_NORMAL,"[httpshare]httpshare_call_system_echo: [%s] \n", cmd);

	return soft_system(cmd);
}


int zte_system(char *cmd[])
{
	pid_t pid;
	int status;
	pid_t ret;
	char *newenviron[] = { NULL };

	// cmd array's size is unknown
//	slog(MISC_PRINT,SLOG_NORMAL,"[httpshare]httpshare_call_system: [%s %s %s] \n", cmd[0],cmd[1],cmd[2]);

	pid = fork();
	if (pid == -1) {
		return -1;
	} else if (pid == 0) {
		/*child process */
		execve(cmd[0], cmd, newenviron);
		/* for kw
		if (execve(cmd[0], cmd, newenviron) == -1)
			_exit(127);*/
	} else {
		/*father process */
		while ((ret = waitpid(pid, &status, 0)) == -1) {
			if (errno != EINTR)
				break;
		}

		if (ret != -1 && WIFEXITED(status))
			return WEXITSTATUS(status);
	}

	return -1;
}

zte_httpshare_db_result_e_type zte_httpshare_db_open(sqlite3**db)
{
	sqlite3* tmp_db;
	int rc = 0;

	if (NULL == db) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_db_open:invalide inputs.\n");
		return ZTE_HTTPSHARE_DB_ERROR_INVAILD_PTR;
	}

	rc = sqlite3_open(ZTE_HTTPSHARE_DB_PATH, &tmp_db);

	if (rc) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_db_open:can not open db,sqlite3_errmsg:%s\n", sqlite3_errmsg(tmp_db));
		(void)sqlite3_close(tmp_db);
		return ZTE_HTTPSHARE_DB_ERROR_NOT_OPEN_DB;
	}
	*db = tmp_db;
	return ZTE_HTTPSHARE_DB_OK;
}

zte_httpshare_db_result_e_type zte_httpshare_db_close(sqlite3*db)
{
	int rc = 0;

	if (NULL == db) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_db_close:invalide inputs.\n");
		return ZTE_HTTPSHARE_DB_ERROR_INVAILD_PTR;
	}
	rc = sqlite3_close(db);
	if (rc) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_db_close:can not close db.\n");
		return ZTE_HTTPSHARE_DB_ERROR;
	}
	return ZTE_HTTPSHARE_DB_OK;
}
zte_httpshare_db_result_e_type zte_httpshare_db_exec_sql(const char *sql, sqlite3_callback callback, void *fvarg)
{
	sqlite3* db;
	int rc = 0;

	if (NULL == sql) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_db_exec_sql:invalide inputs.\n");
		return ZTE_HTTPSHARE_DB_ERROR_INVAILD_PTR;
	}
	if (0 != zte_httpshare_db_open(&db)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_db_exec_sql:open httpshare.db failed.\n");
		return ZTE_HTTPSHARE_DB_ERROR_NOT_OPEN_DB;
	}
	rc = sqlite3_exec(db, sql, callback, fvarg, NULL);

	slog(MISC_PRINT, SLOG_NORMAL,"[httpshare]httpshare_db_exec_sql:%s rc=%d\n", sql, rc);
	if (rc) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_db_exec_sql:can not exec sql,sqlite3_errmsg:%s.\n", sqlite3_errmsg(db));
		(void)zte_httpshare_db_close(db);
		return ZTE_HTTPSHARE_DB_ERROR;
	}
	(void)zte_httpshare_db_close(db);

	return ZTE_HTTPSHARE_DB_OK;
}


int zte_insert_download_file(char *path)
{
	memset(download_file, 0, sizeof(download_file));
	strncpy(download_file, path, sizeof(download_file)-1);
	slog(MISC_PRINT, SLOG_NORMAL,"[httpshare]download_file->%s\n", download_file);
	return 1;
}

int zte_del_download_file()
{
	slog(MISC_PRINT, SLOG_NORMAL,"[httpshare]del download_file->%s\n", download_file);
	memset(download_file, 0, sizeof(download_file));
	return 1;
}


int zte_check_download_file(char *path)//0: ڼ¼  1:¼
{
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]check_download_file:path->%s\n", path);
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]check_download_file:download_file->%s\n", download_file);

	if (!strncmp(path, download_file, strlen(path))) {
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]check_download_file:find used file->%s\n", path);
		return 1;
	} else {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]check_download_file:not find file->%s\n", path);
		return 0;
	}
}

int zte_check_downloading_file()//0: ڼ¼  1:¼
{
	slog(MISC_PRINT, SLOG_DEBUG,"[zyl]strlen(download_file)->%d\n", strlen(download_file));
	return strlen(download_file);
}

void zte_change_rootpath_time()
{
	struct utimbuf times = {0};
	utime(SD_CARD_PATH, &times); //timesΪʱutime ʱ޸ʱΪǰʱ
	return;
}

void   zte_init_user_list()
{
	memset(&pp_header, 0, sizeof(USER_COMMON_INFOR));
	memset(&download_file, 0, sizeof(download_file));
}

int zte_del_file(char *path)
{
	//char *cmd = NULL;

	if (!path) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]del_file  null\n");
		return 0;
	}
	/*
	cmd = (char *)malloc(strlen(path) + 10);
	//char cmd[4*ZTE_HTTPSHARE_FILE_NAME_MAX_LEN+1] = {0};
	if (NULL == cmd) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]del_file malloc error!\n");
		return 0;
	}
	snprintf(cmd, strlen(path) + 10, "rm -rf \"%s\"", path);

	zte_httpshare_call_system(cmd);
	*/
	char *cmd[] = { "/bin/rm", "-rf", path, NULL };
	zte_system(cmd);
	if (access(path, F_OK) == 0) {
		if(remove(path) < 0){
            slog(MISC_PRINT, SLOG_ERR,"[httpshare]remove file %s fail!\n", path); 
			return 0;
		}
		if (access(path, F_OK) == 0) {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]delfile %s fail!\n", path);
			//free(cmd);
			return 0;
		}
	}
	//free(cmd);
	slog(MISC_PRINT, SLOG_NORMAL,"[httpshare]delfile %s OK!\n", path);
	return 1;

}

int zte_umount_dev()
{
	char cmd[ZTE_HTTPSHARE_DEFAULT_LEN] = {0};
	char sd_path[20] = {0};
	char *mount_path = "/bin/umount";
	
	sc_cfg_get ("cur_tcard_blk", sd_path, sizeof(sd_path));
	if (strlen(sd_path) != 0) {
		snprintf(cmd, sizeof(cmd), "%s %s", mount_path, sd_path);
	}
	else {
		snprintf(cmd,  sizeof(cmd), "%s %s", mount_path, USB_DEV_SDCARD_PATH);
	}
	zte_httpshare_call_system(cmd);

	memset(cmd, 0, sizeof(cmd));
	snprintf(cmd,  sizeof(cmd), "%s %s", mount_path, USB_DEV_SDCARD_PATH_BACK);
	zte_httpshare_call_system(cmd);

	memset(cmd, 0, sizeof(cmd));
	snprintf(cmd,  sizeof(cmd), "%s %s", mount_path, SD_CARD_PATH);
	zte_httpshare_call_system(cmd);

	return 0;
}

/*дļزbegin*/
static int filelength(FILE *fp)
{
    int num;
    fseek(fp,0,SEEK_END);
    num=ftell(fp);
    fseek(fp,0,SEEK_SET);
    return num;
}

static int readfile(char *path, char* buf, unsigned len)
{
    FILE *fp;
    unsigned int length;
	size_t read_len = 0;
	
    if((fp=fopen(path,"r"))==NULL)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] open file %s error.\n",path);
        return -1;
    }
    length=filelength(fp);
    length = length > len? len: length;
    //ch=(char *)malloc(length+1);
    read_len = fread(buf,length,1,fp);
	if(read_len != 1)
	{
	    slog(USBCFGMNG_PRINT,SLOG_ERR, "read len:%d.\n",read_len);
	}
	
    fclose(fp);
    *(buf+length)='\0';
    return (int)length;
}
int zte_get_cdrom()
{
	char cdrom0[8] = {0};
	char cdrom1[8] = {0};
	int rtv = 0;
	int cdrom_state0 = -1;
	int cdrom_state1 = -1;
	rtv = readfile("/sys/devices/platform/zx29_hsotg.0/gadget/lun0/cdrom", cdrom0, 8);
	cdrom_state0 = atoi(cdrom0);
	rtv = readfile("/sys/devices/platform/zx29_hsotg.0/gadget/lun1/cdrom", cdrom1, 8);
	cdrom_state1 = atoi(cdrom1);
	if(cdrom_state0 == 0)	//lun0Ϊu
	{
		return 0;	
	}

	if(cdrom_state1 == 0)	//lun1Ϊu
	{
		return 1;	
	}

	return -1;

}

void zte_mount_usb()
{
	int cdrom = -1;
	cdrom = zte_get_cdrom();
	
	if(cdrom == 0)
	{
		zte_umount_dev();
		zte_httpshare_call_system_echo("/bin/echo /dev/mmcblk0 > /sys/devices/platform/zx29_hsotg.0/gadget/lun0/file");
	}
	else if(cdrom == 1)
	{
		zte_umount_dev();
		zte_httpshare_call_system_echo("/bin/echo /dev/mmcblk0 > /sys/devices/platform/zx29_hsotg.0/gadget/lun1/file");
	}
}



int zte_httpshare_mount_sd()
{
	char *cmd[] = { "/bin/mount", "-t", "vfat",USB_DEV_SDCARD_PATH,SD_CARD_PATH, NULL };
	char *cmd1[] = { "/bin/mount", "-t", "vfat",USB_DEV_SDCARD_PATH_BACK,SD_CARD_PATH, NULL };

	char sd_path[20] = {0};
	int i = 0;
	
	zte_umount_dev();
//ѯ1-10
	for (i = 1; i <= 10; i++) {
		memset(sd_path, 0, sizeof(sd_path));
		snprintf(sd_path, sizeof(sd_path), "/dev/mmcblk0p%d", i);
		cmd[3] = sd_path;
		if (0 == zte_system(cmd)) {
			sc_cfg_set("cur_tcard_blk", sd_path);
			sleep(2);
			return 1;
		}
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_mount_sd %s error!\n", sd_path);
	}
	
	if (0 != zte_system(cmd1)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_mount_sd %s error!\n", USB_DEV_SDCARD_PATH_BACK);
		return 0;
	}
	sleep(2);
	return 1;
}

int  zte_mount_httpshare()
{
	char cmd[ZTE_HTTPSHARE_DEFAULT_LEN] = {0};

	int cdrom = -1;

	cdrom = zte_get_cdrom();
    slog(MISC_PRINT, SLOG_ERR,"mount_httpshare:cdrom=%d\n",cdrom);
	if(cdrom == 0)
	{
		memset(cmd, 0, sizeof(cmd));
		zte_httpshare_call_system_echo("/bin/echo NULL > /sys/devices/platform/zx29_hsotg.0/gadget/lun0/file");
		if (-1 == access(SD_CARD_PATH, F_OK)) {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]mount_httpshare mmc2 no exist!\n");
			if(mkdir(SD_CARD_PATH, 0777) < 0)
			{
			    slog(MISC_PRINT, SLOG_ERR,"[httpshare]mkdir(%s) fail!\n", SD_CARD_PATH);
			}
			return zte_httpshare_mount_sd();
		} else {
			slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]mount_httpshare %s exist\n", SD_CARD_PATH);
			return zte_httpshare_mount_sd();
		}
	}
	else if(cdrom == 1)
	{
		memset(cmd, 0, sizeof(cmd));
		zte_httpshare_call_system_echo("/bin/echo NULL > /sys/devices/platform/zx29_hsotg.0/gadget/lun1/file");
		if (-1 == access(SD_CARD_PATH, F_OK)) {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]mount_httpshare mmc2 no exist!\n");
			if(mkdir(SD_CARD_PATH, 0777) < 0){
               slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]mkdir fail %s exist\n", SD_CARD_PATH);
			}
			return zte_httpshare_mount_sd();
		} else {
			slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]mount_httpshare %s exist\n", SD_CARD_PATH);
			return zte_httpshare_mount_sd();
		}
	}
	else
		return 0;

}


void zte_write_auth_to_web(webs_t wp)
{

	if ((NULL == wp)) {
		return;
	}
	char HTTP_SHARE_WR_AUTH[10] = {0};
	char HTTP_SHARE_FILE[1024] = {0};

	(void)zte_web_read(NV_HTTPSHARE_WR_AUTH, HTTP_SHARE_WR_AUTH);
	(void)zte_web_read(NV_HTTPSHARE_FILE, HTTP_SHARE_FILE);

	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]write_auth_to_web: value is [%s]\n", HTTP_SHARE_WR_AUTH);
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]write_auth_to_web: value is [%s]\n", HTTP_SHARE_FILE);
	web_feedback_header(wp);
	(void)websWrite(wp, T("{\"HTTP_SHARE_WR_AUTH\":\"%s\",\"HTTP_SHARE_FILE\":\"%s\"}"),
	                HTTP_SHARE_WR_AUTH, HTTP_SHARE_FILE);
}
void zte_write_tcard_name_to_web(webs_t wp)
{
	if ((NULL == wp)) {
		return;
	}

	web_feedback_header(wp);
	(void)websWrite(wp, T("{\"sd_card_name\":\"%s\"}"), "MicroSD Card");
}


void write_sd_card_total_size(uint32  total_size)
{
	char sd_card_total_size[NV_ITEM_VALUE_STRING_LEN] = {0};

	snprintf(sd_card_total_size, sizeof(sd_card_total_size), "%lu", total_size);
	(void)zte_web_write("sd_card_total_size", sd_card_total_size);
}

void write_sd_card_avi_space_to_nv(uint32  free_size)
{
	char sd_card_avi_space[NV_ITEM_VALUE_STRING_LEN] = {0};
	snprintf(sd_card_avi_space, sizeof(sd_card_avi_space), "%lu", free_size);
	(void)zte_web_write("sd_card_avi_space", sd_card_avi_space);
}


void get_used_space_size()
{

	struct statvfs file_stat;
	uint32 total_size = 0;
	uint32 b_used = 0 ;
	if (zte_check_file_exist(SD_CARD_PATH)) {
		(void)statvfs(SD_CARD_PATH, &file_stat);
		total_size = file_stat.f_blocks * (file_stat.f_bsize / 512) / 64;
		b_used = file_stat.f_bfree * (file_stat.f_bsize / 512) / 64;
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]get_used_space_size dirsize = %ld, %ld\n", total_size, b_used);
		if (total_size / 1024 / 1024 > 32) {
			slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]get_used_space_size total size abnormal >1024G !!!!\n");
			total_size = total_size / 1024;
		}
		if (b_used / 1024 / 1024 > 32) {
			slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]get_used_space_size b_used size abnormal >1024G !!!!\n");
			b_used = b_used / 1024;
		}
		if (total_size < b_used) {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]get_used_space_size sdcard size abnormal : total_size<b_used !!!!\n");
		}
		write_sd_card_total_size(total_size);
		write_sd_card_avi_space_to_nv(b_used);
	}

}



void zte_write_space_info_to_web(webs_t wp)
{
	if ((NULL == wp)) {
		return;
	}
	char sd_card_total_size[NV_ITEM_VALUE_STRING_LEN] = {0};
	char sd_card_avi_space[NV_ITEM_VALUE_STRING_LEN] = {0};

	(void)zte_web_read("sd_card_total_size", sd_card_total_size);
	(void)zte_web_read("sd_card_avi_space", sd_card_avi_space);


	web_feedback_header(wp);
	(void)websWrite(wp, T("{\"sd_card_total_size\":\"%s\",\"sd_card_avi_space\":\"%s\"}"),
	                sd_card_total_size, sd_card_avi_space);
}


/**** *****/
//check whether the  dir exist or not
zte_httpshare_return_e_type zte_httpshare_check_and_creat_dir(char *path)
{
	if (!path) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_check_and_creat_dir: check dir path null.\n");
		return ZTE_HTTPSHARE_FAILURE;
	}
	if (-1 == access(path, F_OK)) {
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]httpshare_check_and_creat_dir:%s does not exist,socreate it.\n", ZTE_HTTPSHARE_DB_DIR);
		if (-1 == mkdir(path, 0777)) {  		/*lint !e1055*/
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_check_and_creat_dir:failed to create db dir.\n");
			return ZTE_HTTPSHARE_FAILURE;
		}
	}
	return ZTE_HTTPSHARE_SUCCESS;
}

zte_httpshare_db_result_e_type zte_httpshare_create_table()
{
	zte_httpshare_db_result_e_type result = ZTE_HTTPSHARE_DB_OK;

	//create httpshare table
	result = zte_httpshare_db_exec_sql(ZTE_CREATE_TABLE_HTTPSHARE_SQL, NULL, NULL);

	if (ZTE_HTTPSHARE_DB_OK != result) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_create_table:create httpshare table result is %d\n", result);
		return result;
	}
	return result;
}

//based path,check the file wether in Tcard
int zte_check_file_exist(char * path)
{

	if (!path) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]check_file_exist:file path null.\n");
		return 0;
	}

	if (-1 == access(path, F_OK)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]check_file_exist path=%s  (file not exist)\n", path);
		return 0;

	} else {
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]check_file_exist path=%s  (file exist)\n", path);
		return 1;
	}
}


int zte_check_sdcard_exist()
{
	int ret = 0;

	FILE *fd = NULL;

	char size_sd[ZTE_HTTPSHARE_LEN_12] = {0};

	//system("echo /dev/mmcblk0>/proc/proc_sd/file");

    if(access("/sys/kernel/debug/mmc1/present", R_OK) != 0)
    {
		slog(MISC_PRINT, SLOG_ERR, "[httpshare] check_sdcard_exist file not exist!\n");
        return ret;	
    }	

	//fd = popen("cat /proc/proc_sd/size","r");
	fd = popen("cat /sys/kernel/debug/mmc1/present", "r");
	//printf("[httpshare]check_sdcard_exist cat /sys/kernel/debug/mmc1/present\n");

	if (fd == NULL) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]check_sdcard_exist popen file = NULL\n");
		return ret;
	}
	if (!feof(fd) && fgets(size_sd, sizeof(size_sd), fd) != NULL) {
		ret = atoi(size_sd);
	}

	pclose(fd);

	//printf("[httpshare]check_sdcard_exist :get size data = %d\n",ret);

	return ret;
}


// Get current mode from nv
zte_httpshare_current_mode_type zte_httpshare_get_current_mode()
{
	char nv_item[ZTE_HTTPSHARE_DEFAULT_LEN] = {0};
	(void)zte_web_read(STR_SDCARD_MODE_OPT, nv_item);
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]sdcard_mode_option:%s\n", nv_item);

	if (0 == strcmp("1", nv_item)) {
		return  ZTE_HTTPSHARE_HTTPSHARE;
	} else {
		return ZTE_HTTPSHARE_USB;
	}

}
int zte_httpshare_change_current_mode(zte_httpshare_current_mode_type mode)
{
	char cmd[ZTE_HTTPSHARE_DEFAULT_LEN] = {0};
	int cdrom = -1;

	if (ZTE_HTTPSHARE_HTTPSHARE == mode) {
		if (!zte_mount_httpshare()) { //devڵΪ/mnt/jffs2/mmc2
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]change to %d mode faile\n", mode);
			(void)zte_web_write(STR_SDCARD_MODE_OPT, "0");

                    cdrom = zte_get_cdrom();
                    slog(MISC_PRINT, SLOG_ERR,"mount_httpshare:cdrom=%d\n",cdrom);
                    if(cdrom == 0)
                        zte_httpshare_call_system_echo("/bin/echo dev/mmcblk0 > /sys/devices/platform/zx29_hsotg.0/gadget/lun0/file");
                    else if(cdrom == 1)
			    zte_httpshare_call_system_echo("/bin/echo dev/mmcblk0 > /sys/devices/platform/zx29_hsotg.0/gadget/lun1/file");
			return ZTE_CHANGE_MODE_ERROR;
		}
		slog(MISC_PRINT, SLOG_NORMAL,"[httpshare]change to %d mode suc.\n", mode);
		(void)zte_web_write(STR_SDCARD_MODE_OPT, "1");
	} else {
		zte_httpshare_check_upload_file();

		zte_mount_usb();
		slog(MISC_PRINT, SLOG_NORMAL,"[httpshare]change to %d mode suc.\n", mode);

		(void)zte_web_write(STR_SDCARD_MODE_OPT, "0");
	}
	return ZTE_CHANGE_MODE_OK;

}

int  zte_init_sdcard_mode()
{
	if (zte_check_sdcard_exist() > 0) {
		(void)zte_web_write(NV_SD_CARD_STATE, "1");

		if (ZTE_HTTPSHARE_USB == zte_httpshare_get_current_mode()) {
			return zte_httpshare_change_current_mode(ZTE_HTTPSHARE_USB);
		} else {
			return zte_httpshare_change_current_mode(ZTE_HTTPSHARE_HTTPSHARE);
		}
	} else {
		(void)zte_web_write(NV_SD_CARD_STATE, "0");
		zte_del_file(SD_CARD_PATH);
		return ZTE_CHANGE_MODE_ERROR;
	}
}

void zte_httpshare_init()
{

	//zte_init_user_list(&pp_header);				//creat user nod
	zte_init_user_list();
	(void)zte_del_file(ZTE_HTTPSHARE_DB_PATH);

	if (ZTE_HTTPSHARE_SUCCESS != zte_httpshare_check_and_creat_dir(ZTE_HTTPSHARE_DB_DIR)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_init:httpshare_check_and_creat_dir HTTPSHARE_DB_DIR fail!\n");
		return;
	}
	if (ZTE_HTTPSHARE_DB_OK != zte_httpshare_create_table()) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_init:httpshare_create_table fail!\n");
		return;
	}

	zte_init_sdcard_mode();
}


int sd_card_isExist()
{
	char sdcard_state[ZTE_HTTPSHARE_DEFAULT_LEN] = {0};
	(void)zte_web_read(NV_SD_CARD_STATE, sdcard_state);
	if (0 == strcmp("0", sdcard_state)) {
		printf("[httpshare]sd_card_isExist:sdcard no exist.\n");
		return 0;
	} else if (0 == strcmp("1", sdcard_state)) {
		return 1;
	} else {
		printf("[httpshare]sd_card_isExist:sdcard state error.\n");
		return 0;
	}

}

boolean zte_httpshare_check_patch_inlegal(const char *path_source)
{
	char *token = NULL;

	if (0 == strncmp(path_source, HTTPSHARE_PATH_INLEGAL, 8)) {
		if (path_source[8] == '/' || path_source[8] == '\0') {
			return TRUE;
		}
	}

	if ((token = strchr(path_source, 39)) != NULL) {  // 39 means '
		while (*token++ == 32); // 32 means (space)

		switch (*token) {
		case 59:          // 59 means ;
		case 124:        // 124 means |
			return TRUE;
		case 38:         // 38 means &
			if (*(++token) == 38)
				return TRUE;
		default:
			return FALSE;
		}
	}

	return FALSE;
}

int zte_httpshare_db_id_cb(void *fvarg, int line, char **zresult, char **lname)
{
	if (1 > line) {
		printf("[httpshare]httpshare_db_id_cb:record no data.\n");
		return -1;
	}
	*(int*)fvarg = atoi(zresult[0]);

	return 0;
}

int  zte_httpshare_check_record(char *ip)
{
	if (!ip) {
		printf("[httpshare]httpshare_check_record:para null.\n");
		return -1;
	}

	int id = 0;
	zte_httpshare_db_result_e_type result = ZTE_HTTPSHARE_DB_OK;

	char sql[ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 40] = {0};

	snprintf(sql, sizeof(sql), "select id from %s where ip = '%s' ", ZTE_HTTPSHARE_DB_NAME, ip);

	result = zte_httpshare_db_exec_sql(sql, zte_httpshare_db_id_cb, &id);
	(void)sleep(2);
	if (ZTE_HTTPSHARE_DB_OK != result) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_check_record:result %d\n", result);
	}

	return id;

}


zte_httpshare_db_result_e_type  zte_httpshare_update_record(char *ip, char *path)
{

	if ((!ip) || (!path)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_update_record:para null.\n");
		return ZTE_HTTPSHARE_DB_ERROR;
	}

	zte_httpshare_db_result_e_type result = ZTE_HTTPSHARE_DB_OK;

	char sql[ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 40] = {0};
	snprintf(sql, sizeof(sql), "update %s set path =\"%s\"  where ip = \"%s\" ", ZTE_HTTPSHARE_DB_NAME, path, ip);

	result = zte_httpshare_db_exec_sql(sql, NULL, NULL);
	if (ZTE_HTTPSHARE_DB_OK != result) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_update_record:update record result %d\n", result);
		return result;
	}

	return result;
}

int zte_httpshare_getpath_cb(void *fvarg, int line, char **zresult, char **lname)
{
	if (1 > line) return -1;
	memcpy(fvarg, zresult[0], strlen(zresult[0]));
	return 0;
}

zte_httpshare_db_result_e_type  zte_httpshare_get_record(char *ip, char *path)
{
	if ((!ip) || (!path)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_get_record:para null.\n");
		return ZTE_HTTPSHARE_DB_ERROR;
	}
	zte_httpshare_db_result_e_type result = ZTE_HTTPSHARE_DB_OK;

	char sql[ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 40] = {0};
	snprintf(sql, sizeof(sql), "select path from %s where ip = '%s' ", ZTE_HTTPSHARE_DB_NAME, ip);

	result = zte_httpshare_db_exec_sql(sql, zte_httpshare_getpath_cb, path);
	(void)sleep(1);
	if (ZTE_HTTPSHARE_DB_OK != result) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_get_record:update record result %d\n", result);
		return result;
	}

	return result;
}


zte_httpshare_db_result_e_type  zte_httpshare_insert_path_to_db(char * ip, char *path)
{

	if ((!ip) || (!path)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_insert_path_to_db:para null.\n");
		return ZTE_HTTPSHARE_DB_ERROR;
	}

	zte_httpshare_db_result_e_type result = ZTE_HTTPSHARE_DB_OK;

	char sql[ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 40] = {0};
	snprintf(sql, sizeof(sql), "insert into %s (ip,path) values (\"%s\",\"%s\")", ZTE_HTTPSHARE_DB_NAME, ip, path);

	result = zte_httpshare_db_exec_sql(sql, NULL, NULL);

	if (ZTE_HTTPSHARE_DB_OK != result) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_insert_path_to_db:result %d\n", result);
		return result;
	}
	return result;

}


void zte_change_file_time(char *path_source, char*new_time)
{
	char *ptr = NULL;
	int i = 0;
	struct utimbuf times;
	if ((!new_time) || (!path_source)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]change_file_time src==NULL\n");

		return;
	}

	if ((!strlen(path_source)) || (!strlen(new_time))) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]change_file_time src==empty\n");

		return;
	}

	if (0 == atoi(new_time)) {
		times.modtime = 1378807200;    //1378807200   2013-09-10 10:00:00
		times.actime = 1378807200;     //1631268000   2021-09-10 10:00:00
	} else {
		times.modtime = atoi(new_time);
		times.actime = atoi(new_time);
	}
	utime(path_source, &times);

	ptr = path_source + strlen(path_source) - 1;
	for (i = strlen(path_source); i > 0; i--) {
		if (*ptr == '/')
			break;
		ptr--;
	}
	*ptr = '\0';
	utime(path_source, &times);

	return;
}
static void zte_write_file_record_pro(webs_t wp)
{
	web_feedback_header(wp);
	(void)websWrite(wp, T("{\"result\":"));
	(void)websWrite(wp, T("{\"fileInfo\":["));

}

/*
struct dirent
{
	long d_ino; // inode number ڵ
	off_t d_off; // offset to this dirent Ŀ¼ļеƫ
	unsigned short d_reclen; // length of this d_name ļ
	unsigned char d_type; // the type of d_name ļ
	char d_name [NAME_MAX+1]; /* file name (null-terminated) ļ256ַ
}
*/

int zte_write_filerecord_alphasort(webs_t wp, char*path)
{
	struct dirent **namelist;
	int n = 0;
	int file_count = 0;
	n = scandir(path, &namelist, 0, alphasort);
	zte_write_file_record_pro(wp);
	if (n < 3) {
		(void)websWrite(wp, T("],\"totalRecord\":\"%d\"}}"), file_count);
		if (n <= 0) {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]write_filerecord_alphasort: scandir n=%d.\n", n);
			free(namelist);
			return 1;
		}
		while (n--) {

			free(namelist[n]);
		}
		free(namelist);
		return 1;
	}
	char *file_path = NULL;
	file_path = (char*)malloc(ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1);
	if (!file_path) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]write_filerecord_alphasort, malloc error!\n");
		(void)websWrite(wp, T("],\"totalRecord\":\"%d\"}}"), file_count);
		while (n--) {
			slog(MISC_PRINT, SLOG_DEBUG,"namelist[%d]:%s\n", n, namelist[n]->d_name);
			free(namelist[n]);
		}
		free(namelist);
		return 1;
	}
	int i = 0;
	zte_file_record_s_type     record_ptr;
	struct stat 	fileinfo;
	for (i = 0; i < n; i++) {
		if (!strcmp(namelist[i]->d_name, ".") || !strcmp(namelist[i]->d_name, "..")) {
			continue;
		}
		memset(file_path, 0, ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1);
		snprintf(file_path, ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1, "%s/%s", path, namelist[i]->d_name);

		errno = 0;
		if (stat(file_path, &fileinfo) < 0) {
			//printf("[httpshare]write_filerecord_alphasort stat < 0\n");
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]write_filerecord_alphasort stat : %s[%s]\n", strerror(errno),file_path);
			continue;
		}
		file_count++;
		memset(&record_ptr, 0, sizeof(record_ptr));
		snprintf(record_ptr.fileName, ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1, "%s", namelist[i]->d_name);
		snprintf(record_ptr.lastUpdateTime, ZTE_HTTPSHARE_DEFAULT_LEN, "%lu", fileinfo.st_mtime);
		if (S_ISDIR(fileinfo.st_mode)) {
			snprintf(record_ptr.attribute, ZTE_HTTPSHARE_DEFAULT_LEN, "%s", ZTE_FOLDER_STR);
		} else {
			snprintf(record_ptr.attribute, ZTE_HTTPSHARE_DEFAULT_LEN, "%s", ZTE_FILE_STR);
			record_ptr.size = fileinfo.st_size;
		}

		if (file_count == 1) {
			(void)websWrite(wp, T("{\"fileName\":\"%s\",\"attribute\":\"%s\",\"size\":\"%u\",\"lastUpdateTime\":\"%s\"}"),
			                record_ptr.fileName, record_ptr.attribute, record_ptr.size, record_ptr.lastUpdateTime);
		} else {
			(void)websWrite(wp, T(",{\"fileName\":\"%s\",\"attribute\":\"%s\",\"size\":\"%u\",\"lastUpdateTime\":\"%s\"}"),
			                record_ptr.fileName, record_ptr.attribute, record_ptr.size, record_ptr.lastUpdateTime);
		}
	}
	(void)websWrite(wp, T("],\"totalRecord\":\"%d\"}}"), file_count);
	free(file_path);
	file_path = NULL;
	while (n--) {
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]write_filerecord_alphasort:namelist[%d]->%s\n", n, namelist[n]->d_name);
		free(namelist[n]);
	}
	free(namelist);
	namelist = NULL;
	return 0;

}


int zte_write_filerecord_alphasort_page(webs_t wp, char*path, int page_index)
{
	struct dirent **namelist;
	int n = 0;
	int file_count = 0;

	int i = 0;
	zte_file_record_s_type     record_ptr;
	struct stat 	fileinfo;
	char *file_path = NULL;
	int begin_index = (page_index - 1) * ZTE_HTTPSHARE_MAX_NUM_SHOW_RECORD;
	int end_index = page_index * ZTE_HTTPSHARE_MAX_NUM_SHOW_RECORD - 1;

	n = scandir(path, &namelist, 0, alphasort);

	zte_write_file_record_pro(wp);
	if (n < 3) {
		(void)websWrite(wp, T("],\"totalRecord\":\"%d\"}}"), file_count);

		if (n <= 0) {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]write_filerecord_alphasort_page scandir n=%d.\n", n);
			free(namelist);
			return 1;
		}
		while (n--) {
			//printf("%s\n",namelist[n]->d_name);
			free(namelist[n]);
		}
		free(namelist);
		return 1;
	}
	file_path = (char*)malloc(ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1);
	if (!file_path) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]write_filerecord_alphasort_page:list file memory fail!\n");
		(void)websWrite(wp, T("],\"totalRecord\":\"%d\"}}"), file_count);
		while (n--) free(namelist[n]);
		free(namelist);
		return 1;
	}

	for (i = 0; i < n; i++) {
		if (!strcmp(namelist[i]->d_name, ".") || !strcmp(namelist[i]->d_name, "..")) {
			if (i <= begin_index) {
				begin_index += 1;
				end_index += 1;
			} else {
				end_index += 1;
			}
			continue;
		}

		if ((i < begin_index))continue;

		if (i > end_index)break;

		memset(file_path, 0, ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1);
		snprintf(file_path, ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1, "%s/%s", path, namelist[i]->d_name);
		if (stat(file_path, &fileinfo) < 0) {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]write_filerecord_alphasort_page stat %s[%s]\n", strerror(errno),file_path);
			continue;
		}

		file_count++;
		memset(&record_ptr, 0, sizeof(record_ptr));
		snprintf(record_ptr.fileName, ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1, "%s", namelist[i]->d_name);
		snprintf(record_ptr.lastUpdateTime, ZTE_HTTPSHARE_DEFAULT_LEN, "%lu", fileinfo.st_mtime);
		if (S_ISDIR(fileinfo.st_mode)) {
			snprintf(record_ptr.attribute, ZTE_HTTPSHARE_DEFAULT_LEN, "%s", ZTE_FOLDER_STR);
		} else {
			snprintf(record_ptr.attribute, ZTE_HTTPSHARE_DEFAULT_LEN, "%s", ZTE_FILE_STR);
			record_ptr.size = fileinfo.st_size;
		}
		if (file_count == 1) {
			(void)websWrite(wp, T("{\"fileName\":\"%s\",\"attribute\":\"%s\",\"size\":\"%u\",\"lastUpdateTime\":\"%s\"}"),
			                record_ptr.fileName, record_ptr.attribute, record_ptr.size, record_ptr.lastUpdateTime);
		} else {
			(void)websWrite(wp, T(",{\"fileName\":\"%s\",\"attribute\":\"%s\",\"size\":\"%u\",\"lastUpdateTime\":\"%s\"}"),
			                record_ptr.fileName, record_ptr.attribute, record_ptr.size, record_ptr.lastUpdateTime);
		}
	}
	(void)websWrite(wp, T("],\"totalRecord\":\"%d\"}}"), n - 2);
	free(file_path);
	file_path = NULL;
	while (n--) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]write_filerecord_alphasort_page:namelist[%d]->%s\n", n, namelist[n]->d_name);
		free(namelist[n]);
	}
	free(namelist);
	namelist = NULL;
	return 0;
}



// creat a new document
int zte_create_document(char* path)
{
	if (!path) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]create_document:path is null\n");
		return 0;
	}
	slog(MISC_PRINT, SLOG_NORMAL,"[httpshare]create_document:create new folder->%s\n", path);

	if (-1 == mkdir(path, 0777)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]create_documentcreate new folder->%s failed\n", path);

		return 0;
	}
	(void)zte_httpshare_call_system("/bin/sync");

	return 1;

}


int  zte_del_multi_file_record(char* path, char* path1) //0ʧܣ1 ɹ2ؼ¼
{
	int del_res = 1;
	char *p = path1;
	int i = 0;
	char *absolute_path = NULL;
	char *name = NULL;
	absolute_path = (char*)malloc(ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1);
	if (!absolute_path) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]del_multi_file_record:multi del abusolute path malloc fail.\n");
		return 0;
	}
	name = (char*)malloc(strlen(path1) + 1);
	if (!name) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]del_multi_file_record:multi del name  malloc fail.\n");
		free(absolute_path);
		absolute_path = NULL;
		return 0;
	}

	memset(absolute_path, 0, ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1);
	memset(name, 0, strlen(path1) + 1);

	for (p = path1; *p != '\0'; p++) {
		if (*p != '*') {
			name[i] = *p;
			i++;
		} else {
			//·Ƴ<4096  ;  ļ<255
			if ((strlen(name) > 255) || ((strlen(name) + strlen(path)) > 4095)) {
				slog(MISC_PRINT, SLOG_ERR,"[httpshare]del_multi_file_record:filename/path too long\n");

				free(name);
				free(absolute_path);
				name = absolute_path =  NULL;
				return 0;
			}

			snprintf(absolute_path, ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1, "%s/%s", path, name);

// added by fenglei for security   begin   20141029
			if (zte_httpshare_check_patch_inlegal(absolute_path)) {
				slog(MISC_PRINT, SLOG_ERR,"[httpshare]del_multi_file_record:check del path is legal or not %s\n", absolute_path);
				free(name);
				free(absolute_path);
				name = absolute_path =  NULL;
				return 0;
			}
// added by fenglei for security   end   20141029
			int check_result = -1;
			if (0 == (check_result = zte_check_download_file(absolute_path))) { //ؼ¼
				(void)zte_del_file(absolute_path);
			}

			slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]del_multi_file_record:check result->%d.\n", check_result);

			if (access(absolute_path, F_OK) == 0) {
				slog(MISC_PRINT, SLOG_ERR,"[httpshare]del_multi_file_record:del file fail.\n");
				if (0 == check_result) { //ڼ¼ɾʧܣʧ
					del_res = 0;
				} else {
					del_res = 2; //ڼ¼ɾʧܣprocessing
				}
				free(name);
				free(absolute_path);
				name = absolute_path =  NULL;
				return del_res;
			} else {
				zte_httpshare_call_system("/bin/sync"); //remove file from sdcard on time
			}
			memset(absolute_path, 0, ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1);
			memset(name, 0, strlen(path1) + 1);
			i = 0;
		}
	}

	free(name);
	free(absolute_path);
	name = absolute_path =  NULL;
	return del_res;
}



/*******************

		GOFORM ҵ start

 *******************/


void zte_httpShare_auth_get(webs_t wp)
{
	int status = 0;
	status = sd_card_isExist();

	if (0 == status) {
		zte_write_result_to_web(wp, NO_SDCARD);
		return;
	}
	zte_write_auth_to_web(wp);
}

void zte_httpShare_getcard_name(webs_t wp)
{
	int status = 0;
	status = sd_card_isExist();
	if (0 == status) {
		zte_write_result_to_web(wp, NO_SDCARD);
		return;
	}
	zte_write_tcard_name_to_web(wp);

}
void zte_httpShare_getcard_value(webs_t wp)
{
	if (!sd_card_isExist()) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_getcard_value  no sdcard.\n");
		zte_write_result_to_web(wp, NO_SDCARD);
		return;
	}
	get_used_space_size();

	zte_write_space_info_to_web(wp);
}


int zte_httpShare_chage_to_mode(webs_t wp, char* mode)
{
	int set_mode = -1;
	if (!strcmp("http_share_mode", mode)) {
		set_mode = ZTE_HTTPSHARE_HTTPSHARE;
	} else {
		set_mode = ZTE_HTTPSHARE_USB;
	}
	if (set_mode == zte_httpshare_get_current_mode()) {
		zte_write_result_to_web(wp, SUCCESS);
	} else {
		if (zte_httpshare_change_current_mode(set_mode)) {
			zte_write_result_to_web(wp, SUCCESS);
		} else {
			zte_write_result_to_web(wp, FAILURE);
		}
	}
	return 1;
}



/**********************************************************************
* Function:         zte_httpShare_modeset
* Description:
* Input:            NULL
* Output:           NULL
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/12   V1.0
**********************************************************************/
void zte_httpShare_modeset(webs_t wp)
{
	char *mode = websGetVar(wp, "mode_set", T(""));

	//printf("[httpshare]httpShare_modeset:set to mode->%s\n", mode);

	if (!sd_card_isExist()) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_modeset:no sdcard.\n");
		zte_write_result_to_web(wp, NO_SDCARD);
		return;
	}
	//printf("[httpshare]httpShare_modeset:sdcard exist.\n");
	if ((0 != strcmp("http_share_mode", mode)) && (0 != strcmp("usb_mode", mode))) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	if (zte_check_downloading_file() > 0) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]downloading file,try later.\n");
		zte_write_result_to_web(wp, PROCESSING);
		return;
	}
	zte_httpShare_chage_to_mode(wp, mode);

	return;
}


/**********************************************************************
* Function:         zte_httpShare_enterFold
* Description:
* Input:            NULL
* Output:           NULL
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/12   V1.0
**********************************************************************/
void zte_httpShare_enterFold(webs_t wp)
{
	char *path_source =  NULL;
	char *path_web_tmp = websGetVar(wp, "path_SD_CARD", T(""));

	int path_source_len = 0;

	char *path_web = neutralize(path_web_tmp);
	if(path_web == NULL){
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_enterFold fail %s.\n", path_web_tmp);
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	path_source_len = strlen(path_web) + 30;

//    path_source = (char *)malloc(strlen(path_web)+5);
	path_source = (char *)malloc(path_source_len); //:SD_CARD_PATH_PR=/mnt/jffs2

	if (!path_source) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_enterFold malloc fail\n");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	int page_index = 0;
	char* index_page = websGetVar(wp, "indexPage", T(""));

	page_index = atoi(index_page);
	if(page_index < 0 || page_index >  INT_MAX-1)
	{
	    page_index = 1;  
	}

	
	char * ip = websGetRequestIpaddr(wp);
	memset(path_source, 0, path_source_len);
	snprintf(path_source, path_source_len, "%s%s", SD_CARD_PATH_PR, path_web);
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]httpShare_enterFold: path->%s, page_index->%d, ip->%s.\n", path_source, page_index, ip);

	if (!sd_card_isExist()) {
		zte_write_result_to_web(wp, NO_SDCARD);
		goto end;
	}

	if (!zte_check_file_exist(path_source)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_enterFold path inexist\n");
		zte_write_result_to_web(wp, FAILURE);
		goto end;
		//return;
	}
//added by fenglei for security begin    20141029
	if (zte_httpshare_check_patch_inlegal(path_source)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_enterFold path %s inlegal\n", path_source);
		zte_write_result_to_web(wp, FAILURE);
		goto end;
	}
	//added by fenglei for security end    20141029
	if (zte_httpshare_check_record(ip)) {
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]db have record \n");
		(void)zte_httpshare_update_record(ip, path_source);
	} else {
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]it is a new user update httpshare db \n");
		(void)zte_httpshare_insert_path_to_db(ip, path_source);
	}

	zte_httpshare_check_upload_file();

	if ('\0' == (*index_page)) { //ļС10һҳʾ
		(void)zte_write_filerecord_alphasort(wp, path_source);
	} else { //ļ϶࣬ҳʾÿҳ10
		(void)zte_write_filerecord_alphasort_page(wp, path_source, page_index);
	}

end:
	free(path_source);
	path_source = NULL;
	return;
}


/**********************************************************************
* Function:         zte_httpShare_new
* Description:
* Input:            NULL
* Output:           NULL
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/12   V1.0
**********************************************************************/

void zte_httpShare_new(webs_t wp)
{

	int new_ret = 0;
	char *path_web_tmp = websGetVar(wp, "path_SD_CARD", T(""));
	char *new_time = websGetVar(wp, ZTE_HTTPSHARE_TIME, T(""));
	char *path_source =  NULL;
	char *path_web = neutralize(path_web_tmp);
	if(path_web == NULL){
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_new fail %s.\n", path_web_tmp);
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	int path_source_len = strlen(path_web) + 30;

//	path_source = (char *)malloc(strlen(path_web)+5);
	path_source = (char *)malloc(path_source_len);

	if (!path_source) {
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]httpShare_new malloc fail\n");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	memset(path_source, 0, path_source_len);
	snprintf(path_source, path_source_len, "%s%s", SD_CARD_PATH_PR, path_web);
	if (!sd_card_isExist()) {
		zte_write_result_to_web(wp, NO_SDCARD);
		goto end;
	}
	//added by fenglei for security begin	 20141029
	if (zte_httpshare_check_patch_inlegal(path_source) ||
	    zte_httpshare_check_patch_inlegal(new_time)) {
		zte_write_result_to_web(wp, FAILURE);
		goto end;
	}
	//added by fenglei for security end    20141029
	if (zte_check_file_exist(path_source)) {
		zte_write_result_to_web(wp, EXIST);
		goto end;
	}
	new_ret = zte_create_document(path_source);

	if (!new_ret) {
		zte_write_result_to_web(wp, FAILURE);
	} else {
		zte_change_file_time(path_source, new_time);
		zte_httpshare_call_system("/bin/sync");
		zte_write_result_to_web(wp, SUCCESS);
	}

end:
	free(path_source);
	path_source = NULL;
	return;

}




/**********************************************************************
* Function:         zte_httpShare_del
* Description:
* Input:            NULL
* Output:           NULL
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/12   V1.0
**********************************************************************/

void zte_httpShare_del(webs_t wp)
{
	char *root_web_tmp = websGetVar(wp, "path_SD_CARD", T(""));
	char *del_path = websGetVar(wp, "name_SD_CARD", T(""));
	char *root_path =  NULL;

	char *root_web = neutralize(root_web_tmp);
	if(root_web == NULL){
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_del fail %s.\n", root_web_tmp);
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	int root_path_len = strlen(root_web) + 30;
	
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]httpShare_del:dele_path->%s, name->%s.\n", root_web, del_path);
		
//    root_path = (char *)malloc(strlen(root_web)+5);
	root_path = (char *)malloc(root_path_len);
	if (!root_path) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_del malloc fail.\n");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	memset(root_path, 0, root_path_len);
	snprintf(root_path, root_path_len, "%s%s", SD_CARD_PATH_PR, root_web);
	if (!sd_card_isExist()) {
		zte_write_result_to_web(wp, NO_SDCARD);
		goto end;
	}
//added by fenglei for security begin    20141029
	if (zte_httpshare_check_patch_inlegal(del_path)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_del path is inlegal %s\n", del_path);
		zte_write_result_to_web(wp, FAILURE);
		goto end;
	}
//added by fenglei for security end    20141029
	switch (zte_del_multi_file_record(root_path, del_path)) {
	case 0://ʧ
		zte_write_result_to_web(wp, FAILURE);
		break;
	case 1://ɹ
		zte_write_result_to_web(wp, SUCCESS);
		break;
	case 2://ؼ¼
		zte_write_result_to_web(wp, PROCESSING);
		break;
	default:
		break;
	}

end:
	free(root_path);
	root_path = NULL;
	return;
}


/**********************************************************************
* Function:         zte_httpShare_auth_set
* Description:
* Input:            NULL
* Output:           NULL
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/12   V1.0
**********************************************************************/

void zte_httpShare_auth_set(webs_t wp)
{
	char *rw_auth = websGetVar(wp, "HTTP_SHARE_WR_AUTH", T(""));
	char *file_name = websGetVar(wp, "HTTP_SHARE_FILE", T(""));
	char  *httpshare_status = websGetVar(wp, NV_HTTPSHARE_STATUS, T(""));
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]httpShare_auth_set:HTTP_SHARE_STATUS->%s, HTTP_SHARE_WR_AUTH->%s, HTTP_SHARE_FILE->%s\n", httpshare_status, rw_auth, file_name);

	if (!strcmp(httpshare_status, "Disabled")) {
		(void)zte_web_write(NV_HTTPSHARE_STATUS, httpshare_status);
	} else {
		(void)zte_web_write(NV_HTTPSHARE_WR_AUTH, rw_auth);
		(void)zte_web_write(NV_HTTPSHARE_FILE, file_name);
		(void)zte_web_write(NV_HTTPSHARE_STATUS, httpshare_status);
	}

	zte_write_result_to_web(wp, SUCCESS);
	return;
}


/**********************************************************************
* Function:         zte_httpShare_rename
* Description:
* Input:            NULL
* Output:           NULL
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/12   V1.0
**********************************************************************/

void zte_httpShare_rename(webs_t wp)
{

	char *old_file_name = NULL;
	char *new_file_name = NULL;
	char *old_file_web_tmp = websGetVar(wp, "OLD_NAME_SD_CARD", T(""));
	char *new_file_web_tmp = websGetVar(wp, "NEW_NAME_SD_CARD", T(""));
	
	char *old_file_web = neutralize(old_file_web_tmp);
	char *new_file_web = neutralize(new_file_web_tmp);

    int check_result = -1;
	int fd = -1;
	
	if(old_file_web == NULL || new_file_web == NULL){
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_rename fail %s  %s.\n", old_file_web_tmp, new_file_web_tmp);
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]httpShare_rename:old name->%s\n", old_file_web);
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]httpShare_rename:new name->%s\n", new_file_web);
//	old_file_name= (char *)malloc(strlen(old_file_web)+5);
	old_file_name = (char *)malloc(strlen(old_file_web) + 30);

	if (!old_file_name) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_rename malloc fail\n");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	new_file_name = (char *)malloc(strlen(new_file_web) + 30);
	if (!new_file_name) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_rename malloc fail\n");
		zte_write_result_to_web(wp, FAILURE);
		goto end2;
	}
	memset(old_file_name, 0, strlen(old_file_web) + 30);
	memset(new_file_name, 0, strlen(new_file_web) + 30);
	snprintf(old_file_name, strlen(old_file_web) + 30, "%s%s", SD_CARD_PATH_PR, old_file_web);
	snprintf(new_file_name, strlen(new_file_web) + 30, "%s%s", SD_CARD_PATH_PR, new_file_web);
//added by fenglei for security begin	 20141029
	if (zte_httpshare_check_patch_inlegal(old_file_name) ||
	    zte_httpshare_check_patch_inlegal(new_file_name)) {
		zte_write_result_to_web(wp, FAILURE);
		goto end;
	}
	if (access(old_file_name, F_OK) != 0) {
		zte_write_result_to_web(wp, NOEXIST);
		goto end;
	}

	
	if ((check_result = zte_check_download_file(old_file_name))) { //ؼ¼
		zte_write_result_to_web(wp, PROCESSING);
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_rename:path is using\n");
		goto end;
	}
//added by fenglei for security end    20141029
	fd = rename(old_file_name, new_file_name);

	if (fd < 0) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_rename:rename fail fd->%d\n", fd);
		zte_write_result_to_web(wp, FAILURE);
	} else {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_rename:rename success, fd->%d\n", fd);
		zte_httpshare_call_system("/bin/sync"); //write new file from momeroy to sdcard on time
		zte_write_result_to_web(wp, SUCCESS);
	}

end:
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]httpShare_rename:end2\n");
	free(new_file_name);
	new_file_name = NULL;

end2:
	free(old_file_name);
	old_file_name = NULL;

	return;
}


/**********************************************************************
* Function:         zte_httpShare_enterFold
* Description:
* Input:            NULL
* Output:           NULL
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/12   V1.0
**********************************************************************/

void zte_httpShare_check_file(webs_t wp)
{
	char *path_web_tmp = websGetVar(wp, "path_SD_CARD", T(""));
	char *path_source = NULL;
	char *path_web = neutralize(path_web_tmp);
	if(path_web == NULL){
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_check_file fail %s.\n", path_web_tmp);
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	int path_source_len = strlen(path_web) + 30;

	if (!sd_card_isExist()) {
		zte_write_result_to_web(wp, NO_SDCARD);
		return;
	}
	path_source = (char *)malloc(path_source_len);
	if (!path_source) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpShare_check_file malloc fail\n");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	memset(path_source, 0, path_source_len);
	snprintf(path_source, path_source_len, "%s%s", SD_CARD_PATH_PR, path_web);

	if (zte_check_file_exist(path_source)) {
		zte_write_result_to_web(wp, EXIST); //ļѴ
	} else { //ļ
		if (zte_check_downloading_file() > 0) {
			slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]downloading file,try later.\n");
			zte_write_result_to_web(wp, PROCESSING);
		} else {
			zte_write_result_to_web(wp, NOEXIST);
		}
	}

	free(path_source);
	path_source = NULL;

	return;
}


#if 0
USER_COMMON_INFOR* zte_user_list_insert()
{
	USER_COMMON_INFOR* ptr = NULL;
	USER_COMMON_INFOR* index_ptr = NULL;
	index_ptr = &pp_header;

	if (!ptr) {
		ptr = (USER_COMMON_INFOR*)malloc(sizeof(USER_COMMON_INFOR));
	}

	if (!ptr) {
		printf("[httpshare]creat user node fail.\n");

		return NULL;
	} else {
		while ((index_ptr->next) != NULL) {
			index_ptr = index_ptr->next;
		}
		index_ptr->next = ptr;
		ptr->next = NULL;
		pp_header.cnt++;
		return ptr;
	}
}



USER_COMMON_INFOR* zte_get_new_user(webs_t wp)
{

	USER_COMMON_INFOR* pp_current = NULL;
	pp_current = zte_user_list_insert();

	if (NULL != pp_current) {
		printf("[httpshare]creat new user node.\n");
		memset(pp_current, 0, sizeof(USER_COMMON_INFOR));
		return pp_current;
	} else {
		printf("[httpshare]creat new user node faile.\n");
		return NULL;
	}
}



USER_COMMON_INFOR* zte_get_user_position(webs_t wp)
{
	USER_COMMON_INFOR *pp_current = NULL;
	pp_current = pp_header.next;

	a_assert(pp_current->address);
	a_assert(websGetRequestIpaddr(wp));

	while ((pp_current != NULL) && (pp_current->address != NULL) && (websGetRequestIpaddr(wp) != NULL)) {
		if ((0 == strcmp((char *)websGetRequestIpaddr(wp), (char *)pp_current->address)) && (pp_current->requst_sid == (void*)websGetSid(wp))) {
			return pp_current;
		} else {
			pp_current = pp_current->next;
		}
	}
	return NULL;
}

USER_COMMON_INFOR* zte_process_user_auth(webs_t wp)
{

	USER_COMMON_INFOR*  ptr = NULL;
	ptr = zte_get_user_position(wp);
	if (NULL == ptr) {
		ptr = zte_get_new_user(wp);
		return ptr;
	} else {
		return ptr;
	}
}
#endif
int  zte_malloc_cgi_buff()
{
	file_buf_memory_ptr = file_buf_memory;
	return 1;
}

int  zte_path_check(webs_t wp)//ϴļURLǷϷ
{
	char path_temp[ZTE_HTTPSHARE_FILE_NAME_MAX_LEN] = {0};
	char *ptr = NULL;

	if (wp->url == NULL) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]path_check error1\n");
		return 0;
	}

	if (strlen(wp->url) == 0) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]path_check error2\n");
		return 0;
	}
	snprintf(path_temp, ZTE_HTTPSHARE_FILE_NAME_MAX_LEN, "%s", wp->url);

	ptr = strstr(path_temp, "/cgi-bin/httpshare");
	ptr += strlen("/cgi-bin/httpshare")+1;//ptrָĸ

	if (strstr(ptr, "/") != NULL) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]path_check error\n");
		return 0;
	}
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]path_check upload name:%s\n", ptr);
	return 1;
}


/**ʼϴļϢ**/
void zte_init_up_infor(USER_COMMON_INFOR*pp_co_info)
{

	memset(pp_co_info->infor.file_tail_pool, 0, ZTE_PARSE_CGI_TAIL_LEN);
	pp_co_info->infor.file_head = ZTE_CGI_PARSE_FILE_HEAD_BEGIN;
	pp_co_info->infor.file_tail = ZTE_CGI_PARSE_FILE_TAIL_BEGIN;
	pp_co_info->infor.file_tail_pool_len = 0;
	pp_co_info->infor.file_head_len = 0;
	pp_co_info->infor.file_tail_len = 0;
	pp_co_info->infor.data_no = ZTE_CGI_WRITE_THE_FIRST_DATA;
	pp_co_info->infor.file_tail_addres = ZTE_CGI_PARSE_FILE_TAIL_ADD_BEGIN;
	pp_co_info->infor.file_raw_size = 0;
}

/****ʼûϢ*****/
int  zte_init_user_infor(USER_COMMON_INFOR* pp_co_info, webs_t wp)
{
	pp_co_info->requst_sid = websGetSid(wp);
	pp_co_info->card_full = 0;
	memset(pp_co_info->address, 0, ZTE_IP_ADDRESS_LENGTH);
	memset(pp_co_info->UnixYMDTime, 0, ZTE_IP_ADDRESS_LENGTH);
	memset(pp_co_info->file_name, 0, ZTE_HTTPSHARE_FILE_NAME_MAX_LEN);
	memset(pp_co_info->path, 0, ZTE_HTTPSHARE_FILE_NAME_MAX_LEN);
	memcpy((void*)pp_co_info->address, (void*)websGetRequestIpaddr(wp), ZTE_IP_ADDRESS_LENGTH);
	(void)zte_httpshare_get_record(pp_co_info->address, pp_co_info->path);
	zte_init_up_infor(pp_co_info);
	return 1;
}

int zte_reset_cgi_state(webs_t wp)
{
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]reset_cgi_state.\n");
#if 0 // kw 3
	if (!zte_malloc_cgi_buff()) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]malloc failed.\n");
		return 0;
	}
#else
    zte_malloc_cgi_buff();
#endif
	if (!zte_path_check(wp)) {
		return 0;
	}
	zte_init_user_infor(&pp_header, wp);
	file_end = FALSE;
	memset(file_buf_memory, 0, FILE_BUFFER_LEN);
	return 1;
}

uint32 zte_get_sd_free_size(uint32 b_free)
{
	struct statvfs file_stat;
	(void)statvfs(SD_CARD_PATH, &file_stat);
	b_free = (file_stat.f_bfree) * (file_stat.f_bsize / 512) / 8;
	return b_free;
}

int zte_str_index(char* s, char* t) //text    filename=
{
	int i = 0;
	int j = 0;
	int strindex = 0;
	int stateindex = 0;
	if (NULL == s || NULL == t) {
		return -1;
	}
	int len = strlen(t);
	stateindex = strlen(s) - strlen(t);
	while ((strindex <= stateindex) && (j < len)) {
		if (s[i] == t[j]) {
			i = i + 1;
			j = j + 1;
		} else {
			i = i - j + 1;
			strindex = i;
			j = 0;
		}
	}
	if (j == len) {
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare] file name index->%d.\n", i - len);
		return (i - len); // filename=  ʼ±
	} else {
		return (-1);
	}
}


int read_upload_info_from_file(const char *file, char *name)
{

	int fd_tcard_upload;
	ssize_t read_len  = 0;

	if (NULL == name) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]name == NULL\n");
		return -1;
	}

	if (-1 == access(TCARD_UPLOAD_FILE, F_OK)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]file is not exist\n");
		return -1;
	}

	errno = 0;
	if ((fd_tcard_upload = open(TCARD_UPLOAD_FILE, O_RDONLY)) < 0) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]open file failed : %s\n", strerror(errno));
		return -1;
	}

	errno = 0;

    read_len = read(fd_tcard_upload, name, HTTPSHARE_BUF_NORMAL_LEN_MAX + 1);
	if (read_len < 0) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]read file failed : %s\n", strerror(errno));
	} else {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]read file ,upload name : %s\n", name);
	}

	close(fd_tcard_upload);

	return 0;
}

int save_upload_info_to_file(const char *file, char *name)
{
	int fd_upload = -1;

	if (name == NULL) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]save_upload_info_to_file error,name == NULL.\n");
		return 0;
	}

	if (strlen(name) == 0) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]save_upload_info_to_file error,name == empty.\n");
		return 0;
	}

	errno = 0;
	fd_upload = open(TCARD_UPLOAD_FILE, O_CREAT | O_WRONLY, 0666);
	if (-1 == fd_upload) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]save_upload_info_to_file open file failed:%s\n", strerror(errno));
		return -1;
	}

	errno = 0;
	if (write(fd_upload, name, strlen(name)) < 0) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]save_upload_info_to_file write file failed:%s\n", strerror(errno));
	}

	close(fd_upload);
	slog(MISC_PRINT, SLOG_NORMAL,"[httpshare]save_upload_info_to_file  save up info.\n");
	return 0;
}

static char* neutralize(char *path)
{
	if(path == NULL)
	{
		return NULL;
	}
	/* · */
	if (strstr(path, "../"))
	{
		return NULL;
	}
	
	/* ϵͳ· */
	if (strncmp(path, "/etc/", 5) == 0)
	{
		return NULL;
	}
	
	/* null ŷ*/
	if (strstr(path, "%00"))
	{
		return NULL;
	}

	return path;
}

void zte_httpshare_check_upload_file()
{
	char cname[ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1] = {0};
	char *name = NULL;

	if (0 == read_upload_info_from_file(TCARD_UPLOAD_FILE, cname)) {
		cname[ZTE_HTTPSHARE_PATH_NAME_MAX_LEN] = 0;
		name = neutralize(cname);
		if(name){
			name[ZTE_HTTPSHARE_PATH_NAME_MAX_LEN] = 0;
		zte_del_file(name);
		zte_del_file(TCARD_UPLOAD_FILE);
		if ((access(name, F_OK) == 0) || (access(TCARD_UPLOAD_FILE, F_OK) == 0)) {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_check_upload_file del upload file fail!\n");
		}
		memset(file_buf_memory, 0, FILE_BUFFER_LEN);
		memset(&pp_header, 0, sizeof(USER_COMMON_INFOR));
		memset(download_file, 0, sizeof(download_file));
		file_buf_memory_ptr = NULL;
		tcard_file_size = 0;
		file_end = FALSE;
		}
	}
}

int zte_get_upload_filename(webs_t wp, USER_COMMON_INFOR * pp_current)
{
	char *temp_name = NULL;
	char URL[ZTE_HTTPSHARE_PATH_NAME_MAX_LEN + 1] = {0};

	//snprintf(URL,sizeof(URL),"%s",wp->url);
	//printf("[iphone]zte_get_upload_filename URL:%s\n",URL);

	slog(MISC_PRINT, SLOG_DEBUG,"[iphone]get_upload_filename url:%s\n", wp->url);
	slog(MISC_PRINT, SLOG_DEBUG,"[iphone]get_upload_filename path:%s\n", wp->path);

	if ((wp->path == NULL) || (wp->url == NULL)) {
		return -1;
	}

	websDecodeUrl(URL, wp->url, gstrlen(wp->url));

	slog(MISC_PRINT, SLOG_DEBUG,"[iphone]get_upload_filename URL:%s\n", URL);

	if (strlen(URL) <= 0) {
		return -1;
	}

	temp_name = strstr(URL, "cgi-bin/httpshare");

	if (temp_name == NULL) {
		slog(MISC_PRINT, SLOG_ERR,"[iphone]get_upload_filename url  strstr cgi == NULL\n");
		return -1;
	}
	temp_name += strlen("cgi-bin/httpshare")+1;

	slog(MISC_PRINT, SLOG_DEBUG,"[iphone]get_upload_filename temp:%s\n", temp_name);

//	if (temp_name != NULL) {
		if (strlen(temp_name) == 0) {
			slog(MISC_PRINT, SLOG_ERR,"[iphone]get_upload_filename url name == NULL,get name from file header\n");
			return 0;
		}
		if (strstr(temp_name, "#") != NULL) {
			slog(MISC_PRINT, SLOG_ERR,"[iphone]get_upload_filename url name have #,get name from file header\n");
			return 0;
		}
//	}else {
//		slog(MISC_PRINT, SLOG_ERR,"[iphone]get_upload_filename temp == NULL\n");
//		return -1;
//	}


    memset(pp_current->file_name, 0, sizeof(pp_current->file_name));

	snprintf(pp_current->file_name, ZTE_HTTPSHARE_FILE_NAME_MAX_LEN, "%s", temp_name);
	slog(MISC_PRINT, SLOG_DEBUG,"[iphone]get_upload_filename url:%s, temp:%s, pp_header:%s\n", URL, temp_name, pp_current->file_name);

	return 1;
}

char * zte_get_cgi_filename(webs_t wp, const char* text, USER_COMMON_INFOR * pp_current)
{
	char  * head_index = NULL;
	char *sp_name = NULL;
	char *time_ptr = NULL;
	int i = 0 ;
	int j = 0;
	int k = 0;
	int name_head ;
	sp_name = "filename=";
	if (NULL == text) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]get_cgi_filename text is null.\n");
		return NULL;
	}
	if (!strlen(pp_current->UnixYMDTime)) {
		time_ptr = strstr(text, ZTE_HTTPSHARE_TIME);
		if (time_ptr) {
			time_ptr = time_ptr + strlen(ZTE_HTTPSHARE_TIME) + 5;
			while (*time_ptr != 13) {     // \r\n
				pp_current->UnixYMDTime[k++] = *time_ptr;
				time_ptr++;
			}
			pp_current->UnixYMDTime[k] = '\0';
		}
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]get_cgi_filename UnixYMDTime is %s.\n", pp_current->UnixYMDTime);
	}

	name_head = zte_str_index(text, sp_name); //find        'filename='
	//printf("[httpshare]get_cgi_filename head is %d.\n",name_head);
	if (name_head > 0) {
		for (i = name_head; * (text + i) != '\0'; i++) { //ҵfilename="test.doc"ĵһλ
			if (*(text + i) == '"') {
				name_head = i + 1;//ϴļʼ±
				break;
			}
		}

		for (i = name_head; * (text + i) != '"'; i++) {
			if (*(text + i) == '\\') {
				name_head = i + 1;
			}
		}

		for (i = name_head, j = 0; * (text + i) != '"'; i++, j++) {
			pp_current->file_name[j] = *(text + i);
		}
		pp_current->infor.file_head_len += i;

		head_index = text + i;//head_index ָfilename= "   "   
		pp_current->file_name[j] = '\0';
		if(strlen(pp_current->path) == 0){
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]get path NULL\n");
			return NULL;
		}
			
		if (pp_current->path[strlen(pp_current->path) - 1] != '/')
			strcat(pp_current->path, "/");

		if (zte_get_upload_filename(wp, pp_current) == -1) {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]get filename error\n");
			return NULL;
		}

		strcat(pp_current->path, pp_current->file_name);

		save_upload_info_to_file(TCARD_UPLOAD_FILE, pp_current->path);
	}
	return head_index;
}



char *zte_cgi_parse_file_head(char * buf, USER_COMMON_INFOR*user)
{
	char *fdindex = NULL;
	if (!buf) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]cgi_parse_file_head file head is null\n");
		return NULL;
	}

	boolean foud_head_first = FALSE;

	fdindex = buf;
#if 1
	while (*fdindex) {
		if (user->infor.file_head == ZTE_CGI_PARSE_FILE_HEAD_BEGIN) {
			if ((*fdindex) == 13) { //س
				user->infor.file_head = ZTE_CGI_PARSE_FINDE_HEAD_FIRST;
				user->infor.file_head_len++;
				fdindex++;
			} else {
				user->infor.file_head = ZTE_CGI_PARSE_FILE_HEAD_BEGIN;
				user->infor.file_head_len++;
				fdindex++;
			}
		} else if (user->infor.file_head == ZTE_CGI_PARSE_FINDE_HEAD_FIRST) {
			if ((*fdindex) == 10) { //
				user->infor.file_head = ZTE_CGI_PARSE_FINDE_HEAD_SEC;

				user->infor.file_head_len++;
				fdindex++;
			} else {
				user->infor.file_head = ZTE_CGI_PARSE_FILE_HEAD_BEGIN;
			}
		} else if (user->infor.file_head == ZTE_CGI_PARSE_FINDE_HEAD_SEC) {
			if ((*fdindex) == 13) {
				user->infor.file_head = ZTE_CGI_PARSE_FINDE_HEAD_THIRD;

				user->infor.file_head_len++;
				fdindex++;
			} else {
				user->infor.file_head = ZTE_CGI_PARSE_FILE_HEAD_BEGIN;
			}
		} else if (user->infor.file_head == ZTE_CGI_PARSE_FINDE_HEAD_THIRD) {
			if ((*fdindex) == 10) {
				user->infor.file_head = ZTE_CGI_PARSE_FINDE_FILE_HEAD;
				user->infor.file_head_len++;
				fdindex++;
				slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]cgi_parse_file_head file_head_len %d.\n", user->infor.file_head_len);
				return fdindex;//ʼ
			} else {
				user->infor.file_head = ZTE_CGI_PARSE_FILE_HEAD_BEGIN;
			}
		}
	}
#endif
	return NULL;
}



char *zte_cgi_parse_file_tail_address(char *buf, USER_COMMON_INFOR*user)
{
	char *fdindex = NULL;
	if (!buf) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]cgi_parse_file_tail_address file tail is null\n");
		return NULL;
	}

	fdindex = buf + ZTE_PARSE_CGI_TAIL_LEN - 1;
	while ((*fdindex) && (user->infor.file_tail_len < ZTE_PARSE_CGI_TAIL_LEN)) {

		if (user->infor.file_tail_addres == ZTE_CGI_PARSE_FILE_TAIL_ADD_BEGIN) {
			if ((*fdindex) == 45) { //'-'
				user->infor.file_tail_addres = ZTE_CGI_PARSE_FINDE_TAIL_ADD_FIRST;
				user->infor.file_tail_len++;
				fdindex--;
			} else {
				user->infor.file_tail_addres = ZTE_CGI_PARSE_FILE_TAIL_ADD_BEGIN;
				user->infor.file_tail_len++;
				fdindex--;
			}
		} else if (user->infor.file_tail_addres == ZTE_CGI_PARSE_FINDE_TAIL_ADD_FIRST) {
			if ((*fdindex) == 10) {
				user->infor.file_tail_addres = ZTE_CGI_PARSE_FINDE_TAIL_ADD_SEC;
				user->infor.file_tail_len++;
				fdindex--;
			} else {
				user->infor.file_tail_addres = ZTE_CGI_PARSE_FILE_TAIL_ADD_BEGIN;
			}
		} else if (user->infor.file_tail_addres == ZTE_CGI_PARSE_FINDE_TAIL_ADD_SEC) {
			if ((*fdindex) == 13) {
				user->infor.file_tail_addres = ZTE_CGI_PARSE_FINDE_FILE_TAIL_ADD;
				user->infor.file_tail_len++;
				slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]cgi_parse_file_tail_address found file tail,file_tail_len->%d.\n", user->infor.file_tail_len);
				return fdindex;//file_tail start
			} else {
				user->infor.file_tail_addres = ZTE_CGI_PARSE_FILE_TAIL_ADD_BEGIN;
			}
		}
	}
	return NULL;
}


char *zte_cgi_parse_file_tail(USER_COMMON_INFOR*pp_current, int left_file_size, char*text, int nbytes)
{
	char *fdindex = NULL;
	char *file_tail = NULL;
	int  tail_record_size = 0;

	if (!text) {
		return NULL;
	}

	if (left_file_size == 0) {
		if (nbytes >= ZTE_PARSE_CGI_TAIL_LEN) {
			fdindex = text + (nbytes - ZTE_PARSE_CGI_TAIL_LEN);

			file_tail = zte_cgi_parse_file_tail_address(fdindex, pp_current);
			slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]file info: tail len->%d.\n", pp_current->infor.file_tail_len);
			if (file_tail) {
				pp_current->infor.file_tail_len = strlen(file_tail);
				slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]cgi_parse_file_tail file tail len is %d\n", pp_current->infor.file_tail_len);
				slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]file info: tail->%s.\n", file_tail);
				pp_current->infor.file_tail = ZTE_CGI_PARSE_FINDE_TAIL_IN_FILE;
				return file_tail;
			} else {
				slog(MISC_PRINT, SLOG_ERR,"[httpshare]cgi_parse_file_tail file_tail not found\n");
				return NULL;
			}
		} else {
			fdindex = text;
			memcpy((pp_current->infor.file_tail_pool + pp_current->infor.file_tail_pool_len), fdindex, nbytes);
			pp_current->infor.file_tail_pool_len = pp_current->infor.file_tail_pool_len + nbytes;
			fdindex = pp_current->infor.file_tail_pool;
			file_tail = zte_cgi_parse_file_tail_address(fdindex, pp_current);
			if (file_tail) {
				pp_current->infor.file_tail = ZTE_CGI_PARSE_FINDE_TAIL_IN_POOL;
				return file_tail;
			} else {
				return NULL;
			}
		}
	} else {
		if ((nbytes + left_file_size) >= ZTE_PARSE_CGI_TAIL_LEN) {
			tail_record_size = ZTE_PARSE_CGI_TAIL_LEN - left_file_size;
			fdindex = text + (nbytes - tail_record_size);
			memcpy((pp_current->infor.file_tail_pool + pp_current->infor.file_tail_pool_len), fdindex, tail_record_size);
			pp_current->infor.file_tail_pool_len =	tail_record_size + pp_current->infor.file_tail_pool_len;
			pp_current->infor.file_tail = ZTE_CGI_PARSE_FINDE_TAIL_IN_FILE;
			return fdindex;
		} else {
			fdindex = text;
			memcpy((pp_current->infor.file_tail_pool + pp_current->infor.file_tail_pool_len), fdindex, nbytes);
			pp_current->infor.file_tail_pool_len =	nbytes + pp_current->infor.file_tail_pool_len;
			pp_current->infor.file_tail = ZTE_CGI_PARSE_FINDE_TAIL_PROCESS;
			return NULL;

		}

	}

}


boolean  zte_bufer_combination(char *buf, int size)
{
	if ((tcard_file_size + size) < FILE_BUFFER_LEN - WEBS_SOCKET_BUFSIZ) {
		//printf("[httpshare]bufer_combination tcard_file_size->%d,size->%d.\n",tcard_file_size,size);
		//printf("[httpshare]bufer_combination FILE_BUFFER_LEN->%d,WEBS_SOCKET_BUFSIZ->%d.\n",FILE_BUFFER_LEN,WEBS_SOCKET_BUFSIZ);
		memcpy(file_buf_memory_ptr, buf, size);
		file_buf_memory_ptr = file_buf_memory_ptr + size;
		tcard_file_size = tcard_file_size + size;
		//printf("[httpshare]bufer_combination tcard_file_size->%d,size->%d.\n",tcard_file_size,size);
		return FALSE;
	} else {
		//printf("[httpshare]bufer_combination begin to write file \n");
		memcpy(file_buf_memory_ptr, buf, size);

		file_buf_memory_ptr = file_buf_memory_ptr + size;
		tcard_file_size = tcard_file_size + size;
		return TRUE;
	}
}


int zte_httpshare_write(webs_t wp, USER_COMMON_INFOR*pp_current) // 1 OK;-1 0 error
{
	int file_close = -1;
	int file_handler = -1;
	//USER_COMMON_INFOR *pp_current = NULL;
	//if(0 == tcard_file_size)
	//{
	//    return -1;
	//}

	if (NULL == pp_current) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_write:get_user_position failed\n");
		return -1;
	}
	if (1 != zte_check_sdcard_exist()) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_write:get_user_position failed\n");
		return -1;
	}
	file_handler = open(pp_current->path, O_CREAT | O_WRONLY | O_APPEND, 0666);

	if (file_handler < 0) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_write write file open file failed\n");
		return -1;
	} else {
		(void)write(file_handler, file_buf_memory, tcard_file_size);
		file_buf_memory_ptr = file_buf_memory;
		memset(file_buf_memory, 0, FILE_BUFFER_LEN);
		tcard_file_size = 0;
		file_close = close(file_handler);
		if (file_close < 0) {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]httpshare_write write file close file failed\n");

			return -1;
		}
		file_handler = -1;
	}
	return 1;
}

int zte_write_file(webs_t wp, char*buf, int file_size, USER_COMMON_INFOR*pp_current) // 1 OK;-1 0 error
{
	int result = 0;
	result = zte_bufer_combination(buf, file_size);
	if (result == 1) {
		return zte_httpshare_write(wp, pp_current);
		//return 1;
	} else {
		if (file_end) {
			return zte_httpshare_write(wp, pp_current);
			//return 1;
		} else
			return 1;
	}
}


#if 0
int   zte_process_cgi_write(webs_t wp, char *file_head, uint32 zte_clen, char * text, int nbytes, USER_COMMON_INFOR*pp_current)
{
	char *file_tail = NULL;
	uint32 left_size = 0;
	int file_close = -1;
	if ((!text) && (!file_head)) {
		return -1;
	}
	left_size = zte_clen - nbytes;

	if (left_size < ZTE_PARSE_CGI_TAIL_LEN) {
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]process_cgi_write left_size->%d.nbytes->%d\n", left_size, nbytes);
		file_tail = zte_cgi_parse_file_tail(pp_current, left_size, text, nbytes); //ҵtail  λ
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]file_tail->%-*.*s.\n", pp_current->infor.file_tail_len, pp_current->infor.file_tail_len, file_tail);
	}

	if (file_tail) {
		if (pp_current->infor.data_no == ZTE_CGI_WRITE_THE_FIRST_DATA) {
			pp_current->infor.file_raw_size = zte_clen; /*get all the data size*/
			pp_current->infor.data_no = ZTE_CGI_WRITE_THE_SEC_DATA;
		}

		if (pp_current->infor.file_tail == ZTE_CGI_PARSE_FINDE_TAIL_IN_FILE) {
			slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]process_cgi_write CGI_PARSE_FINDE_TAIL_IN_FILE.\n");

			if (file_tail == file_head) {
				slog(MISC_PRINT, SLOG_ERR,"[httpshare]process_cgi_write it is a null file\n");
				file_close = close(open(pp_current->path, O_CREAT, 0666));
				if (file_close < 0) {
					slog(MISC_PRINT, SLOG_ERR,"[httpshare]process_cgi_write write file close file failed\n");
				}
				return -1;

			}
			if (file_tail - file_head < 0) {
				slog(MISC_PRINT, SLOG_ERR,"[httpshare]process_cgi_write file_tail-file_head = %d < 0\n", file_tail - file_head);
				return -1;
			}
			slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]file_tail-file_head->%d.\n", file_tail - file_head);
			(void)zte_write_file(wp, file_head, (file_tail - file_head));
		} else if (pp_current->infor.file_tail == ZTE_CGI_PARSE_FINDE_TAIL_IN_POOL) {
			(void)zte_write_file(wp, pp_current->infor.file_tail_pool, (file_tail - pp_current->infor.file_tail_pool));
		} else {
			slog(MISC_PRINT, SLOG_ERR,"[httpshare]process_cgi_write some erro happened\n");
		}

	} else {
		if (pp_current->infor.file_tail != ZTE_CGI_PARSE_FINDE_TAIL_PROCESS) {
			if (pp_current->infor.data_no == ZTE_CGI_WRITE_THE_FIRST_DATA) {
				pp_current->infor.file_raw_size = zte_clen; /*get all the data size*/

				(void)zte_write_file(wp, file_head, nbytes - pp_current->infor.file_head_len);

				pp_current->infor.data_no = ZTE_CGI_WRITE_THE_SEC_DATA;

				printf("[httpshare]process_cgi_write file head len-> %d\n", pp_current->infor.file_head_len);
			} else {
				(void)zte_write_file(wp, file_head, nbytes);
			}
		}
	}
	return 0;
}

#endif


// 1 OK;-1 0 error
int   zte_process_cgi_write(webs_t wp, char *file_head, uint32 zte_clen, char * text, int nbytes, USER_COMMON_INFOR*pp_current)
{
	char *file_tail = NULL;
	uint32 left_size = 0;
	int file_close = -1;
	int ret = -1;
	if ((!text) && (!file_head)) {
		return -1;
	}
	left_size = zte_clen - nbytes;

	if (left_size < ZTE_PARSE_CGI_TAIL_LEN) {
		file_tail = zte_cgi_parse_file_tail(pp_current, left_size, text, nbytes); //ҵtail  λ
	}

	if (file_tail) {
		if (pp_current->infor.data_no == ZTE_CGI_WRITE_THE_FIRST_DATA) {
			pp_current->infor.file_raw_size = zte_clen; /*get all the data size*/
			pp_current->infor.data_no = ZTE_CGI_WRITE_THE_SEC_DATA;
		}

		if (pp_current->infor.file_tail == ZTE_CGI_PARSE_FINDE_TAIL_IN_FILE) {
			printf("[httpshare]process_cgi_write CGI_PARSE_FINDE_TAIL_IN_FILE.\n");

			//if(file_tail==file_head)
			//{
			//   	printf("[httpshare]process_cgi_write it is a null file\n");
			//    file_close=close(open(pp_current->path, O_CREAT,0666 ));
			//    if(file_close<0)
			//    {
			//        printf("[httpshare]process_cgi_write write file close file failed\n");
			//		return -1;
			//	}
			//}
			if (file_tail - file_head < 0) {
				printf("[httpshare]process_cgi_write file_tail-file_head = %d < 0\n", file_tail - file_head);
				return -1;
			}

			file_end = TRUE;
			ret = zte_write_file(wp, file_head, (file_tail - file_head), pp_current);
		} else if (pp_current->infor.file_tail == ZTE_CGI_PARSE_FINDE_TAIL_IN_POOL) {
			file_end = TRUE;
			ret = zte_write_file(wp, pp_current->infor.file_tail_pool, (file_tail - pp_current->infor.file_tail_pool), pp_current);
		} else {
			printf("[httpshare]process_cgi_write some erro happened\n");
			ret = 0;
		}

	} else {
		if (pp_current->infor.file_tail != ZTE_CGI_PARSE_FINDE_TAIL_PROCESS) {
			if (pp_current->infor.data_no == ZTE_CGI_WRITE_THE_FIRST_DATA) {
				pp_current->infor.file_raw_size = zte_clen; /*get all the data size*/

				ret = zte_write_file(wp, file_head, nbytes - pp_current->infor.file_head_len, pp_current);

				pp_current->infor.data_no = ZTE_CGI_WRITE_THE_SEC_DATA;
			} else {
				ret = zte_write_file(wp, file_head, nbytes, pp_current);
			}
		}
	}
	//printf("[zyl]process_cgi_write:ret->%d\n",ret);
	return ret;
}




/*ʼļ*/
int zte_process_cgi_recv(webs_t wp, uint32 zte_clen, char *text, int nbytes)//-1,0 error; 1 OK
{
	uint32 b_free = 0;
	char *file_head = NULL;
	uint32 clen = zte_clen - 200;
	USER_COMMON_INFOR *pp_current = &pp_header;
	//pp_current = zte_process_user_auth(wp);//ȡzte_reset_cgi_stateעpp_currentϢ
	//pp_current = zte_get_user_position(wp);
//	if (NULL == pp_current || NULL == text) { // kw 3 pp_current point to pp_aheader's address, can not be NULL
	if (NULL == text) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]process_cgi_begin recv failed.\n");
		return -1;
	}
	if (pp_current->card_full) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]T card full %d \n", pp_current->card_full);
		return 0;
	}

#if 0
	b_free = zte_get_sd_free_size(b_free);
	if (b_free >= 524288) {          //2*1024*1024*1024/512/8       sd card bfree more than 2G
		printf("[httpshare]T card available size: %d  \n", b_free * 512 * 8 / 1024 / 1024); //ϴļҪС2G
	} else if ((((int)clen) > (b_free * 512 * 8)) && ((int)clen > 0)) { //ʣռС2GȽϴļС
		pp_current->card_full = 1;
		printf("[httpshare]upload file too larg.\n");//֪ͨwebUI
		return 1;
	}
#endif
	//printf("[httpshare]file info: clen->%d.\n",zte_clen);

	if (pp_current->infor.file_head != ZTE_CGI_PARSE_FINDE_FILE_HEAD) {
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]upload to fild head.\n");

		file_head = zte_cgi_parse_file_head(zte_get_cgi_filename(wp, text, pp_current), pp_current);
		//ҵʼλfile_head
		if (pp_current->infor.file_head == ZTE_CGI_PARSE_FINDE_FILE_HEAD && file_head) {
			return zte_process_cgi_write(wp, file_head, zte_clen, text, nbytes, pp_current); // 1 OK;-1 0 error
		}

		return 1;
	} else {
		file_head = text;
		return zte_process_cgi_write(wp, file_head, zte_clen, text, nbytes, pp_current);
	}
}



void zte_write_httpShare_upload_result_to_web(webs_t wp, char_t *result, char_t*reason)
{
	if ((NULL == wp) || (NULL == result)) {
		return;
	}

	web_feedback_header(wp);
	(void)websWrite(wp, T("{\"result\":\"%s\",\"reason\":\"%s\"}"),
	                result, reason);
}



int zte_check_file_complete(char *temp_file_name, USER_COMMON_INFOR*user)
{

	int file_should_size = 0;
	//int ret = 0;
	struct stat statbuf;

	if (!temp_file_name) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]check_file_complete:path NULL\n");

		return 0;
	}

	if (!strlen(temp_file_name)) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]check_file_complete:strlen(path)==0\n");

		return 0;
	}


	memset((void*)&statbuf, 0, sizeof(statbuf));

	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]path file name is = %s, len is %d\n", temp_file_name, strlen(temp_file_name));

	//ret = stat(temp_file_name, &statbuf);

	//slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]ret is %d\n", ret);
	if (stat(temp_file_name, &statbuf) < 0) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]check_file_complete stat : %s[%s]\n", strerror(errno),temp_file_name);
		return 0;
	}
	file_should_size = user->infor.file_raw_size - user->infor.file_head_len - user->infor.file_tail_len;

	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]the file size shoud is %d,  actul is %d\n",  file_should_size, statbuf.st_size);
	if (statbuf.st_size  != file_should_size) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]file transfer failed:the file size shoud is %d,  actul is %d \n", file_should_size, statbuf.st_size);
		return 0;
	} else {
		return 1;
	}

}


void zte_release_user(USER_COMMON_INFOR* current)
{
	if (!current) return;

	pp_header.cnt--;

	if (pp_header.cnt == 0) {
		file_buf_memory_ptr = NULL;
#if 0
		if (file_buf_memory) {
			free(file_buf_memory);
			file_buf_memory = file_buf_memory_ptr = NULL;
			printf("[httpshare]release memory\n");
		}
#endif
	}
	free(current);
	current = NULL;
}

void   zte_remove_user()
{
	zte_del_file(TCARD_UPLOAD_FILE);
	memset(&pp_header, 0, sizeof(pp_header));
	memset(file_buf_memory, 0, FILE_BUFFER_LEN);
	memset(download_file, 0, sizeof(download_file));
	file_buf_memory_ptr = NULL;
	tcard_file_size = 0;
	file_end = FALSE;
}

int zte_httpshare_proc_end(webs_t wp)
{
	websDone(wp, 200);
	sleep(1);
	slog(MISC_PRINT, SLOG_NORMAL,"[httpshare]process_cgi_end websDone\n");
	zte_remove_user();
	return 1;
}

void zte_pre_process_cgi_end(webs_t wp)
{
	USER_COMMON_INFOR *pp_current  = &pp_header;
#if 0   // kw 3 pp_current points to pp_haader' address, can not be null
	if (NULL == pp_current) {
		slog(MISC_PRINT, SLOG_ERR,"[httpshare]process_cgi_end pp_current NULL.\n");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
#endif
	slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]process_cgi_end path =%s\n", pp_current->path);
	if (pp_current->card_full) {
		unlink(pp_current->path);
		zte_write_httpShare_upload_result_to_web(wp, FAILURE, "space_not_enough");
		return;
	}

	if (!zte_check_file_complete(pp_current->path, pp_current)) {
		unlink(pp_current->path);
		zte_write_httpShare_upload_result_to_web(wp, FAILURE, "data_lost");
		slog(MISC_PRINT, SLOG_DEBUG,"[httpshare]process_cgi_end data_lost.\n");
		return;
	} else {
		(void)zte_httpshare_call_system("/bin/sync");  //write new file from momeroy to sdcard on time
		zte_change_file_time(pp_current->path, pp_current->UnixYMDTime);
		zte_write_result_to_web(wp, SUCCESS);
		return;
	}

}


int zte_process_cgi_end(webs_t wp)
{
	zte_pre_process_cgi_end(wp);
	zte_httpshare_proc_end(wp);
	return 1;
}


