#ifndef __FOTA_COMMON_H__
#define __FOTA_COMMON_H__

#define ZTE_FOTA_UPDATEFLAG_LEN 32
#define ZTE_FOTA_NETDOG_FLAG_LEN 256
#define ZTE_FOTA_FLAG_LEN ZTE_FOTA_NETDOG_FLAG_LEN+ZTE_FOTA_UPDATEFLAG_LEN+4

#define ZTE_FOTA_PARTITION_STR_LEN 32

typedef struct {
	char update_flag[ZTE_FOTA_UPDATEFLAG_LEN];
	int state_flag;
	char netdog_flag[ZTE_FOTA_NETDOG_FLAG_LEN];
	void* reserve;

} fotaflag_t;

typedef enum {
	STATEFLAG_NULL = 0,
	RECOVERY,
	RECOVERY_KERNEL,
	CPUM0,
	CPUZSP,
	CPUR7,
	CPUAP,
	CPFS,
	USERDATA,
	SECUREFS
} stateflag_t;

typedef struct {
	stateflag_t stateflag;
	char name[ZTE_FOTA_PARTITION_STR_LEN];
} stateflag_print_t;

typedef enum {
	SNTP_FAILED = 0,
	MEMORY_ALLOC_FAILED,
	NETWORK_NOT_AVAILABLE,
	DMSESSION_ABORTED_HIGH,
	DMSESSION_ABORTED_LOW,
	DLSESSION_ABORTED_HIGH,
	DLSESSION_ABORTED_LOW,
	IMEI_INVALID,
	CR_INNER_VERSION_INVALID,
} netdogflag_error_t;

#define NET_DOG_INIT_FLAG 0xFF
#define NET_DOG_EXCEPTION_FLAG 1

//UPDATE_STATE
#define 	IDLE 					"idle"
#define	CHECKING				"checking"
#define	CHECK_COMPLETE			"check_complete"
#define	WAIT_CONFIRM			"wait_confirm"
#define	DOWNLOADING			"downloading"
#define	DOWNLOAD_SUCCESS	"download_success"
#define	DOWNLOAD_FAILED		"download_failed"
#define	LOW_BATTERY			"low_battery"
#define	PREPARE_INSTALL		"prepare_install"
#define 	NONE					"none"

//new version state  has state below

//#define 	IDLE 					"idle"
#define	CHECK_FAILED				"check_failed"
#define	ROAMING					"roaming"
#define	BAD_NETWORK			"bad_network"
#define	NO_NEW_VERSION 			"no_new_version"
#define	HAS_OPTIONAL 			"has_optional"
#define	HAS_CRITICAL				"has_critical"
#define	PKG_TOO_BIG				"pkg_too_big"
#define	ALREADY_HAS_PKG				"already_has_pkg"



// nv 


#define NV_FOTA_PKG_TOTAL_SIZE 						"fota_pkg_total_size"
#define NV_FOTA_PKG_DL_SIZE 						"fota_dl_pkg_size"
#define NV_FOTA_DM_VENDOR 							"fota_dm_vendor"

/*polling  */
/*Աȡʹ*/
#define NV_DM_NEXTPOLLINGTIME 						"dm_nextpollingtime"
/*unit in second,  ʵʹ*/
#define NV_FOTA_POLLING_NEXT_TIME                   "polling_nexttime"

#define NV_DM_FOTA_ALLOW_ROAMING 					"fota_allowRoamingUpdate" //"dm_fota_allow_roaming" 
#define NV_DM_POLLINGCYCLE 							"fota_updateIntervalDay" //"dm_pollingcycle"
#define NV_DM_POLLINGSWITCH 						"fota_updateMode" //"dm_pollingswitch"
#define NV_FOTA_TESTMODE_SWITCH						"fota_test_mode"  //fota test mode switch


/*nvrcűʹ*/
#define NV_UPDATE_TYPE 								"update_type"



#define NV_FOTA_NEW_VERSION_STATE 					"fota_new_version_state"
#define NV_FOTA_CURR_UPGRADE_STATE 				"fota_current_upgrade_state"
#define NV_FOTA_UPGRADE_SELECTOR 				"fota_upgrade_selector"
#define NV_FOTA_NEED_USER_CONFIRM_DOWNLOAD 				"fota_need_user_confirm_download"
#define NV_FOTA_NEED_USER_CONFIRM_UPDATE 				"fota_need_user_confirm_update"

/*
1.   when poweron,  it will be init according to the delta.package file
2.  when downloaded, it will be set
3.  it does not exist in the default_parameter_user file,  it means when restart, it must be reinit
*/
#define NV_FOTA_PKG_EXIST			 			"fota_package_already_download"
#define NV_FOTA_PACKAGE_ALREADY_DOWNLOAD 		"fota_package_already_download"


/*½ҪŻ*/
#define NV_FOTA_UPGRADE_RESULT 					"fota_upgrade_result"
#define NV_FOTA_UPGRADE_RESULT_MMI				"fota_upgrade_result_mmi"


/*goadhead Ȼʹ*/
#define NV_FOTA_DM_LAST_CHECK_TIME   				"dm_last_check_time"

#define NV_FOTA_VERSION_NAME 						"fota_version_name"
#define NV_FOTA_VERSION_DELTA_ID 					"fota_version_delta_id"
#define NV_FOTA_VERSION_DELTA_URL 					"fota_version_delta_url"
#define NV_FOTA_VERSION_MD5SUM 					"fota_version_md5sum"

#define NV_FOTA_OEM									"fota_oem"
#define NV_FOTA_TOKEN 								"fota_token"
#define NV_FOTA_DEVICE_TYPE 						"fota_device_type"
#define NV_FOTA_PLATFORM 							"fota_platform"
#define NV_FOTA_MODELS 								"fota_models"

// add by new libdmgr
#define NV_FOTA_PRODUCTID							"fota_product_id"
#define NV_FOTA_PRODUCTSECRET 						"fota_product_secret"
#define NV_FOTA_APPVERSION 							"fota_app_version"
#define NV_FOTA_NETWORKTYPE 						"fota_network_type"




#define NV_FOTA_DL_URL 								"fota_dl_url"
#define NV_FOTA_CHK_URL 							"fota_chk_url"
#define NV_FOTA_REG_URL 							"fota_reg_url"
#define NV_FOTA_REPORT_DLR_URL 						"fota_report_dlr_url"
#define NV_FOTA_REPORT_UPGR_URL 					"fota_report_upgr_url"
#define NV_FOTA_REPORT_SALES_URL 					"fota_report_sales_url"

/*
	SNTP ģʽȡֵ
	manual
	auto
*/
//#define NV_SYSTIME_MODE 							"systime_mode"
#define NV_SNTP_MANUAL_MODE 						"manual"
#define NV_SNTP_AUTO_MODE 							"auto"
#define NV_SNTP_PROCESS_RESULT 						"sntp_process_result"
/*
״̬
International:::Internal:::Home*/
#define NV_SIMCARD_ROAM 							"simcard_roam"
#define NV_MODEM_MAIN_STATE 						"modem_main_state"

/*wa_inner_mod = ZTE_MF910S  MF910W MF922*/
#define NV_WA_INNER_MOD 							"wa_inner_mod"
#define NV_IMEI 										"imei"
#define NV_CR_INNER_VERSION 						"cr_inner_version"
#define NV_HARDWARE_VERSION 						"hardware_version"

#define UPGRADE_STATE_ACCEPT 						"accept"
#define UPGRADE_STATE_CANCEL 						"cancel"

#define UPGRADE_SELECTOR_NONE 						"none"
#define UPGRADE_SELECTOR_ACCEPT 					"accept"
#define UPGRADE_SELECTOR_CANCEL 					"cancel"

#define UPDATE_SUCCESS 							"success"
#define UPDATE_FAIL 								"fail"

#define SUCCESS_STRING 								"success"
/***********************************************/

/*****************NV_SIMCARD_ROAM***************/
typedef enum NetworkStatus_tag {
	NETWORK_IDLE,
	ROAMING_HOME,
	ROAMING_INTERNATIONAL,
	ROAMING_INTERNAL,
	ROAMING_NA,
	HAS_USER_DATA,
	CHANGE_APN_FAIL,
	NO_SIMCARD_INSERTED,
	NETWORK_AVAILABLE
} NetworkStatus;

#define ROAM_INTERNATIONAL "International"
#define ROAM_INTERNAL "Internal"
#define ROAM_HOME "Home"

/***********************************************/

/****************NV_MODEM_MAIN_STATE*************/
#define MODEM_MAIN_STATE_MODEM_SIM_UNDETECTED "modem_sim_undetected"
/***********************************************/

/****************NV_FOTA_STATE*******************/
#define FOTA_SEARCH_FAILED "fota_search_failed"
/***********************************************/

/***********NV_FOTA_PKG_DL_CHECK_RESUL************/
#define FOTA_PKG_DL_FAILED "fota_pkg_dl_failed"
/***********************************************/


#define 	ZTE_FOTA_MAIN_PATH							"/cache/zte_fota/"
#define  	FOTAUPI										ZTE_FOTA_MAIN_PATH"upi.log"
#define  	FOTARB										ZTE_FOTA_MAIN_PATH"lib.log"
#define  	FOTADM										ZTE_FOTA_MAIN_PATH"dm.log"
#define 	FOTA_UPDATE_STATUS_FILE 					ZTE_FOTA_MAIN_PATH"update_status"
#define 	FOTA_UPDATE_STATUS_FILE_OLD					ZTE_FOTA_MAIN_PATH"/dua/update_status"



#define 	FOTA_PACKAGE_FILE   					 	ZTE_FOTA_MAIN_PATH"delta.package"
#define     FOTA_PACKAGE_FILE_FAILED   				     ZTE_FOTA_MAIN_PATH"delta.package.failed"
#define 	CHARGER_VOLTAGE_FILE   						"/sys/class/power_supply/battery/voltage_now"
#define     FOTA_DM_UPGRADE_TEMP 						ZTE_FOTA_MAIN_PATH"upgrade_temp"
#define 	FOTA_DM_META_FILE                             ZTE_FOTA_MAIN_PATH"meta_data"


#define 	DL_TMP_FILENAME            						ZTE_FOTA_MAIN_PATH"process_delta.package" //ϵعʱļ

#define 	DELTA_VERIFY_FAILED 						ZTE_FOTA_MAIN_PATH"delta.package.verifyFailed"
#define 	DELTA_RECO_FAILED 							ZTE_FOTA_MAIN_PATH"delta.package.recoFailed"
#define 	DELTA_SYS_FAILED    							ZTE_FOTA_MAIN_PATH"delta.package.systemFailed"

#define  	FOTA_DLSVR_DOMAIN							"mg.adups.cn"


#endif
