/**
* @file Mainctl_msg.h
* @brief ṩءϢӿ
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author Linxu Gebin
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*
************************************************************************
*/

#ifndef __MAINCTRL_MSG_H__
#define __MAINCTRL_MSG_H__

#include "message.h"

/**
* @brief Ϣ
* @param MSG_CMD_RESET_REQUEST ָ
* @param MSG_CMD_POWEROFF_REQUEST ػ
* @param MSG_CMD_RESTART_REQUEST 
* @param MSG_CMD_NET_IPPORT_FILTER ǽ-˿ڹϢ
* @param MSG_CMD_NET_IPPORT_FORWARD ǽ-˿תϢ
* @param MSG_CMD_NET_DMZ ǽ-DMZϢ
* @param MSG_CMD_NET_IPPORT_MAPPING ǽ-˿ӳϢ
* @param MSG_CMD_NET_UPNP ǽ-UPNPϢ
* @param MSG_CMD_NET_URL_FILTER ǽ-URLϢ
* @param MSG_CMD_NET_MTU MTUϢ
* @param MSG_CMD_NET_STATIC_DHCP DHCPַеľ̬IPϢ
* @param MSG_CMD_NET_PLUGIN Ȳ豸Ϣ
* @param MSG_CMD_NET_PLUGOUT Ȳ豸γϢ
* @param MSG_CMD_NET_CONNECT rj45wifi豸Ϣ
* @param MSG_CMD_NET_DISCON rj45wifi豸ϿϢ
* @param MSG_CMD_NET_PDP_ACT pdpϢ
* @param MSG_CMD_NET_PDP_DEACT pdpȥϢ
* @param MSG_CMD_NET_TC_CTRL Ϣ
* @param MSG_CMD_NET_GET_HOSTNAME ޸Ľ豸hostnameϢ
* @param MSG_CMD_NET_BIND_STATIC_ADDRESS ַ̬Ϣ
* @param MSG_CMD_NET_BIND_STATIC_ADDRESS_ADD Ӿַ̬Ϣ
* @param MSG_CMD_NET_BIND_STATIC_ADDRESS_DEL ɾַ̬Ϣ
* @param MSG_CMD_NET_PING_DIAGNOSTICS pingϲϢ
* @param MSG_CMD_NET_DHCP_SETTING_REQ DHCPϢ
*/
#ifndef DOXYGEN_SHOULD_SKIP_THIS
/*Ϣ*/
typedef enum {
	/*ؿ*/
	MSG_CMD_MAINCTRL_BEG = MSG_CMD_MAINCTRL_BASE,

	/* յ֪ͨҪģӦյģظresult
	  * յresultִĲ(NVػreset)
	  */
	MSG_CMD_RESET_REQUEST,               /*ָ 211D, : */
	MSG_CMD_POWEROFF_REQUEST,            /*ػ211E, : */
	MSG_CMD_RESTART_REQUEST,             /*211F, : */
	MSG_CMD_RESET_NOTIFY,                /*ָ֪ͨ2120, :, ģظMSG_CMD_RESET_RSP */
	MSG_CMD_POWEROFF_NOTIFY,             /*֪ͨػ2121, :, ģظMSG_CMD_POWEROFF_RSP */
	MSG_CMD_RESTART_NOTIFY,              /*֪ͨ2122, :, ģظMSG_CMD_RESTART_RSP */
	MSG_CMD_RESET_RSP,                   /*ָûظϢ, : */
	MSG_CMD_POWEROFF_RSP,                /*ػýظϢ, : */
	MSG_CMD_RESTART_RSP,                 /*ýظϢ, : */

	//
	MSG_CMD_NET_IPPORT_FILTER,           /*ǽ-˿ڹ, :, ҪǰNV, NV */
	MSG_CMD_NET_IPPORT_FORWARD,          /*ǽ-˿ת, :, ҪǰNV, NV */
	MSG_CMD_NET_DMZ,                     /*ǽ-DMZ,      :, ҪǰNV, NV */
	MSG_CMD_NET_IPPORT_MAPPING,          /*ǽ-˿ӳ, :, ҪǰNV, NV */
	MSG_CMD_NET_UPNP,                    /*upnp, :, ҪǰNV, NV */
	MSG_CMD_NET_URL_FILTER,              /*ǽ-URL, :, ҪǰNV, NV, ֧HTTPS */
	MSG_CMD_NET_MTU,                     /*MTU, ҪǰNV mtuֵ */
	MSG_CMD_NET_STATIC_DHCP,             /*DHCPַеľ̬IP, :, ҪǰNV, NV */
	MSG_CMD_NET_PLUGIN,                  /*Ȳ豸룬netdev_plugin_proc_byname/netdev_plugin_procʹ */
	MSG_CMD_NET_PLUGOUT,                 /*Ȳ豸γnetdev_plugout_proc_byname/netdev_plugout_procʹ */
	MSG_CMD_NET_CONNECT,                 /*rj45wifi豸磬netdev_connect_internetʹ */
	MSG_CMD_NET_DISCON,                  /*rj45wifi豸Ͽ磬netdev_disconnect_internetʹ */
	MSG_CMD_NET_PDP_ACT,                 /*pdp,pdp_act_procʹ */
	MSG_CMD_NET_PDP_DEACT,               /*pdpȥ,pdp_deact_procʹ */
	MSG_CMD_NET_TC_CTRL,                 /*,tc_controlʹ */
	MSG_CMD_NET_GET_HOSTNAME,            /*޸Ľ豸hostname, :struct mac_hostname_info */
	MSG_CMD_NET_BIND_STATIC_ADDRESS,     /*ַ̬, : ҪǰNV, NV */
	MSG_CMD_NET_BIND_STATIC_ADDRESS_ADD, /*Ӿַ̬, : struct static_macip_info */
	MSG_CMD_NET_BIND_STATIC_ADDRESS_DEL, /*ɾַ̬, : macַ */
	MSG_CMD_NET_PING_DIAGNOSTICS,		 /*pingϲ, :, ҪǰNV, NV */

	MSG_CMD_NET_DHCP_SETTING_REQ,        /*DHCP*/
	MSG_CMD_NET_DHCP_SETTING_RSP,        /*DHCPûظ*/

#if (MODEM_TYPE == vehicle_dc)
	MSG_CMD_NET_FIREWALL_ADD_REQ,		 /*÷ǽָIP豸*/
	MSG_CMD_NET_FIREWALL_DEL_REQ,		 /*ɾǽָIP豸*/
	MSG_CMD_NET_FIREWALL_CLEANUP_REQ,	 /*ѷǽָIP豸*/
#endif

	/* --------------------- ڲʹϢ ---------------- */
	MSG_CMD_NET_WAN4_CHANGE,             /*ipv4ڷ仯, : */
	MSG_CMD_NET_WAN6_CHANGE,             /*ipv6ڷ仯, : */
	MSG_CMD_NET_TIMER_DEL,               /*ɾʱ, :ethwanwifiwan */
	MSG_CMD_NET_TIMER_OUT,               /*ʱʱ, :豸dev_ID */
	MSG_CMD_NET_SET_RJ45_LAN,            /*rj45Ϊ, : */
	MSG_CMD_NET_ADD_CHILDREN_DEVICE,     /*ҳģʽ, 豸ͯ豸, : struct mac_hostname_info*/
	MSG_CMD_NET_DEL_CHILDREN_DEVICE,     /*ҳģʽ, ɾͯ豸, : macַ */
	MSG_CMD_NET_ADD_WHITE_SITE,          /*ҳģʽ, վ, : struct white_site_info */
	MSG_CMD_NET_REMOVE_WHITE_SITE,       /*ҳģʽ, ɾеַ, : վ */
	MSG_CMD_NET_START_NONET,             /*ҳģʽ, ֹʱ俪ʼ, :, ҪǰNV, NV */
	MSG_CMD_NET_STOP_NONET,              /*ҳģʽУֹʱ, :, ҪǰNV, NV */
	MSG_CMD_NET_WAN_DIAL_FAIL,           /*֪ͨʱ, : */
	MSG_CMD_SECURITY_LOG_SAVE,                /*ȫ־洢, :־ַs */
} emMSG_CMD_MainCtrl;
#endif

/** * @brief dhcpϢ
 * @param lan_ip        ip
 * @param lan_netmask   
 * @param dhcp_enabled  dhcp ʹܱ־
 * @param dchp_start    dhcp ַʼַ
 * @param dchp_end      dhcp ַؽַ
 * @param dchp_dns      dnsַ
 * @param dchp_lease    dhcpԼļ
 */
typedef struct {
	char lan_ip[SOFTAP_IP_MAX_LEN];
	char lan_netmask[SOFTAP_IP_MAX_LEN];
	int  dhcp_enabled;
	char dhcp_start[SOFTAP_IP_MAX_LEN];
	char dhcp_end[SOFTAP_IP_MAX_LEN];
	char dhcp_dns[SOFTAP_IP_MAX_LEN];
	char dhcp_lease[SOFTAP_STR_LEN_16];
} dhcp_setting_req;

/** * @brief restart request message info
 * @param action        restart or reset
 * @param subactuon   finally realized by MCU or mainCtrl
 */
typedef struct {
	int action;
	int subaction;
} restart_info;

typedef enum {
	Restart_Action_RESTART = 0,
	Restart_Action_RESET,
} emACTION_RESTART_MainCtrl;

typedef enum {
	Operate_By_MCU = 0,
	Operate_By_SOC,
} emSUBACTION_RESTART_MainCtrl;


#endif
