/**
* @file upi_fotaflag_partition.h
* @brief 汾Ϣ
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author
*
*/

#ifndef _UPI_FOTAFLAG_PARTITION_H
#define _UPI_FOTAFLAG_PARTITION_H

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "pub_flags.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/

// fotaflagzftl5ռõֽ
#define FOTA_FLAG_SIZE						(32)



// fotaflag ú궨
#define ZTE_DUA_FOTAFLAG_PART				("/device/name")
#define ZTE_DUA_FOTAFLAG					("fotaflag")
#define ZTE_DUA_PART_UPDATED_DEV			("/dev")
#define ZTE_DUA_FOTAFLAG_BLOCK_PART		("/sys/class/block")


/*  */
typedef enum
{
    SYSTEM_FLAG_FOTA_MAIN = 0,
    SYSTEM_FLAG_FOTA_BACKUP,
} E_SYSTEM_FLAG_DATA_TYPE;



/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/

#if 0
/* flagsƫƵַ */

#define FLAGS_MAGIC						(0x464C4147UL)



#define  DUALSYSTEM_STATUS_BOOTABLE				(0xB0AB)	/*  */
#define  DUALSYSTEM_STATUS_SUCCESSFUL			(0x5CCF)	/* ܳɹ */
#define  DUALSYSTEM_STATUS_UNBOOTABLE			(0xBABE)	/*  */

typedef struct
{
    int status;     /* bootable/successful/unbootable */
    int try_cnt;
} T_DualSystem_Status;

typedef enum
{
    DUAL_SYSTEM  = 0x875A,   /* һϵͳ */
    DUAL_SYSTEM2 = 0x986B,   /* ڶϵͳ */
} T_BOOT_TARGET;

/* ˫ϵͳ */
typedef enum
{
    DUALSYSTEM_RECOVERY = 0x7575,          /* normal-recovery˫ϵͳ */
    DUALSYSTEM_AA       = 0xAAAA,          /* AA˫ϵͳ */
    DUALSYSTEM_AB       = 0xABAB           /* AB˫ϵͳ */
} T_BOOT_DUALSYSTEM_TYPE;

typedef struct
{
    unsigned int			magic;          /* Чħ */
    T_BOOT_TARGET			boot_to;        /* ǰϵͳ־*/
    unsigned int			fota_status;    /* fota״̬ */
    T_DualSystem_Status		system;         /* һϵͳ״̬ */
    T_DualSystem_Status		system2;        /* ڶϵͳ״̬ */
} T_BOOT_FOTA_FLAG;

typedef struct
{
    unsigned int					magic;           /* Чħ */
    T_BOOT_DUALSYSTEM_TYPE			dualsys_type;   /* ˫ϵͳ */
    char system_boot_env[128];
    char system2_boot_env[128];
} T_BOOT_ENV;


typedef struct
{
    T_BOOT_FOTA_FLAG 	boot_flag;
    T_BOOT_ENV 			boot_env;
} T_FOTA_FLAG_INFO;
#endif


/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/

void upi_reboot();
int check_fota_flag_partition(void);



int upi_get_boot_env(T_BOOT_ENV* boot_env);
int upi_set_boot_fota_flag(T_BOOT_FOTA_FLAG* fota_flag);
int upi_get_system_boot_to();
int upi_set_system_boot_to(int boot_to, int boot_to_status);
int upi_set_system_status(int system, int status);

int upi_get_boot_flag(T_BOOT_FOTA_FLAG *boot_flag);

int upi_get_system_info(T_FLAGS_INFO *p_system_info);

// fota־Ҫ־ǷҪͬNV
int upi_get_system_fota_status();
int upi_set_system_fota_stauts(int status);




/*******************************************************************************
 *                      Inline function implementations                        *
 ******************************************************************************/




#endif // _UPI_FOTAFLAG_PARTITION_H

