/**
* @file upi_public.h
* @brief ӿڼϢ
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author
*
*/

#ifndef _UPI_PUBLIC_H
#define _UPI_PUBLIC_H

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>



/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
//ڴ⿪
//#define FOTA_MEM_DEBUG


#ifndef FOTA_MEM_DEBUG
#define upi_free(ptr)      if(NULL != ptr) {free(ptr); ptr = NULL;}
#define upi_malloc(size)   malloc(size)
#define upi_strdup(str)    strdup(str)
#define upi_realloc(ptr, size) realloc(ptr, size)
#else
void* realloc_debug(void *ptr, size_t size, const char*func, long line);

void* malloc_debug(size_t bytes, const char* func, long line);
void* free_debug(void*p, const char* func, long line);
char* strdup_debug(const char* str, const char* func, long line);

#define upi_free(ptr) if(NULL != ptr){free_debug(ptr, __FUNCTION__, __LINE__); ptr=NULL;}
#define upi_malloc(size) malloc_debug(size, __FUNCTION__, __LINE__)
#define upi_strdup(str) strdup_debug(str, __FUNCTION__, __LINE__)
#define upi_realloc(ptr, size) realloc_debug(ptr, size, __FUNCTION__, __LINE__)


#endif

#define MAX_PATH_LEN							(256)
#define SHA512_LEN								(64)
#define HASH_MAX_LEN							(64)

#define PARTITION_NAME_LEN						(32)
#define EXTRA_NAME_LEN							(32)



#define FOTA_AB_UPGRADE_STATUS           "fota_ab_upgrade_status"

#define FOTA_AB_UPGRADE_TOTAL_SIZE       "fota_ab_upgrade_total_size"

#define FOTA_AB_UPGRADE_UPDATED_SZIE     "fota_ab_upgrade_updated_size"

#define FOTA_AB_AA_SYNC_STATUS			 "fota_ab_aa_sync_status"


#define PARTITION_NAME_FOTA_FLAG         "flags"
#define PARTITION_NAME_ROOTFS_1          "rootfs"
#define PARTITION_NAME_ROOTFS_2          "rootfs2"
#define SYSTEM_INDEX_1                   (1)
#define SYSTEM_INDEX_2                   (2)
#define SYSTEM_INDEX_UNKNOWN             (-1)



#define FILE_PATH_PROC_MTD              "/proc/mtd"
#define FILE_PATH_PROC_CMDLINE          "/proc/cmdline"


#define SYSTEM_UPGRADE_PARTITION_INFO_HEAD_MAGIC		("SUPI")
#define SYSTEM_UPGRADE_PARTITION_INFO_HEAD_MAGIC_LEN	(4)

#define SYSTEM_PARTITION_FILE ("/etc_ro/systemPartitionInfo.conf")

#define PLATFORM_PARTITION_NUM_MAX (7)
#define OEM_PARTITION_NUM_MAX (7)

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/

typedef enum
{
    HASH_TYPE_SHA_512 = 0,
    HASH_TYPE_SHA_256
} Hash_type_s;


/**
* @brief							ϵͳϢͷ
* @param	magic					ħ
* @param	plat					ƽ̨: 0 - V3T, 1 - 8501
* @param	plat_partition_num		ƽ̨
* @param	oem_partition_num		oem
*/
typedef struct
{
    char				magic[SYSTEM_UPGRADE_PARTITION_INFO_HEAD_MAGIC_LEN];
    int					plat;
    int					plat_partition_num;
    int					oem_partition_num;
} system_partition_info_head_t;


/**
* @brief						ƽ̨ϵͳϢ
* @param	name				
* @param	system_type			ϵͳ - 0 ƽ̨, 1 oem
* @param	partition_type		
*/
typedef struct
{
    char				name[PARTITION_NAME_LEN];
    int					system_type;
    int					partition_type;
} platform_partition_info_t;


/**
* @brief						oemϢ
* @param	name				
* @param	system_type			ϵͳ - 0 ƽ̨, 1 oem
* @param	partition_type		
*/
typedef struct
{
    char				name[PARTITION_NAME_LEN];
    int					system_type;
    int					partition_type;
} oem_partition_info_t;


/**
* @brief									ϵͳϢ
* @param	platform_partition_info			ƽ̨Ϣ
* @param	oem_partition_info				oemϢ
*/
typedef struct
{
    system_partition_info_head_t system_partition_info_head;
    platform_partition_info_t *platform_partition_info;
    oem_partition_info_t *oem_partition_info;
} system_upgrade_partition_info_t;


/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/
extern char FOTA_PACKAGE_FILE[128];


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
int upi_delete_folder(const char* folderpath);
int upi_create_folder(const char* folderpath);
int upi_check_file_existence(const char* filepath);
char * get_log_root_path();
char * get_temp_path();

int hash_copy(char *dst, char *src, int type);
int hash_compare(char *str1, char *str2, int type);
void show_hash_hex(int type, const char* title, char *hash);


void upi_set_upgrade_status(int status);
void upi_set_upgrade_total_size(int total_size);
void upi_set_upgrade_updated_size(int updated_size);
void upi_set_sync_status(int sync_status);

int upi_get_upgrade_status();
int upi_get_upgrade_total_size();
int upi_get_upgrade_updated_size();
int upi_get_sync_status();

int upi_get_current_system();
int upi_get_target_upgrade_system();
int upi_get_target_sync_system(int *target_system_index, int *target_system);

ssize_t upi_readn(int fd, void *vptr, size_t n);

int upi_init_system_partition_info(system_upgrade_partition_info_t *system_partition_info);
void upi_deinit_system_partition_info(system_upgrade_partition_info_t *system_partition_info);


/*******************************************************************************
 *                      Inline function implementations                        *
 ******************************************************************************/




#endif // _UPI_PUBLIC_H

