/**
* @file upi_delta.h
* @brief ļͷļ
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author
*
*/

#ifndef _UPI_UPGRADE_PACKAGE_H
#define _UPI_UPGRADE_PACKAGE_H

/*******************************************************************************
 *						   Include header files							  *
 ******************************************************************************/

#include "upi_public.h"

/*******************************************************************************
 *							 Macro definitions							   *
 ******************************************************************************/

#define UPGRADE_PACKAGE_HEAD_MAGIC				("FOTA")
#define UPGRADE_PACKAGE_HEAD_MAGIC_LEN			(4)

#define VERSION_LEN								(64)


/*******************************************************************************
 *							 Type definitions								*
 ******************************************************************************/

/**
* @brief		ļļͷϢУļȣȡǰļзextraȣ
* @param	magic_word:						ļͷħ
* @param	plat:							ƽ̨
* @param	upgrade_package_type:			ļ ALȫ汾 DE
* @param	upgrade_type					
* @param	upgrade_package_version:		ļ汾
* @param	partition_num:					
* @param	extra_num:						hash㷨ͣ0Ĭ SHA512
* @param	block_size:						С128
* @param	extra_num:						extraļ
* @param	version_src:					ļԴ汾Ӧڲ汾
* @param	version_dst:					ļĿ汾ţӦڲ汾
* @param	hash:							hash㷨ֵ
**/



typedef struct
{
    char							magic_word[UPGRADE_PACKAGE_HEAD_MAGIC_LEN];
    int								upgrade_package_version;
    int								plat;
    int								upgrade_package_type;
    int								upgrade_type;
    int								partition_num;
    int								extra_num;
    int								hash_type;
    int								block_size;
    char							version_src[VERSION_LEN];
    char							version_dst[VERSION_LEN];
    unsigned char					hash[HASH_MAX_LEN];
    char							reserve[28];
} upgrade_package_head_info_t;

/**
* @brief		ļͷϢĲַļϢ
* @param	name:				ַ
* @param	len:				ַļ
* @param	offset:				ַļdeltaļ0ַƫ
* @param	partition_type:		
* @param	zipped:				Ƿ񾭹ѹ
* @param	reserve:			
* @param	hash:				ַԴļmd5
*/
typedef struct
{
    char				name[PARTITION_NAME_LEN];
    int					len;
    int					offset;
    int					partition_type;
    int					zipped;
    char				reserve[16];
    unsigned char		hash[HASH_MAX_LEN];
} partition_head_info_t;


/**
* @brief		extraϢ
* @param	name:		extraļ
* @param	len:		ļ
* @param	offset:		ļƫ
* @param	hash:		ļhashֵ
* @param	reserve:	ԤϢ
*/
typedef struct
{
    char				name[EXTRA_NAME_LEN];
    int					len;
    int					offset;
    char				reserve_1[8];
    unsigned char		hash[HASH_MAX_LEN];
    char				reserve_2[8];
} extra_head_info_t;


/**
* @brief		ļϢ
* @param	head:						ļͷϢ
* @param	partition_num:				ļз
* @param	partition_info:				Ϣָͷ
* @param	extra_num:					extraļ
* @param	extra_info:					extraļϢָ
* @param	upgrade_package_file_desc:	ļ
* @param	upgrade_package_file_size:	ļ
*/
typedef struct
{
    upgrade_package_head_info_t			*head;
    //	int									partition_num;
    partition_head_info_t				*partition_info;
    //	int									extra_num;
    extra_head_info_t					*extra_info;
    int									upgrade_package_file_desc;
    unsigned int						upgrade_package_file_size;
} upgrade_package_info_t;






/*******************************************************************************
 *					   Global variable declarations						  *
 ******************************************************************************/


/*******************************************************************************
 *					   Global function declarations						  *
 ******************************************************************************/


int init_upgrade_package_info(const char * upagrade_package_file_path);
void deinit_upgrade_package_info();

upgrade_package_info_t  *get_upgrade_package_info();

partition_head_info_t *get_partition_head_info();
int get_partition_num();

extra_head_info_t *get_extra_head_info();
int get_extra_num();

int get_upgrade_package_file_fd();

partition_head_info_t *get_partition_head_info_by_name(const char *partition_name);
int get_total_partition_length();

int get_upgrade_type();

/*******************************************************************************
 *					  Inline function implementations						*
 ******************************************************************************/




#endif // _UPI_UPGRADE_PACKAGE_H

