
/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       v0.5.
 * Author:        zhanglixia
 * Date:          2016-02-03
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ******************************************************************************/ 
#ifndef _DRV_CODEC_ALC5672_DSP_H
#define _DRV_CODEC_ALC5672_DSP_H

#define DSP_CLK_RATE 			RT5672_DSP_CLK_96K
#define RT5672_DSP_CTRL1		0xe0
#define RT5672_DSP_CTRL2		0xe1
#define RT5672_DSP_CTRL3		0xe2
#define RT5672_DSP_CTRL4		0xe3
#define RT5672_DSP_CTRL5		0xe4
/* DSP Control 1 (0xe0) */
#define RT5672_DSP_CMD_MASK		(0xff << 8)
#define RT5672_DSP_CMD_PE		(0x0d << 8)	/* Patch Entry */
#define RT5672_DSP_CMD_MW		(0x3b << 8)	/* Memory Write */
#define RT5672_DSP_CMD_MR		(0x37 << 8)	/* Memory Read */
#define RT5672_DSP_CMD_RR		(0x60 << 8)	/* Register Read */
#define RT5672_DSP_CMD_RW		(0x68 << 8)	/* Register Write */
#define RT5672_DSP_REG_DATHI	(0x26 << 8)	/* High Data Addr */
#define RT5672_DSP_REG_DATLO	(0x25 << 8)	/* Low Data Addr */
#define RT5672_DSP_CLK_MASK		(0x3 << 6)
#define RT5672_DSP_CLK_SFT		6
#define RT5672_DSP_CLK_768K		(0x0 << 6)
#define RT5672_DSP_CLK_384K		(0x1 << 6)
#define RT5672_DSP_CLK_192K		(0x2 << 6)
#define RT5672_DSP_CLK_96K		(0x3 << 6)
#define RT5672_DSP_BUSY_MASK	(0x1 << 5)
#define RT5672_DSP_RW_MASK		(0x1 << 4)
#define RT5672_DSP_DL_0			(0x0 << 2)
#define RT5672_DSP_DL_1			(0x1 << 2)
#define RT5672_DSP_DL_2			(0x2 << 2)
#define RT5672_DSP_DL_3			(0x3 << 2)
#define RT5672_DSP_I2C_AL_16	(0x1 << 1)
#define RT5672_DSP_CMD_EN		(0x1)
/* Debug String Length */
#define RT5672_DSP_REG_DISP_LEN 25

typedef struct rt5672_priv {
	UINT32 aif_pu;
	UINT32 sysclk;
	UINT32 sysclk_src;
	UINT32 lrck[AUDIO_I2S_MAX];
	UINT32 bclk[AUDIO_I2S_MAX];
	UINT32 master[AUDIO_I2S_MAX];
	UINT32 v_id;
	UINT32 pll_src;
	UINT32 pll_in;
	UINT32 pll_out;
	UINT8 dsp_mode; // dsp algorithm mode
	BOOL dsp_inited;
	BOOL dsp_bypass;
	T_ZDrvCodec_OutDevice device;
	UINT8 sample;
	T_ZDrvCodec_SourceType codecSrcType;	
}T_ZDrvCodec_Rt5672_Priv;

typedef enum {
	RT5672_DSP_DIS,
	RT5672_DSP_NS,
	RT5672_DSP_AEC,
	RT5672_DSP_VT,
	RT5672_DSP_VR,
	RT5672_DSP_FFP_NS,
	RT5672_DSP_48K_STO_FFP,
	RT5672_DSP_2MIC_HANDSET,
	RT5672_DSP_2MIC_HANDSFREE,
	RT5672_DSP_AEC_HANDSFREE
} T_ZDrvCodec_DSP_PARAMMODE;

SINT32 rt5672_dsp_switch(BOOL onoff );
SINT32 rt5672_dsp_setpara(T_ZDrvCodec_Rt5672_Priv *codecDspPara);

#endif /* __RT5672_DSP_H__ */
