/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   ƵŲģ
* ļƣzte_video.c
* ļʶ 
* ժҪ 
*   
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/3/25    1.0                                              
************************************************************************/
  
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "oss_api.h"
#include "zte_display.h"
#include "zMsp_Com.h"
#include "drv_api.h"    
#include "zte_video.h"
#include "zte_osd.h"
#include "ZMF_API.h"   

/**************************************************************************
 *                                                                    *
 **************************************************************************/
/* ƵģڲʹϢ */
enum
{
    EV_VIDEO_START_PLAY_SYN = 1,   /* ʼ               */
    EV_VIDEO_STOP_PLAY_SYN,        /* ֹͣ               */
    EV_VIDEO_PAUSE_PLAY_SYN,       /* ͣ               */
    EV_VIDEO_RESUME_PLAY_SYN,      /* ָ               */
    EV_VIDEO_SEEK_PLAY_SYN,        /* ضλ             */
    EV_VIDEO_ROTATE_PLAY_SYN,      /* Ƶ           */
    EV_VIDEO_CLOSE_PLAY_SYN,       /* رղ               */

    EV_AUDIO_FIRST_OUT,            /* Ƶ߳״   */
    EV_AUDIO_NORMAL_OUT,           /* Ƶ߳   */
    EV_VIDEO_FIRST_OUT,            /* Ƶ߳״   */ 
    EV_VIDEO_NORMAL_OUT,           /* Ƶ߳   */
    EV_AUDIO_DATA_DECODE,          /* ߳Ƶݽ   */
    EV_VIDEO_DATA_FILL,            /* ߳Ƶ   */    
    EV_VIDEO_DATA_DECODE,          /* ߳Ƶݽ   */
    EV_VIDEO_DATA_SUPPLY,          /* ߳Ƶݲ   */
    EV_AUDIO_OUT_OVER,             /* Ƶ       */
    EV_VIDEO_OUT_OVER,             /* Ƶ       */

    EV_AUDIO_OUT_PAUSE,            /* Ƶ߳ͣ   */
    EV_AUDIO_OUT_RESUME,           /* Ƶָ̻߳   */
    EV_AUDIO_OUT_SEEK,             /* Ƶ߳ضλ     */
    EV_AUDIO_OUT_STOP,             /* Ƶֹ߳ͣ   */ 
    EV_AUDIO_OUT_CLOSE,            /* Ƶ̹߳ر   */        

    EV_VIDEO_OUT_PAUSE,            /* Ƶ߳ͣ   */ 
    EV_VIDEO_OUT_SEEK,             /* Ƶ߳ضλ     */    
    EV_VIDEO_OUT_STOP,             /* Ƶֹ߳ͣ   */
    EV_VIDEO_OUT_CLOSE,            /* Ƶ̹߳ر   */ 

    EV_OP_EXP,                     /* Ƶģ쳣           */
};

/* ƵģڲʹõĴ */
enum
{
    VIDEO_OP_SUCCESS     = 0,       /* Ƶ           */
    VIDEO_OP_ERROR       = -1,      /* ƵһԴ     */
    VIDEO_OP_DATAEND     = -2,      /* Ƶݶȡ   */
    VIDEO_OP_FILE_ERR    = -3,      /* Ƶݶȡ   */
    VIDEO_OP_BUFFER_ERR  = -4,      /* ײBuffer     */
    VIDEO_OP_DEVICE_ERR  = -5,      /* ײ豸쳣       */
    VIDEO_OP_DECODE_ERR  = -6,      /* Ƶ           */
    VIDEO_OP_POSTPPU_ERR = -7,      /* Ƶ         */    
};

/* Videoģ쳣־ */
enum
{
    VIDEO_NO_EXP                = 0,       /* 쳣           */
    VIDEO_OP_EXP                = 1 << 0,  /* 쳣         */        
    VIDEO_PCM_EXP               = 1 << 1,  /* ײPCM豸쳣  */ 
    VIDEO_BUF_EXP               = 1 << 2,  /* ײӲBuf쳣  */  
    VIDEO_FILE_EXP              = 1 << 3,  /* ļ쳣       */
    VIDEO_AUDIO_OVER_EXP        = 1 << 4,  /* ļƵݲ */
    VIDEO_VIDEO_OVER_EXP        = 1 << 5,  /* ļƵݲ */
    VIDEO_FILE_AUDIO_OVER_EXP   = 1 << 6,  /* ļƵ   */
    VIDEO_FILE_VIDEO_OVER_EXP   = 1 << 7,  /* ļƵ   */
};

/**************************************************************************
 *                                                                      *
 **************************************************************************/
#define VIDEO_CALI_NUM        2                         /* ƵʱУ֡      */
#define VIDEO_BUFFER_LEN      2                         /* Ƶ            */
#define VIDEO_CON_PRI         18                        /* Ƶ߳ȼ    */
#define AUDIO_OUT_PRI         19                        /* Ƶ߳ȼ        */
#define VIDEO_OUT_PRI         19                        /* Ƶ߳ȼ        */
#define VIDEO_CON_STACK       (60 * 1024)               /* Ƶ߳ջ        */
#define AUDIO_OUT_STACK       (4 * 1024)                /* Ƶ߳ջ            */
#define VIDEO_OUT_STACK       (4 * 1024)                /* Ƶ߳ջ            */
#define AUDIO_VIDEO_MAX_INTER  500                      /* Ƶ */
#define VIDEO_CON_THREAD      "video_control_thread"    /* Ƶ߳        */
#define AUDIO_OUT_THREAD      "audio_output_thread"     /* Ƶ߳            */
#define VIDEO_OUT_THREAD      "video_output_thread"     /* Ƶ߳            */
#define VIDEO_OUTPUT_SEM      "video_output_sem"        /* Ƶͬź    */
#define VIDEO_CONTROL_SEM     "video_control_sem"       /* Ƶſͬź    */
#define VIDEO_SYNC_TIMER      "video_output_timer"      /* Ƶʱ            */
#define VIDEO_BUFFER_LOCK     "video_buffer_lock"       /* Ƶ          */

/* Ŀ¼Ҫ²̶ */
#define VIDEO_BUF_3GP_FILE    "C:\\video_buf_file.3gp"  /* Buffer(3gp)Ӧļ */
#define VIDEO_BUF_MP4_FILE    "C:\\video_buf_file.mp4"  /* Buffer(mp4)Ӧļ */

/**************************************************************************
 *                                                                 *
 **************************************************************************/
/* ƵT_VideoBufferݳԱ */
typedef struct _T_VideoBufferData
{
    BOOL                 bUsed;           /* ûԪǷʹ   */
    BOOL                 bARGB;           /* ƵͼǷΪARGB */    
    UINT32               uiTime;          /* ƵݶӦĲʱ */    
    RECT_T               tPlayRect;       /* Ƶͼʾ       */
    T_ZDrv_ImageDataBuf  tImageData;      /* Ƶͼ           */   
}T_VideoBufferData;

/* Ƶ */
typedef struct _T_VideoBuffer
{   
    UINT32               uiRdIndex;       /* ָλ       */
    UINT32               uiWrtIndex;      /* дָλ       */
    UINT32               uiBufLen;        /* Ԫܳ   */
    UINT32               uiUsedLen;       /* ЧԪس */
    ZOSS_MUTEX_ID        pBufLock;        /* Ļ         */
    T_VideoBufferData   *pDataBuf;        /* Ԫصַ     */
}T_VideoBuffer;

/* Ƶ״̬ */
typedef enum
{
    AUDIO_BUF_INVALID = 0,                /* ƵЧ       */
    AUDIO_BUF_UNUSED,                     /* ƵЧδʹ */
    AUDIO_BUF_USED,                       /* ƵЧʹ */
}EAudioBufState;

/* Ƶ */
typedef struct _T_AudioBuffer
{
    VOID                *pPhyBuffer;      /* ַ          */
    UINT32               uiBufLen;        /* ԭʼ          */
    UINT32               uiUsedLen;       /* ʹó          */
    UINT32               uiStartTime;     /* PCMݿʼʱ */
    UINT32               uiEndTime;       /* PCMݽʱ */
    EAudioBufState       eBufState;       /* Ƶ״̬          */
}T_AudioBuffer;

/* ƵϢ */
typedef struct _T_AudioOutInfo
{
    UINT32        uiWriteCount;           /* PCMĿ */
    UINT32        uiRemainCount;          /* ʣPCMĿ   */
}T_AudioOutInfo;

/* ƵϢ */
typedef struct _T_VideoOutInfo
{
    UINT32         uiPlayCount;           /* ¼ѲŵƵ֡Ŀ       */
    UINT32         uiVideoOutTime;        /* ¼Ƶĵǰʱ       */ 
    UINT32         uiSysStartTime;        /* ¼Ƶʼŵϵͳʱ   */
    UINT32         uiTimerDuration;       /* ʱĶʱʱ             */
    UINT32         uiFrameStartTime;      /* ¼һ֡Ƶ벥ʱ */    
}T_VideoOutInfo;

/* ƵſϢ */
typedef struct _T_Video_ControlParam
{
    BOOL                      bBufPlay;        /* Buffer͵Ƶ       */
    BOOL                      bFirstVideoDec; /* ǷǵһƵ */
    SINT32                    iVideoExp;       /* Videoģ쳣־          */
    UINT32                    uiFdAudio;       /* Audio豸                  */
    UINT32                    uiFdVideo;       /* Video豸                  */
    UINT32                    uiYOffset;       /* ȫYƫ      */
    UINT32                    uiUOffset;       /* ȫUƫ      */
    UINT32                    uiVOffset;       /* ȫVƫ      */
    T_MediaAudioDecHandle    *pAudioHandle;    /* Ƶ             */
    DecHandle                 pVideoHandle;    /* Ƶ             */
    T_AudioBuffer             tAudioBuffer;    /* Ƶݻ         */
    T_VideoBuffer            *pVideoBuffer;    /* Ƶ֡           */     
    T_AudioOutInfo            tAudioOutInfo;   /* ƵϢ           */
    T_VideoOutInfo            tVideoOutInfo;   /* ƵϢ           */    
    ZOSS_TIMER_ID             pVideoTimerId;   /* ƵʱID           */
    ZOSS_THREAD_ID            pControlThread;  /* Ƶſ߳           */
    ZOSS_THREAD_ID            pAudioOutThread; /* Ƶ߳               */
    ZOSS_THREAD_ID            pVideoOutThread; /* Ƶ߳               */   
    ZOSS_SEMAPHORE_ID         pControlSem;     /* ûͬź       */
    ZOSS_SEMAPHORE_ID         pOutputSem;      /* ͬź       */
    VIDEO_PLAY_SEEK_T         tPlaySeekParam;  /* ƵŵضλϢ       */
    T_ZDrvVideo_BufInfo       tDftDecBuf;      /* ƵĹ̶Buffer */
}T_Video_ControlParam;

/* ΪļͳһӿӵĽṹ */
struct _T_MEDIADATALIST_NODE
{
    T_ZOss_Node       tNode;
    T_ZMFOutPutUnit   *pOutUnit;
};
typedef struct _T_MEDIADATALIST_NODE T_MEDIA_VIDEODATA_NODE;
typedef struct _T_MEDIADATALIST_NODE T_MEDIA_AUDIODATA_NODE;

/**************************************************************************
 *                           ֲԭ                                  *
 **************************************************************************/
static VOID Video_NotifyUser(SINT32 iStatus);

static VOID Video_DrvNotifyCB(T_ZDrvAudio_Info tStatus);

static DCAMERA_RETURN_VALUE_E Video_OpenOutPutDev(VOID);

static DecHandle Video_VideoDecoderOpen(T_ZDrvVideo_CodecStandard   eVideoType);

static VOID Video_VideoDecoderClose(DecHandle pHandle);

static DecHandle Video_OpenVideoDecoder(EMediaVideoType eMediaVType);

static VOID Video_CloseVideoDecoder(EMediaVideoType eMediaVType, DecHandle pHandle);

static DCAMERA_RETURN_VALUE_E Video_MountDecodeLib(VOID);

static VOID Video_UnMountDecodeLib(VOID);

static T_VideoBuffer *Video_CreateBuffer(UINT32 uiBufLen);

static DCAMERA_RETURN_VALUE_E Video_ReadFromBufferUnlock(T_VideoBuffer *pBuffer,   T_ZDrv_ImageDataBuf  *pImageData,
                                                         BOOL   *pARGB,   RECT_T   *pPlayRect, UINT32   *pTime);

static DCAMERA_RETURN_VALUE_E Video_WriteToBufferLock(T_VideoBuffer *pBuffer,   T_ZDrv_ImageDataBuf  *pImageData, 
                                                      BOOL   bARGB,   RECT_T   *pPlayRect, UINT32    uiTime);

static VOID Video_ClearBuffer(T_VideoBuffer *pBuffer);

static VOID Video_FreeBuffer(T_VideoBuffer *pBuffer);

static DCAMERA_RETURN_VALUE_E Video_CreateOutPutThread(VOID);

static VOID Video_WaitForOutThreadsEnd(VOID);

static VOID Video_CloseOutPutDev(VOID);

static SINT32 Video_ControlProcVideo(UINT32 uiFrames);

static SINT32 Video_RefreshAudioBuffer(VOID);

static SINT32 Video_ControlInitAudioProc(VOID);

static VOID Video_ControlReleaseAudioProc(VOID);

static SINT32 Video_ControlProcAudio(VOID);

static VOID Video_ControlProcStartMsg(VOID);

static VOID Video_ControlProcPauseMsg(VOID);

static VOID Video_ControlProcResumeMsg(VOID);

static VOID Video_ControlProcSeekOnReady(VOID);

static VOID Video_ControlProcSeekOnPlay(VOID);

static VOID Video_ControlProcSeekOnPause(VOID);

static VOID Video_ControlProcSeekMsg(VOID);

static VOID Video_ControlProcRotateMsg(VOID);

static VOID Video_ControlProcStopMsg(VOID);

static VOID Video_ControlProcCloseMsg(VOID);

static VOID Video_ControlProcAudioDecMsg(VOID);

static VOID Video_ControlProcVideoDecMsg(VOID);

static VOID Video_ControlProcVideoSupplyMsg(BOOL bReStart);

static VOID Video_ControlThreadLoop(VOID);

static VOID Audio_OutputProcOutMsg(BOOL bFirst);

static VOID Audio_OutputProcPauseMsg(VOID);

static VOID Audio_OutputProcResumeMsg(VOID);

static VOID Audio_OutputProcStopMsg(VOID);

static VOID Audio_OutputProcCloseMsg(VOID);

static VOID Audio_OutputThreadLoop(VOID);

static VOID Video_TimeoutFunc(SINT32  arg);

static VOID Video_FreeDrvBuf(BOOL    bARGB,    UINT32               uiWidth, 
                             UINT32  uiHeight, T_ZDrv_ImageDataBuf *pImageData);

static VOID Video_OutputProcOutMsg(BOOL bFirst);

static VOID Video_OutputProcPauseMsg(VOID);

static VOID Video_OutputProcStopMsg(VOID);

static VOID Video_OutputProcCloseMsg(VOID);

static VOID Video_OutputThreadLoop(VOID);

static VOID Video_ControlThreadEntry(SINT32 arg);

static VOID Video_OutputThreadEntry(SINT32 arg);

static VOID Audio_OutputThreadEntry(SINT32 arg);

static EZMFResultCode Video_GetNextVideoFrame(T_MEDIA_VIDEODATA_NODE **pOutUnit);

static EZMFResultCode Video_GetNextAudioFrame(T_MEDIA_AUDIODATA_NODE **pOutUnit);

static VOID Video_ReleseDataList();

EZMFResultCode Video_Seek_Adapt(UINT32 uiPos); 
/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
static VIDEO_PLAY_STATE         g_Curstate = VIDEO_PLAY_STATE_IDLE;  /* Videoģ״̬     */
static VIDEO_PLAY_PARAM_T       g_VideoPlayParam;                    /* ƵŲ      */
static VIDEO_PLAY_PARAM_T       g_tTempVideoPlayParam;               /* ʱƵŲ  */
static T_FileInfoParam          g_VideoFileParam;                    /* ƵļýϢ  */
static T_Video_ControlParam     g_VideoControlParam;                 /* VideoҵϢ */
static DCAMERA_RETURN_VALUE_E   g_ErrorCode = DCAMERA_OP_SUCCESS;    /* Videoģ״̬ */

/* ΪļͳһӿӵĽṹ */
static T_ZOss_List       *g_pVideoDataList        = NULL; //Ƶ
static T_ZOss_List       *g_pAudioDataList        = NULL; //Ƶ

/* Լ */
UINT32  g_uiDecCount             = 0;
UINT32  g_uiTimerCount1          = 0;
UINT32  g_uiTimerCount2          = 0;
UINT32  g_uiTimerCount3          = 0;
UINT32  g_uiCount1               = 0;
UINT32  g_uiCount2               = 0;
UINT32  g_uiCount3               = 0;
UINT32  g_uiGetYUVBufCount       = 0;
UINT32  g_uiVideoFreeYUVBufCount = 0;

/**************************************************************************
 *                ʵ--в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--˽в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 ************************* Դ룬YUV********************
 **************************************************************************/
static void SaveYUVData(T_ZDrv_ImageDataBuf imageData, UINT32 iWidth, UINT32 iHeight)
{
    FILE   *fp           = NULL;    
    SINT32  iRet         = 0;
    CHAR    filename[50] = {0};
    sprintf(filename, "%s", "C:\\yuvimg.yuv");
    fp = zOss_FOpen((const CHAR *)filename, "wb");
    if (NULL == fp)
    {
        return;
    }
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Y,  (SSIZE_T)1, (SSIZE_T)iWidth * iHeight,   fp);
    iRet = (SINT32)zOss_FFlush(fp);
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Cb, (SSIZE_T)1, (SSIZE_T)iWidth * iHeight/4, fp);
    iRet = (SINT32)zOss_FFlush(fp);
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.YuvBuf.Cr, (SSIZE_T)1, (SSIZE_T)iWidth * iHeight/4, fp);
    iRet = (SINT32)zOss_FFlush(fp);
    zOss_FClose(fp);
}

/**************************************************************************
 ************************* Դ룬ARGB ********************
 **************************************************************************/
static void SaveARGBData(T_ZDrv_ImageDataBuf imageData, UINT32 iWidth, UINT32 iHeight)
{
    FILE   *fp           = NULL;    
    SINT32  iRet         = 0;
    CHAR    filename[50] = {0};
    sprintf(filename, "%s", "C:\\argbimg.rgb");
    fp = zOss_FOpen((const CHAR *)filename, "wb");
    if (NULL == fp)
    {
        return;
    }
    
    iRet = (SINT32)zOss_FWrite((VOID *)imageData.ARGBdataBuf,  (SSIZE_T)1, (SSIZE_T)iWidth * iHeight * 4,   fp);
    iRet = (SINT32)zOss_FFlush(fp);
    zOss_FClose(fp);
}


/**************************************************************************
 *                     ȫֺʵ                                      *
 **************************************************************************/
/**
 * ƣ Video_Open 
 *  Ƶģ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_Open(void)
{
    SINT32 iRet = 0;
    if(g_Curstate != VIDEO_PLAY_STATE_IDLE)
    {
        return DCAMERA_OP_ERROR;
    } 
    g_Curstate   = VIDEO_PLAY_STATE_OPEN;
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_Close 
 *  رƵģ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_Close(void)
{
    SINT32 iRet = 0;
    if(g_Curstate != VIDEO_PLAY_STATE_OPEN)
    {
        return DCAMERA_OP_ERROR;
    }
    g_Curstate = VIDEO_PLAY_STATE_IDLE;
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_Play_Init 
 *  Ƶųʼļ
 * ˵ (IN) param ƵŲṹ
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ param贫ЧĴļ
 */
DCAMERA_RETURN_VALUE_E Video_Play_Init(VIDEO_PLAY_PARAM_T *param)
{
    if(g_Curstate != VIDEO_PLAY_STATE_OPEN)
    {
        return DCAMERA_OP_ERROR;
    }

    /* жָǷΪգжļǷΪ */
    if(NULL == param || '0' == param->filepath[0])
    {
        return DCAMERA_OP_ERROR;
    }    

    /* ȫֱʼ */
    zOss_Memset(&g_VideoPlayParam,      0, sizeof(VIDEO_PLAY_PARAM_T));
    zOss_Memset(&g_VideoFileParam,      0, sizeof(T_FileInfoParam));
    zOss_Memset(&g_VideoControlParam,   0, sizeof(T_Video_ControlParam));
    zOss_Memset(&g_tTempVideoPlayParam, 0, sizeof(VIDEO_PLAY_PARAM_T));
    g_ErrorCode = DCAMERA_OP_SUCCESS;

    /* ǷBufferƵ */
    g_VideoControlParam.bBufPlay = FALSE;
    
    /* ƵϢ */
    g_VideoPlayParam = *param;
    
    g_pVideoDataList = zOss_Malloc(sizeof(T_ZOss_List));
    if(NULL == g_pVideoDataList)
    {
        return DCAMERA_OP_ERROR;        
    }
    
    g_pAudioDataList = zOss_Malloc(sizeof(T_ZOss_List));
    if(NULL == g_pAudioDataList)
    {
        zOss_Free(g_pVideoDataList);
        
        return DCAMERA_OP_ERROR;        
    }

    zOss_ListInit(g_pVideoDataList);
    zOss_ListInit(g_pAudioDataList);
    
    /* ͬõź */
    g_VideoControlParam.pControlSem = zOss_CreateSemaphore(VIDEO_CONTROL_SEM, 0);
    if(ZOSS_NULL == g_VideoControlParam.pControlSem)
    {
        zOss_Free(g_pVideoDataList);
        zOss_Free(g_pAudioDataList);
        
        return DCAMERA_OP_ERROR;        
    }
    g_VideoControlParam.pOutputSem = zOss_CreateSemaphore(VIDEO_OUTPUT_SEM, 0);
    if(ZOSS_NULL == g_VideoControlParam.pOutputSem)
    {
        zOss_Free(g_pVideoDataList);
        zOss_Free(g_pAudioDataList);
        
        zOss_DeleteSemaphore(g_VideoControlParam.pControlSem);
        return DCAMERA_OP_ERROR;        
    }
    
    /* Ƶ߳ */
    g_VideoControlParam.pControlThread = zOss_CreateThread(VIDEO_CON_THREAD,
                                                           Video_ControlThreadEntry,
                                                           0,
                                                           VIDEO_CON_STACK,
                                                           VIDEO_CON_PRI,
                                                           1,
                                                           1);
    if(ZOSS_INVALID_THREAD_ID == g_VideoControlParam.pControlThread)
    {
        zOss_Free(g_pVideoDataList);
        zOss_Free(g_pAudioDataList);

        zOss_DeleteSemaphore(g_VideoControlParam.pControlSem);
        zOss_DeleteSemaphore(g_VideoControlParam.pOutputSem);
        
        return DCAMERA_OP_ERROR;        
    }

    /* ȴ̵߳ĳʼȲ */
    zOss_GetSemaphore(g_VideoControlParam.pControlSem, ZOSS_WAIT_FOREVER);
    /* ̵߳ĲǷ */
    if(g_ErrorCode != DCAMERA_OP_SUCCESS)
    {
        zOss_Free(g_pVideoDataList);
        zOss_Free(g_pAudioDataList);
        
        zOss_DeleteSemaphore(g_VideoControlParam.pControlSem);
        zOss_DeleteSemaphore(g_VideoControlParam.pOutputSem);

        /* λ־ */
        g_ErrorCode  = DCAMERA_OP_SUCCESS;
        
        return DCAMERA_OP_ERROR;        
    }
    
    g_Curstate = VIDEO_PLAY_STATE_READY;    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_Play_Buffer_Init 
 *  ƵųʼBuffer
 * ˵ (IN) param ƵŲṹ
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_Play_Buffer_Init(VIDEO_PLAY_PARAM_T *param)
{
    FILE       *pFile     = NULL;
    SSIZE_T     uiCount   = 0;
    const CHAR *pfilename = NULL;
    
    if(g_Curstate != VIDEO_PLAY_STATE_OPEN)
    {
        return DCAMERA_OP_ERROR;
    }

    if(NULL == param
       || NULL == param->videoBuf
       || 0 == param->videoBuffSize)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ֧3GP/MP4ʽƵ */
    switch(param->videotype)
    {
        case VIDEO_FILE_TYPE_MP4:
        {
            pfilename = (const CHAR *)VIDEO_BUF_MP4_FILE;
            
            break;
        }
        case VIDEO_FILE_TYPE_3GP:
        {
            pfilename = (const CHAR *)VIDEO_BUF_3GP_FILE;
            
            break;
        }
        default:
        {
            break;
        }
    }

    if(NULL == pfilename)
    {
        return DCAMERA_OP_ERROR;    
    }
    
    /* ȫֱʼ */
    zOss_Memset(&g_VideoPlayParam,      0, sizeof(VIDEO_PLAY_PARAM_T));
    zOss_Memset(&g_VideoFileParam,      0, sizeof(T_FileInfoParam));
    zOss_Memset(&g_VideoControlParam,   0, sizeof(T_Video_ControlParam));
    zOss_Memset(&g_tTempVideoPlayParam, 0, sizeof(VIDEO_PLAY_PARAM_T));
    g_ErrorCode = DCAMERA_OP_SUCCESS;
    
    /* ƵݱΪʱļ"wb"ʽ򿪣
     * ļԭȫҪÿɾļ
     */
    pFile = zOss_FOpen(pfilename, "wb");
    if(NULL == pFile)
    {
        return DCAMERA_OP_ERROR;
    }
        
    uiCount = zOss_FWrite((const VOID *)param->videoBuf, param->videoBuffSize, 1, pFile);
    if(uiCount != 1)
    {
        zOss_FClose(pFile);
        zOss_FDelete(pfilename);
        
        return DCAMERA_OP_ERROR;
    }

    /* رʱļ */
    zOss_FFlush(pFile);
    zOss_FClose(pFile);

    /* ǷBufferƵ */
    g_VideoControlParam.bBufPlay = TRUE;

    /* ƵϢ */
    g_VideoPlayParam = *param;
    strcpy(g_VideoPlayParam.filepath, (const char *)pfilename);
    
    g_pVideoDataList = zOss_Malloc(sizeof(T_ZOss_List));
    if(NULL == g_pVideoDataList)
    {
        zOss_FDelete(pfilename);
        g_VideoControlParam.bBufPlay = FALSE;
        return DCAMERA_OP_ERROR;        
    }
    
    g_pAudioDataList = zOss_Malloc(sizeof(T_ZOss_List));
    if(NULL == g_pAudioDataList)
    {
        zOss_FDelete(pfilename);
        g_VideoControlParam.bBufPlay = FALSE;
        zOss_Free(g_pVideoDataList);
        
        return DCAMERA_OP_ERROR;        
    }

    zOss_ListInit(g_pVideoDataList);
    zOss_ListInit(g_pAudioDataList);
    
    /* ͬõź */
    g_VideoControlParam.pControlSem = zOss_CreateSemaphore(VIDEO_CONTROL_SEM, 0);
    if(ZOSS_NULL == g_VideoControlParam.pControlSem)
    {   
        zOss_Free(g_pVideoDataList);
        zOss_Free(g_pAudioDataList);
        zOss_FDelete(pfilename);
        g_VideoControlParam.bBufPlay = FALSE;
        
        return DCAMERA_OP_ERROR;        
    }
    g_VideoControlParam.pOutputSem = zOss_CreateSemaphore(VIDEO_OUTPUT_SEM, 0);
    if(ZOSS_NULL == g_VideoControlParam.pOutputSem)
    {
        zOss_DeleteSemaphore(g_VideoControlParam.pControlSem);
        zOss_Free(g_pVideoDataList);
        zOss_Free(g_pAudioDataList);
        zOss_FDelete(pfilename);
        g_VideoControlParam.bBufPlay = FALSE;
        
        return DCAMERA_OP_ERROR;        
    }
    
    /* Ƶ߳ */
    g_VideoControlParam.pControlThread = zOss_CreateThread(VIDEO_CON_THREAD,
                                                           Video_ControlThreadEntry,
                                                           0,
                                                           VIDEO_CON_STACK,
                                                           VIDEO_CON_PRI,
                                                           1,
                                                           1);
    if(ZOSS_INVALID_THREAD_ID == g_VideoControlParam.pControlThread)
    {
        zOss_DeleteSemaphore(g_VideoControlParam.pControlSem);
        zOss_DeleteSemaphore(g_VideoControlParam.pOutputSem);
        zOss_Free(g_pVideoDataList);
        zOss_Free(g_pAudioDataList);
        zOss_FDelete(pfilename);
        g_VideoControlParam.bBufPlay = FALSE;
        
        return DCAMERA_OP_ERROR;        
    }

    /* ȴ̵߳ĳʼȲ */
    zOss_GetSemaphore(g_VideoControlParam.pControlSem, ZOSS_WAIT_FOREVER);

    /* ̵߳ĲǷ */
    if(g_ErrorCode != DCAMERA_OP_SUCCESS)
    {
        zOss_DeleteSemaphore(g_VideoControlParam.pControlSem);
        zOss_DeleteSemaphore(g_VideoControlParam.pOutputSem);
        zOss_Free(g_pVideoDataList);
        zOss_Free(g_pAudioDataList);
        zOss_FDelete(pfilename);
        g_VideoControlParam.bBufPlay = FALSE;

        /* λ־ */
        g_ErrorCode  = DCAMERA_OP_SUCCESS;
        
        return DCAMERA_OP_ERROR;        
    }
    
    g_Curstate = VIDEO_PLAY_STATE_READY;    
    
    return DCAMERA_OP_SUCCESS;    
}

/**
 * ƣ Video_Play_Release 
 *  Ƶͷ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_Play_Release(void)
{
    SINT32  iRet  = -1;
    
    if(VIDEO_PLAY_STATE_IDLE == g_Curstate
       || VIDEO_PLAY_STATE_OPEN == g_Curstate)
    {
        return DCAMERA_OP_ERROR;
    }
   
    iRet = zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_CLOSE_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }
    
    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_VideoControlParam.pControlSem, ZOSS_WAIT_FOREVER);

    if(g_VideoControlParam.pControlSem != NULL)
    {
        zOss_DeleteSemaphore(g_VideoControlParam.pControlSem);
        g_VideoControlParam.pControlSem = NULL;
    }
    if(g_VideoControlParam.pOutputSem != NULL)
    {
        zOss_DeleteSemaphore(g_VideoControlParam.pOutputSem);
        g_VideoControlParam.pOutputSem = NULL;
    }

    /* ɾBufferƵӦʱļ */
    if(g_VideoControlParam.bBufPlay)
    {
        zOss_FDelete((const CHAR *)g_VideoPlayParam.filepath);
    }

    /* ͷŻͷ */
    zOss_Free(g_pVideoDataList);
    zOss_Free(g_pAudioDataList);

    /* ƵĹرգϢǷ
     * ״̬ǨƣVideo_Close޷
     */
    g_Curstate = VIDEO_PLAY_STATE_OPEN;

    /* ϢǷ */
    if(g_ErrorCode != DCAMERA_OP_SUCCESS)
    {
        /* λ־ */
        g_ErrorCode  = DCAMERA_OP_SUCCESS;
        
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_StartPlay 
 *  ʼƵ
 * ˵ (IN) param ƵŲṹ
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_StartPlay(VIDEO_PLAY_PARAM_T *param)
{
    SINT32                  iRet  = -1;
    DCAMERA_RETURN_VALUE_E  eRet  = DCAMERA_OP_ERROR;
    
    if(g_Curstate != VIDEO_PLAY_STATE_READY)
    {
        return DCAMERA_OP_ERROR;
    }
    if(NULL == param)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ƵתǶ */
    eRet = Video_Rotate(param);
    if(eRet != DCAMERA_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }
    
    /* ƵŲ棬ҪԱ棬ΪBuffer
     * ƵļĬϵʱļparamΪNULL
     */
    g_VideoPlayParam.channel   = param->channel;
    g_VideoPlayParam.volume    = param->volume;
    g_VideoPlayParam.curstate  = param->curstate;
    
    iRet = zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_START_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_VideoControlParam.pControlSem, ZOSS_WAIT_FOREVER);

    /* ϢǷ */
    if(g_ErrorCode != DCAMERA_OP_SUCCESS)
    {
        /* λ־ */
        g_ErrorCode  = DCAMERA_OP_SUCCESS;
        
        return DCAMERA_OP_ERROR;
    }
    
    g_Curstate = VIDEO_PLAY_STATE_PLAY; 
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_StopPlay 
 *  ֹͣƵ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_StopPlay(void)
{
    SINT32  iRet  = -1;
    
    if(g_Curstate != VIDEO_PLAY_STATE_PLAY
       && g_Curstate != VIDEO_PLAY_STATE_PAUSE)
    {
        return DCAMERA_OP_ERROR;
    }

    iRet = zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_STOP_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_VideoControlParam.pControlSem, ZOSS_WAIT_FOREVER);

    /* ϢǷ */
    if(g_ErrorCode != DCAMERA_OP_SUCCESS)
    {
        /* λ־ */
        g_ErrorCode  = DCAMERA_OP_SUCCESS;
        
        return DCAMERA_OP_ERROR;
    }

    g_Curstate = VIDEO_PLAY_STATE_READY; 
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_PausePlay 
 *  ͣƵ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_PausePlay(void)
{
    SINT32  iRet  = 0;
   
    if(g_Curstate != VIDEO_PLAY_STATE_PLAY)
    {
        return DCAMERA_OP_ERROR;
    }

    iRet = zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_PAUSE_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_VideoControlParam.pControlSem, ZOSS_WAIT_FOREVER);

    /* ϢǷ */
    if(g_ErrorCode != DCAMERA_OP_SUCCESS)
    {
        /* λ־ */
        g_ErrorCode  = DCAMERA_OP_SUCCESS;
        
        return DCAMERA_OP_ERROR;
    }

    g_Curstate = VIDEO_PLAY_STATE_PAUSE; 
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_ResumePlay 
 *  ָƵ
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_ResumePlay(void)
{
    SINT32  iRet  = 0;
    
    if(g_Curstate != VIDEO_PLAY_STATE_PAUSE)
    {
        return DCAMERA_OP_ERROR;
    }
    
    iRet = zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_RESUME_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_VideoControlParam.pControlSem, ZOSS_WAIT_FOREVER);

    /* ϢǷ */
    if(g_ErrorCode != DCAMERA_OP_SUCCESS)
    {
        /* λ־ */
        g_ErrorCode  = DCAMERA_OP_SUCCESS;
        
        return DCAMERA_OP_ERROR;
    }

    g_Curstate = VIDEO_PLAY_STATE_PLAY; 
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_Seek 
 *  Ƶضλ
 * ˵ (IN) param ƵŲṹ
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ ִ֧ļʼλ
 */
DCAMERA_RETURN_VALUE_E Video_Seek(VIDEO_PLAY_SEEK_T *param)
{
    SINT32  iRet  = -1;
    UINT32  uiPos = 0;
    
    if(g_Curstate != VIDEO_PLAY_STATE_READY
       && g_Curstate != VIDEO_PLAY_STATE_PLAY
       && g_Curstate != VIDEO_PLAY_STATE_PAUSE)
    {
        return DCAMERA_OP_ERROR;
    }

    if(NULL == param)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ضλģʽ */
    if(param->seekmode != VIDEO_SEEK_FROM_CUR
       && param->seekmode != VIDEO_SEEK_FROM_BEGIN)
    {
        return DCAMERA_OP_ERROR;
    }
    
    /* λʱȽϼ */
    if(VIDEO_SEEK_FROM_BEGIN == param->seekmode)
    {
        if(param->pos >= g_VideoFileParam.uiFileTotalTime)
        {
            return DCAMERA_OP_ERROR;
        }

        uiPos = param->pos;
    }
    else
    {
        UINT32  uiCurTime = 0;

        /* ȡǰʱ */
        Video_GetCurTime(&uiCurTime);

        uiPos = param->pos + uiCurTime;

        if(uiPos >= g_VideoFileParam.uiFileTotalTime)
        {
            return DCAMERA_OP_ERROR;
        }
    }

    /* ¼ضλʱֵ߳̽ӿʼSEEK */
    g_VideoControlParam.tPlaySeekParam.seekmode = VIDEO_SEEK_FROM_BEGIN;
    g_VideoControlParam.tPlaySeekParam.pos      = uiPos;
        
    iRet = zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_SEEK_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_VideoControlParam.pControlSem, ZOSS_WAIT_FOREVER);

    /* ϢǷ */
    if(g_ErrorCode != DCAMERA_OP_SUCCESS)
    {
        /* λ־ */
        g_ErrorCode  = DCAMERA_OP_SUCCESS;
        
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_Rotate 
 *  ƵʾתǶȵ
 * ˵ (IN) param ƵŲṹ
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_Rotate(VIDEO_PLAY_PARAM_T *param)
{
    SINT32               iRet        = -1;
    UINT32               uiSrcWidth  = 0;     /* ppuĿ */
    UINT32               uiSrcHeight = 0;
    RECT_T               tTempRect   = {0, };
    T_ZDrvVideo_DecCfg  *pDecCfg     = NULL;  /* ò  */    
    VIDEO_PLAY_PARAM_T   videoPlayParam;
    
    if(g_Curstate < VIDEO_PLAY_STATE_READY)
    {
        return DCAMERA_OP_ERROR;
    }  

    if(NULL == param)
    {
        return DCAMERA_OP_ERROR;
    }

    /* Ƶݣ˽ӿ */
    if(!(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO))
    {
        return DCAMERA_OP_SUCCESS;
    }
    
    /* תǶȲ */
    if(param->rotate < ROTATE_0
       || param->rotate > ROTATE_MAX)
    {
        return DCAMERA_OP_ERROR;
    }
    
    /* ûĲ浽Լṹ */
    zOss_Memcpy(&videoPlayParam, param, sizeof(VIDEO_PLAY_PARAM_T));
    
    /* ʾ */
    if (ROTATE_270 == videoPlayParam.rotate || ROTATE_90 == videoPlayParam.rotate)
    {
        uiSrcWidth                      = videoPlayParam.play_rect.height;
        videoPlayParam.play_rect.height = videoPlayParam.play_rect.width;
        videoPlayParam.play_rect.width  = uiSrcWidth;
    }
    
    if(videoPlayParam.play_rect.sx + videoPlayParam.play_rect.width > g_uiScreenWidth
    || videoPlayParam.play_rect.sy + videoPlayParam.play_rect.height > g_uiScreenHeight)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ȡͼƬԭʼߣppu */
    pDecCfg = (T_ZDrvVideo_DecCfg *)g_VideoControlParam.pVideoHandle; 

    /* ڴʱδתһж */
    if(((ROTATE_0 == videoPlayParam.rotate || ROTATE_180 == videoPlayParam.rotate)
       && (ROT_0 == pDecCfg->tRotate || ROT_180 == pDecCfg->tRotate))
       || ((ROTATE_90 == videoPlayParam.rotate || ROTATE_270 == videoPlayParam.rotate)
       && (ROT_90 == pDecCfg->tRotate || ROT_270 == pDecCfg->tRotate)))
    {
        uiSrcWidth  = pDecCfg->tOutput.uiWidth;
        uiSrcHeight = pDecCfg->tOutput.uiHeight;  
    }
    else
    {
        uiSrcWidth  = pDecCfg->tOutput.uiHeight;
        uiSrcHeight = pDecCfg->tOutput.uiWidth;  
    }
#if 0
    /* ӲƣƵͼƬʾxyΪ16ı
     * ߱16ı 
     */
    iRet = zMspCom_VideoPlayRectModify(&tTempRect, &(videoPlayParam.play_rect), 
                                       uiSrcWidth, uiSrcHeight);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ʾתǶȣ˴ͨתΪ˱ʹϢ */
    g_tTempVideoPlayParam.play_rect = tTempRect;
#endif
    g_tTempVideoPlayParam.play_rect = videoPlayParam.play_rect;

    g_tTempVideoPlayParam.rotate    = videoPlayParam.rotate;
        
    iRet = zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_ROTATE_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_VideoControlParam.pControlSem, ZOSS_WAIT_FOREVER);

    /* ϢǷ */
    if(g_ErrorCode != DCAMERA_OP_SUCCESS)
    {
        /* λ־ */
        g_ErrorCode  = DCAMERA_OP_SUCCESS;
        
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_GetCurTime 
 *  ȡǰʱ䣬λ
 * ˵ (OUT) param 浱ǰѲʱ䣨ms
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_GetCurTime(UINT32 *param)
{
    if(g_Curstate < VIDEO_PLAY_STATE_READY)
    {
        return DCAMERA_OP_ERROR;
    }    
    if(NULL == param)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ƵΪ׼Ժ迼һֵ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        *param = g_VideoControlParam.tAudioBuffer.uiStartTime;
        return DCAMERA_OP_SUCCESS;
    }

    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        *param = g_VideoControlParam.tVideoOutInfo.uiVideoOutTime;
        return DCAMERA_OP_SUCCESS;
    }

    *param = 0;
    return DCAMERA_OP_ERROR;
}

/**
 * ƣ Video_GetTotalTime 
 *  ȡƵļʱλ
 * ˵ (OUT) param Ƶļʱ䣨ms
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_GetTotalTime(UINT32 *param)
{
    SINT32 iRet = 0;
    if(g_Curstate < VIDEO_PLAY_STATE_READY)
    {
        return DCAMERA_OP_ERROR;
    }    
    if(NULL == param)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ýļʱ */
    *param = g_VideoFileParam.uiFileTotalTime;

    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_GetFileInfo 
 *  ȡƵļϢ
 * ˵ (OUT) param ƵļϢ
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Video_GetFileInfo(VIDEO_PLAY_INFO *param)
{
    if(g_Curstate < VIDEO_PLAY_STATE_READY)
    {
        return DCAMERA_OP_ERROR;
    }    
    if(NULL == param)
    {
        return DCAMERA_OP_ERROR;
    }

    /* ýļʱ */
    param->dwTotalTime = g_VideoFileParam.uiFileTotalTime;

    /* ǷΪƵļ */
    if(FILE_DATA_ONLY_AUDIO == g_VideoFileParam.eFileDataInfo)
    {
        param->dwOnlyHaveAudio = 1;
    }
    else
    {
        param->dwOnlyHaveAudio = 0;
    }

    /* ƵԭʼС */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        UINT32 uiIndex    = 0;
        UINT32 uiTrackNum = g_VideoFileParam.pFileInfo->tFileInfo.t_isoInfo.u32TrackNum;

        param->tsize.width  = 0;
        param->tsize.height = 0;
        
        for(uiIndex = 0; uiIndex < uiTrackNum; uiIndex++)
        {
            if(g_VideoFileParam.pFileInfo->tFileInfo.t_isoInfo.pTrackArray[uiIndex].u32TrackID == g_VideoFileParam.u32VideoTrack)
            {
                param->tsize.width  = g_VideoFileParam.pFileInfo->tFileInfo.t_isoInfo.pTrackArray[uiIndex].tTrackInfo.tVideoParam.u32Width;
                param->tsize.height = g_VideoFileParam.pFileInfo->tFileInfo.t_isoInfo.pTrackArray[uiIndex].tTrackInfo.tVideoParam.u32Height;
            }
        }
    }
    else
    {
        param->tsize.width  = 0;
        param->tsize.height = 0;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**************************************************************************
 *                      ֲʵ                                      *
 **************************************************************************/
/* Ϊļͳһӿڶӵڲ */
/**
 * ƣ Video_GetNextVideoFrame 
 *  Ƶģȡһ֡Ƶ
 * ˵ (IN) pOutUnit ýļָ
 *   ֵ EZMFResultCode
 * ˵ 
 *            
 */
static EZMFResultCode Video_GetNextVideoFrame(T_MEDIA_VIDEODATA_NODE  **pData)
{
    T_MEDIA_VIDEODATA_NODE  *pVideoDataNode = NULL;
    T_MEDIA_AUDIODATA_NODE  *pAudioDataNode = NULL;
    T_ZMFOutPutUnit         *ptempOutUnit   = NULL;
    T_ZMFOutPutUnit         *pDataOutUnit   = NULL;
    EZMFResultCode           iRet           = ZMF_RS_OK;

    /* Ƶݣȡһ */
    if(zOss_ListCount(g_pVideoDataList) > 0)
    {
        pVideoDataNode = (T_MEDIA_VIDEODATA_NODE  *)zOss_ListFirst(g_pVideoDataList);
        zOss_ListDelete(g_pVideoDataList, (T_ZOss_Node *)pVideoDataNode);

        (*pData) = pVideoDataNode;

        return ZMF_RS_OK;
    }
    else
    {/* ƵûݣȡļֱȡƵΪֹ */
        while(1)
        {
            iRet = GetNextFrame(g_VideoFileParam.u32FileID, &ptempOutUnit);

            if(ZMF_RS_VIDEO_TRACK_OVER == iRet
             || ZMF_RS_AUDIO_TRACK_OVER == iRet)
            {
                ReleaseUnitData(g_VideoFileParam.u32FileID, ptempOutUnit);
                return iRet;
            }
            
            if(ZMF_RS_OK != iRet)
            {
                return iRet;
            }
            /* ȡƵļ˳ */
            if(ptempOutUnit->u32TrackID == g_VideoFileParam.u32VideoTrack)
            {
                /* 汾еһ֡Ƶ֡Ϊ㣬ԭ */
                if(ptempOutUnit->u32Len == 0 && ptempOutUnit->eCodeID != ZM_CODEC_ID_AMR_NB)
                {
                    ReleaseUnitData(g_VideoFileParam.u32FileID, ptempOutUnit);
                    continue;
                }
                
                pVideoDataNode = zOss_Malloc(sizeof(T_MEDIA_VIDEODATA_NODE));
                if(NULL == pVideoDataNode)
                {
                    ReleaseUnitData(g_VideoFileParam.u32FileID, ptempOutUnit);
                    return ZMF_RS_ERROR;
                }

                pVideoDataNode->pOutUnit = ptempOutUnit;

                (*pData) = pVideoDataNode;
                
                return ZMF_RS_OK;
            }
            /* ȡƵݣݷƵУȡ */
            else if(ptempOutUnit->u32TrackID == g_VideoFileParam.u32AudioTrack)
            {
                pAudioDataNode = zOss_Malloc(sizeof(T_MEDIA_AUDIODATA_NODE));
                if(NULL == pAudioDataNode)
                {
                    ReleaseUnitData(g_VideoFileParam.u32FileID, ptempOutUnit);
                    return ZMF_RS_ERROR;
                }

                pAudioDataNode->pOutUnit = ptempOutUnit;
                
                zOss_ListAdd(g_pAudioDataList, (T_ZOss_Node *) pAudioDataNode);
            }
            else
            {
                ReleaseUnitData(g_VideoFileParam.u32FileID, ptempOutUnit);
            }
        }
    }
    
}

/**
 * ƣ Video_GetNextAudioFrame 
 *  Ƶģȡһ֡Ƶ
 * ˵ (IN) pOutUnit ýļָ
 *   ֵ EZMFResultCode
 * ˵ 
 *            
 */
static EZMFResultCode Video_GetNextAudioFrame(T_MEDIA_AUDIODATA_NODE **pData)
{
    T_MEDIA_VIDEODATA_NODE  *pVideoDataNode = NULL;
    T_MEDIA_AUDIODATA_NODE  *pAudioDataNode = NULL;
    T_ZMFOutPutUnit         *ptempOutUnit   = NULL;
    EZMFResultCode           iRet           = ZMF_RS_OK;

    /* Ƶݣȡһ */
    if(zOss_ListCount(g_pAudioDataList) > 0)
    {
        pAudioDataNode = (T_MEDIA_AUDIODATA_NODE  *)zOss_ListFirst(g_pAudioDataList);
        zOss_ListDelete(g_pAudioDataList, (T_ZOss_Node *)pAudioDataNode);

        (*pData) = pAudioDataNode;

        return ZMF_RS_OK;
    } 
    else
    {/* ƵûݣȡļֱȡƵΪֹ */
        while(1)
        {
            iRet = GetNextFrame(g_VideoFileParam.u32FileID, &ptempOutUnit);
            
            if(ZMF_RS_VIDEO_TRACK_OVER == iRet
             || ZMF_RS_AUDIO_TRACK_OVER == iRet)
            {
                ReleaseUnitData(g_VideoFileParam.u32FileID, ptempOutUnit);
                return iRet;
            }
            
            if(ZMF_RS_OK != iRet)
            {
                return iRet;
            }
            /* ȡƵļ˳ */
            if(ptempOutUnit->u32TrackID == g_VideoFileParam.u32AudioTrack)
            {
                pAudioDataNode = zOss_Malloc(sizeof(T_MEDIA_AUDIODATA_NODE));
                if(NULL == pAudioDataNode)
                {
                    ReleaseUnitData(g_VideoFileParam.u32FileID, ptempOutUnit);
                    return ZMF_RS_ERROR;
                }

                pAudioDataNode->pOutUnit = ptempOutUnit;

                (*pData) = pAudioDataNode;

                return ZMF_RS_OK;
            }
            /* ȡƵݣݷƵУȡ */
            else if(ptempOutUnit->u32TrackID == g_VideoFileParam.u32VideoTrack)
            {
                /* 汾еһ֡Ƶ֡Ϊ㣬ԭ */
                if(ptempOutUnit->u32Len == 0)
                {
                    ReleaseUnitData(g_VideoFileParam.u32FileID, ptempOutUnit);
                    continue;
                }
                
                pVideoDataNode = zOss_Malloc(sizeof(T_MEDIA_VIDEODATA_NODE));
                if(NULL == pVideoDataNode)
                {
                    ReleaseUnitData(g_VideoFileParam.u32FileID, ptempOutUnit);
                    return ZMF_RS_ERROR;
                }

                pVideoDataNode->pOutUnit = ptempOutUnit;
               
                zOss_ListAdd(g_pVideoDataList, (T_ZOss_Node *) pVideoDataNode);                
            }
            else
            {
                ReleaseUnitData(g_VideoFileParam.u32FileID, ptempOutUnit);
            }
        }
    }
    
}

/**
 * ƣ Video_ReleseDataList 
 *  ͷƵĿռ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 *            
 */
static VOID Video_ReleseDataList()
{
    T_MEDIA_VIDEODATA_NODE  *pVideoDataNode = NULL;
    T_MEDIA_VIDEODATA_NODE  *pAudioDataNode = NULL;

    while(1)
    {
        if(zOss_ListCount(g_pAudioDataList) > 0)
        {
            pAudioDataNode = (T_MEDIA_AUDIODATA_NODE  *)zOss_ListFirst(g_pAudioDataList);
            zOss_ListDelete(g_pAudioDataList, (T_ZOss_Node *)pAudioDataNode);
            ReleaseUnitData(g_VideoFileParam.u32FileID, pAudioDataNode->pOutUnit);
            zOss_Free(pAudioDataNode);
        }
        else
        {
            break;
        }
    }
    
    while(1)
    {
        if(zOss_ListCount(g_pVideoDataList) > 0)
        {
            pVideoDataNode = (T_MEDIA_VIDEODATA_NODE  *)zOss_ListFirst(g_pVideoDataList);
            zOss_ListDelete(g_pVideoDataList, (T_ZOss_Node *)pVideoDataNode);
            ReleaseUnitData(g_VideoFileParam.u32FileID, pVideoDataNode->pOutUnit);
            zOss_Free(pVideoDataNode);
        }
        else
        {
            break;
        }
    }
}

/**
 * ƣ Video_Seek_Adapt 
 *  ͳһӿڵضλ
 * ˵ (IN) uiPos:ļضλλ
 *   ֵ EZMFResultCode
 * ˵ 
 *            
 */
EZMFResultCode Video_Seek_Adapt(UINT32 uiPos)
{
    EZMFResultCode rtCode = ZMF_RS_OK;

    /* ضλʱͷŻе */
    Video_ReleseDataList();
    rtCode = Seek(g_VideoFileParam.u32FileID, uiPos);

    return rtCode;
    
}

/**
 * ƣ Video_NotifyUser 
 *  Ƶģ֪ͨû
 * ˵ (IN) iStatus  ״̬
 *   ֵ 
 * ˵ ˺ӦΪûעᣬP95Tƣ˴ֱ
 *            CCMĺԺ޸ġ
 */
/* extern VOID zMmfSink_VideoStopCallback(VOID); */
static VOID Video_NotifyUser(SINT32 iStatus)
{
    switch(iStatus)
    {
        case VIDEO_OP_DATAEND:
        {
            /* 2--Ƶģ */
            zMspCom_NotifyUser(MSP_MODULE_VIDEO, MSP_PLAY_END);
            break;
        }

        /* 뻺ļȡ쳣ײ豸ŵ쳣 */
        default:
        {
            /* 2--Ƶģ */
            zMspCom_NotifyUser(MSP_MODULE_VIDEO, MSP_PLAY_ERR);
            break;
        }
    }

    return;
}

/**
 * ƣ Video_DrvNotifyCB 
 *  עĵײ㲥֪ͨص
 * ˵ (IN) iStatus  ״̬
 *   ֵ 
 * ˵ 
 */
static VOID Video_DrvNotifyCB(T_ZDrvAudio_Info tStatus)
{
    switch(tStatus)
    {
        /* ײPCM쳣 */
        case AUDIO_INFO_PLAY_ERR:
        {
            g_VideoControlParam.iVideoExp |= VIDEO_PCM_EXP;            
            
            break;        
        }

        /* ײPCMݲ */
        case AUDIO_INFO_PLAY_END:
        {
            if(g_VideoControlParam.iVideoExp & VIDEO_FILE_AUDIO_OVER_EXP)
            {
                /* ֪ͨƵ */
                zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_AUDIO_OUT_OVER);
            }
            
            break;        
        }

        default:
        {
            break;
        }
    }

    return;
}


/**
 * ƣ Video_OpenOutPutDev 
 *  audiovideo豸
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
static DCAMERA_RETURN_VALUE_E Video_OpenOutPutDev(VOID)
{
    SINT32 iFdAudio = -1;
    SINT32 iFdVideo = -1;
    
    /* Audio豸Video豸 */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        iFdAudio = zMspCom_AudioOpen();
        if(iFdAudio <= 0)
        {
            return DCAMERA_OP_ERROR;
        }
        g_VideoControlParam.uiFdAudio = (UINT32)iFdAudio;

    }
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        iFdVideo = zMspCom_VideoOpen();
        if(iFdVideo <= 0)
        {
            if(g_VideoControlParam.uiFdAudio > 0)
            {
                zMspCom_AudioClose();
                g_VideoControlParam.uiFdAudio = 0;
            }
            return DCAMERA_OP_ERROR;
        }
        g_VideoControlParam.uiFdVideo = (UINT32)iFdVideo;
    }    

    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_VideoDecoderOpen 
 *  H263ʽƵ
 * ˵ (IN) 
 *   ֵ ʧܷNULL
 * ˵ ΪH263ȴһ֡ݣ⴦;
 *            ʵΪ(T_ZDrvVideo_DecCfg *)
 */
static DecHandle Video_VideoDecoderOpen(T_ZDrvVideo_CodecStandard   eVideoType)
{
    SINT32               iRet      = -1;
    EZMFResultCode       rtCode    = ZMF_RS_ERROR;        
    T_MEDIA_VIDEODATA_NODE    *pData     = NULL;   
    T_ZDrvVideo_DecCfg  *pDecCfg   = NULL;
    T_ZDrvVideo_BufInfo  tBuf;

    pDecCfg = (T_ZDrvVideo_DecCfg *)zOss_Malloc(sizeof(T_ZDrvVideo_DecCfg));
    if(NULL == pDecCfg)
    {
        return NULL;
    }
    zOss_Memset(pDecCfg, 0, sizeof(T_ZDrvVideo_DecCfg));

    /* ݲͬƵͽ䣬avcmpeg4ص3gp mp4
    ƵļͷϢʱֻܴӵһ֡Ƶ
    ȡһ֡ûavcmpeg4ͷϢͻ
    ʧ*/
    if((eVideoType == VIDEO_CODEC_STD_AVC 
             ||eVideoType == VIDEO_CODEC_STD_MPEG4)
       && (ZM_FileID_3GP == g_VideoFileParam.pFileInfo->eFileType
             || ZM_FileID_MP4 == g_VideoFileParam.pFileInfo->eFileType))
     {
        PhyAddr * pEncHeader = (PhyAddr  *)g_VideoFileParam.pFileInfo->tFileInfo.t_isoInfo.pTrackArray[g_VideoFileParam.uiVideoIndex].tTrackInfo.tVideoParam.pPrivatePara;
        UINT32    uiEncLenth    = g_VideoFileParam.pFileInfo->tFileInfo.t_isoInfo.pTrackArray[g_VideoFileParam.uiVideoIndex].tTrackInfo.tVideoParam.u32PrivateParaLen;

        /* ȡӲBuffer */
        tBuf.bufType                = STREAM_TYPE;
        tBuf.bufSize.streamBufSize  = uiEncLenth;
        tBuf.pDataBuf.streamDataBuf = NULL;
        iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_GET_BUFINFO, &tBuf);
        if(iRet < 0 || NULL == tBuf.pDataBuf.streamDataBuf)
        {            
            zOss_Free(pDecCfg); 
            
            return NULL;
        }

         /* ļƵ֡ӲBuffer׼룬ο޷ */
         zOss_Memcpy(tBuf.pDataBuf.streamDataBuf, pEncHeader, uiEncLenth);
     }
     else
     {
    /* ҪH263ʽȴһ֡ */
    iRet = Video_GetNextVideoFrame(&pData);
    if(iRet != ZMF_RS_OK)
    {
        zOss_Free(pDecCfg);
        return NULL;
    }

    /* ȡӲBuffer */
    tBuf.bufType                = STREAM_TYPE;
    tBuf.bufSize.streamBufSize  = pData->pOutUnit->u32Len;
    tBuf.pDataBuf.streamDataBuf = NULL;
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_GET_BUFINFO, &tBuf);
    if(iRet < 0 || NULL == tBuf.pDataBuf.streamDataBuf)
    {
        ReleaseUnitData(g_VideoFileParam.u32FileID, pData->pOutUnit);  
        
        zOss_Free(pData);
        zOss_Free(pDecCfg); 
        
        return NULL;
    }

    /* ļƵ֡ӲBuffer׼룬ο޷ */
    zOss_Memcpy(tBuf.pDataBuf.streamDataBuf, pData->pOutUnit->pPacket, tBuf.bufSize.streamBufSize);
    ReleaseUnitData(g_VideoFileParam.u32FileID, pData->pOutUnit);
    zOss_Free(pData);
     }

    /* Ϊ֤ԺĲ̲䣬ｫļضλʼĲŵ */
    //rtCode = Seek(g_VideoFileParam.u32FileID, 0);
    rtCode = Video_Seek_Adapt(0);
    if (rtCode != ZMF_RS_OK)
    {
        zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tBuf);
        zOss_Free(pDecCfg); 

        return NULL;
    }    
 
    /* ʼ */
    pDecCfg->tInput.tCodecStd   = eVideoType;
    pDecCfg->tRotate            = ROT_0;
    pDecCfg->tMirror            = MIR_NONE;
    pDecCfg->tOutput.tPixelFmt  = PIXEL_YCbCr420;
    pDecCfg->tInput.pEncHeader  = tBuf.pDataBuf.streamDataBuf;
    pDecCfg->tInput.headerLenth = tBuf.bufSize.streamBufSize;


    /* ȫ */
    if(0 == g_VideoPlayParam.play_rect.sx
       && 0 == g_VideoPlayParam.play_rect.sy
       && g_uiScreenWidth == g_VideoPlayParam.play_rect.width
       && g_uiScreenHeight == g_VideoPlayParam.play_rect.height)
    {
        pDecCfg->tRotate = ROT_270;
    }
    else
    {
        pDecCfg->tRotate = ROT_0;
    }

    /* ʼbufferֶͷţͷ */
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_DECSTART, (VOID *)pDecCfg);
    if(iRet < 0)
    {
        /*
        zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tBuf);
        */
        zOss_Free(pDecCfg); 
        
        return NULL;
    }

    /* һνñ --cyx--20101026*/
    g_VideoControlParam.bFirstVideoDec = TRUE;
    

    /* תȵͼƬĿ */
    if(ROT_90  == pDecCfg->tRotate || ROT_270 == pDecCfg->tRotate)
    {
        UINT32  uiWidth;
        UINT32  uiHeight;
        
        uiWidth  = pDecCfg->tOutput.uiWidth;
        uiHeight = pDecCfg->tOutput.uiHeight;

        pDecCfg->tOutput.uiWidth  = uiHeight;
        pDecCfg->tOutput.uiHeight = uiWidth;        
    }

    /* ֧ƵͼƬΪ16Ƶʽ */
    if(pDecCfg->tOutput.uiWidth % 16 != 0
       || pDecCfg->tOutput.uiHeight % 16 != 0)
    {
        zOss_Free(pDecCfg); 
        
        return NULL;
    }
    
    /* ʼbufferֶͷţͷ */
    /* ͷӲBuffer */
    /*
    zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tBuf);
    */
    
    pDecCfg->tInput.pEncHeader  = NULL;
    pDecCfg->tInput.headerLenth = 0;

    /* ̶ĽBuffer */
    g_VideoControlParam.tDftDecBuf.bufType                   = YUV_TYPE;
    g_VideoControlParam.tDftDecBuf.bufSize.YuvBufSize.ySize  = (pDecCfg->tOutput.uiWidth) * (pDecCfg->tOutput.uiHeight);
    g_VideoControlParam.tDftDecBuf.bufSize.YuvBufSize.uSize  = (pDecCfg->tOutput.uiWidth) * (pDecCfg->tOutput.uiHeight) / 4;
    g_VideoControlParam.tDftDecBuf.bufSize.YuvBufSize.vSize  = (pDecCfg->tOutput.uiWidth) * (pDecCfg->tOutput.uiHeight) / 4;

    g_uiGetYUVBufCount++;
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_GET_BUFINFO, &(g_VideoControlParam.tDftDecBuf));
    if(iRet < 0)
    {   
        zMspCom_Print();
        zOss_Free(pDecCfg); 
        
        return NULL;
    }
    
    return (DecHandle)pDecCfg;
}

/**
 * ƣ Video_VideoDecoderClose 
 *  رƵ
 * ˵ (IN) pHandle  Video_H263DecoderOpenصĽ
 *   ֵ 
 * ˵ 
 */
static VOID Video_VideoDecoderClose(DecHandle pHandle)
{
    T_ZDrvVideo_DecCfg  *pDecCfg = NULL;

    if(NULL == pHandle)
    {
        return;
    }

    /* ͷŽĹ̶Buffer */
    zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&(g_VideoControlParam.tDftDecBuf));

    pDecCfg = (T_ZDrvVideo_DecCfg *)pHandle;
    zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_DECSTOP, (VOID *)(&(pDecCfg->uiVideoInst)));
    zOss_Free(pDecCfg);
    g_VideoControlParam.pVideoHandle = NULL;

    return;
}


/**
 * ƣ Video_OpenVideoDecoder 
 *  Ƶ
 * ˵ (IN) eMediaVtype Ƶݸʽ
 *   ֵ ʧܷNULL
 * ˵ 
 */
static DecHandle Video_OpenVideoDecoder(EMediaVideoType eMediaVType)
{
    DecHandle  pHandle = NULL;

    switch(eMediaVType)
    {
        /*
        case MEDIA_VIDEO_UNKNOWN:
        {
            pHandle = NULL;
            
            break;
        }
        */
        
        case ZM_CODEC_ID_H263:
        case ZM_CODEC_ID_H263_1998:
        case ZM_CODEC_ID_H263_2000:
        {
            pHandle = Video_VideoDecoderOpen(VIDEO_CODEC_STD_H263);
            
            break;
        }
        case ZM_CODEC_ID_MPEG4:
        {
            pHandle = Video_VideoDecoderOpen(VIDEO_CODEC_STD_MPEG4);
            break;
        }
        case ZM_CODEC_ID_H264:
        {
            pHandle = Video_VideoDecoderOpen(VIDEO_CODEC_STD_AVC);
            break;
        }

        default :
        {
            pHandle = NULL;
            
            break;
        }        
    }

    return pHandle;
}

/**
 * ƣ Video_CloseVideoDecoder 
 *  رƵ
 * ˵ (IN) eMediaVtype Ƶݸʽ
 *            (IN) pHandle     
 *   ֵ 
 * ˵ 
 */
static VOID Video_CloseVideoDecoder(EMediaVideoType eMediaVType, DecHandle pHandle)
{
    switch(eMediaVType)
    {
        /*
        case MEDIA_VIDEO_UNKNOWN:
        {           
            break;
        }
        */
        
        case ZM_CODEC_ID_H263:
        case ZM_CODEC_ID_H263_1998:
        case ZM_CODEC_ID_H263_2000:
        case ZM_CODEC_ID_MPEG4:
        case ZM_CODEC_ID_H264:
        {
            Video_VideoDecoderClose(pHandle);
            
            break;
        }

        default :
        {            
            break;
        }        
    }

    return;    
}

/**
 * ƣ Video_MountDecodeLib 
 *  ⲢƵ
 * ˵ 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
static DCAMERA_RETURN_VALUE_E Video_MountDecodeLib(VOID)
{
    SINT32               iRet;
    EMediaAudioType      eMediaAType;
    EMediaVideoType      eMediaVType;

    eMediaAType = g_VideoFileParam.eMediaAType;
    eMediaVType = g_VideoFileParam.eMediaVType;

    /* Ƶ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        EZMFResultCode    rtCode;
        T_MEDIA_AUDIODATA_NODE  *pData = NULL;
        T_Audio_AacParam  tAacParam;

        /* Ƶ */
        iRet = zMspCom_LoadAudioDecodeLib(eMediaAType);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            return DCAMERA_OP_ERROR;
        }
        
        /* Ϊ˻ȡƵĲͨṩһ֡Ƶ */
        //iRet = GetNextFrame(g_VideoFileParam.u32FileID, /*g_VideoFileParam.u32AudioTrack,*/ &pOutUnit);
        iRet = Video_GetNextAudioFrame(&pData);
        if(iRet != ZMF_RS_OK)
        {
            zMspCom_UnLoadAudioDecodeLib(eMediaAType);
            
            return DCAMERA_OP_ERROR;
        }
        
        /* Ϊ֤ԺĲ̲䣬ｫļضλʼĲŵ */
        //rtCode = Seek(g_VideoFileParam.u32FileID, 0);
        rtCode = Video_Seek_Adapt(0);
        if (rtCode != ZMF_RS_OK)
        {
            ReleaseUnitData(g_VideoFileParam.u32FileID, pData->pOutUnit);
            
            zOss_Free(pData);
            zMspCom_UnLoadAudioDecodeLib(eMediaAType);            
            
            return DCAMERA_OP_ERROR;
        } 
        
        /* 3gp,MP4ļеAACƵʽҪϢ */
        if((ZM_CODEC_ID_AAC == g_VideoFileParam.eMediaAType || 
            ZM_CODEC_ID_AAC_PLUS== g_VideoFileParam.eMediaAType) && 
            (ZM_FileID_3GP == g_VideoFileParam.pFileInfo->eFileType
             || ZM_FileID_MP4 == g_VideoFileParam.pFileInfo->eFileType))
        {
            tAacParam.pDecConfig = g_VideoFileParam.pFileInfo->tFileInfo.t_isoInfo.pTrackArray[g_VideoFileParam.uiAudioIndex].tTrackInfo.tAudioParam.pPrivatePara;
            tAacParam.iConfigLen = g_VideoFileParam.pFileInfo->tFileInfo.t_isoInfo.pTrackArray[g_VideoFileParam.uiAudioIndex].tTrackInfo.tAudioParam.u32PrivateParaLen;
        }
        /* AVIļеAACûϢҪֶдһЩ */
        else if((ZM_CODEC_ID_AAC == g_VideoFileParam.eMediaAType || 
            ZM_CODEC_ID_AAC_PLUS== g_VideoFileParam.eMediaAType) && 
            ZM_FileID_AVI == g_VideoFileParam.pFileInfo->eFileType)
        {
            tAacParam.pDecConfig            = NULL;
            tAacParam.iConfigLen            = 0;
            tAacParam.u32Profile_ObjectType = 2;
            tAacParam.u32SampleRate         = g_VideoFileParam.pFileInfo->tFileInfo.t_aviInfo.pStreamInfo[g_VideoFileParam.uiAudioIndex].tStreamInfo.tWaveFmtInfo.u32SamplesPerSec;
        }
        else
        {
            tAacParam.pDecConfig = NULL;
            tAacParam.iConfigLen = 0;
        }

        g_VideoControlParam.pAudioHandle = zMspCom_OpenAudioDecoder(eMediaAType, 
                                                                    pData->pOutUnit->pPacket, 
                                                                    pData->pOutUnit->u32Len, 
                                                                    &tAacParam,                                                                    
                                                                    &g_VideoFileParam.eChannel,
                                                                    &g_VideoFileParam.eSample);

        
        if(NULL == g_VideoControlParam.pAudioHandle)
        {
            ReleaseUnitData(g_VideoFileParam.u32FileID, pData->pOutUnit);
            zOss_Free(pData);

            zMspCom_UnLoadAudioDecodeLib(eMediaAType);
            
            return DCAMERA_OP_ERROR;
        }

        ReleaseUnitData(g_VideoFileParam.u32FileID, pData->pOutUnit);
        zOss_Free(pData);
    }
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        g_VideoControlParam.pVideoHandle = Video_OpenVideoDecoder(eMediaVType);
        if(NULL == g_VideoControlParam.pVideoHandle)
        {
            zMspCom_CloseAudioDecoder(g_VideoControlParam.pAudioHandle);            
            zMspCom_UnLoadAudioDecodeLib(eMediaAType);
            g_VideoControlParam.pAudioHandle = NULL;

            return DCAMERA_OP_ERROR;
        }
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_UnMountDecodeLib 
 *  رƵж
 * ˵ 
 *   ֵ 
 * ˵ 
 */
static VOID Video_UnMountDecodeLib(VOID)
{
    EMediaAudioType      eMediaAType;
    EMediaVideoType      eMediaVType;

    eMediaAType = g_VideoFileParam.eMediaAType;
    eMediaVType = g_VideoFileParam.eMediaVType;

    /* رƵ */
    zMspCom_CloseAudioDecoder(g_VideoControlParam.pAudioHandle);            
    Video_CloseVideoDecoder(eMediaVType, g_VideoControlParam.pVideoHandle);

    g_VideoControlParam.pAudioHandle = NULL;
    g_VideoControlParam.pVideoHandle = NULL;
    
    /* ж */
    zMspCom_UnLoadAudioDecodeLib(eMediaAType);

    return;
}

/**
 * ƣ Video_CreateBuffer 
 *  
 * ˵ (IN)  uiBufLen   дݵĴС
 *   ֵ Ļ׵ַʧܷNULL
 * ˵ 
 */
static T_VideoBuffer *Video_CreateBuffer(UINT32 uiBufLen)
{
    T_VideoBuffer      *pBuffer   = NULL;
    T_VideoBufferData  *pBufArray = NULL;

    /*һ黺*/
    pBuffer = (T_VideoBuffer *)zOss_Malloc(sizeof(T_VideoBuffer));
    if(NULL == pBuffer)
    {
        return NULL;
    }
    zOss_Memset(pBuffer, 0, sizeof(T_VideoBuffer));

    /* 뻺*/
    pBufArray = (T_VideoBufferData *)zOss_Malloc(sizeof(T_VideoBufferData) * uiBufLen); 
    if(NULL == pBufArray)
    {
        zOss_Free(pBuffer);
        
        return NULL;        
    }
    zOss_Memset(pBufArray, 0, sizeof(T_VideoBufferData) * uiBufLen);

    pBuffer->pDataBuf   = pBufArray;
    pBuffer->uiBufLen   = uiBufLen;
    pBuffer->uiUsedLen  = 0;
    pBuffer->uiRdIndex  = 0;    
    pBuffer->uiWrtIndex = 0;

    /*  */
    pBuffer->pBufLock = zOss_CreateMutex(VIDEO_BUFFER_LOCK, ZOSS_NO_INHERIT);
    if(NULL == pBuffer->pBufLock)
    {
        zOss_Free(pBuffer);
        zOss_Free(pBufArray);
        
        return NULL; 
    }
  
    return pBuffer;
}

/**
 * ƣ Video_ReadFromBufferUnlock 
 *  ȡеһԪ
 * ˵ (IN)  pBuffer     ַ
 *            (OUT) pImageData  еƵͼƬ(ȫ)
 *            (OUT) pARGB       ƵͼƬǷΪARGB
 *            (OUT) pPlayRect   Ƶͼʾ
 *            (OUT) pTime       ƵݶӦʱ
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ ע: 1. ȡʱݵûԼ!!!!!!
 *                     ΪƵʱȶȡһ֡Ȼڶ֡
 *                     ʱм㣬Ĺмÿơ
 *                  2. ͼƬݸʽ֧YUV420ARGB
 */
static DCAMERA_RETURN_VALUE_E Video_ReadFromBufferUnlock(T_VideoBuffer *pBuffer,   T_ZDrv_ImageDataBuf  *pImageData,
                                                         BOOL   *pARGB,   RECT_T   *pPlayRect, UINT32   *pTime)
{ 
    if(NULL == pBuffer || NULL == pImageData)
    {        
        return DCAMERA_OP_ERROR;
    }

    /* գû */
    if(0 == pBuffer->uiUsedLen)
    {
        pImageData->YuvBuf.Y  = NULL;
        pImageData->YuvBuf.Cb = NULL;
        pImageData->YuvBuf.Cr = NULL;
        
        return DCAMERA_OP_ERROR;
    }

    /* ȡеԪ */
    *pImageData = (pBuffer->pDataBuf[pBuffer->uiRdIndex]).tImageData;
    if(pPlayRect != NULL)
    {
        *pPlayRect = (pBuffer->pDataBuf[pBuffer->uiRdIndex]).tPlayRect;        
    }
    if(pTime != NULL)
    {
        *pTime = (pBuffer->pDataBuf[pBuffer->uiRdIndex]).uiTime;        
    }
    if(pARGB != NULL)
    {
        *pARGB = (pBuffer->pDataBuf[pBuffer->uiRdIndex]).bARGB;
    }

    /* ߵݵԪ־ */
    (pBuffer->pDataBuf[pBuffer->uiRdIndex]).bUsed = FALSE;

    /* ЧԪؼһ */
    --(pBuffer->uiUsedLen);

    /* ±ƶ */
    ++(pBuffer->uiRdIndex);
    if(pBuffer->uiBufLen == pBuffer->uiRdIndex)
    {
        pBuffer->uiRdIndex = 0;
    }   
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_WriteToBufferLock 
 *  д뻺
 * ˵ (IN)  pBuffer     ַ
 *            (IN) pImageData  д뻺ƵͼƬ(ȫ)
 *            (IN) bARGB       ƵͼƬݸʽǷΪARGB32
 *            (IN) pPlayRect   Ƶͼʾ
 *            (IN) uiTime      ݶӦʱ䲥ʱ
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ ע: ˽ӿڲмı!!!!!!ͼƬݸʽ֧
 *                  ARGB32YUV420
 */
static DCAMERA_RETURN_VALUE_E Video_WriteToBufferLock(T_VideoBuffer *pBuffer,   T_ZDrv_ImageDataBuf  *pImageData, 
                                                      BOOL   bARGB,   RECT_T   *pPlayRect, UINT32    uiTime)
{
    if(NULL == pBuffer || NULL == pImageData || NULL == pPlayRect)
    {
        return DCAMERA_OP_ERROR;
    }

    {
        /* Ԥݱ浽ļУԴ */
        BOOL    bNeedSave = FALSE;
        UINT32  uiWidth  = pPlayRect->width;
        UINT32  uiHeight = pPlayRect->height;
        
        if(bNeedSave)
        {
            if(bARGB)
            {
                SaveARGBData(*pImageData, uiWidth, uiHeight);
            }
            else
            {
                SaveYUVData(*pImageData, uiWidth, uiHeight);
            }
        }
    }

    /*  */
    zOss_GetMutex(pBuffer->pBufLock, ZOSS_WAIT_FOREVER);  

    /*  */
    if(pBuffer->uiBufLen == pBuffer->uiUsedLen)
    {
        zOss_PutMutex(pBuffer->pBufLock);      
        
        return DCAMERA_OP_ERROR;
    }

    (pBuffer->pDataBuf[pBuffer->uiWrtIndex]).bUsed       = TRUE;
    (pBuffer->pDataBuf[pBuffer->uiWrtIndex]).bARGB       = bARGB;    
    (pBuffer->pDataBuf[pBuffer->uiWrtIndex]).uiTime      = uiTime;
    (pBuffer->pDataBuf[pBuffer->uiWrtIndex]).tPlayRect   = *pPlayRect;    
    (pBuffer->pDataBuf[pBuffer->uiWrtIndex]).tImageData  = *pImageData;

    /* »ʹͳƼдָλ */
    ++(pBuffer->uiUsedLen);
    ++(pBuffer->uiWrtIndex);
    if(pBuffer->uiBufLen == pBuffer->uiWrtIndex)
    {
        pBuffer->uiWrtIndex = 0;
    }

    /*  */
    zOss_PutMutex(pBuffer->pBufLock);

    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_ClearBuffer 
 *  ջеݵԪ
 * ˵ (IN)  pBuffer   ַ
 *   ֵ 
 * ˵ ע: 
 */
static VOID Video_ClearBuffer(T_VideoBuffer *pBuffer)
{
    UINT32  uiIndex;
    
    /* գû */
    if(NULL == pBuffer || 0 == pBuffer->uiUsedLen)
    {        
        return;
    }

    for(uiIndex = 0; uiIndex < pBuffer->uiBufLen; uiIndex++)
    {        
        /* ÿδӻȡʱbUsedԱֵΪFALSE */
        if((pBuffer->pDataBuf[uiIndex]).bUsed)
        {
            T_ZDrvVideo_BufInfo  tBufInfo;

            /* ȫARGBƵ */
            if((pBuffer->pDataBuf[uiIndex]).bARGB)
            {
                tBufInfo.bufType             = ARGB_TYPE;
                tBufInfo.bufSize.ARGBBufSize = g_uiDefaultARGBSize / 2;
            }
            else
            {
                /* ȫYUV420 */
                tBufInfo.bufType                   = YUV_TYPE;
                tBufInfo.bufSize.YuvBufSize.ySize  = g_uiDefaultYSize;
                tBufInfo.bufSize.YuvBufSize.uSize  = g_uiDefaultUSize;
                tBufInfo.bufSize.YuvBufSize.vSize  = g_uiDefaultVSize;

                g_uiVideoFreeYUVBufCount++;
            }

            /* ˴bufferΪƵbufferʽ̶ΪYUV420 */
            tBufInfo.pDataBuf = (pBuffer->pDataBuf[uiIndex]).tImageData;

            /* ͷӲBuffer */
            zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tBufInfo);

            (pBuffer->pDataBuf[uiIndex]).bUsed = FALSE;
        }
    }

    /* BufferЧԪظдָ */
    pBuffer->uiUsedLen  = 0;
    pBuffer->uiRdIndex  = 0;
    pBuffer->uiWrtIndex = 0;
    
    return;
}

/**
 * ƣ Video_FreeBuffer 
 *  ͷŻ
 * ˵ (IN)  pBuffer   ַ
 *   ֵ 
 * ˵ ע: ˴ͷݻеԪ
 */
VOID Video_FreeBuffer(T_VideoBuffer *pBuffer)
{
    SINT32 iRet = 0;
    /* ջеݵԪ */
    Video_ClearBuffer(pBuffer);
    
    /* ͷBufferĻ */
    zOss_DeleteMutex(pBuffer->pBufLock);
    
    /* ͷݻ */
    zOss_Free(pBuffer->pDataBuf);
    
    /* ͷŻ */
    zOss_Free(pBuffer);
    
    return;
}

/**
 * ƣ Video_CreateOutPutThread 
 *  Ƶ߳
 * ˵ (IN) 
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷDCAMERA_OP_ERROR
 * ˵ 
 */
static DCAMERA_RETURN_VALUE_E Video_CreateOutPutThread(VOID)
{
    SINT32 iRet = -1;
    
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        /* Ƶ߳ */
        g_VideoControlParam.pAudioOutThread = zOss_CreateThread(AUDIO_OUT_THREAD,
                                                           Audio_OutputThreadEntry,
                                                           0,
                                                           AUDIO_OUT_STACK,
                                                           AUDIO_OUT_PRI,
                                                           1,
                                                           1);
        if(ZOSS_INVALID_THREAD_ID == g_VideoControlParam.pAudioOutThread)
        {            
            return DCAMERA_OP_ERROR;
        }
    }
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        UINT32 uiFrames = 15;  /* ĬΪ15֡/sƵ */
        
        /* Ƶ߳ */
        g_VideoControlParam.pVideoOutThread = zOss_CreateThread(VIDEO_OUT_THREAD,
                                                           Video_OutputThreadEntry,
                                                           0,
                                                           VIDEO_OUT_STACK,
                                                           VIDEO_OUT_PRI,
                                                           1,
                                                           1);
        if(ZOSS_INVALID_THREAD_ID == g_VideoControlParam.pVideoOutThread)
        {   
            if(g_VideoControlParam.pAudioOutThread != ZOSS_INVALID_THREAD_ID)
            {
                zOss_DeleteThread(g_VideoControlParam.pAudioOutThread); 
            }
            
            return DCAMERA_OP_ERROR;
        }  

        uiFrames = ((T_ZDrvVideo_DecCfg *)(g_VideoControlParam.pVideoHandle))->uiFrameRate;

        /* FIXME: ֪ͨGUIлOSDģʽ */
        iRet = Zte_OsdInit(g_VideoControlParam.uiFdVideo, uiFrames);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            if(g_VideoControlParam.pAudioOutThread != ZOSS_INVALID_THREAD_ID)
            {
                zOss_DeleteThread(g_VideoControlParam.pAudioOutThread); 
            }
            zOss_DeleteThread(g_VideoControlParam.pVideoOutThread); 

            return DCAMERA_OP_ERROR;
        }

    }   

    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Video_WaitForOutThreadsEnd 
 *  ȴƵ߳̽
 * ˵ (IN) 
 *   ֵ 
 * ˵ ʹźעЩźӦƵ߳
 *            ʱͷ
 */
static VOID Video_WaitForOutThreadsEnd(VOID)
{
    /* ȴƵ߳̽ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
    }
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);

        /* FIXME: ֪ͨGUIлģʽ */
        {
            Zte_OsdUnInit();
        }
    }     

    return;
}

/**
 * ƣ Video_CloseOutPutDev 
 *  رaudiovideo豸
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_CloseOutPutDev(VOID)
{
    /* رAudio豸Video豸 */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO
       && g_VideoControlParam.uiFdAudio > 0)
    {
        zMspCom_AudioClose();
        g_VideoControlParam.uiFdAudio = 0;
    }
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO
        && g_VideoControlParam.uiFdVideo > 0)
    {
        zMspCom_VideoClose();
        g_VideoControlParam.uiFdVideo = 0;
    }     

    return;
}

/**
 * ƣ Video_ControlProcVideo 
 *  ̴߳ƵݵĶȡ롢д뻺
 * ˵ (IN) uiFrames  ֡Ƶ
 *   ֵ ɹVIDEO_OP_SUCCESS
 * ˵ 
 */ 
static SINT32 Video_ControlProcVideo(UINT32 uiFrames)
{
    BOOL                   bARGB;
    SINT32                 iRet;
    UINT32                 i;
    UINT32                 uiTime;            /* Ƶ֡Ĳʱ     */
    UINT32                 uiVideoInst;       /* ʵ       */
    UINT32                 uiDisWidth;        /* ƵͼƬʾĿ   */
    UINT32                 uiDisHeight;       /* ƵͼƬʾĸ߶   */
    T_MEDIA_VIDEODATA_NODE *pData  = NULL;   
    T_ZDrvVideo_DecCfg    *pDecCfg;           /* ò         */   
    T_ZDrvVideo_BufInfo    tDecBuf;           /* ӲBuffer   */
    T_ZDrvVideo_BufInfo    tPpuBuf;           /* ƵBuffer */
    T_ZDrvVideo_PpuInfo    tPpuInfo;          /*            */
    T_ZDrvVideo_BufInfo    tOsdOutBufInfo = {0}; 

    T_ZDrvVideo_DecParam   tDecParam;         /*              */
    DCAMERA_RETURN_VALUE_E eRet;

    /* Ƶ */
    if(!(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO))
    {
        return VIDEO_OP_SUCCESS;
    }

    g_uiDecCount += uiFrames;

    /* ļѾȡϣֱӷ */
    if(g_VideoControlParam.iVideoExp & VIDEO_FILE_VIDEO_OVER_EXP)
    {
        return VIDEO_OP_DATAEND;
    }
    
    for(i = 0; i < uiFrames; i++)
    {
        /* ȡһ֡Ƶ */
        //iRet = GetNextFrame(g_VideoFileParam.u32FileID, /*g_VideoFileParam.u32VideoTrack,*/ &pOutUnit);
        iRet = Video_GetNextVideoFrame(&pData);
        /* ݶȡ */
        if(ZMF_RS_DATA_READ_OVER == iRet
         || ZMF_RS_VIDEO_TRACK_OVER == iRet
         || ZMF_RS_AUDIO_TRACK_OVER == iRet)
        {
            /* ¼쳣־--Ƶݶȡ */
            g_VideoControlParam.iVideoExp |= VIDEO_FILE_VIDEO_OVER_EXP;
            g_VideoControlParam.iVideoExp |= VIDEO_FILE_AUDIO_OVER_EXP;
            /* һ֡ */
            if(0 == i)
            {
                zOss_Printf(1, 1, "video play over!");
                return VIDEO_OP_DATAEND; 
            }
            else
            {
                /* X֡ */
                
                return VIDEO_OP_SUCCESS;
            }
        }
        /* ݶȡ */
        if(iRet != ZMF_RS_OK)
        {
            g_VideoControlParam.iVideoExp |= VIDEO_FILE_EXP;
            zMspCom_Print();
            
            return VIDEO_OP_FILE_ERR;
        }

        
        /* H264 MPEG4 һνҪͷϢ͵һ֡
              ͬʱ*/
        if(g_VideoControlParam.bFirstVideoDec == TRUE && 
           (g_VideoFileParam.eMediaVType == ZM_CODEC_ID_MPEG4
            ||g_VideoFileParam.eMediaVType == ZM_CODEC_ID_H264))
        {
            PhyAddr * pEncHeader = (PhyAddr  *)g_VideoFileParam.pFileInfo->tFileInfo.t_isoInfo.pTrackArray[g_VideoFileParam.uiVideoIndex].tTrackInfo.tVideoParam.pPrivatePara;
            UINT32    uiEncLenth    = g_VideoFileParam.pFileInfo->tFileInfo.t_isoInfo.pTrackArray[g_VideoFileParam.uiVideoIndex].tTrackInfo.tVideoParam.u32PrivateParaLen;

            g_VideoControlParam.bFirstVideoDec = FALSE;
        
        /* ȡӲBuffer */
        tDecBuf.bufType                = STREAM_TYPE;
            tDecBuf.bufSize.streamBufSize  = pData->pOutUnit->u32Len + uiEncLenth;
            tDecBuf.pDataBuf.streamDataBuf = NULL;
            iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_GET_BUFINFO, &tDecBuf);
            if(iRet < 0 || NULL == tDecBuf.pDataBuf.streamDataBuf)
            {
                g_VideoControlParam.iVideoExp |= VIDEO_BUF_EXP;            
                ReleaseUnitData(g_VideoFileParam.u32FileID, pData->pOutUnit);
                
                zOss_Free(pData);
                zMspCom_Print();
                
                return VIDEO_OP_BUFFER_ERR;
            }
            
            /* ļƵ֡ӲBuffer׼룬ο޷ */
            zOss_Memcpy(tDecBuf.pDataBuf.streamDataBuf, pEncHeader, uiEncLenth);
            zOss_Memcpy(tDecBuf.pDataBuf.streamDataBuf + uiEncLenth, 
                                  pData->pOutUnit->pPacket, 
                                  pData->pOutUnit->u32Len);
        }
        else
        {
        /* ȡӲBuffer */
        tDecBuf.bufType                = STREAM_TYPE;
        tDecBuf.bufSize.streamBufSize  = pData->pOutUnit->u32Len;
        tDecBuf.pDataBuf.streamDataBuf = NULL;
        iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_GET_BUFINFO, &tDecBuf);
        if(iRet < 0 || NULL == tDecBuf.pDataBuf.streamDataBuf)
        {
            g_VideoControlParam.iVideoExp |= VIDEO_BUF_EXP;            
            ReleaseUnitData(g_VideoFileParam.u32FileID, pData->pOutUnit);
            
            zOss_Free(pData);
            zMspCom_Print();
            
            return VIDEO_OP_BUFFER_ERR;
        }
        
        /* ļƵ֡ӲBuffer׼룬ο޷ */
        zOss_Memcpy(tDecBuf.pDataBuf.streamDataBuf, pData->pOutUnit->pPacket, tDecBuf.bufSize.streamBufSize);
        }

        /* Ƶ֡ʱһms */
        uiTime = (UINT32)((pData->pOutUnit->u32DecodeTime / g_VideoFileParam.f64VideoTimeScale) * 1000);

        /* ͷƵ֡ */
        ReleaseUnitData(g_VideoFileParam.u32FileID, pData->pOutUnit); 
        
        zOss_Free(pData);

        /* ȡƵ */
        pDecCfg = (T_ZDrvVideo_DecCfg *)g_VideoControlParam.pVideoHandle;
        uiVideoInst = pDecCfg->uiVideoInst;

        /* ׼ʼһ֡Ƶ IOCTL_VIDEO_DECONEFRAME */
        tDecParam.uiVideoInst = uiVideoInst;
        tDecParam.pDataIn     = tDecBuf.pDataBuf.streamDataBuf;
        tDecParam.uiLenIn     = tDecBuf.bufSize.streamBufSize;
        tDecParam.hasDecdata  = TRUE;

        /* ȡƵͼƬʾĿ */
        uiDisWidth  = g_VideoPlayParam.play_rect.width;
        uiDisHeight = g_VideoPlayParam.play_rect.height;

        /* ԤʾͼƬĿĿ߲һ£ʱ뵽̶ĽBuffer */
        if(pDecCfg->tOutput.uiWidth != uiDisWidth || pDecCfg->tOutput.uiHeight != uiDisHeight
            || /* Ŀ߱Ϊ SCREEN_WIDTHSCREEN_HEIGHTʱȫģʽҪߴ*/
            (pDecCfg->tOutput.uiWidth == uiDisWidth && pDecCfg->tOutput.uiHeight == uiDisHeight
            && g_uiScreenWidth == uiDisWidth && g_uiScreenHeight == uiDisHeight))
        {
            /* ý */
            tDecParam.uiStride = pDecCfg->tOutput.uiWidth;
            tDecParam.pDataOut = g_VideoControlParam.tDftDecBuf.pDataBuf;
                
            /* Bufferڵӿʱͷ */
            iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_DECONEFRAME, &tDecParam);    
            if(iRet < 0)
            {
                /* ڴ˽Bufferǹ̶ģڴ˴ͷ */
                zMspCom_Print();
                
                return VIDEO_OP_DECODE_ERR;
            }            
            
            {
                /* Ԥݱ浽ļУԴ */
                BOOL    bNeedSave = FALSE;
                UINT32  uiWidth  = 176;
                UINT32  uiHeight = 144;
                
                if(bNeedSave)
                {
                   
                    SaveYUVData(tDecParam.pDataOut, uiWidth, uiHeight);
                }
            }

        }
        else /* ԤʾͼƬĿĿһʱ뵽ȫĺɫ */
        {
            T_ZDrv_YuvBuf tTempYuvBuf;            

            bARGB = FALSE;
            
            /* ȡƵӲBufferȫʱƵݸʽΪYUV420 */
            /* ȫģʽµĽ룬ͨСƵͼƬֱӽںɫ */
            tPpuBuf.bufType                   = YUV_TYPE;
            tPpuBuf.bufSize.YuvBufSize.ySize  = g_uiDefaultYSize;
            tPpuBuf.bufSize.YuvBufSize.uSize  = g_uiDefaultUSize;
            tPpuBuf.bufSize.YuvBufSize.vSize  = g_uiDefaultVSize;

            g_uiGetYUVBufCount++;
            iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_GET_BUFINFO, &tPpuBuf);
            if(iRet < 0)
            {   
                g_VideoControlParam.iVideoExp |= VIDEO_BUF_EXP;
                zMspCom_Print();
                
                return VIDEO_OP_BUFFER_ERR;
            }             

            /* ɫ */
            zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Y,  0,   tPpuBuf.bufSize.YuvBufSize.ySize);
            zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Cb, 128, tPpuBuf.bufSize.YuvBufSize.uSize);
            zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Cr, 128, tPpuBuf.bufSize.YuvBufSize.vSize);

            /* עYUVΪPhyAddr *ָͣӷʱ1ڼ4 */
            tTempYuvBuf.Y  = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Y  + g_VideoControlParam.uiYOffset);
            tTempYuvBuf.Cb = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Cb + g_VideoControlParam.uiUOffset);
            tTempYuvBuf.Cr = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Cr + g_VideoControlParam.uiVOffset);

            /* ý */
            tDecParam.uiStride        = g_uiScreenWidth;            
            tDecParam.pDataOut.YuvBuf = tTempYuvBuf; 
                
            /* Bufferڵӿʱͷ */
            iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_DECONEFRAME, &tDecParam);    
            if(iRet < 0)
            {
                /* ͷŽBuffer */
                zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tPpuBuf);
                zMspCom_Print();
                
                return VIDEO_OP_DECODE_ERR;
            }
        }

        /* FIXME: ӦötDecParam.outputtypeжϣH263
         * Լ򵥣˴ûϸǣԺҪд
         */
        {
            
        }

        /* ԤʾͼƬĿĿ߲һ£ʱ뵽̶ĽBuffer */
        if(pDecCfg->tOutput.uiWidth != uiDisWidth || pDecCfg->tOutput.uiHeight != uiDisHeight
            || /* Ŀ߱Ϊ SCREEN_WIDTHSCREEN_HEIGHTʱȫģʽҪߴ*/
            (pDecCfg->tOutput.uiWidth == uiDisWidth && pDecCfg->tOutput.uiHeight == uiDisHeight
            && g_uiScreenWidth == uiDisWidth && g_uiScreenHeight == uiDisHeight))
        {
            /* ȫģʽƵֱˢҪOSDĻϴ
             * ˴˴ݸʽΪARGB 
             */            
            if(g_uiScreenWidth == uiDisWidth && g_uiScreenHeight == uiDisHeight)
            {
                /* ͼŴȫ */
                bARGB = TRUE;
                
                /* ȡƵӲBufferƵȫʾʱΪARGBʽ */
                tPpuBuf.bufType             = ARGB_TYPE;
                /* ˴ΪRGB565ݣֻһĿռ */
                tPpuBuf.bufSize.ARGBBufSize = g_uiDefaultARGBSize / 2;

                iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_GET_BUFINFO, &tPpuBuf);
                if(iRet < 0 || NULL == tPpuBuf.pDataBuf.ARGBdataBuf)
                {   
                    /* ڴ˽Bufferǹ̶ģڴ˴ͷ */
                    g_VideoControlParam.iVideoExp |= VIDEO_BUF_EXP;                 
                    zMspCom_Print();
                    
                    return VIDEO_OP_BUFFER_ERR;
                }    

                /* ppuͼƬϢ */
                tPpuInfo.outputInfo.uiWidth       = g_uiScreenWidth;
                tPpuInfo.outputInfo.uiHeight      = g_uiScreenHeight;
                tPpuInfo.outputInfo.uiStride      = g_uiScreenWidth;
                tPpuInfo.outputInfo.tPixelFmt     = PIXEL_RGB565;//PIXEL_ARGB888;              /* YUV420 */
                tPpuInfo.outputInfo.pOutPutbuffer = tPpuBuf.pDataBuf;  
            
            }
            else
            {
                T_ZDrv_YuvBuf tTempYuvBuf;

                bARGB = FALSE;
                
                /* ȡƵӲBufferȫʱƵݸʽΪYUV420 */
                /* ȫģʽµƵͨСƵͼƬźںɫı */
                tPpuBuf.bufType                   = YUV_TYPE;
                tPpuBuf.bufSize.YuvBufSize.ySize  = g_uiDefaultYSize;
                tPpuBuf.bufSize.YuvBufSize.uSize  = g_uiDefaultUSize;
                tPpuBuf.bufSize.YuvBufSize.vSize  = g_uiDefaultVSize;

                g_uiGetYUVBufCount++;
                iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_GET_BUFINFO, &tPpuBuf);
                if(iRet < 0)
                {   
                    /* ڴ˽Bufferǹ̶ģڴ˴ͷ */
                    g_VideoControlParam.iVideoExp |= VIDEO_BUF_EXP;
                    zMspCom_Print();
                    
                    return VIDEO_OP_BUFFER_ERR;
                }             

                /* ɫ */
                zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Y,  0,   tPpuBuf.bufSize.YuvBufSize.ySize);
                zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Cb, 128, tPpuBuf.bufSize.YuvBufSize.uSize);
                zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Cr, 128, tPpuBuf.bufSize.YuvBufSize.vSize);

                /* עYUVΪPhyAddr *ָͣӷʱ1ڼ4 */
                tTempYuvBuf.Y  = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Y  + g_VideoControlParam.uiYOffset);
                tTempYuvBuf.Cb = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Cb + g_VideoControlParam.uiUOffset);
                tTempYuvBuf.Cr = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Cr + g_VideoControlParam.uiVOffset);
                
                /* ppuͼƬϢ */
                tPpuInfo.outputInfo.uiWidth              = uiDisWidth;       /* ͼƬ       */
                tPpuInfo.outputInfo.uiHeight             = uiDisHeight;      /* ͼƬ       */
                tPpuInfo.outputInfo.uiStride             = g_uiScreenWidth;     /*            */
                tPpuInfo.outputInfo.tPixelFmt            = PIXEL_YCbCr420;   /* YUV420           */
                tPpuInfo.outputInfo.pOutPutbuffer.YuvBuf = tTempYuvBuf;      /* ͼƬʼַ */
            }

            /* ppuϢ */
            tPpuInfo.inputInfo.uiStartX       = 0;
            tPpuInfo.inputInfo.uiStartY       = 0;
            tPpuInfo.inputInfo.uiWidth        = pDecCfg->tOutput.uiWidth;
            tPpuInfo.inputInfo.uiHeight       = pDecCfg->tOutput.uiHeight;  
            tPpuInfo.inputInfo.uiStride       = pDecCfg->tOutput.uiWidth;    
            tPpuInfo.inputInfo.tPixelFmt      = pDecCfg->tOutput.tPixelFmt;  /* YUV420 */
            tPpuInfo.inputInfo.pInPutbuffer   = tDecParam.pDataOut; 
            tPpuInfo.tMirror   = MIR_NONE;
            tPpuInfo.tRotate  = ROT_0;

            /* OSDʹ */
            tPpuInfo.osdInfo.bEnable          = FALSE;
#if 0
            /* ΪƵоƬȱʱӣȫʱҲһosd */
            if(SCREEN_WIDTH == uiDisWidth && SCREEN_HEIGHT == uiDisHeight)
            {
                tOsdOutBufInfo.bufType             = ARGB_TYPE;
                tOsdOutBufInfo.bufSize.ARGBBufSize = g_uiDefaultARGBSize;
 
                iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_GET_BUFINFO, &tOsdOutBufInfo);
                if(iRet < 0 || NULL == tOsdOutBufInfo.pDataBuf.ARGBdataBuf)
                {   
                    /* ڴ˽Bufferǹ̶ģڴ˴ͷ */
                    g_VideoControlParam.iVideoExp |= VIDEO_BUF_EXP;                 
                    zMspCom_Print();
                    
                    return VIDEO_OP_BUFFER_ERR;
                }

                zOss_Memset(tOsdOutBufInfo.pDataBuf.ARGBdataBuf, 0, g_uiDefaultARGBSize);
            
                tPpuInfo.osdInfo.bEnable          = TRUE;
                tPpuInfo.osdInfo.tInput.uiWidth   = SCREEN_WIDTH ;//- 16;//cyx ƵоƬȱ
                tPpuInfo.osdInfo.tInput.uiHeight  = SCREEN_HEIGHT;// - 16;//cyx ƵоƬȱ
                tPpuInfo.osdInfo.tInput.uiStride  = SCREEN_WIDTH;
                tPpuInfo.osdInfo.globalEnable     = FALSE;
                tPpuInfo.osdInfo.globalAlpha      = 0;
                tPpuInfo.osdInfo.pImg             = tOsdOutBufInfo.pDataBuf.ARGBdataBuf;
                tPpuInfo.osdInfo.uiOutputStartX   = 0;
                tPpuInfo.osdInfo.uiOutputStartY   = 0;
           }

           if(176 == uiDisWidth && 144 == uiDisHeight)
            {
                tOsdOutBufInfo.bufType             = ARGB_TYPE;
                tOsdOutBufInfo.bufSize.ARGBBufSize = 176 * 144 * 4;
 
                iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_GET_BUFINFO, &tOsdOutBufInfo);
                if(iRet < 0 || NULL == tOsdOutBufInfo.pDataBuf.ARGBdataBuf)
                {   
                    /* ڴ˽Bufferǹ̶ģڴ˴ͷ */
                    g_VideoControlParam.iVideoExp |= VIDEO_BUF_EXP;                 
                    zMspCom_Print();
                    
                    return VIDEO_OP_BUFFER_ERR;
                }

                zOss_Memset(tOsdOutBufInfo.pDataBuf.ARGBdataBuf, 0, g_uiDefaultARGBSize);
            
                tPpuInfo.osdInfo.bEnable          = TRUE;
                tPpuInfo.osdInfo.tInput.uiWidth   = 176 ;//- 16;//cyx ƵоƬȱ
                tPpuInfo.osdInfo.tInput.uiHeight  = 144;// - 16;//cyx ƵоƬȱ
                tPpuInfo.osdInfo.tInput.uiStride  = 176;
                tPpuInfo.osdInfo.globalEnable     = FALSE;
                tPpuInfo.osdInfo.globalAlpha      = 0;
                tPpuInfo.osdInfo.pImg             = tOsdOutBufInfo.pDataBuf.ARGBdataBuf;
                tPpuInfo.osdInfo.uiOutputStartX   = 0;
                tPpuInfo.osdInfo.uiOutputStartY   = 0;
           }

#endif            

            /* ƵƵ */
            iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_POSTPROCESS, &tPpuInfo);
            if(iRet < 0)
            {
                /* ڴ˽Bufferǹ̶ģڴ˴ͷţ˴ͷŵppuBuffer */
                zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tPpuBuf);
                zMspCom_Print();
#if 0   
                zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tOsdOutBufInfo);
#endif                
                return VIDEO_OP_POSTPPU_ERR;
            }                 
#if 0
            zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tOsdOutBufInfo);
#endif            
        }

        /* Ƶ֡Ƶ */
        /* Ƶ֡ݸʽǸʾֵģʾΪȫ
         * ݸʽΪARGBΪYUV420
         */
        eRet = Video_WriteToBufferLock(g_VideoControlParam.pVideoBuffer,
                                       &(tPpuBuf.pDataBuf),  
                                       bARGB,
                                       &(g_VideoPlayParam.play_rect), 
                                       uiTime);  
        if(eRet != DCAMERA_OP_SUCCESS)
        {
            /* ´bufferƵ߳ͷ */
            zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tPpuBuf);
            zMspCom_Print();
            
            return VIDEO_OP_ERROR;
        }
    }

    
    return VIDEO_OP_SUCCESS;    
}

/**
 * ƣ Video_RefreshAudioBuffer 
 *  ȡƵbufferȫֱϢ
 * ˵ 
 *   ֵ ɹVIDEO_OP_SUCCESS
 * ˵ ˽ӿ̵߳Ŀʼлʹ(ʼšָ
 *            šضλŶʹõʼ);Ƶ߳
 *            ϢҲʹõ
 */
static SINT32 Video_RefreshAudioBuffer(VOID)
{
    SINT32               iRet = -1;
    T_ZDrvAudio_BufInfo  tBufInfo;

    /* Ƶ */
    if(!(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO))
    {
        return VIDEO_OP_SUCCESS;
    }

    /* ȻbufferδʹϣͣĻָ
     * ͣ״̬£ƵϢᱻʱbuffer
     */
    if(AUDIO_BUF_UNUSED == g_VideoControlParam.tAudioBuffer.eBufState)
    {
        return VIDEO_OP_SUCCESS; 
    }

    /* ȡBuffer */
    tBufInfo.buf        = NULL;
    tBufInfo.buffersize = 0;
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_GET_BUFFER, (VOID *)&tBufInfo);
    if(iRet < 0 || NULL == tBufInfo.buf)
    {
        zMspCom_Print();
        return VIDEO_OP_ERROR;
    }

    /* 뵽Bufferĵַ볤ȼ¼ȫϢУһ
     * ߳Buffer߳м¼ԺÿζƵ
     * ̸߳´Ϣ
     */
    g_VideoControlParam.tAudioBuffer.pPhyBuffer = tBufInfo.buf;
    g_VideoControlParam.tAudioBuffer.uiBufLen   = tBufInfo.buffersize;
    g_VideoControlParam.tAudioBuffer.uiUsedLen  = 0;
    g_VideoControlParam.tAudioBuffer.eBufState  = AUDIO_BUF_UNUSED;

    return VIDEO_OP_SUCCESS;    
}

/**
 * ƣ Video_ControlInitAudioProc 
 *  ƵʼҪͨ
 *            ʡʼȲ
 * ˵ 
 *   ֵ ɹVIDEO_OP_SUCCESS
 * ˵ 
 */
static SINT32 Video_ControlInitAudioProc(VOID)
{
    SINT32                      iRet        = -1;
    T_MSP_CHANNEL_OUTPUT        outputpath;      
    T_ZDrvAudio_PlayParam       tPlayParam;
    T_ZDrvAudio_SampleRate      eSample     = AUDIO_RATE_8_KHZ;          
    T_MSP_OUTPUT_VOLUME_LEVEL   outputVol;
    BOOL                        bMute;

    /* FIXME: ͨӦĬֵ */
    
    /* Ƶ */
    if(!(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO))
    {
        return VIDEO_OP_SUCCESS;
    }

    /* ֵƵʽйأAMRʽʹ̶Ϊ8K */
    eSample = g_VideoFileParam.eSample;
        
    /* ֵƵʽйأ3֡AMRPCMݳΪ960ֽڡ */
    tPlayParam.channel    = g_VideoFileParam.eChannel;
    tPlayParam.buffersize = g_VideoFileParam.uiAudioBufsize;                                   

    /* ·ʡصʼ */
    /* ȡ */
    iRet = zMspCom_GetOutputVol(&outputVol);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return VIDEO_OP_ERROR;
    }

    /* ȡͨ */
    iRet = zMspCom_GetOutputChannel(&outputpath);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return VIDEO_OP_ERROR;
    }
    
    /* ȡ*/
    iRet = zMspCom_GetMute(&bMute);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return VIDEO_OP_ERROR;
    }
    
    /* ͨ */
    iRet = zMspCom_SetOutputChannel(outputpath);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        return VIDEO_OP_ERROR;
    }

    /*  */
    iRet = zMspCom_SetOutputVol(outputVol);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        return VIDEO_OP_ERROR;
    }

    /* þ */
    iRet = zMspCom_SetMute(bMute);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        return VIDEO_OP_ERROR;
    }

    #if 0
    iRet = zMspCom_SetOutputVol(g_VideoPlayParam.volume);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        return VIDEO_OP_ERROR;
    }
    iRet = zMspCom_SetOutputChannel(g_VideoPlayParam.channel);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        return VIDEO_OP_ERROR;
    }
    #endif
    
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_SET_SAMPLE,      (VOID *)&eSample);
    if(iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        return VIDEO_OP_ERROR;
    }
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_SET_CALLBACK,    (VOID *)Video_DrvNotifyCB);
    if(iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        return VIDEO_OP_ERROR;
    }
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_START,      (VOID *)&tPlayParam);        
    if(iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        return VIDEO_OP_ERROR;
    }
    
    return VIDEO_OP_SUCCESS;    
}

/**
 * ƣ Video_ControlReleaseAudioProc 
 *  ͷVideo_ControlInitAudioProcԴ
 * ˵ 
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlReleaseAudioProc(VOID)
{
    zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_STOP, NULL);    

    /* STOP¼ȫƵϢ */
    zOss_Memset(&(g_VideoControlParam.tAudioBuffer), 0, sizeof(T_AudioBuffer));

    g_VideoControlParam.tAudioOutInfo.uiWriteCount  = 0;
    g_VideoControlParam.tAudioOutInfo.uiRemainCount = 0;

    return;
}

/**
 * ƣ Video_ControlProcAudio 
 *  ̴߳ƵݵĶȡ롢д뻺
 * ˵ (IN) 
 *   ֵ ɹVIDEO_OP_SUCCESS
 * ˵ 
 */
#if 0
static SINT32 Video_ControlProcAudio(VOID)
{
    VOID                       *pPhyBuf         = NULL;     
    SINT32                      iRet            = 0;
    UINT32                      uiBufLen        = 0;
    UINT32                      uiUsedSize      = 0;
    T_ZMFOutPutUnit            *pOutUnit        = NULL;    
    
    /* Ƶ */
    if(!(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO))
    {
        return VIDEO_OP_SUCCESS;
    }
    
    /* ȡõBufferַϢ */
    pPhyBuf  = g_VideoControlParam.tAudioBuffer.pPhyBuffer;
    uiBufLen = g_VideoControlParam.tAudioBuffer.uiBufLen;
    
    /* һ֡ */
    iRet = GetNextFrame(g_VideoFileParam.u32FileID, /*g_VideoFileParam.u32AudioTrack, */&pOutUnit);

    /* ݶȡ */
    if(ZMF_RS_DATA_READ_OVER == iRet)
    {
        /* ¼쳣־--Ƶݶȡ */
        g_VideoControlParam.iVideoExp |= VIDEO_FILE_AUDIO_OVER_EXP;


        /* ˴ݣΪͷbuffer֪ͨ */
        uiBufLen = uiBufLen <= 320 ? uiBufLen : 320;
        zOss_Memset(pPhyBuf, 0, uiBufLen);
        iRet = zDrv_Write(g_VideoControlParam.uiFdAudio, (const VOID *)pPhyBuf, uiBufLen);
        if(iRet < 0)
        {
            zMspCom_Print();
            return VIDEO_OP_ERROR;
        }
        
        return VIDEO_OP_DATAEND;            
    }    
    else if(iRet != ZMF_RS_OK)   /* ݶȡ */
    {
        zMspCom_Print();
        return VIDEO_OP_ERROR;
    }

    /* FIXME: Ƶ֡룬˴ֻһ֡Ƶ */
    uiUsedSize = zMspCom_AudioDecode(g_VideoControlParam.pAudioHandle, 
                                     g_VideoFileParam.eMediaAType,
                                     pOutUnit, pPhyBuf, uiBufLen);

    /* ¼Ƶʱ*/
    pOutUnit->u32DecodeTime = (UInt32)((pOutUnit->u32DecodeTime / g_VideoFileParam.f64AudioTimeScale) * 1000);

    /* ƵеBufferʹóȣݶӦʼʱ */
    g_VideoControlParam.tAudioBuffer.uiUsedLen   = uiUsedSize;
    g_VideoControlParam.tAudioBuffer.uiStartTime = pOutUnit->u32DecodeTime;
    g_VideoControlParam.tAudioBuffer.uiEndTime   = pOutUnit->u32DecodeTime;
    g_VideoControlParam.tAudioBuffer.eBufState   = AUDIO_BUF_USED;

    /* ͷƵ뵥ԪԴ */
    ReleaseUnitData(g_VideoFileParam.u32FileID, pOutUnit);

    return VIDEO_OP_SUCCESS;
}
#endif

#if 1
static SINT32 Video_ControlProcAudio(VOID)
{
    VOID               *pPhyBuf         = NULL;     
    SINT32              iRet            = -1;
    UINT32              uiBufLen        = 0;
    UINT32              uiUsedSize      = 0;
    UINT32              uiTotalLen      = 0;   /* ѽPCMݳ */     
    UINT32              uiReadCount     = 0;   /* ѽ֡        */    
    UINT32              uiMaxFrameData  = 320;
    T_MEDIA_AUDIODATA_NODE    *pData         = NULL; 
    T_Audio_DecodeParam       tAudioDecParam = {0,};
    
    /* Ƶ */
    if(!(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO))
    {
        return VIDEO_OP_SUCCESS;
    }
    
    /* ȡõBufferַϢ */
    pPhyBuf  = g_VideoControlParam.tAudioBuffer.pPhyBuffer;
    uiBufLen = g_VideoControlParam.tAudioBuffer.uiBufLen;

    /* һ֡ƵΪPCMռ */
    uiMaxFrameData = g_VideoFileParam.uiMaxFramePcmLen;
    do
    {        
        /* һ֡ */
        //iRet = GetNextFrame(g_VideoFileParam.u32FileID,/* g_VideoFileParam.u32AudioTrack,*/ &pOutUnit);
        iRet = Video_GetNextAudioFrame(&pData);
 
        /* ݶȡ */
        if(ZMF_RS_DATA_READ_OVER == iRet
           || ZMF_RS_VIDEO_TRACK_OVER == iRet
           || ZMF_RS_AUDIO_TRACK_OVER == iRet)
        {
            /* ¼쳣־--Ƶݶȡ */
            g_VideoControlParam.iVideoExp |= VIDEO_FILE_AUDIO_OVER_EXP;
            g_VideoControlParam.iVideoExp |= VIDEO_FILE_VIDEO_OVER_EXP;

            /* ˴ݣΪͷbuffer֪ͨ */
            if(0 == uiReadCount)
            {
                uiBufLen = uiBufLen <= 320 ? uiBufLen : 320;
                zOss_Memset(pPhyBuf, 0, uiBufLen);
                g_VideoControlParam.tAudioBuffer.eBufState = AUDIO_BUF_USED;
                iRet = zDrv_Write(g_VideoControlParam.uiFdAudio, (const VOID *)pPhyBuf, uiBufLen);
                if(iRet < 0)
                {
                    zMspCom_Print();
                    return VIDEO_OP_ERROR;
                }

                zOss_Printf(1, 1, "audio play over!");
                
                return VIDEO_OP_DATAEND; 
            }
            else
            {
                return VIDEO_OP_SUCCESS;
            }
        }    
        else if(iRet != ZMF_RS_OK)   /* ݶȡ */
        {
            g_VideoControlParam.iVideoExp |= VIDEO_FILE_EXP;            
            zMspCom_Print();
            
            return VIDEO_OP_FILE_ERR;
        }

        //zOss_Printf(1, 1, "get an audio frame!");

        tAudioDecParam.pHandle     = g_VideoControlParam.pAudioHandle;
        tAudioDecParam.pOutUnit    = pData->pOutUnit;
        tAudioDecParam.pPhyBuf     = pPhyBuf;
        tAudioDecParam.uiLen       = uiBufLen;
        /* FIXME: Ƶ֡룬˴ֻһ֡Ƶ */
        uiUsedSize = zMspCom_AudioDecode(&tAudioDecParam);

        pPhyBuf  = (VOID *)((CHAR *)pPhyBuf + uiUsedSize);
        uiBufLen = uiBufLen - uiUsedSize;
        
        /* ¼Ƶʱ */
        pData->pOutUnit->u32DecodeTime = (UInt32)((pData->pOutUnit->u32DecodeTime / g_VideoFileParam.f64AudioTimeScale) * 1000);

        uiTotalLen += uiUsedSize;
        
        /* ƵеBufferʹóȣݶӦʼʱ */
        g_VideoControlParam.tAudioBuffer.uiUsedLen   = uiTotalLen;

        if(0 == uiReadCount)
        {
            g_VideoControlParam.tAudioBuffer.uiStartTime = pData->pOutUnit->u32DecodeTime;
            g_VideoControlParam.tAudioBuffer.uiEndTime   = pData->pOutUnit->u32DecodeTime;
            g_VideoControlParam.tAudioBuffer.eBufState   = AUDIO_BUF_USED;           
        }
        else
        {
            g_VideoControlParam.tAudioBuffer.uiEndTime   = pData->pOutUnit->u32DecodeTime;
        }

        /* ͷƵ뵥ԪԴ */
        ReleaseUnitData(g_VideoFileParam.u32FileID, pData->pOutUnit);
        zOss_Free(pData);
        uiReadCount++;
    }while(uiBufLen >= uiMaxFrameData);
    

    return VIDEO_OP_SUCCESS;
}
#endif

/**
 * ƣ Video_RefreshYUVOffset 
 *  Ƶĺʱƫ(ȫģʽ)
 * ˵ (IN) 
 *   ֵ 
 * ˵ ΪЧʹ
 */
static VOID Video_RefreshYUVOffset(VOID)
{
    UINT32  uiXpos = 0;
    UINT32  uiYpos = 0;

    /* ƵͼƬYUVƫ */            
    uiXpos = g_VideoPlayParam.play_rect.sx;
    uiYpos = g_VideoPlayParam.play_rect.sy;

    /* עYUVΪPhyAddr *ָͣӷʱ1ڼ4 */
    g_VideoControlParam.uiYOffset = g_uiScreenWidth * uiYpos + uiXpos;
    g_VideoControlParam.uiUOffset = g_uiScreenWidth * uiYpos / 4 + uiXpos / 2;
    g_VideoControlParam.uiVOffset = g_uiScreenWidth * uiYpos / 4 + uiXpos / 2;

    return;    
}

/**
 * ƣ Video_ControlProcStartMsg 
 *  ʼϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ ĳδҪϸ
 */
static VOID Video_ControlProcStartMsg(VOID)
{
    SINT32  iRet = -1;

    /* (ȫģʽ)Ƶĺʱƫ꣬
     * Чʣÿνظ 
     */
    Video_RefreshYUVOffset();
    
    /* Ƶݶȡ롢д뻺 */
    iRet = Video_ControlProcVideo(VIDEO_BUFFER_LEN);
    if(iRet != VIDEO_OP_SUCCESS)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;
    }
    
    /* Ƶͨʣÿʼ */
    iRet = Video_ControlInitAudioProc();    
    if(iRet != VIDEO_OP_SUCCESS)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;        
    }

    /* Ƶ */
    iRet = Video_RefreshAudioBuffer();
    if(iRet != VIDEO_OP_SUCCESS)
    {
        zMspCom_Print();
        return;
    }    
    
    /* Ƶݶȡд뻺 */    
    iRet = Video_ControlProcAudio();
    if(iRet != VIDEO_OP_SUCCESS)
    {
        Video_ControlReleaseAudioProc();
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;        
    }

    /* Ƶ߳ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pAudioOutThread, EV_AUDIO_FIRST_OUT);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            Video_ControlReleaseAudioProc();
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;
        }
    }
    
    /* Ƶ߳ */    
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {       
        iRet = zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_FIRST_OUT);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            Video_ControlReleaseAudioProc();
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;
        }
    } 

    /* ǰ״̬ǨƵPLAY */
    g_Curstate = VIDEO_PLAY_STATE_PLAY;

    return;
}

/**
 * ƣ Video_ControlProcPauseMsg 
 *  ͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlProcPauseMsg(VOID)
{
    SINT32  iRet = -1;

    /* ֪ͨƵ߳ͣ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_OUT_PAUSE);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;            
            zMspCom_Print();
            return;
        }
    }
    
    /* ֪ͨƵ߳ͣ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pAudioOutThread, EV_AUDIO_OUT_PAUSE);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;
        }
    }

    /* ȡͬźȴƵ̴߳ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
    }
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
    }

    /* Ƶģ״̬ */
    if(DCAMERA_OP_SUCCESS == g_ErrorCode)
    {
        g_Curstate = VIDEO_PLAY_STATE_PAUSE; 
    }
    
    return;
}

/**
 * ƣ Video_ControlProcResumeMsg 
 *  ָϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlProcResumeMsg(VOID)
{
    BOOL    bAudioData = TRUE;  /* Ƶݴ */
    BOOL    bVideoData = TRUE;  /* Ƶݴ */
    SINT32  iRet       = -1;
    UINT32  uiFrames   = 0;
    
    /* ֪ͨƵָ̻߳ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pAudioOutThread, EV_AUDIO_OUT_RESUME);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;            
            zMspCom_Print();
            return;
        }

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);

        /* Ƶָ */
        if(g_ErrorCode != DCAMERA_OP_SUCCESS)
        {
            zMspCom_Print();
            return;
        }
    }

    /* 뿪ʼ̴˿ʼŵ̵Ĵ */

    /* ƵϵĻָţƵǷȡϵжϣ
     * Ϊ˱⵱ļϺ(ʱϱŽϢ)ִpause
     * ִresumeٴϱŽϢ
     */
    if(g_VideoControlParam.iVideoExp & VIDEO_FILE_VIDEO_OVER_EXP
        && zOss_ListCount(g_pVideoDataList) == 0)
    {
        bVideoData = FALSE;
    }
    else
    {
        /* ƵĿԪλãͣڳͻ˲Ҫ */
        uiFrames = g_VideoControlParam.pVideoBuffer->uiBufLen - g_VideoControlParam.pVideoBuffer->uiUsedLen;

        /* Ƶݶȡ롢д뻺 */
        iRet = Video_ControlProcVideo(uiFrames);

        /* ݶȡ */
        if(VIDEO_OP_DATAEND == iRet)    
        {
            /* ΪƵͣ״̬£̲߳ܶʱ */
            zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_OUT_OVER);
            bVideoData = FALSE;
        }
        else if(iRet != VIDEO_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;
        }        
    }

    if(g_VideoControlParam.iVideoExp & VIDEO_FILE_AUDIO_OVER_EXP
        && zOss_ListCount(g_pAudioDataList) == 0)
    {
        if(g_VideoControlParam.tAudioBuffer.eBufState == AUDIO_BUF_UNUSED)
        {
            UINT32  uiBufLen = g_VideoControlParam.tAudioBuffer.uiBufLen;
            VOID   *pPhyBuf  = g_VideoControlParam.tAudioBuffer.pPhyBuffer;
            
            uiBufLen = uiBufLen <= 320 ? uiBufLen : 320;
            zOss_Memset(pPhyBuf, 0, uiBufLen);
            g_VideoControlParam.tAudioBuffer.eBufState = AUDIO_BUF_USED;
            iRet = zDrv_Write(g_VideoControlParam.uiFdAudio, (const VOID *)pPhyBuf, uiBufLen);
        }
        bAudioData = FALSE;
    }
    else
    {
        /* Ƶ */
        iRet = Video_RefreshAudioBuffer();    
        if(iRet != VIDEO_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;        
        }
        
        /* Ƶݶȡд뻺 */    
        iRet = Video_ControlProcAudio();

        /* FIXME: ݶȡ */
        if(VIDEO_OP_DATAEND == iRet)    
        {
            /* ƵδϵPCMݣԼţ
             * û֪̣ͨ߳Ƶ
             */
            bAudioData = FALSE;
            /*
            if(0 == g_VideoControlParam.tAudioOutInfo.uiRemainCount)
            {
                zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_AUDIO_OUT_OVER);
                bAudioData = FALSE;
            }
            */
        }
        else if(iRet != VIDEO_OP_SUCCESS)
        {
            Video_ControlReleaseAudioProc();
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;        
        }
    }

    /* Ƶ߳ */
    if((g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO) && bAudioData)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pAudioOutThread, EV_AUDIO_FIRST_OUT);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;
        }
    }
    
    /* Ƶ߳ */    
    if((g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO) && bVideoData)
    {       
        /* ͣµƵָҪ¸ƵϵͳʱϢ²ŵ */
        iRet = zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_FIRST_OUT);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;
        }
    } 

    /* Ƶģ״̬ */
    if(DCAMERA_OP_SUCCESS == g_ErrorCode)
    {    
        g_Curstate = VIDEO_PLAY_STATE_PLAY;
    }
    
    return;    
}

/**
 * ƣ Video_ControlProcSeekOnReady 
 *  READY״̬seekϢĴ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlProcSeekOnReady(VOID)
{
    UINT32         uiPos  = 0;
    EZMFResultCode rtCode = ZMF_RS_ERROR;

    /* Video_Seekӿжضλģʽ˴˴ļʼ */    
    /* SeekӿڵλòΪs */
    uiPos = g_VideoControlParam.tPlaySeekParam.pos / 1000;

    /* ýļضλָλ */
    //rtCode = Seek(g_VideoFileParam.u32FileID, uiPos);
    rtCode = Video_Seek_Adapt(uiPos);
    if (rtCode != ZMF_RS_OK)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;
    }

    /* ƵӦĵǰʱϢļȡϱ־ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        g_VideoControlParam.tAudioBuffer.uiStartTime = uiPos;
        g_VideoControlParam.iVideoExp &= ~VIDEO_FILE_AUDIO_OVER_EXP;
        g_VideoControlParam.iVideoExp &= ~VIDEO_AUDIO_OVER_EXP;
    }
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        g_VideoControlParam.tVideoOutInfo.uiVideoOutTime = uiPos;
        g_VideoControlParam.iVideoExp &= ~VIDEO_FILE_VIDEO_OVER_EXP;
        g_VideoControlParam.iVideoExp &= ~VIDEO_VIDEO_OVER_EXP;        
    }
    
    return;
}

/**
 * ƣ Video_ControlProcSeekOnPlay 
 *  PLAY״̬seekϢĴ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlProcSeekOnPlay(VOID)
{
    SINT32  iRet   = -1;
    
    /* ͣ״̬µضλֹͨͣƵݣ
     * ȻƵٿʼSTARTPAUSE 
     */
    /* ֪ͨƵֹ߳ͣ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pAudioOutThread, EV_AUDIO_OUT_STOP);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;            
            zMspCom_Print();
            return;
        }

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);

        /* Ƶֹͣ */
        if(g_ErrorCode != DCAMERA_OP_SUCCESS)
        {
            zMspCom_Print();
            return;
        }
    }

    /* ֪ͨƵֹ߳ͣ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_OUT_STOP);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;            
            zMspCom_Print();
            return;
        }

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);

        /* Ƶֹͣ */
        if(g_ErrorCode != DCAMERA_OP_SUCCESS)
        {
            zMspCom_Print();
            return;
        }
    }

    /* ýļضλƵǰʱϢ */
    Video_ControlProcSeekOnReady();
    if(g_ErrorCode != DCAMERA_OP_SUCCESS)
    {
        zMspCom_Print();
        return;
    }
    
    /* ¿ʼ̣︴˿ʼϢĴ롣
     * עֹͣܵЧƵϢĶѻ
     * ƵϢʱԻ״̬ж; Ƶ
     * ϢʱԻǷжϣЩЧĽϢ
     */
    Video_ControlProcStartMsg();
    return;    
}

/**
 * ƣ Video_ControlProcSeekOnPause 
 *  PAUSE״̬seekϢĴ
 * ˵ (IN) 
 *   ֵ 
 * ˵ ͣ״̬µضλҪƵݡ
 */
static VOID Video_ControlProcSeekOnPause(VOID)
{
    SINT32                      iRet        = -1;
    T_MSP_CHANNEL_OUTPUT        ePath       = MSP_CHANNEL_OUTPUT_SPEAKER;    
    T_ZDrvAudio_PlayParam       tPlayParam;
    T_ZDrvAudio_SampleRate      eSample;          
    T_MSP_OUTPUT_VOLUME_LEVEL   eVol        = MSP_OUTPUT_VOLUME_LEVEL_3;
    
    /* ͣ״̬µضλֹͨͣƵݣ
     * ȻƵٽпʼSTARTPAUSE 
     */
    /* ֪ͨƵֹ߳ͣ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        /* ͨ */
        iRet = zMspCom_GetOutputVol(&eVol);
        iRet = zMspCom_GetOutputChannel(&ePath);
        
        iRet = zMspCom_PostMsg(g_VideoControlParam.pAudioOutThread, EV_AUDIO_OUT_STOP);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;            
            zMspCom_Print();
            return;
        }

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);

        /* Ƶֹͣ */
        if(g_ErrorCode != DCAMERA_OP_SUCCESS)
        {
            zMspCom_Print();
            return;
        }
    }

    /* ֪ͨƵֹ߳ͣ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_OUT_STOP);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;            
            zMspCom_Print();
            return;
        }

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);

        /* Ƶֹͣ */
        if(g_ErrorCode != DCAMERA_OP_SUCCESS)
        {
            zMspCom_Print();
            return;
        }
    }
    
    /* ƵָPAUSE״̬ѾֹͣҪSTART */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        /* FIXME: ֵͨӦĬ */        

        /* ֵƵʽйأAMRʽʹ̶Ϊ8K */
        eSample = g_VideoFileParam.eSample;
            
        /* ֵƵʽйأ3֡AMRPCMݳΪ960()/1920(˫) */
        tPlayParam.channel    = g_VideoFileParam.eChannel;
        tPlayParam.buffersize = g_VideoFileParam.uiAudioBufsize;                                   

        /* ·ʡ֪ͨصʼ */
        iRet = zMspCom_SetOutputVol(eVol);
        iRet = zMspCom_SetOutputChannel(ePath);
        iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_SET_SAMPLE,      (VOID *)&eSample);
        iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_SET_CALLBACK,    (VOID *)Video_DrvNotifyCB);

        /* STARTƵ */
        iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_START,      (VOID *)&tPlayParam);        
        if(iRet < 0)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;
        }

        /* PAUSEƵ */
        iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_PAUSE, NULL);    
        if(iRet < 0)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;
        }
    }

    /* ýļضλ︴Ready״̬µĴ */
    Video_ControlProcSeekOnReady();    
    
    return;    
}

/**
 * ƣ Video_ControlProcSeekMsg 
 *  ضλϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ PAUSEPLAYREADY״̬£ضλϢ
 *            ĴһֱԴ
 */
static VOID Video_ControlProcSeekMsg(VOID)
{
    switch(g_Curstate)
    {
        /* Ѿʼ״̬ */
        case VIDEO_PLAY_STATE_READY:
        {
            Video_ControlProcSeekOnReady();
            break;        
        }

        /* ״̬ */
        case VIDEO_PLAY_STATE_PLAY:
        {
            Video_ControlProcSeekOnPlay();
            break;        
        }

        /* ͣ״̬ */
        case VIDEO_PLAY_STATE_PAUSE:
        {
            Video_ControlProcSeekOnPause();
            break;        
        }

        default:
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            break;        
        }        
    }

    return;
}

/**
 * ƣ Video_ControlProcRotateMsg 
 *  ʾתǶϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlProcRotateMsg(VOID)
{
    SINT32                iRet;
    T_ZDrv_RotateType     tRotate;
    T_ZDrv_RotateType     tPreRotate;    
    T_ZDrvVideo_DecCfg   *pDecCfg;        /* ò */   
    T_ZDrvVideo_Setting   tVideoSetting;

    /* תǶȼʾ */
    g_VideoPlayParam.rotate    = g_tTempVideoPlayParam.rotate;
    g_VideoPlayParam.play_rect = g_tTempVideoPlayParam.play_rect;

    /* (ȫģʽ)Ƶĺʱƫ꣬
     * Чʣÿνظ 
     */
    Video_RefreshYUVOffset();
    
    /* ȡƵ */
    pDecCfg = (T_ZDrvVideo_DecCfg *)g_VideoControlParam.pVideoHandle;

    switch(g_VideoPlayParam.rotate)
    {
        case ROTATE_0:
        {
            tRotate = ROT_0;
            break;
        }
            
        case ROTATE_90:
        {
            tRotate = ROT_90;
            break;
        }
            
        case ROTATE_180:
        {
            tRotate = ROT_180;
            break;
        }
            
        case ROTATE_270:
        {
            tRotate = ROT_270;
            break;   
        }

        default:
        {
            tRotate = ROT_0;
            break; 
        }
    }

    /* ¼תǰ */
    tPreRotate = pDecCfg->tRotate;
    
    /* תϢ¼ڽò */
    pDecCfg->tRotate = tRotate;
    
    /* ýת */
    tVideoSetting.cmd         = VIDEO_SET_ROTATION;    
    tVideoSetting.param       = (VOID *)&tRotate;
    tVideoSetting.uiVideoInst = pDecCfg->uiVideoInst;
    
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_DECSETTING, &tVideoSetting);    
    if(iRet < 0)
    {
        /* ʱ֧ */
        g_ErrorCode = DCAMERA_OP_ERROR; 
    }

    /* ͼƬĿ */
    if(((ROT_0  == tPreRotate || ROT_180 == tPreRotate) && (ROT_90 == tRotate || ROT_270 == tRotate))
       || ((ROT_90 == tPreRotate || ROT_270 == tPreRotate) && (ROT_0  == tRotate || ROT_180 == tRotate)))
    {
        UINT32  uiWidth;
        UINT32  uiHeight;
        
        uiWidth  = pDecCfg->tOutput.uiWidth;
        uiHeight = pDecCfg->tOutput.uiHeight;

        pDecCfg->tOutput.uiWidth  = uiHeight;
        pDecCfg->tOutput.uiHeight = uiWidth;        
    }
    
    return;
}

/**
 * ƣ Video_ControlProcStopMsg 
 *  ֹͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlProcStopMsg(VOID)
{
    SINT32         iRet   = -1;
    EZMFResultCode rtCode = ZMF_RS_ERROR;
    
    /* ֪ͨƵֹ߳ͣ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pAudioOutThread, EV_AUDIO_OUT_STOP);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;            
            zMspCom_Print();
            return;
        }

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);

        /* Ƶֹͣ */
        if(g_ErrorCode != DCAMERA_OP_SUCCESS)
        {
            zMspCom_Print();
            return;
        }
    }

    /* ֪ͨƵֹ߳ͣ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_OUT_STOP);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;            
            zMspCom_Print();
            return;
        }

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);

        /* Ƶֹͣ */
        if(g_ErrorCode != DCAMERA_OP_SUCCESS)
        {
            zMspCom_Print();
            return;
        }
    }

    /* ýļضλʼʹúٴβ */
    //rtCode = Seek(g_VideoFileParam.u32FileID, 0);
    rtCode = Video_Seek_Adapt(0);
    if (rtCode != ZMF_RS_OK)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;
    }

    /* ƵӦĵǰʱϢļȡϱ־ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        g_VideoControlParam.tAudioBuffer.uiStartTime = 0;
        g_VideoControlParam.iVideoExp &= ~VIDEO_FILE_AUDIO_OVER_EXP;
        g_VideoControlParam.iVideoExp &= ~VIDEO_AUDIO_OVER_EXP;
    }
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        g_VideoControlParam.tVideoOutInfo.uiVideoOutTime = 0;
        g_VideoControlParam.iVideoExp &= ~VIDEO_FILE_VIDEO_OVER_EXP;
        g_VideoControlParam.iVideoExp &= ~VIDEO_VIDEO_OVER_EXP;        
    }

    /* Ƶģ״̬ */
    g_Curstate = VIDEO_PLAY_STATE_READY;
    
    return;
}

/**
 * ƣ Video_ControlProcCloseMsg 
 *  رղϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlProcCloseMsg(VOID)
{
    SINT32  iRet   = -1;
    
    /* ֪ͨƵ̹߳رղ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pAudioOutThread, EV_AUDIO_OUT_CLOSE);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;            
            
            return;
        }

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);

        /* ƵرմȻ֪ͨƵر */
    }

    /* ֪ͨƵ̹߳رղ */
    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
    {
        iRet = zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_OUT_CLOSE);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;            
            
            return;
        }

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_VideoControlParam.pOutputSem, ZOSS_WAIT_FOREVER);

        /* Ƶرմ */
        if(g_ErrorCode != DCAMERA_OP_SUCCESS)
        {
            return;
        }
    }
    
    return;
}

/**
 * ƣ Video_ControlProcAudioDecMsg 
 *  ƵݽϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ ĳӦ쳣̣֪ͨ
 *            ص֪ͨû
 */
static VOID Video_ControlProcAudioDecMsg(VOID)
{
    SINT32   iRet = -1;

    /* ЧδʹõƵĳͣȲ
     * ̻߳ѹ˶ƵϢϢӦ 
     */
    if(g_VideoControlParam.tAudioBuffer.eBufState != AUDIO_BUF_UNUSED)
    {
        return;
    }   
    
    /* Ƶݶȡд뻺 */    
    iRet = Video_ControlProcAudio();
    
    /* FIXME: Ƶݶȡϣͨص֪ͨϲû */
    if(VIDEO_OP_DATAEND == iRet)
    {
        return;
    }
    
    if(iRet != VIDEO_OP_SUCCESS)
    {
        /* ¼쳣־ */
        g_VideoControlParam.iVideoExp |= VIDEO_OP_EXP;

        /* ֪ͨû */
        Video_NotifyUser(iRet);        
        g_ErrorCode = DCAMERA_OP_ERROR;

        zMspCom_Print();
        return;        
    }   

    /* ֪ͨƵ߳PCM */
    iRet = zMspCom_PostMsg(g_VideoControlParam.pAudioOutThread, EV_AUDIO_NORMAL_OUT);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;
    }

    /* FIXME: ĳӦ쳣̣֪ͨص֪ͨû */
    
    return;
}

/**
 * ƣ Video_ControlProcVideoDecMsg 
 *  ƵݽϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlProcVideoDecMsg(VOID)
{
    SINT32   iRet     = -1;    

    /* ƵͣȲ
     * ̻ѹ˶ƵϢϢӦ
     */
    if(g_VideoControlParam.pVideoBuffer->uiBufLen == g_VideoControlParam.pVideoBuffer->uiUsedLen)
    {
        return;
    }
    
    /* Ƶݶȡ롢д뻺 */
    iRet = Video_ControlProcVideo(1);

    /* FIXME: Ƶݶȡ */
    if(VIDEO_OP_DATAEND == iRet)
    {
        return;
    }
    if(iRet != VIDEO_OP_SUCCESS)
    {
        /* ¼쳣־ */
        g_VideoControlParam.iVideoExp |= VIDEO_OP_EXP;
        
        /* ֪ͨƵ߳Ƴʱ */
        zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_OUT_STOP); 
        
        /* ֪ͨû */
        Video_NotifyUser(iRet);        
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;
    }

    return;    
}

/**
 * ƣ Video_ControlProcVideoSupplyMsg 
 *  ƵݲϢ
 * ˵ (IN) bReStart  ƵǷ
 *   ֵ 
 * ˵ ϢȽϢһ֪ͨƵ߳
 */
static VOID Video_ControlProcVideoSupplyMsg(BOOL bReStart)
{
    SINT32   iRet     = -1;    
    UINT32   uiFrames = 0;

    /* ƵͣȲ
     * ̻ѹ˶ƵϢϢӦ
     */    
    if(g_VideoControlParam.pVideoBuffer->uiBufLen == g_VideoControlParam.pVideoBuffer->uiUsedLen)
    {
        return;
    }
    
    /* ƵĿԪλãϢĳζ
     * ûжʱֹͣԻķʣ˲
     */
    uiFrames = g_VideoControlParam.pVideoBuffer->uiBufLen - g_VideoControlParam.pVideoBuffer->uiUsedLen;
    
    /* Ƶݶȡ롢д뻺 */
    iRet = Video_ControlProcVideo(uiFrames);

    /* Ƶݶȡ */
    if(VIDEO_OP_DATAEND == iRet)
    {
        /* лݣ */
        if(g_VideoControlParam.pVideoBuffer->uiUsedLen > 0)
        {
            iRet = zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_NORMAL_OUT);
            if(iRet != MSP_COM_OP_SUCCESS)
            {
                g_ErrorCode = DCAMERA_OP_ERROR;
                zMspCom_Print();
                return;
            }   
        }
        return;
    }
    if(iRet != VIDEO_OP_SUCCESS)
    {
        /* ¼쳣־ */
        g_VideoControlParam.iVideoExp |= VIDEO_OP_EXP;
        
        /* ֪ͨƵ߳Ƴʱ */
        zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_OUT_STOP); 
        
        /* ֪ͨû */
        Video_NotifyUser(iRet);        
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;
    }

    /* Ƶ̷߳Ϣ */
    if(bReStart)
    {
        /* Ƶ */
        iRet = zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_FIRST_OUT);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;
        }        
    }
    else
    {
        /* Ƶ */
        iRet = zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_NORMAL_OUT);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = DCAMERA_OP_ERROR;
            zMspCom_Print();
            return;
        }   
    }

    return;    
}

/**
 * ƣ Video_ControlThreadLoop 
 *  Ƶ߳Ϣѭ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlThreadLoop(VOID)
{
    BOOL    bQuit  = FALSE;
    UINT32  uiMsg  = 0;
    SINT32  iRet   = 0;

    while(1)
    {
        /* Ϣ */
        iRet = zMspCom_RecvMsg(&uiMsg, ZOSS_WAIT_FOREVER);
        
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            continue;
        }

        if(VIDEO_PLAY_STATE_READY == g_Curstate)
        {
            if(uiMsg != EV_VIDEO_START_PLAY_SYN
               && uiMsg != EV_VIDEO_SEEK_PLAY_SYN
               && uiMsg != EV_VIDEO_CLOSE_PLAY_SYN
               && uiMsg != EV_VIDEO_ROTATE_PLAY_SYN)
            {
                /* ͷϢԴ */
                uiMsg = 0;

                continue;
            }
        }

        /* ͣ״̬½resumestopseekrotatecloseoverϢ */
        if(VIDEO_PLAY_STATE_PAUSE == g_Curstate)
        {
            if(uiMsg != EV_VIDEO_RESUME_PLAY_SYN
               && uiMsg != EV_VIDEO_SEEK_PLAY_SYN
               && uiMsg != EV_VIDEO_STOP_PLAY_SYN
               && uiMsg != EV_VIDEO_CLOSE_PLAY_SYN
               && uiMsg != EV_VIDEO_ROTATE_PLAY_SYN
               && uiMsg != EV_AUDIO_OUT_OVER
               && uiMsg != EV_VIDEO_OUT_OVER)
            {
                /* ͷϢԴ */
                uiMsg = 0;

                continue;
            }
        }
        
        /* 쳣ģʽֻضϢ */
        if(g_VideoControlParam.iVideoExp & VIDEO_OP_EXP)
        {
            /* 쳣ϱƵ䡢Ƶ롢Ƶ䡢ƵϢ */
            if(EV_OP_EXP == uiMsg
               || EV_AUDIO_DATA_DECODE == uiMsg 
               || EV_VIDEO_DATA_FILL   == uiMsg                
               || EV_VIDEO_DATA_DECODE == uiMsg
               || EV_VIDEO_DATA_SUPPLY == uiMsg
               || EV_AUDIO_OUT_OVER    == uiMsg
               || EV_VIDEO_OUT_OVER    == uiMsg)
            {
                /* ͷϢԴ */
                uiMsg = 0;

                continue;
            }
            
            /* šָͣضλͬϢ */
            if(EV_VIDEO_START_PLAY_SYN     == uiMsg 
               || EV_VIDEO_PAUSE_PLAY_SYN  == uiMsg
               || EV_VIDEO_RESUME_PLAY_SYN == uiMsg
               || EV_VIDEO_ROTATE_PLAY_SYN == uiMsg
               || EV_VIDEO_SEEK_PLAY_SYN   == uiMsg)
            {
                /* ͷͬź֪ͨû߳̿ռϢ */
                zOss_PutSemaphore(g_VideoControlParam.pControlSem); 
                
                /* ͷϢԴ */
                uiMsg = 0;        
                
                continue;                
            }
        }
        
        switch(uiMsg)
        {
            /* ʼ */
            case EV_VIDEO_START_PLAY_SYN:
            {
                Video_ControlProcStartMsg();
                
                /* ͷͬź֪ͨû߳̿ռϢ */
                zOss_PutSemaphore(g_VideoControlParam.pControlSem);            
                    
                break;
            }

            /* ͣ */
            case EV_VIDEO_PAUSE_PLAY_SYN:
            {
                Video_ControlProcPauseMsg();  
                
                /* ͷͬź֪ͨû߳̿ռϢ */
                zOss_PutSemaphore(g_VideoControlParam.pControlSem);            
               
                break;
            }

            /* ָ */
            case EV_VIDEO_RESUME_PLAY_SYN:
            {
                Video_ControlProcResumeMsg();
                
                /* ͷͬź֪ͨû߳̿ռϢ */
                zOss_PutSemaphore(g_VideoControlParam.pControlSem);            
                    
                break;
            }

            /* ֹͣ */
            case EV_VIDEO_STOP_PLAY_SYN:
            {
                Video_ControlProcStopMsg();
                
                /* ͷͬź֪ͨû߳̿ռϢ */
                zOss_PutSemaphore(g_VideoControlParam.pControlSem);            
                    
                break;                
            }

            /* ضλ */
            case EV_VIDEO_SEEK_PLAY_SYN:
            {
                Video_ControlProcSeekMsg();
                
                /* ͷͬź֪ͨû߳̿ռϢ */
                zOss_PutSemaphore(g_VideoControlParam.pControlSem);            

                break;
            }

            /* ʾתǶ */
            case EV_VIDEO_ROTATE_PLAY_SYN:
            {
                Video_ControlProcRotateMsg();
                
                /* ͷͬź֪ͨû߳̿ռϢ */
                zOss_PutSemaphore(g_VideoControlParam.pControlSem);
                
                break;
            }
            
            /* ţͬźͷԴͷϺ
             * Video_ControlThreadEntry
             */
            case EV_VIDEO_CLOSE_PLAY_SYN:
            {
                Video_ControlProcCloseMsg();
                
                bQuit = TRUE;
                
                break;
            }

            /* Ƶݽ */
            case EV_AUDIO_DATA_DECODE:
            {
                /* ڵײ㲥쳣 */
                if(g_VideoControlParam.iVideoExp & VIDEO_PCM_EXP)
                {
                    /* ֪ͨû */
                    g_VideoControlParam.iVideoExp |= VIDEO_OP_EXP;
                    Video_NotifyUser(VIDEO_OP_DEVICE_ERR);
                }
                else
                {
                    Video_ControlProcAudioDecMsg();
                }

                break;
            }

            /* Ƶݽ */
            case EV_VIDEO_DATA_DECODE:
            {

                Video_ControlProcVideoDecMsg();

                break;
            }

            /* ϢƵУУƵ֡ʱ
             * ΪƵɶʱ֡ʱ
             * ִУҪ߳һΡ
             */
            case EV_VIDEO_DATA_SUPPLY:
            {
                Video_ControlProcVideoSupplyMsg(FALSE);
                
                break;
            }

            /* ϢƵУУƵǰƵ
             * ܶʱƵգϵͳʱҪȷ
             * Ƶ²̡
             */
            case EV_VIDEO_DATA_FILL:
            {
                Video_ControlProcVideoSupplyMsg(TRUE);
                break;
            }

            /* Ƶ */
            case EV_AUDIO_OUT_OVER:
            {
                if(g_VideoControlParam.iVideoExp & VIDEO_FILE_AUDIO_OVER_EXP)
                {
                    g_VideoControlParam.iVideoExp |= VIDEO_AUDIO_OVER_EXP;
                    g_VideoControlParam.iVideoExp |= VIDEO_VIDEO_OVER_EXP;

                    /* ýļƵ */
                    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_VIDEO)
                    {
                        /* Ƶݲ */
                        if(g_VideoControlParam.iVideoExp & VIDEO_VIDEO_OVER_EXP
                           && g_VideoControlParam.iVideoExp & VIDEO_FILE_VIDEO_OVER_EXP)
                        {
                            /* ֪ͨû */
                            Video_NotifyUser(VIDEO_OP_DATAEND);
                        }
                    }
                    else
                    {
                        /* Ƶݣ֪ͨû */
                        Video_NotifyUser(VIDEO_OP_DATAEND);
                    }
                }

                break;
            }

            /* Ƶ */
            case EV_VIDEO_OUT_OVER:
            {
                if(g_VideoControlParam.iVideoExp & VIDEO_FILE_VIDEO_OVER_EXP)
                {
                    g_VideoControlParam.iVideoExp |= VIDEO_AUDIO_OVER_EXP;
                    g_VideoControlParam.iVideoExp |= VIDEO_VIDEO_OVER_EXP;
                    
                    /* ýļƵ */
                    if(g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
                    {
                        /* Ƶݲ */
                        if(g_VideoControlParam.iVideoExp & VIDEO_AUDIO_OVER_EXP
                           && g_VideoControlParam.iVideoExp & VIDEO_FILE_AUDIO_OVER_EXP)
                        {
                            /* ֪ͨû */
                            Video_NotifyUser(VIDEO_OP_DATAEND);
                        }
                    }
                    else
                    {
                        /* Ƶݣ֪ͨû */
                        Video_NotifyUser(VIDEO_OP_DATAEND);
                    }
                }
                
                break;
            }

            /* 쳣Ϣ */
            case EV_OP_EXP:
            {
                g_VideoControlParam.iVideoExp |= VIDEO_OP_EXP;
                Video_NotifyUser(VIDEO_OP_ERROR);
                
                break;
            }
            
            default:
            {
                break;
            }
        }

        /* ͷϢԴ */
        uiMsg = 0;

        /* ˳Ϣѭ */
        if(bQuit)
        {
            break;
        }
    }

    /* ܻһЩĴ */
    
    return;
}

/**
 * ƣ Audio_OutputProcOutMsg 
 *  Ƶ̴߳һƵϢ
 * ˵ (IN) bFirst  ǷΪһƵ
 *   ֵ 
 * ˵ лҪһЩʼĲ
 *            ϵͳʱ估ͳϢ
 */
static VOID Audio_OutputProcOutMsg(BOOL bFirst)
{
    VOID                *pPcmDataBuf = NULL;
    SINT32               iRet        = -1;
    UINT32               uiBufLen    = 0;

    uiBufLen    = g_VideoControlParam.tAudioBuffer.uiUsedLen;
    pPcmDataBuf = g_VideoControlParam.tAudioBuffer.pPhyBuffer;

    /* FIXME: 
     * ﻹҪһЩʼĲϵͳ
     * ʱ估ͳϢ 
     */
    if(bFirst)
    {
        g_VideoControlParam.tAudioOutInfo.uiWriteCount  = 0;
        g_VideoControlParam.tAudioOutInfo.uiRemainCount = 0;
    }

    /* PCM */
    iRet = zDrv_Write(g_VideoControlParam.uiFdAudio, (const VOID *)pPcmDataBuf, uiBufLen);
    if(iRet < 0)
    {        
        /* ֪̳ͨ߳쳣 */
        zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_OP_EXP);
        zMspCom_Print();
        
        return;
    }

    /* ˴ӦûҪPCMݵͳ */
    {
        g_VideoControlParam.tAudioOutInfo.uiWriteCount += iRet;
    }

    /* Ƶ */
    iRet = Video_RefreshAudioBuffer();
    if(iRet != VIDEO_OP_SUCCESS)
    {        
        /* ֪̳ͨ߳쳣 */
        zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_OP_EXP);
        zMspCom_Print();
        
        return;
    }     

    /* ֪ͨ߳̽Ƶݽ */
    iRet = zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_AUDIO_DATA_DECODE);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;
    }     
    
    return;
}

/**
 * ƣ Audio_OutputProcPauseMsg 
 *  Ƶ̴߳ƵͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputProcPauseMsg(VOID)
{
    SINT32               iRet      = 0;
    T_ZDrvAudio_PlayInfo tPlayInfo = {0};

    /* ͣƵ */
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_PAUSE, NULL);    
    if(iRet < 0)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;  
        zMspCom_Print();
        return;
    }

    /* ȡƵѲPCMPCMͳ */
    zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_GET_PLAY_INFO, &tPlayInfo);

    g_VideoControlParam.tAudioOutInfo.uiWriteCount  -= tPlayInfo.DataLenth;
    g_VideoControlParam.tAudioOutInfo.uiRemainCount  = tPlayInfo.DataLenth;
    
    return;
}

/**
 * ƣ Audio_OutputProcResumeMsg 
 *  Ƶ̴߳ƵŻָϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputProcResumeMsg(VOID)
{
    SINT32  iRet = 0;

    /* ָƵ */
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_RESUME, NULL);    
    if(iRet < 0)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;
    }

    /* PCMͳϢΪʱƵŻָдPCM */
    g_VideoControlParam.tAudioOutInfo.uiWriteCount  += g_VideoControlParam.tAudioOutInfo.uiRemainCount;
    g_VideoControlParam.tAudioOutInfo.uiRemainCount  = 0;
    
    return;
}

/**
 * ƣ Audio_OutputProcStopMsg 
 *  Ƶ̴߳ƵֹͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputProcStopMsg(VOID)
{
    SINT32  iRet = 0;

    /* ֹͣƵ */
    iRet = zDrv_Ioctl(g_VideoControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_STOP, NULL);    
    if(iRet < 0)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_Print();
        return;
    }
    
    /* STOP¼ȫƵϢ */
    zOss_Memset(&(g_VideoControlParam.tAudioBuffer), 0, sizeof(T_AudioBuffer));

    g_VideoControlParam.tAudioOutInfo.uiWriteCount  = 0;
    g_VideoControlParam.tAudioOutInfo.uiRemainCount = 0;
    
    return;
}

/**
 * ƣ Audio_OutputProcCloseMsg 
 *  Ƶ̴߳ƵŹرϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputProcCloseMsg(VOID)
{
    SINT32 iRet = 0;
    /* READY״̬Ƚֹͣ */
    if(g_Curstate != VIDEO_PLAY_STATE_READY)
    {
        Audio_OutputProcStopMsg();
    }    
    return;
}

/**
 * ƣ Audio_OutputThreadLoop 
 *  Ƶ߳Ϣѭ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputThreadLoop(VOID)
{
    BOOL    bQuit  = FALSE;
    UINT32  uiMsg  = 0;
    SINT32  iRet   = -1;

    while(1)
    {
        /* Ϣ */
        iRet = zMspCom_RecvMsg(&uiMsg, ZOSS_WAIT_FOREVER);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            continue;
        }

        switch(uiMsg)
        {
            /* PCM״ */
            case EV_AUDIO_FIRST_OUT:
            {
                Audio_OutputProcOutMsg(TRUE);

                break;
            }

            /* PCM */
            case EV_AUDIO_NORMAL_OUT:
            {
                Audio_OutputProcOutMsg(FALSE);                

                break;
            }

            /* ƵͣϢ */
            case EV_AUDIO_OUT_PAUSE:
            {
                Audio_OutputProcPauseMsg(); 

                /* ֪ͨ߳Ƶͣ */
                zOss_PutSemaphore(g_VideoControlParam.pOutputSem);

                break;
            }

            /* ƵָϢ */
            case EV_AUDIO_OUT_RESUME:
            {
                Audio_OutputProcResumeMsg(); 
                
                /* ֪ͨ߳Ƶָ */
                zOss_PutSemaphore(g_VideoControlParam.pOutputSem);
                
                break;
            }

            /* ƵֹͣϢ */
            case EV_AUDIO_OUT_STOP:
            {
                Audio_OutputProcStopMsg(); 
                
                /* ֪ͨ߳Ƶָ */
                zOss_PutSemaphore(g_VideoControlParam.pOutputSem);
                
                break;
            }
            
            /* ƵϢ */
            case EV_AUDIO_OUT_CLOSE:
            { 
                Audio_OutputProcCloseMsg();
                
                /* ֪ͨ߳Ƶ */
                zOss_PutSemaphore(g_VideoControlParam.pOutputSem);
                
                bQuit = TRUE;
                
                break;
            }

            default:
            {
                break;
            }
        }

        /* ͷϢԴ */
        uiMsg = 0;

        if(bQuit)
        {
            break;
        }
    }

    /* ܻһЩĴ */    
    return;    
}

/**
 * ƣ Video_TimeoutFunc 
 *  Ƶʱں
 * ˵ (IN) arg  ʱڲ
 *   ֵ 
 * ˵ 
 */
static VOID Video_TimeoutFunc(SINT32  arg)
{
    g_uiTimerCount3++;
    /* Ƶ̷߳Ϣ */
    if(g_VideoControlParam.pVideoTimerId != ZOSS_INVALID_TIMER_ID)
    {
        zMspCom_PostMsg(g_VideoControlParam.pVideoOutThread, EV_VIDEO_NORMAL_OUT);
    }
    return;
}

/**
 * ƣ Video_FreeDrvBuf 
 *  ͷƵӲBuffer
 * ˵ (IN) bARGB      ǷΪARGBʽ
 *            (IN) uiWidth    ƵͼƬ
 *            (IN) uiHeight   ƵͼƬ
 *            (IN) pImageData Ƶͼ
 *   ֵ 
 * ˵ ýӿڽ֧ARGBYUV420ʽƵBufferͷ
 */
static VOID Video_FreeDrvBuf(BOOL    bARGB,    UINT32               uiWidth, 
                             UINT32  uiHeight, T_ZDrv_ImageDataBuf *pImageData)
{
    T_ZDrvVideo_BufInfo tFreeBuf;  

    /* ARGBƵ */
    if(bARGB)
    {
        tFreeBuf.bufType = ARGB_TYPE;

        if(g_uiScreenWidth == uiWidth && g_uiScreenHeight == uiHeight)
        {
            tFreeBuf.bufSize.ARGBBufSize = g_uiDefaultARGBSize / 2;
        }
        else
        {
            tFreeBuf.bufSize.ARGBBufSize = uiWidth * uiHeight * 2;
        }
    }
    else
    {
        tFreeBuf.bufType = YUV_TYPE;

        /* YUV420 */
        if(g_uiScreenWidth == uiWidth && g_uiScreenHeight == uiHeight)
        {
            tFreeBuf.bufSize.YuvBufSize.ySize = g_uiDefaultYSize;
            tFreeBuf.bufSize.YuvBufSize.uSize = g_uiDefaultUSize;
            tFreeBuf.bufSize.YuvBufSize.vSize = g_uiDefaultVSize;
        }
        else
        {
            tFreeBuf.bufSize.YuvBufSize.ySize = uiWidth * uiHeight;
            tFreeBuf.bufSize.YuvBufSize.uSize = uiWidth * uiHeight / 4;
            tFreeBuf.bufSize.YuvBufSize.vSize = uiWidth * uiHeight / 4;
        }
        
        g_uiVideoFreeYUVBufCount++;
    }

    tFreeBuf.pDataBuf = *pImageData;
    
    /* ͷ */
    zDrv_Ioctl(g_VideoControlParam.uiFdVideo, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tFreeBuf);            

    return;
}

/**
 * ƣ Video_OutputProcOutMsg 
 *  Ƶ̴߳Ϣ
 * ˵ (IN) bFirst Ƿһ
 *   ֵ 
 * ˵ bFirstΪTRUEᴴʱһЩƵ״
 *            Ϣĸ
 */
static VOID Video_OutputProcOutMsg(BOOL bFirst)
{
    BOOL                    bARGB            = FALSE;
    SINT32                  iOffset;
    SINT32                  iDurationTime    = 40;   
    UINT32                  uiRet;
    UINT32                  uiAudioTime      = 0;
    UINT32                  uiPerfectTime;
    UINT32                  uiSysTime;
    UINT32                  uiVideoDataTime1;  /* ¼һ֡ƵĲʱ */
    UINT32                  uiVideoDataTime2;  /* ¼ڶ֡ƵĲʱ */
    RECT_T                  tPlayRect;
    T_VideoBuffer          *pVideoBuffer;
    T_ZDrv_ImageDataBuf     tImageData;
    DCAMERA_RETURN_VALUE_E  eRet;
    
    /* ǵһε£g_pVideoTimerIdΪЧֵ
     * ܳƵͣϢ˲䶨ʱϢ
     */
    if(ZOSS_INVALID_TIMER_ID == g_VideoControlParam.pVideoTimerId 
       && !bFirst)
    {
        return;
    }

    /* һδƵʱ¼Ƶ֡ʱ */
    if(bFirst)
    {
        /* ƳϴεĶʱ */
        if(g_VideoControlParam.pVideoTimerId != ZOSS_INVALID_TIMER_ID)
        {
            zOss_KillTimer(g_VideoControlParam.pVideoTimerId);
            g_VideoControlParam.pVideoTimerId = ZOSS_INVALID_TIMER_ID;
        }
        /* Ժʱ */
        g_VideoControlParam.pVideoTimerId = zOss_CreateTimer(VIDEO_SYNC_TIMER, Video_TimeoutFunc, 0, FALSE);
        if(ZOSS_INVALID_TIMER_ID == g_VideoControlParam.pVideoTimerId)
        {            
            /* ֪̳ͨ߳쳣 */
            zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_OP_EXP);
            zMspCom_Print();
            
            return;
        } 
    }
    
    pVideoBuffer = g_VideoControlParam.pVideoBuffer;

    zOss_GetMutex(pVideoBuffer->pBufLock, ZOSS_WAIT_FOREVER);
    
    /* ȡһ֡ƵݼϢ(ʾʱ) */ 
    eRet = Video_ReadFromBufferUnlock(pVideoBuffer, &tImageData, &bARGB,
                                      &tPlayRect,  &uiVideoDataTime1);
   
    /* ˴ֻΪ */
    if(eRet != DCAMERA_OP_SUCCESS)
    {
        zOss_PutMutex(pVideoBuffer->pBufLock);

        /* FIXME: ƺܳ */       
        /* ֪̳ͨ߳쳣 */
        zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_OP_EXP);
        zMspCom_Print();
        
        return;
    }

    /* ƵƵ */
    if(pVideoBuffer->uiUsedLen > 0)
    {
        /* ¼ڶ֡Ƶʱ */
        uiVideoDataTime2 = pVideoBuffer->pDataBuf[pVideoBuffer->uiRdIndex].uiTime;
        
        /* 㵱ǰƵ֡ĳʱ */
        iDurationTime = uiVideoDataTime2 - uiVideoDataTime1; 
    }
    else 
    {
        /* FIXME: ʾBufferû(Ӧһ֡) */

        /* ¼ǰʱ(Ƶ) */
        g_VideoControlParam.tVideoOutInfo.uiVideoOutTime  = uiVideoDataTime1;
             
        /* ¼ѲƵ֡ */
        g_VideoControlParam.tVideoOutInfo.uiPlayCount++;
            
        /* Ƶݶȡ */
        if(g_VideoControlParam.iVideoExp & VIDEO_FILE_VIDEO_OVER_EXP)
        {            
            /* OSDӲˢOSDлͷŵϴεƵͼ */
            Zte_OsdUpdateVideoInput(&tImageData, bARGB, &tPlayRect);

            /* ֪ͨ߳Ƶ */
            zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_OUT_OVER);
        }

        else
        {
            /* ǰ֪̲֡ͨ߳ƵݣӦò */ 
            Video_FreeDrvBuf(bARGB, g_uiScreenWidth, g_uiScreenHeight, &tImageData);

            /* ֪߲ͨƵ */
            zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_DATA_SUPPLY);

            g_uiCount1++;
        }

        zOss_PutMutex(pVideoBuffer->pBufLock); 
	 return;

    }

    zOss_PutMutex(pVideoBuffer->pBufLock);    

    /* Ƶʱѡ߻ȡƵĶʱ(Ƶͬ) */
    if((g_VideoFileParam.eFileDataInfo & FILE_DATA_ONLY_AUDIO)
        && (!(g_VideoControlParam.iVideoExp & VIDEO_AUDIO_OVER_EXP)))/* Ϊ */
    {
        uiAudioTime = g_VideoControlParam.tAudioBuffer.uiStartTime;

        /* ƵʱƵʱҳAUDIO_VIDEO_MAX_INTERʱ */
        if(uiVideoDataTime1 > uiAudioTime + AUDIO_VIDEO_MAX_INTER)
        {
            UINT32  uiTime;
            
            /* ֪ͨ߶ݽ */
            zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_DATA_DECODE);

            /* 㶨ʱʱ */
            uiTime = uiVideoDataTime1 - uiAudioTime + iDurationTime;
            
            /* ʱ */
            g_uiTimerCount2++;
            if(uiTime < 10){uiTime = 10;}
            uiRet = zOss_StartTimer(g_VideoControlParam.pVideoTimerId, 
                                    uiTime, Video_TimeoutFunc, 0);
            if(uiRet != ZOSS_SUCCESS)
            {
                /* ֪̳ͨ߳쳣 */
                zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_OP_EXP);
                zMspCom_Print();

                return;
            }
            
            /* ϵͳʱ */
            /* ¼Ѳ֡ʼϵͳʱ̡һ֡Բʱ */
            g_VideoControlParam.tVideoOutInfo.uiPlayCount++;
            g_VideoControlParam.tVideoOutInfo.uiSysStartTime   = zOss_GetTickCount() * ZOSS_MS_PER_TICK; 
            g_VideoControlParam.tVideoOutInfo.uiFrameStartTime = uiAudioTime;
            
            /* ¼ǰʱ(Ƶ) */
            g_VideoControlParam.tVideoOutInfo.uiVideoOutTime  = uiAudioTime;
            
            /* OSDӲˢOSDлͷŵϴεƵͼ */
            Zte_OsdUpdateVideoInput(&tImageData, bARGB, &tPlayRect);
            
            return;
        }
        else if(uiAudioTime > uiVideoDataTime1 + AUDIO_VIDEO_MAX_INTER)
        {
            /* ǰ֡ */ 
            Video_FreeDrvBuf(bARGB, g_uiScreenWidth, g_uiScreenHeight, &tImageData);

            zOss_GetMutex(pVideoBuffer->pBufLock, ZOSS_WAIT_FOREVER);
            
            /* Ƶл */
            Video_ClearBuffer(g_VideoControlParam.pVideoBuffer);
            
            zOss_PutMutex(pVideoBuffer->pBufLock);

            /* Ƶݶȡ */
            if(g_VideoControlParam.iVideoExp & VIDEO_FILE_VIDEO_OVER_EXP)
            {
                /* ֪ͨ߳Ƶ */
                zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_OUT_OVER);

            }
            else
            {
                /* ֪߲ͨƵݣƵ */
                zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_DATA_FILL);
            }
            g_uiCount3++;
            zOss_Printf(1, 1, "Ƶͬ%d֡Ƶ",g_uiCount3);
            
            return;
        }
    }

    /* һ¼Ƶ֡ʱ */
    if(bFirst)
    {       
        /* ¼Ѳ֡ʼϵͳʱ̡һ֡Բʱ */
        g_VideoControlParam.tVideoOutInfo.uiPlayCount      = 0;
        g_VideoControlParam.tVideoOutInfo.uiSysStartTime   = zOss_GetTickCount() * ZOSS_MS_PER_TICK; 
        g_VideoControlParam.tVideoOutInfo.uiFrameStartTime = uiVideoDataTime1;
    }

    /* ¼ǰʱ(Ƶ) */
    g_VideoControlParam.tVideoOutInfo.uiVideoOutTime  = uiVideoDataTime1;
     
    /* ¼ѲƵ֡ */
    g_VideoControlParam.tVideoOutInfo.uiPlayCount++;

    /* 㵱ǰ֡벥ʱ */
    uiPerfectTime = g_VideoControlParam.tVideoOutInfo.uiSysStartTime 
                    + uiVideoDataTime1 - g_VideoControlParam.tVideoOutInfo.uiFrameStartTime;

    /* ǰʱϵͳʱУÿVIDEO_CALIBRATE_COUNT֡һУ */
    if (0 == g_VideoControlParam.tVideoOutInfo.uiPlayCount % VIDEO_CALI_NUM)
    {        
        /* ȡǰʵϵͳʱ */
        uiSysTime = zOss_GetTickCount() * ZOSS_MS_PER_TICK;
        
        /* ʵʱʱ֮ƫ */
        iOffset = uiSysTime - uiPerfectTime;

        /* ʱСΪ10ms */
        if(iDurationTime > iOffset + 10)
        {
            /* ʱԭƵ֡ĳʱʱƫ */
            iDurationTime = iDurationTime - iOffset;
        }
        else
        {
            /* ǰ֪̲֡ͨ߳Ƶ */
            Video_FreeDrvBuf(bARGB, g_uiScreenWidth, g_uiScreenHeight, &tImageData);

            /* Ƶݶȡ */
            if((g_VideoControlParam.iVideoExp & VIDEO_FILE_VIDEO_OVER_EXP)
                && g_VideoControlParam.pVideoBuffer->uiUsedLen == 0)
            {
                /* ֪ͨ߳Ƶ */
                zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_OUT_OVER);

            }
            else
            {
                /* ֪̲ͨ߳Ƶ */
                zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_VIDEO_DATA_SUPPLY);
            }
            g_uiCount2++;
//            zOss_Printf(42, 1, "ϵͳʱУ׼%d֡Ƶ",g_uiCount2);
            

            return;
        }
    }

    /* ¼ǰʱĶʱ */
    g_VideoControlParam.tVideoOutInfo.uiTimerDuration = iDurationTime;

//    zOss_Printf(42, 1, "EV_VIDEO_DATA_DECODE  decode msg send success! time: %d", zOss_GetTickCount());
    
    /* ֪ͨ߳̽ */
    zMspCom_PostMsg(g_VideoControlParam.pControlThread, /*EV_VIDEO_DATA_SUPPLY*/EV_VIDEO_DATA_DECODE);

    /* ʱ */
    g_uiTimerCount1++;
    if(iDurationTime < 10){iDurationTime = 10;}    
    uiRet = zOss_StartTimer(g_VideoControlParam.pVideoTimerId, 
                    iDurationTime, Video_TimeoutFunc, 0);
    if(uiRet != ZOSS_SUCCESS)
    {
        /* ֪̳ͨ߳쳣 */
        zMspCom_PostMsg(g_VideoControlParam.pControlThread, EV_OP_EXP);
        zMspCom_Print();

        return;
    }

    /* OSDӲˢOSDлͷŵϴεƵͼ */
    Zte_OsdUpdateVideoInput(&tImageData, bARGB, &tPlayRect);
    
    return;
}

/**
 * ƣ Video_OutputProcPauseMsg 
 *  Ƶ̴߳ͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_OutputProcPauseMsg(VOID)
{
    UINT32  uiRet = 0;
    
    /* ƳƵʹõĶʱ */
    if(g_VideoControlParam.pVideoTimerId != ZOSS_INVALID_TIMER_ID)
    {
        uiRet = zOss_KillTimer(g_VideoControlParam.pVideoTimerId);
        if(uiRet != ZOSS_SUCCESS)
        {
            zMspCom_Print();
            g_ErrorCode = DCAMERA_OP_ERROR;
        }
        g_VideoControlParam.pVideoTimerId = ZOSS_INVALID_TIMER_ID;
    }
    
    return;
}

/**
 * ƣ Video_OutputProcStopMsg 
 *  Ƶ̴ֹ߳ͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_OutputProcStopMsg(VOID)
{
    UINT32  uiRet;
    
    /* ƳƵʹõĶʱעöʱܱͣƳ */
    if(g_VideoControlParam.pVideoTimerId != ZOSS_INVALID_TIMER_ID)
    {
        uiRet = zOss_KillTimer(g_VideoControlParam.pVideoTimerId);
        if(uiRet != ZOSS_SUCCESS)
        {
            zMspCom_Print();
            g_ErrorCode = DCAMERA_OP_ERROR;
        }
        g_VideoControlParam.pVideoTimerId = ZOSS_INVALID_TIMER_ID;
    }

    /* ƵʱϢ */
    g_VideoControlParam.tVideoOutInfo.uiPlayCount      = 0;
    g_VideoControlParam.tVideoOutInfo.uiSysStartTime   = 0; 
    g_VideoControlParam.tVideoOutInfo.uiVideoOutTime   = 0;
    g_VideoControlParam.tVideoOutInfo.uiFrameStartTime = 0;

    /* Ƶл */
    Video_ClearBuffer(g_VideoControlParam.pVideoBuffer);
    
    return;
}

/**
 * ƣ Video_OutputProcCloseMsg 
 *  Ƶ̴߳رղϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_OutputProcCloseMsg(VOID)
{
    /* READY״̬Ƚֹͣ */    
    if(g_Curstate != VIDEO_PLAY_STATE_READY)
    {
        Video_OutputProcStopMsg();
    }
    return;
}

/**
 * ƣ Video_OutputThreadLoop 
 *  Ƶ߳Ϣѭ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Video_OutputThreadLoop(VOID)
{
    BOOL    bQuit  = FALSE;
    UINT32  uiMsg  = 0;
    SINT32  iRet  = -1;

    while(1)
    {
        /* Ϣ */
        iRet = zMspCom_RecvMsg(&uiMsg, ZOSS_WAIT_FOREVER);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            continue;
        }

        switch(uiMsg)
        {
            /* Ƶͼ״ */
            case EV_VIDEO_FIRST_OUT:
            {
                Video_OutputProcOutMsg(TRUE);

                break;
            }

            /* Ƶͼ */
            case EV_VIDEO_NORMAL_OUT:
            {
                Video_OutputProcOutMsg(FALSE);

                break;
            }

            /* Ƶͼͣ */
            case EV_VIDEO_OUT_PAUSE:
            {
                Video_OutputProcPauseMsg(); 
                
                /* ֪ͨ߳Ƶͣ */
                zOss_PutSemaphore(g_VideoControlParam.pOutputSem);

                break;
            }

            /* Ƶͼֹͣ */
            case EV_VIDEO_OUT_STOP:
            {
                Video_OutputProcStopMsg(); 
                
                /* ֪ͨ߳Ƶֹͣ */
                zOss_PutSemaphore(g_VideoControlParam.pOutputSem);

                break;
            }
            
            /* ƵϢ */
            case EV_VIDEO_OUT_CLOSE:
            {
                Video_OutputProcCloseMsg();

                /* ֪ͨ߳Ƶ */
                zOss_PutSemaphore(g_VideoControlParam.pOutputSem);

                bQuit = TRUE;
                
                break;
            }

            default:
            {
                break;
            }
        }

        /* ͷϢԴ */
        uiMsg = 0;
        
        if(bQuit)
        {
            break;
        }
    }

    /* ܻһЩĴ */    
    return;
}

/**
 * ƣ Video_ControlThreadEntry 
 *  Ƶ߳ں
 * ˵ (IN) arg ߳ں
 *   ֵ 
 * ˵ 
 */
static VOID Video_ControlThreadEntry(SINT32 arg)
{
    SINT32                  iRet    = MSP_COM_OP_ERROR;
    DCAMERA_RETURN_VALUE_E  eRet    = DCAMERA_OP_ERROR;
    UINT32                  uiMsg   = 0;

    /* ļʼýļļʽԼý
     * ļϢȡز(˴ƵʡƵ
     * BufferĴСϢ)
     */
    iRet = zMspCom_DecPreProcess(MSP_MODULE_VIDEO,
                                 g_VideoPlayParam.filepath, 
                                 &g_VideoFileParam);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;

        /* ͷͬź֪ͨụ̂߳߳׼ */
        zOss_PutSemaphore(g_VideoControlParam.pControlSem);
        
        return;
    }    

    /* PCM豸Video豸 */
    eRet = Video_OpenOutPutDev();
    if(eRet != DCAMERA_OP_SUCCESS)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        zMspCom_DecPostProcess(g_VideoFileParam.u32FileID);

        /* ͷͬź֪ͨụ̂߳߳׼ */        
        zOss_PutSemaphore(g_VideoControlParam.pControlSem);
        
        return;
    }    
    
    /* زʼ⡢ӦĽ */
    eRet = Video_MountDecodeLib();
    if(eRet != DCAMERA_OP_SUCCESS)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        Video_CloseOutPutDev();
        zMspCom_DecPostProcess(g_VideoFileParam.u32FileID);

        /* ͷͬź֪ͨụ̂߳߳׼ */        
        zOss_PutSemaphore(g_VideoControlParam.pControlSem);
        
        return;
    }    

    /* Ƶ */
    g_VideoControlParam.pVideoBuffer = Video_CreateBuffer(VIDEO_BUFFER_LEN);
    if(NULL == g_VideoControlParam.pVideoBuffer)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        Video_UnMountDecodeLib();
        Video_CloseOutPutDev();
        zMspCom_DecPostProcess(g_VideoFileParam.u32FileID);

        /* ͷͬź֪ͨụ̂߳߳׼ */        
        zOss_PutSemaphore(g_VideoControlParam.pControlSem);
        
        return;            
    }

    /* Ƶ߳ */   
    eRet = Video_CreateOutPutThread();
    if(eRet != DCAMERA_OP_SUCCESS)
    {
        g_ErrorCode = DCAMERA_OP_ERROR;
        Video_FreeBuffer(g_VideoControlParam.pVideoBuffer);
        Video_UnMountDecodeLib();
        Video_CloseOutPutDev();
        zMspCom_DecPostProcess(g_VideoFileParam.u32FileID);

        /* ͷͬź֪ͨụ̂߳߳׼ */
        zOss_PutSemaphore(g_VideoControlParam.pControlSem);
        
        return;
    }     
    
    /* ͷͬź֪ͨụ̂߳߳׼ */
    g_ErrorCode = DCAMERA_OP_SUCCESS;
    zOss_PutSemaphore(g_VideoControlParam.pControlSem);

    /* Ϣѭ */
    {
        Video_ControlThreadLoop();
    }

    /* ȴ߳̽ */
    {
        Video_WaitForOutThreadsEnd();
    }

    /* ٻ */
    {
        Video_ReleseDataList();
        Video_FreeBuffer(g_VideoControlParam.pVideoBuffer);
    }
    
    /* жؽ */
    {
        Video_UnMountDecodeLib();
    }

    /* رPCM豸Video豸 */
    {
        Video_CloseOutPutDev();
    }

    /* رýļ */
    {
        zMspCom_DecPostProcess(g_VideoFileParam.u32FileID);
    }

    //ȡϢеʣϢTOS߳˳ʱʣϢ
    while(MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsg, ZOSS_NO_WAIT))
    {
        uiMsg = 0;
    }

    /* ͷͬź֪ͨû߳(ӦreleaseӿеĻȡź) */
    zOss_PutSemaphore(g_VideoControlParam.pControlSem);

    /* ˳߳ */
    return;    
}

/**
 * ƣ Video_OutputThreadEntry 
 *  Ƶ߳ں
 * ˵ (IN) arg ߳ں
 *   ֵ 
 * ˵ 
 */
static VOID Video_OutputThreadEntry(SINT32 arg)
{
    SINT32 iRet    = 0;
    UINT32  uiMsg  = 0;
    /* Ϣѭ */
    Video_OutputThreadLoop();

    //ȡϢеʣϢTOS߳˳ʱʣϢ
    while(MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsg, ZOSS_NO_WAIT))
    {
        uiMsg = 0;
    }

    /* ͷͬź֪ͨ߳Ƶ߳̽ */
    zOss_PutSemaphore(g_VideoControlParam.pOutputSem);

    return;
}

/**
 * ƣ Audio_OutputThreadEntry 
 *  Ƶ߳ں
 * ˵ (IN) arg ߳ں
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputThreadEntry(SINT32 arg)
{
    SINT32 iRet  = 0;
    UINT32 uiMsg = 0;

    /* Ϣѭ */
    Audio_OutputThreadLoop();

    //ȡϢеʣϢTOS߳˳ʱʣϢ
    while(MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsg, ZOSS_NO_WAIT))
    {
        uiMsg = 0;
    }
    /* ͷͬź֪ͨ߳Ƶ߳̽ */
    zOss_PutSemaphore(g_VideoControlParam.pOutputSem);

    return;
}

