/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : oss_posix.c
* ļ : 
* ʵֹ : ossPOSIXӿ
*      : 
*      : V1.0
*  : 2013/01/12
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 
*    : 
* ޸ : 
* ޸ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#if defined _OS_TOS || defined _OS_OSE
#include "drv_api.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/

/**************************************************************************
* ݽṹ
**************************************************************************/
 
/**************************************************************************
* ֲԭ
**************************************************************************/
 
/**************************************************************************
* ȫֳ/
**************************************************************************/
#if defined _OS_OSE || defined _OS_WIN
static ZOSS_S_TIMEZONE gOsa_tz  = {0};  /* timezone */
#endif

/**************************************************************************
* ȫֺʵ
**************************************************************************/

#ifdef _OS_OSE
/**************************************************************************
* : zOss_Gettimeofday
* : ȡʱʱ;
* ˵: (IN)tv:ʱĽṹָ룬ΪNULL
                tz:The use of the timezone structure is obsolete.the tz argument
                     should normally be specified as NULL
*   ֵ: tick
* ˵: Local time zone(tz) not implemented.Linuxtimezoneʹ
*           ϳʹ.ΪչԼʱ,չ
*           Լʱʹ,޿Ԥ,û
*           򵥵ķʵ.
**************************************************************************/
UINT32  zOss_Gettimeofday(ZOSS_S_TIMEVAL *tv, ZOSS_S_TIMEZONE *tz)
{
    zOss_AssertEx(tv != NULL, ZOSS_ERROR);
    
    /* ose ûдtz */
    if (gettimeofday(tv, tz) == -1)
    {
        return ZOSS_ERROR;
    }

    if (tz != NULL)
    {
        *tz = gOsa_tz;
    }

    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_Settimeofday
* : òϵͳʱӼRTCӲʱ,ûʹ
* ˵: (IN)    tv:ʱĽṹָ룬ΪNULLʱֲ
                    tz:õʱϢṹָ,ΪNULL,ΪNULLʱֲ
*   ֵ:  ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:  Local time zone(tz) not implemented. Linuxtimezoneʹ
*            ϳʹ.ΪչԼʱ,չ
*            Լʱʹ,޿Ԥ,û
*            򵥵ķʵ.
**************************************************************************/
UINT32  zOss_Settimeofday(ZOSS_S_TIMEVAL *tv, ZOSS_S_TIMEZONE *tz)
{
    struct tm           *tTm        = NULL;
    T_ZDrvRtc_TimeDate  tDatetime   = {0};
    T_ZDrvRtc_TimeDate  tTemp       = {0};

    zOss_AssertEx(tv != NULL, ZOSS_ERROR);
    
    tTm = gmtime((const time_t* )&(tv->tv_sec));
    if (0 != Rtc_GetDateTime(&tTemp))
    {
       return ZOSS_ERROR;
    }    

    tDatetime.year          = (UINT16)tTm->tm_year + 1900;
    tDatetime.month         = (UINT8)tTm->tm_mon + 1; 
    tDatetime.day           = (UINT8)tTm->tm_mday;
    tDatetime.hour          = (UINT8)tTm->tm_hour;
    tDatetime.minute        = (UINT8)tTm->tm_min;
    tDatetime.second        = (UINT8)tTm->tm_sec;
    tDatetime.PM_flag       = tTemp.PM_flag;
    tDatetime.mode_12_hour  = tTemp.mode_12_hour;
    tDatetime.wday          = tTemp.wday;
    
    if (0 != Rtc_SetDateTime(&tDatetime))
    {
        return ZOSS_ERROR;
    }    

    /*  */
    /* ose ûдtz */
    if (settimeofday(tv, tz) == -1)
    {
        Rtc_SetDateTime(&tTemp);
        return ZOSS_ERROR;
    }    
     
    if (tz != NULL)
    {
        gOsa_tz = *tz ;
    }

    return ZOSS_SUCCESS;
}
#endif

#ifdef _OS_WIN
/**************************************************************************
* ƣ zOss_Gettimeofday
*  ȡʱʱ
* ˵ (IN)
             (OUT)
             tv: ȡʱĽṹָ,1970ǰ΢
             tz: ȡʱϢṹָ
*   ֵ ɹZOSS_SUCCESS, ʧܷZOSS_ERROR
* ˵ Local time zone(tz) not implemented.Linuxtimezoneʹ
             ϳʹ.ΪչԼʱ,չԼʱ
             ʹ,޿Ԥ,ûм򵥵ķʵ
             windowsƽ̨tzЧ
**************************************************************************/
UINT32 zOss_Gettimeofday(ZOSS_S_TIMEVAL *tv, ZOSS_S_TIMEZONE *tz)
{
    SYSTEMTIME  systime;
    struct      tm tm_time;
    time_t      tm_t;

    zOss_AssertEx(NULL != tv, ZOSS_ERROR);
    
    GetLocalTime(&systime);
    tm_time.tm_sec  = systime.wSecond;
    tm_time.tm_min  = systime.wMinute;
    tm_time.tm_hour = systime.wHour;
    tm_time.tm_mday = systime.wDay;
    tm_time.tm_mon  = systime.wMonth -1;    /* systime.wMonth(1-12),tm_time.tm_mon(0-11)    */
    tm_time.tm_year = systime.wYear - 1900;   /* 1900ڵʱ                         */

    tm_t            = mktime(&tm_time);
    tv->tv_sec      = tm_t;
    tv->tv_usec     = systime.wMilliseconds * 1000;

    if (tz != NULL)
    {
        *tz = gOsa_tz;
    }

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ zOss_Settimeofday
*  ʱʱ
* ˵ (IN)
             tv: ʱĽṹָ
             tz: õʱϢṹָ
             (OUT)
*   ֵ ɹ:ZOSS_SUCCESS,ʧ:ZOSS_ERROR
* ˵ Local time zone(tz) not implemented.Linuxtimezoneʹ
             ϳʹ.ΪչԼʱ,չԼʱ
             ʹ,޿Ԥ,ûм򵥵ķʵ
             windowsƽ̨ӿЧ
**************************************************************************/
UINT32 zOss_Settimeofday(ZOSS_S_TIMEVAL *tv, ZOSS_S_TIMEZONE *tz)
{
    SYSTEMTIME  systime;
    struct      tm tm_time;

    if (tv != NULL) /* for pclint check */
    {
        tm_time = *localtime(&tv->tv_sec);
        systime.wSecond         = (UINT16)tm_time.tm_sec;
        systime.wMinute         = (UINT16)tm_time.tm_min;
        systime.wHour           = (UINT16)tm_time.tm_hour;
        systime.wDay            = (UINT16)tm_time.tm_mday;
        systime.wMonth          = (UINT16)tm_time.tm_mon + 1;       /* systime.wMonth(1-12),tm_time.tm_mon(0-11)  */
        systime.wYear           = (UINT16)tm_time.tm_year + 1900;   /* 1900ڵʱ                       */
        systime.wDayOfWeek      = (UINT16)tm_time.tm_wday;
        systime.wMilliseconds   = (UINT16)(WORD)tv->tv_usec / 1000;

        if (!SetLocalTime(&systime))
        {
            return ZOSS_ERROR;
        }
    }

    if (tz != NULL)
    {
        gOsa_tz = *tz;
    }

    return ZOSS_SUCCESS;
}
#endif

#ifdef _OS_LINUX
/**************************************************************************
* :     ȡʱʱ
* ˵:     
*   ()  void
*   ()  tv:     ʱĽṹָ룬ΪNULLϵͳԣ
                tz:     ʱĽṹָ룬ΪNULL
*   ֵ:     ɹZOSS_SUCCESS
                ʧܣZOSS_ERROR
* ˵:     Local time zone(tz) not implemented.LinuxtimezoneʹѾ
                ϳʹ.ΪչԼʱ,չԼʱʹ
                ,޿Ԥ,ûм򵥵ķʵ
**************************************************************************/
UINT32  zOss_Gettimeofday(ZOSS_S_TIMEVAL *tv, ZOSS_S_TIMEZONE *tz)
{
    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     òϵͳʱӼRTCӲʱ,ûʹ
* ˵:     
*   ()  tv:     ʱĽṹָ룬ΪNULLʱֲ䣻
                tz:     ʱĽṹָ룬ΪNULLʱֲ䡣
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS
                ʧܣZOSS_ERROR
* ˵:     Local time zone(tz) not implemented. LinuxtimezoneʹѾ
                ϳʹ.ΪչԼʱ,չԼʱʹ
                ,޿Ԥ,ûм򵥵ķʵ
**************************************************************************/
UINT32 zOss_Settimeofday(ZOSS_S_TIMEVAL *tv, ZOSS_S_TIMEZONE *tz)
{
    return ZOSS_SUCCESS;
}
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/

#ifdef __cplusplus
 }
#endif

