/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : sup_shell_psm.c
* ļ : 
* ʵֹ : ʡصshell
*      : 
*      : V1.0
*  : 2019-01-10
* ˵ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "sup_shell.h"
#include "sup_shell_cmd.h"
#include "sup_except.h"
#include "osa.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/

/**************************************************************************
* ݽṹ
**************************************************************************/
 
/**************************************************************************
* ֲԭ
**************************************************************************/
 
/**************************************************************************
* ȫֳ/
**************************************************************************/
#ifdef _USE_PSM
ZOSS_SEMAPHORE_ID g_zTos_PsmInfoSema   = NULL;
ZOSS_TIMER_ID	  g_zTos_PsmInfoTimer  = NULL;
ZOSS_THREAD_ID	  g_zTos_PsmInfoThread = NULL;
#ifdef _USE_CPU_DFM
ZOSS_SEMAPHORE_ID g_zTos_DfmInfoSema   = NULL;
ZOSS_TIMER_ID	  g_zTos_DfmInfoTimer  = NULL;
ZOSS_THREAD_ID	  g_zTos_DfmInfoThread = NULL;
#endif
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* ȫֺʵ
**************************************************************************/

#ifdef _USE_PSM
#ifdef _USE_CPU_DFM
/**************************************************************************
* : OSS_DfmInfoTimerFunc
* ˵:     
*           (IN)  args: 
*           (OUT) 
*   ֵ: 
* ˵: 
**************************************************************************/
VOID OSS_DfmInfoTimerFunc(SINT32 args)
{
    UINT32 status = zOss_PutSemaphore(g_zTos_DfmInfoSema);
    zOss_AssertExN(status == ZOSS_SUCCESS);
}

/**************************************************************************
* : OSS_DfmInfoThreadEntry
* ˵:     
*           (IN)  args:
*           (OUT) 
*   ֵ: 
* ˵: 
**************************************************************************/
VOID OSS_DfmInfoThreadEntry(SINT32 args)
{
    while(1)
    {
        zOss_GetSemaphore(g_zTos_DfmInfoSema, ZOSS_WAIT_FOREVER);
        zOss_DfmTraceInfo();
    }
}

/**************************************************************************
* : OSS_DfmTraceInfo
* ˵:     
*           (IN)  CmdMsg: shellϢָ
*           (OUT) 
*   ֵ: 
* ˵: 
**************************************************************************/
VOID OSS_DfmTraceInfo(T_Shell_CommandMessage *CmdMsg)
{
    UINT32 tmp = 0;

    zOss_AssertExN(CmdMsg != NULL);
    if ((1 != CmdMsg->paraCount) || (-1 == Shell_StrisNumber(CmdMsg->para[0])))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ĸʽ: dfminfo 01 \n");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t 0:ر, 1:\n");
        return;
    }

    tmp = strtoul((char*)CmdMsg->para[0], NULL, 0);
    if (tmp >1)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ĸʽ: dfminfo 01 \n");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t 0:ر, 1:\n");
        return;
    }
    
    if (tmp)
    {
        g_zTos_DfmInfoSema   = zOss_CreateSemaphore("dfminfosema", 0);
        g_zTos_DfmInfoTimer  = zOss_CreateTimer("dfminfotimer", OSS_DfmInfoTimerFunc, 10, TRUE);
        g_zTos_DfmInfoThread = zOss_CreateThread("dfminfothread", OSS_DfmInfoThreadEntry, 0, 4096, 25, 1, 1);
        zOss_StartTimer(g_zTos_DfmInfoTimer, 10, OSS_DfmInfoTimerFunc, 0);
    }
    else
    {
        zOss_DeleteThread(g_zTos_DfmInfoThread);
        zOss_KillTimer(g_zTos_DfmInfoTimer);
        zOss_DeleteSemaphore(g_zTos_DfmInfoSema);
    }

    return;
}
#endif  //_USE_CPU_DFM

/**************************************************************************
* : OSS_PsmInfoTimerFunc
* ˵:     
*           (IN)  args: 
*           (OUT) 
*   ֵ: 
* ˵: 
**************************************************************************/
VOID OSS_PsmInfoTimerFunc(SINT32 args)
{
    UINT32 status = zOss_PutSemaphore(g_zTos_PsmInfoSema);
    zOss_AssertExN(status == ZOSS_SUCCESS);
}

/**************************************************************************
* : OSS_PsmInfoThreadEntry
* ˵:     
*           (IN)  args: 
*           (OUT) 
*   ֵ: 
* ˵: 
**************************************************************************/
VOID OSS_PsmInfoThreadEntry(SINT32 args)
{
    while(1)
    {
        zOss_GetSemaphore(g_zTos_PsmInfoSema, ZOSS_WAIT_FOREVER);
        zOss_PsmTraceInfo();
    }
}

/**************************************************************************
* : OSS_PsmTraceInfo
* ˵:     
*           (IN)  CmdMsg: shellϢָ
*           (OUT) 
*   ֵ: 
* ˵: 
**************************************************************************/
VOID OSS_PsmTraceInfo(T_Shell_CommandMessage *CmdMsg)
{
    UINT32 tmp = 0;

    zOss_AssertExN(CmdMsg != NULL);
    if ((1 != CmdMsg->paraCount)||(-1 == Shell_StrisNumber(CmdMsg->para[0])))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ĸʽ: psminfo 01 \n");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t 0:ر, 1:\n");
        return;
    }

    tmp = strtoul((char*)CmdMsg->para[0], NULL, 0);
    if (tmp > 1)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ĸʽ: psminfo 01 \n");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t 0:ر, 1:\n");
        return;
    }
    
    if (tmp)
    {
        g_zTos_PsmInfoSema   = zOss_CreateSemaphore("psminfosema", 0);
        g_zTos_PsmInfoTimer  = zOss_CreateTimer("psminfotimer", OSS_PsmInfoTimerFunc, 10, TRUE);
        g_zTos_PsmInfoThread = zOss_CreateThread("psminfothread", OSS_PsmInfoThreadEntry, 0, 4096, 25, 1, 1);
        zOss_StartTimer(g_zTos_PsmInfoTimer, 30, OSS_PsmInfoTimerFunc, 0);
    }
    else
    {
        zOss_DeleteThread(g_zTos_PsmInfoThread);
        zOss_KillTimer(g_zTos_PsmInfoTimer);
        zOss_DeleteSemaphore(g_zTos_PsmInfoSema);
    }

    return;
}
#endif // _USE_PSM

#ifdef __cplusplus
}
#endif

