/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    drvs_iokeys.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2014-02-11
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_IOKEYS_H
#define _DRVS_IOKEYS_H

/****************************************************************************
* 	                                        Macros
****************************************************************************/
#define IOKEYS(x) (1)
/****************************************************************************
* 	                                        Types
****************************************************************************/
/*IO CTRL Function KEY*/
typedef enum _T_DRVIO_CTRL_KEY
{
// for io dal layer use
	IOCTL_IODEV_REGISTER_NOTIFY = 2,
	IOCTL_IODEV_GET_DEV_STATUS,
	IOCTL_IODEV_WAIT_CONNECT,
	IOCTL_IODEV_DISALLOW_DISCONNECT,
	IOCTL_IODEV_ALLOW_DISCONNECT,
	IOCTL_IODEV_VENDOR = 31,
//end

	/*¿豸ӺЧ*/

// for common io device

    IOCTL_IODEV_SET_BLOCKTIME = 0x1000,

// for block device function

	IOCTL_BLKDEV_GET_INFO=0x2000,
	IOCTL_BLKDEV_EREASE,
	IOCTL_BLKDEV_GET_STATE,

// for serial device function

	IOCTL_SERIAL_SET_CONFIG=0x3000,
	IOCTL_SERIAL_UART_SET_CTSRTS,
	IOCTL_SERIAL_UART_SET_CONFIG,

// for virtual com port

    IOCTL_VCOM_GET_USB_STATUS=0x4000,
    IOCTL_VCOM_OPEN_ECHO,
    IOCTL_VCOM_CLOSE_ECHO,


// for virtual NIC(Netword Interface Card)

    IOCTL_VNIC_CONNECT=0x5000,
    IOCTL_VNIC_DISCONNECT,

    IOCTL_VNIC_REG_CBK_XFER_STATISTICS,
    IOCTL_VNIC_FREE_UNREAD_BUF,
    IOCTL_VNIC_REG_CBK_NIC_DISABLE,
    IOCTL_VNIC_GET_USB_STATUS,
    IOCTL_VNIC_REG_CBK_NIC_ENABLE,
    IOCTL_VNIC_GET_VNIC_STATE,
    IOCTL_VNIC_SET_ECM_TPYE,
    IOCTL_VNIC_SET_NET_DEV,

// for io voice

    IOCTL_VOICE_SET_SAMPLE    = 0x6000,          /*Set sample.param:T_ZDrvVoice_Sample*/
    IOCTL_VOICE_SET_INPUT_PATH,      /*Set input path.  param:T_ZDrv_VoiceInputPath*/
    IOCTL_VOICE_SET_OUTPUT_PATH,     /*Set output path.  param:T_ZDrv_VoiceOutputPath*/
    IOCTL_VOICE_SET_INPUT_VOL,       /*Set input volume. param:T_ZDrvVoice_InputVolLevel*/
    IOCTL_VOICE_SET_OUTPUT_VOL,      /*Set output volume. param:T_ZDrvVoice_OutputVolLevel*/
    IOCTL_VOICE_ENABLE,              /*enable voice  channel.param:none*/
    IOCTL_VOICE_DISABLE,             /*disable voice channel.param:none*/

    IOCTL_VOICE_SET_VT_START,        /*Start voice for VideoTelephone. param:T_ZDrvVoice_AmrInfoPtr*/
    IOCTL_VOICE_SET_VT_STOP,         /*Stop voice for VideoTelephone. param:NULL*/
    IOCTL_VOICE_SET_MUTE,            /*Set voice mute or not. param:T_ZDrvVoice_MuteInfo*/
    IOCTL_VOICE_RECORD_START,        /*record start.param:T_ZDrvRcd_InfoParam*/
    IOCTL_VOICE_RECORD_STOP,         /*record stop.param:none*/
    IOCTL_VOICE_RECORD_DATA_READ,    /*read record data. param:T_ZDrvVoice_BufInfo*/
    IOCTL_VOICE_TEST_LOOPBACK,       /*Set voice loop or not. param:T_ZDrvVoice_Switch*/
    IOCTL_VOICE_RCD_FREE_BUFF,       /*free record buffer. param:VOID*/

    IOCTL_VOICE_CONFIG_PARAM,             /*config volte param .param:T_ZDrvVp_Cfg, for volte*/
    IOCTL_VOICE_READ_START,             /* volte read start .param:VOID, for volte*/
    IOCTL_VOICE_READ_STOP,             /* volte read stop .param:VOID, for volte*/
    IOCTL_VOICE_WRITE_START,             /* volte write start .param:VOID, for volte*/
    IOCTL_VOICE_WRITE_STOP,             /* volte write stop .param:VOID, for volte*/
    IOCTL_VOICE_MODE_CONFIG,

// for audio
    IOCTL_AUDIO_RECORD_START,      /* start record,param:T_ZDrvRcd_InfoParam */
    IOCTL_AUDIO_RECORD_STOP,       /* stop record,param:none */
    IOCTL_AUDIO_SET_RECORD_PATH,   /* set record input path,param:T_ZDrv_CodecInputPath */
    IOCTL_AUDIO_SET_RECORD_VOL,    /* set record volum,param:T_ZDrvAudio_InputVolLevel */
    IOCTL_AUDIO_RCD_FREE_BUFF,     /* free record buffer,param:VOID * */
    IOCTL_AUDIO_SET_RECORD_SAMPLE,  /* Set audio codec config for RECORD, SAMPLE param:T_ZDrvAudio_SampleRate  */
    IOCTL_AUDIO_SET_SAMPLE,            /* Set audio codec config for PLAY, SAMPLE param:T_ZDrvAudio_SampleRate */
    IOCTL_AUDIO_SET_BANLANCE,      /* set balance,param:T_ZDrvAudio_Banlance */
    IOCTL_AUDIO_SET_OUTPUT_PATH,   /* Set OUTPUT path for play ,param:T_ZDrv_AudioOutputPath */
    IOCTL_AUDIO_SET_OUTPUT_VOL,    /* Set OUTPUT volume for play ,param:T_ZDrvAudio_OutputVolLevel */
    IOCTL_AUDIO_SET_EQMODE,        /* set EQmode,param:T_ZDrvAUDIO_EQMODE */
    IOCTL_AUDIO_ENABLE_3DEFFECT,   /* set 3deffect,param:T_ZDrvAudio_3DEFFECT */
    IOCTL_AUDIO_SET_MUTE,          /* set mute,param:BOOL */
    IOCTL_AUDIO_PLAY_START,        /* start  audio play ,param:T_ZDrvAudio_PlayParam */
    IOCTL_AUDIO_PLAY_STOP,         /* stop  audio play,param:none */
    IOCTL_AUDIO_PLAY_PAUSE,        /* pause  audio play,param:none */
    IOCTL_AUDIO_PLAY_RESUME,       /* resume  audio play ,param:none */
    IOCTL_AUDIO_GET_PLAY_INFO,     /* get the audio play info ,param:T_ZDrvAudio_PlayInfo */
    IOCTL_AUDIO_GET_BUFFER,        /* get the audio buffer ,param:T_ZDrvAudio_BufInfo */
    IOCTL_AUDIO_SET_CALLBACK,      /* set audio callback func,param:T_ZDrvAudio_CallbackFunc */

//for earpiece
	IOCTL_EARP_SET_CALLBACK 	,  /*Set callback function, it is used to register the callback function which will send the earpiece switch status to user.*/
	IOCTL_EARP_GET_PLUG_STATUS	 ,	/*Get earpiece plug status, replace the read function.*/
	IOCTL_EARP_SET_HOOK_ENABLE,
	IOCTL_EARP_SET_HOOK_DISABLE,

// for io led
    IOCTL_LED_WAN = 0x7000,
    IOCTL_LED_LAN,
    IOCTL_LED_SMS,
    IOCTL_LED_BATTERY,
    IOCTL_LED_TRAFFIC,
    IOCTL_LED_SLEEP,
    IOCTL_LED_LEFT_1,
    IOCTL_LED_LEFT_2,
    IOCTL_LED_LEFT_3,
    IOCTL_LED_LEFT_4,
    IOCTL_LED_1_2_ON,
    IOCTL_LED_1_2_3_ON,
    IOCTL_LED_ALL_ON,
    IOCTL_LED_ALL_OFF,
    IOCTL_LED_CTRL_MOD,
    IOCTL_LED_LGP,

// for rtc
    IOCTL_PMIC_RTC_SET_TIME = 0x8000,
    IOCTL_PMIC_RTC_GET_TIME,
    IOCTL_PMIC_RTC_SET_ALARM,
    IOCTL_PMIC_RTC_GET_ALARM,
    IOCTL_PMIC_RTC_ENABLE_ALARM,
    IOCTL_PMIC_RTC_ENABLE_CYCLE,
    IOCTL_PMIC_RTC_REGIS_CYCLE_NOTIFY,
    IOCTL_PMIC_RTC_REGIS_ALARM_NOTIFY,
    IOCTL_PMIC_RTC_ENABLE_TIMER,          //timerʱ, 0ر
    IOCTL_PMIC_RTC_REGIS_TIMER_NOTIFY,    //timerʱص
    IOCTL_PMIC_RTC_GET_TIMER_REMAIN,      //ȡtimerʣʱ
    IOCTL_PMIC_RTC_CYCLE_INT_SEL,


//for charger
    IOCTL_CHARGER_SET_CALLBACK = 0x9000,
    IOCTL_CHARGER_GET_VOLTAGE,
    IOCTL_CHARGER_GET_CHG_STATUS,
    IOCTL_CHARGER_GET_DISCHG_STATUS,
    IOCTL_CHARGER_TEMP_DETECT,
    IOCTL_CHARGER_CHG_SWITCH,
    IOCTL_CHARGER_DISCHG_SWITCH,
    IOCTL_CHARGER_QUICK_START_FLAG,
    IOCTL_CHARGER_GET_CHGTYPE,
    IOCTL_CHARGER_BOOST_ON,
    IOCTL_CHARGER_RELEASE_BUTTON,
    IOCTL_CHARGER_GET_ELECQUAN,
    IOCTL_CHARGER_DEBUG,
    

    IOCTL_CHARGER_SET_OTG,
    IOCTL_CHARGER_SET_SHIPPING_MODE,
    IOCTL_CHARGER_GET_ERROR_CODE,
    IOCTL_CHARGER_SET_STOP_CURRENT,
    IOCTL_CHARGER_GET_STOP_REASON,
    IOCTL_CHARGER_GET_USB_STATUS,

//for LCD
    IOCTL_LCD_UPDATE = 0xA000,
    IOCTL_LCD_SLEEP,
    IOCTL_LCD_BACKLIGHT,
    IOCTL_LCD_BRIGHTNESS,
    IOCTL_LCD_GET_INFO,
	IOCTL_LCD_VOU_WBUPDATE,
//for spi
	IOCTL_SSP_SET_XFER_WIDTH,
	IOCTL_SSP_SET_CHG_FREQ,
	IOCTL_SSP_SET_MSMODE,
	IOCTL_SSP_SET_TXTHES,
	IOCTL_SSP_SET_RXTHES,

//for FM
	IOCTL_FM_SET_OUTPATH = 0xB000,
	IOCTL_FM_SET_VOL,
	IOCTL_FM_SET_SOUNDMODE,
	IOCTL_FM_SET_FREQ,
	IOCTL_FM_SET_SCANNEXT,
	IOCTL_FM_GET_CURFREQ,
	IOCTL_FM_GET_CURVOL,

//for VIB
	IOCTL_VIB_ENABLE = 0xC000,
	IOCTL_VIB_CHECKSTA,

/* for Keypad */
    IOCTL_KPD_SET_BLG_ON = 0xD000,
    IOCTL_KPD_SET_BLG_OFF,
    IOCTL_KPD_SET_BLG_BRIGHTNESS,
    IOCTL_KPD_GET_BLG_STATUS,
    IOCTL_KPD_GET_KEYS_STATUS,
    IOCTL_KPD_GET_HEADPHONE_STATE,

//for FLASHLIGHT
	IOCTL_FLASHLIGHT_ENABLE = 0xF000,
	IOCTL_FLASHLIGHT_CHECKSTA,
//for CAMERA
	IOCTL_CAM_SENSOR_GET_INFO = 0x10000,
	IOCTL_CAM_SENSOR_SELECT,
	IOCTL_CAM_SET_ZOOM,
	IOCTL_CAM_SET_IMG_SIZE,
	IOCTL_CAM_SET_EFFECT,
	IOCTL_CAM_SET_MIRRORFLIP,
	IOCTL_CAM_SET_BRIGHTNESS,
	IOCTL_CAM_SET_CONTRAST,
	IOCTL_CAM_SET_SATURATION,
	IOCTL_CAM_SET_WHITE_BALANCE,
	IOCTL_CAM_SET_LIGHTMODE,
	IOCTL_CAM_SET_NIGHTMODE,
	IOCTL_CAM_SET_FRAMERATE,
	IOCTL_CAM_GET_ONEFRAME,
	IOCTL_CAM_FREE_FRAME_BUFFER,
//	IOCTL_CAM_SET_EXPOSURE_COMPENSATION,
	IOCTL_CAM_SET_ANTIFLICKER,
	IOCTL_CAM_START,
	IOCTL_CAM_STOP,
	IOCTL_UNDEFINE=0x7FFFFFFF

} T_DRVIO_CTRL_KEY;

//===================IO DEV===============

#if IOKEYS(IOCTL_VNIC_GET_VNIC_STATE)
/*VNIC State*/
typedef enum _T_DRVIO_VNIC_STATE
{
    DRVIO_VNIC_DISABLE = 0x0,	//״̬
    DRVIO_VNIC_READY = 0x1,		//δӣɲ
    DRVIO_VNIC_CONNECT = 0x2,	//
    DRVIO_VNIC_ERR = 0xff,		//쳣״̬
}
T_DRVIO_VNIC_STATE;
#endif

#if IOKEYS(IOCTL_IODEV_GET_DEV_STATUS)
/*Device Status*/
typedef struct _T_DRVIO_DEV_STATUS
{
	UINT32 CONNECT: 1;
	UINT32 reserved:31;
}
T_DRVIO_DEV_STATUS;
#endif

#if IOKEYS(IOCTL_IODEV_REGISTER_NOTIFY)
/*Global Event*/
typedef enum _T_DRVIO_EVENT
{
    DRVIO_EV_CONNECT = 2,
    DRVIO_EV_PRE_DISCONNECT,
    DRVIO_EV_DISCONNECT,
} T_DRVIO_EVENT;

/*Device Notify*/
typedef struct _T_ZDrvIO_DevNotify
{
    VOID ( *notify_fn )(VOID *privData, T_DRVIO_EVENT  event);
    VOID *privData;
}
T_ZDrvIO_DevNotify;
#endif

//===================block device===============

#if IOKEYS(IOCTL_BLKDEV_GET_INFO)
typedef struct  _T_BlkDev_Info
{
    UINT32 blkSize;
    UINT32 blkCnt;
}T_BlkDev_Info;
#endif


#if IOKEYS(IOCTL_BLKDEV_EREASE)
typedef struct  _T_BlkDev_EraseInfo
{
    UINT32 startBlk;
    UINT32 blkCnt;
}T_BlkDev_EraseInfo;
#endif


#if IOKEYS(IOCTL_SERIAL_SET_CONFIG)
typedef struct  _T_UartDev_ConfigInfo
{
	UINT8  dataBits;
	UINT8  stopBits;
	UINT8  parity;
	UINT32	baudrate;
}T_UartDev_ConfigInfo;
#endif



typedef union
{
    UINT8 nodeInBytes[8];
    struct
    {
        UINT8* 	pNodeBuf;
        UINT32 	uiNodeBufLen;
    }
    node;
}
T_ZDrv_BufNode;

typedef  T_ZDrv_BufNode T_ZDrvVcom_BufNode;

typedef unsigned long long  UINT64;

#if IOKEYS(IOCTL_VNIC_REG_CBK_XFER_STATISTICS)
typedef struct  _T_ZDrvVnic_XferStatistics
{
    UINT64 TxOkCnt;
    UINT64 RxOkCnt;
    UINT64 TxErrCnt;
    UINT64 RxErrCnt;
    UINT64 TxOverFlowCnt;
    UINT64 RxOverFlowCnt;
}
T_ZDrvVnic_XferStatistics;

typedef  T_ZDrvVnic_XferStatistics* (* VnicCbk_XferStatistics) (VOID);
#endif


#if IOKEYS(IOCTL_VNIC_REG_CBK_NIC_DISABLE)
typedef  VOID (* VnicCbk_Disable) (VOID*privData);
#endif


#if IOKEYS(IOCTL_VNIC_REG_CBK_NIC_ENABLE)
typedef  VOID (* VnicCbk_Enable) (VOID*privData);
#endif

//typedef  UINT32  (* VnicCbk_GetSpeed) (VOID);

#endif/*_DRVS_IOKEYS_H*/

