/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    Drvs_voice_config.h
 * File Mark:
 * Description:  Provide the interface for the voice config of refdrv
 * Others:
 * Version:       V0.5
 * Author:        xuxinqiang
 * Date:          2014-06-04
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#ifndef _DRVS_VPCFG_H
#define _DRVS_VPCFG_H

/*************************************************************************
  *                                  Include files                                                                         *
  *************************************************************************/

#include "drvs_voiceprocess.h"
#include "drvs_i2s.h"
#include "drvs_codec.h"
#include "drvs_tdm.h"

/**************************************************************************
 *                                  Types                                                                                   *
 **************************************************************************/


//the size of each buffer should >=0.5MB
typedef struct _T_ZDrv_VpInOutBuffer
{
	UINT8* p_voiceRxInBuffer ;/*the  pcm data in the s_voiceRxInBuffer,receive   from  far-end. */
	UINT8* p_voiceTxInBuffer ;/*  the  pcm data in the s_voiceTxInBuffer, receiver from codec.*/
	UINT8* p_voiceRxOutPutBuffer;/*  the  pcm data in the s_voiceRxOutPutBuffe, will send to codec.*/
	UINT8* p_voiceTxOutPutBuffer;/*  the  pcm data in the s_voiceTxOutBuffer, will send to near end.*/

}T_ZDrv_VpInOutBuffer;


typedef struct 
{ 
    SINT32 (*hal_VpCfg_OpenBegin_obsolete)(VOID); 
    SINT32 (*hal_VpCfg_OpenEnd_obsolete)(VOID);             
    SINT32 (*hal_VpCfg_Close_obsolete)(VOID); 
    SINT32 (*hal_VpCfg_Open)(T_ZDrvVp_SourceType srctype); 
    SINT32 (*hal_VpCfg_Close)(VOID);             
    SINT32 (*hal_VpCfg_Enable)(VOID);              
    SINT32 (*hal_VpCfg_Disable)(VOID);  
    SINT32 (*hal_VpCfg_SetFs)(T_ZDrv_VpFs fs);
    SINT32 (*hal_VpCfg_SetInputPath)(T_ZDrv_VpPath path,BOOL enable);  
    SINT32 (*hal_VpCfg_SetOutputPath)(T_ZDrv_VpPath path,BOOL enable); 
    SINT32 (*hal_VpCfg_SetMute)(T_ZDrv_VpPath path,BOOL mute);	
    SINT32 (*hal_VpCfg_SetFmPath)(T_ZDrv_VpPath path,BOOL enable);	
    SINT32 (*hal_VpCfg_SetLoopback)(BOOL enable);		
    SINT32 (*hal_VpCfg_SetInputVol)(T_ZDrv_VpVol vol);  
    SINT32 (*hal_VpCfg_SetOutputVol)(T_ZDrv_VpVol vol); 	
    SINT32 (*hal_VpCfg_SetUseProtocol)(T_ZDrvCodec_UseProtocol useProtocol); 
	SINT32 (*hal_VpCfg_GetMixerToneInfo)(T_ZDrvVp_ToneNum toneNum,T_HalMixerToneInfo *toneInfo);
	SINT32 (*hal_VpCfg_GetAudioLoopInfo)(T_HalAudioLoopTestInfo *audioInfo); 
	SINT32 (*hal_VpCfg_GetAudioLoopResult)(T_HalAudioLoopTestPra *audioPra);
    SINT32 (*hal_VpCfg_SetInputMute)(BOOL mute);
    SINT32 (*hal_VpCfg_SetOutputMute)(BOOL mute);

} T_HalVpCfg_Opt;
extern SINT32 zDrvVp_SetExtAudioCfg(T_ZDrvI2S_Cfg *pI2sNbCfg,T_ZDrvI2S_Cfg *pI2sWbCfg, 
                                  T_ZDrvTdm_Cfg *pTdmNbCfg,T_ZDrvTdm_Cfg *pTdmWbCfg);
//voice config
extern SINT32 zDrvVp_SetI2sCfg(T_ZDrvI2S_Cfg *s_VpI2sCfg);//obsolete
extern SINT32 zDrvVp_SetExtI2sCfg(T_ZDrvI2S_Cfg *pI2sNbCfg,T_ZDrvI2S_Cfg *pI2sWbCfg);

extern SINT32 zDrvVp_SetInOutBuffer(T_ZDrv_VpInOutBuffer *pInOutBuffer);	//obsolete
extern SINT32 zDrvVp_SetInOutBufferAddSize(T_ZDrv_VpInOutBuffer *pInOutBuffer,UINT32  bufSize);	
extern VOID zDrvVpCfg_SetOperations(T_HalVpCfg_Opt* VpCfg_ObjPtr);
extern SINT32 zDrvVp_Init(VOID);

extern SINT32 zDrvVoice_Initiate(VOID);
extern SINT32 Aud_TaskInt_Init(VOID);

//is usd for xinke 20150709 lvwenhua    value:0~100  step:1(0.25dB)
extern SINT32 zDrvVp_SetInitGain(UINT8 value);
#endif
