/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       v0.1
 * Author:        wuhui
 * Date:          2016-12-17
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_VOU_H
#define _DRVS_VOU_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/


/****************************************************************************
* 	                                        Macros
****************************************************************************/


/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef struct
{
	BOOL			funcCSC; 		  	 		/*CSC for VL, color conversion from YUV to RGB or from  RGB to YUV*/
	UINT32			VLNum;		      			/*how many Video layers*/
	UINT32			GLNum;		       			/*how many Video layers*/
	BOOL			VL_SrcYUYV;		   			/*whether  VL Source data support  YUYV format */
	BOOL			VL_SrcUYVY;		   			/*whether  VL Source data support  UYVY format  */
	BOOL			VL_SrcYVYU;		   			/*whether  VL Source data support  YVYU format */
	BOOL			VL_SrcVYUY;		   			/*whether  VL Source data support  VYUY format  */
	BOOL			VL_SrcPlanarYUV420;		    /*whether  VL Source data support  PlanarYUV420 format*/
	BOOL			VL_SrcSemiPlanarYUV420;	    /*whether  VL Source data support  SemiPlanarYUV420 format */
	BOOL			VL_GlobalAlpha;	   			/*whether  VL  support global alpha  */
	BOOL			GL_SrcARGB8888;		   		/*whether  GL Source data support  ARGB8888 format */
	BOOL			GL_SrcRGB888;		   		/*whether  GL Source data support  RGB888 format  */
	BOOL			GL_SrcRGB565;		   		/*whether  GL Source data support  RGB565 format */
	BOOL			GL_SrcARGB1555;		   		/*whether  GL Source data support  ARGB1555 format  */
	BOOL			GL_Src8BPP;		   			/*whether  GL Source data support 8BPP format  */
	BOOL			GL_ColorkeyAlpha;	   		/*whether  GL  support Color key Alpha  */
	BOOL			GL_PixelAlpha;	   			/*whether  GL  supportPixel Alpha  */
	BOOL			GL_GlobalAlpha;	   			/*whether  GL  support global alpha  */
 	UINT32 			MAX_WIDTH;					/*the  max pixel width  */
	UINT32 			MAX_HEIGTH;					/*the  max pixel height  */
	BOOL			funcOSD_WB; 				/*whether  support  OSD write back function */
} T_ZDrv_OSDInfo;

typedef enum 
{
	VOU_OPEN              = 0x0,
	VOU_FINISH_ONEFRAME   = 0x1,
	VOU_ERROR = 0x2,
	VOU_CLOSE = 0x3,
	MAX_VOU_STATE = 0x4
}T_ZDrv_VOUSTATE;

typedef enum
{	
	eDISABLE = 0,	
	eENABLE =1,
	MAX_eENABLE_TYPE =2
}T_ZDrv_ENABLE_TYPE;

typedef enum
 {
	eLITTLEENDIAN = 0,
	eBIGENDIAN = 1,
	MAX_ENDIAN_TYPE = 2
 }T_ZDrv_ENDIAN;

typedef enum
 {
	eSEMI_PLANAR = 0,
	ePLANAR = 1,
	eYUV422_YUYV = 2,
	eYUV422_YVYU = 3,
	eYUV422_UYVY = 4,
	eYUV422_VYUY = 5, 
	MAX_DATASRC_MODE = 6
 }T_ZDrv_VL_DATASRC_MODE;

typedef enum
 {
	eARGB8888 = 0,
	eRGB888 = 1,
	eRGB565 = 2,
	eARGB1555 = 3,
	e8BPP = 4,
	MAX_DATAFORMAT = 5
 }T_ZDrv_GL_DATAFORMAT;

typedef enum
 {
	eCOLORKEYALPHA= 0 ,
	eGLOBALALPHA = 1,
	ePIXALPHA = 2,
	MAX_ALPHA_SEL =3
 }T_ZDrv_ALPHA_SEL;

typedef enum
{
   eRANGE0To255 = 0,
   eRANGE0To127 = 1,
   MAX_PIXALPHA_RANGE = 2
}T_ZDrv_PIXALPHA_RANGE;

typedef enum
{
	eEXTLOWBITS = 0,
	eEXTHIGHBITS = 1,
	MAX_EXT_MODE = 2
}T_ZDrv_EXT_MODE;

typedef enum
{
	eEXTBYALL0 = 0,
	eEXTBYALL1 = 1,
	eEXTBYLSB = 2,
	eEXTBYMSB = 3,
	MAX_EXT_DATA_TYPE = 4
}T_ZDrv_EXT_DATA_TYPE;

typedef enum
{
	eRGB666_IN_18B = 0,
	eRGB666_IN_24B = 1,
	eRGB565_IN_32B = 2,
	eRGB565_IN_16B = 3,
	MAX_WB_DATA_MODE = 4
}T_ZDrv_WB_DATA_MODE;

typedef enum
{
	RGB_TO_YUV_FOR_SDTV = 0,
	YUV_TO_RGB_FOR_SDTV = 1,
	RGB_TO_YUV_FOR_SDTV_COMPUTER = 2,
	YUV_TO_RGB_FOR_SDTV_COMPUTER = 3,
	RGB_TO_YUV_FOR_HDTV = 4,
	YUV_TO_RGB_FOR_HDTV = 5,
	RGB_TO_YUV_FOR_HDTV_COMPUTER = 6,
	YUV_TO_RGB_FOR_HDTV_COMPUTER = 7,
	MAX_CSC_MODE = 8
}T_ZDrv_CSC_MODE;

typedef struct _T_VOU_POSXY
{
	UINT16 startX;			     		/*dislplay start pos X,in pixels,from top left point of screen,range 0~1919 */
	UINT16 startY;			     		/*dislplay start pos Y,in pixels,from top left point of screen,range 0~1079 */	
	UINT16 endX;			     		/*dislplay end pos X,in pixels,from top left point of screen,range 0~1919 */
	UINT16 endY;			     		/*dislplay end pos Y,in pixels,from top left point of screen,range 0~1079 */
} T_ZDrv_VOU_POSXY;

typedef struct _T_VOU_VL_SRCWH
{
	UINT16 VLSrcWidth;  		 		/*the source width in pixels, make sure picture boundary is  inside screen*/
	UINT16 VLSrcHeight;			 		/*the source height in pixels, make sure picture boundary is  inside screen*/
} T_ZDrv_VOU_VL_SRCWH;

typedef struct _T_VOU_VL_SRCSTR
{
	UINT16 VLLuStr;        				/*the luma stride in bytes, 8 bytes aligned*/
	UINT16 VLChrStr;		 			/*the chroma stride in bytes, 8 bytes aligned*/
} T_ZDrv_VOU_VL_SRCSTR;

typedef struct _T_VOU_VL_YUVADDR
{
	UINT8* VL_AddrY;			 		/*address of Y for VL,8 bytes aligned*/
	UINT8* VL_AddrU;				 	/*address of U for VL,8 bytes aligned*/
	UINT8* VL_AddrV;			 		/*address of V for VL,8 bytes aligned*/
} T_ZDrv_VOU_VL_YUVADDR;

typedef struct _T_VOU_VL_GALP
{
	T_ZDrv_ENABLE_TYPE VL_GAlpEnable;   		/*enalble VL layer alpha or not*/	
	UINT8 VL_GAlpVal;			 		/*the global alpha value ,range 0~255,0 is transparent*/	
} T_ZDrv_VOU_VL_GALP;

typedef struct _T_VOU_GL_ALP
{
	UINT8 GL_AlpA0;			 			/*the alpha for ARGB1555 When A=0 ,range 0~127 or range 0~255,0 is transparent*/
	UINT8 GL_AlpA1;			 			/*the alpha for ARGB1555 When A=1 ,range 0~127 or range 0~255,0 is transparent*/
	UINT8 GL_AlpGlobal;					/*the global alpha value ,range 0~255,0 is totally transparent*/	
	T_ZDrv_ALPHA_SEL GL_AlphaMode;
	T_ZDrv_PIXALPHA_RANGE GL_PixelAlpRange;
} T_ZDrv_VOU_GL_ALP;

typedef struct _T_VOU_VLPara
{
	T_ZDrv_ENABLE_TYPE VLEnable; 	 		/*enalble VL layer or not*/
	UINT8 VLPriority;			 		/*VL layer priority ,value range  0~7,he value must diffrent,the smaller value,the higher priority */
	T_ZDrv_VOU_POSXY VL_PosXY;        		/*just need the start X Y,end XY can be calculated based on width and height*/
	T_ZDrv_VL_DATASRC_MODE VLSrcMode; 		/*the VL src data mode*/
	T_ZDrv_VOU_VL_SRCSTR VL_SrcStr;
	T_ZDrv_VOU_VL_SRCWH VL_SrcHW;
	T_ZDrv_VOU_VL_YUVADDR VL_AddrYUV;
	T_ZDrv_VOU_VL_GALP VL_GAlp;
} T_ZDrv_VOU_VLPara;

typedef struct _T_VOU_GL_EXT
{
	T_ZDrv_EXT_MODE GL_ExtDir;  				/*the extension direction , recommand eEXTLOWBITS ,only for ARGB1555 /RGB 565 */
	T_ZDrv_EXT_DATA_TYPE GL_ExtDataMode;		/*the extension date type, recommand eEXTBYALL0 */
} T_ZDrv_VOU_GL_EXT;

typedef struct _T_VOU_GL_CK0
{
	UINT8 GL_AlpColorIn;				/*alpha inside color key  region0 and region1 ,range 0~255*/
	UINT8 GL_CK0_MinR;					/*the color key region0,the min R value*/
	UINT8 GL_CK0_MinG;					/*the color key region0,the min G value*/
	UINT8 GL_CK0_MinB;					/*the color key region0,the min B value*/
	UINT8 GL_AlpColorOut;				/*alpha outside color key  region0 and region1,range 0~255 */
	UINT8 GL_CK0_MaxR;					/*the color key region0,the max R value*/
	UINT8 GL_CK0_MaxG;					/*the color key region0,the max  G value*/
	UINT8 GL_CK0_MaxB;					/*the color key region0,the max B value*/
} T_ZDrv_VOU_GL_CK0;

typedef struct _T_VOU_GL_CK1
{
	T_ZDrv_ENABLE_TYPE GL_CKRegion1Enable; 	/*enalble color key region1 or not*/
	UINT8 GL_CK1_MinR;					/*the color key region1,the min R value*/
	UINT8 GL_CK1_MinG;					/*the color key region1,the min G value*/
	UINT8 GL_CK1_MinB;					/*the color key region1,the min B value*/
	UINT8 GL_CK1_MaxR;					/*the color key region1,the max R value*/
	UINT8 GL_CK1_MaxG;					/*the color key region1,the max G value*/
	UINT8 GL_CK1_MaxB;					/*the color key region1,the max B value*/
} T_ZDrv_VOU_GL_CK1;


typedef struct _T_VOU_GLPara
{
	T_ZDrv_ENABLE_TYPE GLEnable; 	        /*enalble GL layer or not*/
	UINT8 GLPriority;			 		/*GL layer priority ,value range  0~7;the value must diffrent ,the smaller value,the higher priority */
	T_ZDrv_ENDIAN GL_endianType;        		/*the graphic data type ,recommand little endian*/
	T_ZDrv_VOU_POSXY GL_PosXY;
	T_ZDrv_GL_DATAFORMAT GLSrcMode; 			/*the GL src data mode*/
	T_ZDrv_VOU_GL_ALP GL_Alp;
	T_ZDrv_VOU_GL_EXT GL_Ext;
	UINT16 GLStride;       		 		/*the stride in bytes, 8 bytes aligned*/
	UINT8* GL_SrcAddr;			 		/*address of Graphic data,8 bytes aligned*/
	T_ZDrv_VOU_GL_CK0 GL_CK0;
	T_ZDrv_VOU_GL_CK1 GL_CK1;	
} T_ZDrv_VOU_GLPara;

typedef struct _T_VOU_MC_WH
{
	UINT16 MCScrWidth;           /*the screen width, max to 1920, multiple of 2 */
	UINT16 MCScrHeight;          /*the screen height, max to 1088, multiple of 2 */
}T_ZDrv_VOU_MC_WH;

typedef struct _T_VOU_MC_BG
{
	UINT8 MC_BGValueR;			 /*the main back ground R value*/
	UINT8 MC_BGValueG;			 /*the main back ground G value*/
	UINT8 MC_BGValueB;			 /*the main back ground B value*/
}T_ZDrv_VOU_MC_BG;


typedef struct _T_VOU_MCPara
{
	T_ZDrv_ENABLE_TYPE MCEnable; 	 /*enalble main channel or not*/
	T_ZDrv_VOU_MC_WH MCSrcWH;
	T_ZDrv_VOU_MC_BG MC_BG_RGB;
} T_ZDrv_VOU_MCPara;

typedef struct _T_VOU_WB_BUFADDR
{
	UINT8* WB_BufAddr0; 		 /*address of write back frame buffer 0,8 bytes aligned*/
	UINT8* WB_BufAddr1; 		 /*address of write back frame buffer 1,8 bytes aligned*/
	UINT8* WB_BufAddr2; 		 /*address of write back frame buffer 2,8 bytes aligned*/
	UINT8* WB_BufAddr3; 		 /*address of write back frame buffer 3,8 bytes aligned*/
}T_ZDrv_VOU_WB_BUFADDR;

typedef struct _T_VOU_WBPara
{
	T_ZDrv_ENABLE_TYPE WBEnable; 	 /*enalble write back or not*/
	UINT16 WBStride;             /*the write back stride, multiple of 8 */
	UINT8 WBBufNum;			 	 /*indicate how many frame buffers will be used,range 1~4*/
	UINT8 WBPeriod;			 	 /*skip n frames before write back one frame,range 0~7*/
	T_ZDrv_WB_DATA_MODE WBDataMode;
	T_ZDrv_VOU_WB_BUFADDR WBBufAddr;
} T_ZDrv_VOU_WBPara;

typedef struct _T_VOU_CSC_Coeff
{
	SINT16 CSC_CoeA;			 /* the coefficient of X in F(X.Y,Z) */
	SINT16 CSC_CoeB;			 /* the coefficient of Y in F(X.Y,Z) */
	SINT16 CSC_CoeC;			 /* the coefficient of Z in F(X.Y,Z) */
	SINT16 CSC_CoeD;			 /* the coefficient of d in F(X.Y,Z) */
}T_ZDrv_VOU_CSC_Coeff;

typedef struct _T_VOU_CSC_SPACE
{
	UINT8  CSC_SPACE_FLOOR;  /* the floor level  of  col */
	UINT8  CSC_SPACE_TOP;    /* the top level  of  col */
}T_ZDrv_VOU_CSC_SPACE;

typedef struct _T_VOU_CSCPara
{
	T_ZDrv_ENABLE_TYPE CSCEnable; 	  		/*enalble CSC or not*/
	T_ZDrv_CSC_MODE CSC_ConMode;       		/* the conversion mode */
	T_ZDrv_VOU_CSC_Coeff CSC_XYZ_F[3];	  	/* the coefficient of X in F1(X.Y,Z) ,F2(X.Y,Z) ,F3(X.Y,Z) */
	T_ZDrv_VOU_CSC_SPACE CSC_SPACE_IN[3];	/* the floor&top level  of  col_in1, col_in2,col_in3*/
	T_ZDrv_VOU_CSC_SPACE CSC_SPACE_OUT[3];	/* the floor&top level  of  col_out1, col_out2,col_out3*/
} T_ZDrv_VOU_CSCPara;

typedef struct _T_VOU_OSDPara
{
	T_ZDrv_VOU_VLPara OSD_VLPara;   /*Video layer Parameters*/
	T_ZDrv_VOU_GLPara OSD_GLPara;   /*Graphic layer Parameters*/
	T_ZDrv_VOU_MCPara OSD_MCPara;   /*Main Chanle  Parameters*/
} T_ZDrv_VOU_OSDPara;

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/



#endif/*_FILENAME_H*/

