#ifndef __DRV_LINUX_SPINLOCK_H__
#define __DRV_LINUX_SPINLOCK_H__

#ifndef _OS_LINUX

typedef int spinlock_t;	//Howard Hu TempChanged
#define SPIN_LOCK_UNLOCKED (spinlock_t) { }
#define DEFINE_SPINLOCK(x) spinlock_t x = SPIN_LOCK_UNLOCKED

#define spin_lock_irqsave(_lock, f)		LOCK_SAVE(_lock)	/*//Howard Hu TempChanged */
#define spin_unlock_irqrestore(_lock, f)	LOCK_RESTORE(_lock)	/*//Howard Hu TempChanged */

#define spin_lock_init(lock)             \
CYG_MACRO_START;                         \
CYG_UNUSED_PARAM(spinlock_t *, lock);    \
CYG_MACRO_END

#define spin_lock(lock)                  \
CYG_MACRO_START;                         \
CYG_UNUSED_PARAM(spinlock_t *, lock);    \
CYG_MACRO_END

#define spin_unlock(lock)                \
CYG_MACRO_START;                         \
CYG_UNUSED_PARAM(spinlock_t *, lock);    \
CYG_MACRO_END

#define spin_lock_bh(lock)               \
CYG_MACRO_START;                         \
CYG_UNUSED_PARAM(spinlock_t *, lock);    \
CYG_MACRO_END

#define spin_unlock_bh(lock)             \
CYG_MACRO_START;                         \
CYG_UNUSED_PARAM(spinlock_t *, lock);    \
CYG_MACRO_END

#endif

#endif /* __LINUX_SPINLOCK_H__ */
