#ifndef _DRVS_TEAK_H
#define _DRVS_TEAK_H

#define word ushort
#define byte ubyte

//Aud_lib.c used #include "trap.h"               /* for error reporting */
#if defined(TRAP_HANDLING)
#define TRAP_AUD_FILESYSTEM_ACCESS 346   /*!< 0x15a  	Communication with FFS system failed	*/
#endif

//Aud_data.c used in #include "platform_cnf.h"
/* Use only one of these for each pad */
#define PCL_IS(n)          (n << 0)
#define PCL_OS(n)          (n << 4)
#define PCL_INTERNAL_SIG   (0u << 8)
#define PCL_GPIO           (1u << 8)
#define PCL_GPIO_D0        (0u << 9)
#define PCL_GPIO_D1        (1u << 9)
#define PCL_GPIO_OUT       (1u << 10)
#define PCL_GPIO_IN        (0u << 10)
#define PCL_RESET_ALWAYS   (0u << 11)
#define PCL_RESET_OPTIONAL (1u << 11)
#define PCL_PUSH_PULL      (0u << 12)
#define PCL_OPEN_DRAIN     (1u << 12)
#define PCL_PU             (1u << 13)
#define PCL_PD             (2u << 13)
#define PCL_NO_PUPD        (0u << 13)
#define PCL_ENABLE         (0u << 15)
#define PCL_TRISTATE       (1u << 15)

#define SYNTH_DATA_WORDS  65
#define VM_DATA_WORDS     17

//regs
// aud_i2s.c used GSML1_ZX29_GSM_VA in l1g_pa_to_va.h
#define GSML1_ZX29_GSM_VA(x)            (x)

#ifdef SGOLD3
#define SCU_DSPSRC2     *((volatile uint *) (GSML1_ZX29_GSM_VA(0xf4400408)))
#define SCU_DSPSRC3     *((volatile uint *) (GSML1_ZX29_GSM_VA(0xf440040c)))
#endif

#define SCU_DSPSRC4     *((volatile uint *) (GSML1_ZX29_GSM_VA(0xf4400410)))
#define SCU_DSPSRC5     *((volatile uint *) (GSML1_ZX29_GSM_VA(0xf4400414)))
#define SCU_DSPSRC6     *((volatile uint *) (GSML1_ZX29_GSM_VA(0xf4400418)))
#define SCU_DSPSRC7     *((volatile uint *) (GSML1_ZX29_GSM_VA(0xf440041c)))

#define  AFE_OFF_AND_I2S1OFF	0
#define  COPYPARAMETERS_TO_AFE	1
#define  INIT_AFE_COPYPARAM_I2S1OFF	2
#define  I2S1_ON_AFE_OFF	3
#define  I2S1_ON_AFE_OUT_ON	4
#define DSP_CMD_ID_LEN	1
#define DSP_CMD_VB_SET_BIQUAD	16
#define DSP_CMD_VB_SET_GAIN	17
#define DSP_CMD_START_TONE	18
#define DSP_CMD_STOP_TONE	19
#define DSP_CMD_READ_DURATION	20
#define DSP_CMD_VB_RESET	21
#define DSP_CMD_VB_DAI	22
#define DSP_CMD_HF_SET_PAR	23
#define DSP_CMD_HF_ON	24
#define DSP_CMD_VM_CMD	25
#define DSP_CMD_CBUF_GAIN	26

#define DSP_CMD_VB_I2S2                   37
#define DSP_CMD_TTY_CTM                   38
#define DSP_CMD_VB_SYNC                   39
#define DSP_CMD_UMTS_ON                   40
#define DSP_CMD_MIDI                      42

#define DSP_CMD_AUDIOPROC                 44
#define DSP_CMD_PCM                       45
#define DSP_CMD_PCM_REC                   46   
#define DSP_CMD_A3D                       47
#define DSP_CMD_SBC                       48
#define DSP_CMD_VB_ASP_EP                 50
#define DSP_CMD_VB_HF_SET_GAIN            51
#define DSP_CMD_VB_SET_FIR                52
#define DSP_CMD_VB_AUDIO_FILTER_SWITCH    53
#define DSP_CMD_VB_RX_NR_CONFIG    54

#define DSP_ASYNC_VB_I2S2(p_msg_para) DSP_vb_i2s2_cmd(p_msg_para)

#define DSP_ASYNC_MIDI(p_msg_para) DSP_synth_cmd(p_msg_para)

//pow.h
#ifdef PS_RAT_GSM

#define l1d_psv_disable(id) POW_l1g_sleep_disable(id)
#define l1d_psv_enable(id) POW_l1g_sleep_enable(id)	
#endif
	
//dsp_sgold3_cmn_ext.h
#ifndef TARGET
#define BASEADR_COM_INT   (&l1d_brs_dsp_shmem[0])
#else
#define BASEADR_COM_INT   ((volatile word *) GSML1_ZX29_GSM_VA(0xF6001000)) /* Note also defined in dsp_sgold2_aud_ext.h */
#endif

//Aud_data.c used PMU_AUD_GAIN_6dB in pmu_hal.h
typedef enum PMU_AUD_AMP_GAIN_E
{  
  PMU_AUD_GAIN_6dB,
  PMU_AUD_GAIN_0dB,
  PMU_AUD_GAIN_12dB,
  PMU_AUD_GAIN_18dB
}PMU_AUD_AMP_GAIN_T;

//aud_i2s.c used this enum in pow.h
typedef enum
{ 
  POW_OK = 0,
  POW_FAILED,
  POW_INVALID_ID,
  NUM_OF_POW_RETURN_RESULTS
}POW_RETURN_RESULT_T;

//aud_ear.c used llt_type_audio_function_interface in llt.h
enum llt_types_audio_enum_e
{
   llt_type_audio_function_interface,
   llt_type_audio_sm_speech,
   llt_type_audio_sm_simple_tones,
   llt_type_audio_sm_mp3,
   llt_type_audio_sm_pcm_recording,
   llt_type_audio_sm_vm_recording,
   llt_type_audio_sm_pcm_playback,
   llt_type_audio_sm_vm_playback,
   llt_type_audio_sm_internal_ringer,
   llt_type_audio_sm_external_ringer,
   llt_type_audio_sm_fm_radio,
   llt_type_audio_sm_i2s2 ,
   llt_type_audio_sm_tty,
   llt_type_audio_sm_hal,
   llt_type_audio_mapi,
   llt_type_audio_volume,
   llt_type_audio_volume_ulc,
   llt_type_audio_path,
   llt_type_audio_path_ulc,
   llt_type_audio_return_signal,
   llt_type_audio_hisr_mp3,
   llt_type_audio_hisr_pcm_recording,
   llt_type_audio_hisr_pcm_playback,
   llt_type_audio_hisr_vm_recording,
   llt_type_audio_hisr_vm_playback,
   llt_type_audio_hisr_simple_tones,
   llt_type_audio_hisr_internal_ringer,
   llt_type_audio_hisr_external_ringer,
   llt_type_audio_dsp_afe,
   llt_type_audio_dsp_VB_gain,
   llt_type_audio_dsp_CBUF_gain,
   llt_type_audio_dsp_VM_gain
};

//dsp.h
typedef struct
{
  word  scal_in;
  word  scal_out;
  word  side_tone_fact;
  word  mic_mute_on;
  word  scal_mic;
  word  gain_out;
  word  scal_rec;
  word  speech_mix; //speech_mix_dl
  word  tone_fact;
  word  delta0;
  word  delta1;
  word  kappa0;
  word  kappa1;
  word  lambda0;
  word  lambda1;
  word  scal_afe;
  word  scal_mic2;
  word  afe_tone;
  word  ton_mix_ul;
  word  ton_mix_dl;
  word  speech_mix_ul; 
  word  scal_I2S1;
#if defined (STEON2_PROJECT)  
  word alfa0_i2s2;
  word alfa1_i2s2;
  word beta1_i2s2;
  word gamma1_i2s2;
#endif  
}T_DSP_CMD_VB_SET_GAIN_PAR;

//dsp_sgold3_aud_ext.h
typedef struct
{
  word mode;
  word scenario;
} T_DSP_CMD_A3D_PAR;

typedef struct
{
  word  vm_mode;
  word  alpha0;
  word  alpha1;
  word  beta0;
  word  beta1;
  word  gamma0;
  word  gamma1;
} T_DSP_CMD_VM_SET_COEFF_PAR;

typedef struct
{
  word  coeffi;
  word  a1_1;
  word  b1_1;
  word  a2_1;
  word  b2_1;
  word  a0_1;
  word  a1_2;
  word  b1_2;
  word  a2_2;
  word  b2_2;
  word  a0_2;
} T_DSP_CMD_VB_SET_BIQUAD_PAR;

typedef struct
{
  word  gain_analog;
  word  step_width;
  word  lms_length;
  word  lms_offset;
  word  block_length;
  word  rxtx_relation;
  word  nr_sw_2;
  word  nr_u_fak_0;
  word  nr_u_fak;
  word  add_atten;
  word  min_atten;
  word  max_atten;
} T_DSP_CMD_HF_SET_PAR;

typedef struct
{
  word  mode;
} T_DSP_CMD_HF_ON_PAR;


typedef struct
{
  word scal_sapp;
  word scal_ext;
  word scal_pcm;
  word mix_afe;
  word mix_i2s1;
  word mix_pcmrec;
}T_DSP_CMD_CBUF_GAIN;

typedef struct
{
  word  Switch;
  word  afe_ext_input_ctrl;
  word  afe_tx_ctrl1;
  word  afe_tx_ctrl4;
  word  afe_tx_ctrl5;
  word  afe_tx_ctrl6;
  word  afe_tx_ctrl7;
  word  afe_rx_ringer;
  word  afe_rx_ana1;
  word  afe_rx_ana2;
  word  afe_rx_ana3;
  word  afe_rx_ctrl2;
  word  afe_rx_epref;
  word  afe_rx_gain_digital;
  word  afe_tx_ctrl2;
  word  input_mic_mode;
  word  ratesw;
  word  out_mode;
  word  csel;
  word  num0;
  word  den0;
  word  num1;
  word  den1;
  word  rxconf;
  word  txconf;
  #if !defined (STEON2_PROJECT)
  word  i2s1_hw_mode;
  word  i2s1_chn_mode;
  #endif
} T_DSP_CMD_VB_HW_PAR;

typedef struct
{
  word   AudioPostProcSwitch;
  sshort b_exp;
  sshort b1;
  sshort b0;
  sshort a1;
  sshort INITDATA_mono_flag;
  sshort INITDATA_m_bufflen;
  sshort INITDATA_m_inv_bufflen;
  sshort INITDATA_m_hp_coef_exp;
  sshort INITDATA_mlp1_coef;
  sshort INITDATA_mlp2_coef;
  sshort INITDATA_mlp4_coef;
  sshort INITDATA_mlp3_coef;
  sshort INITDATA_m_L_A;
  sshort INITDATA_m_L_Bf;
  sshort INITDATA_m_G_Comp;
  sshort INITDATA_um_R_infA;
  sshort INITDATA_um_R_AB;
  sshort INITDATA_um_R_B0; 
}T_DSP_CMD_AUDIOPOSTPROC_PAR;


typedef struct 
{
  word  synth_buffer[SYNTH_DATA_WORDS];
} T_SYNTH_DATA;

typedef struct
{
  word fadin_dur;
} T_TONE_FADIN_DUR;

typedef struct
{
  word fadout_dur;
} T_TONE_FADOUT_DUR;

typedef struct
{
  word  tone_freq_1;
  word  tone_amp_1;
  word  tone_freq_2;
  word  tone_amp_2;
  word  tone_freq_3;
  word  tone_amp_3;
  word  tone_dur_in;
  word  tone_dur_out;  
  word  tone_dur_inter; 
  word  tone_fadein_dur;
  word  tone_fadeout_dur;  
} T_TONE_DATA;

typedef struct 
{
  word  vm_buffer_0[VM_DATA_WORDS];
  word  vm_buffer_1[VM_DATA_WORDS];
} T_VM_DATA;

typedef struct
{
  word  mode;
  word  sync;
  word  ptr_val;
  word  sync_lim;
} T_DSP_CMD_VB_SYNC;

typedef struct
{
  word ul_dl_select;
  word csi;
  word h[17]; 
}T_DSP_CMD_VB_SET_FIR;   

typedef struct
{
  word dl_enable;
  word ul_enable;
  word cbuf_enable; 
}T_DSP_CMD_VB_AUDIO_FILTER_SWITCH;  
 
typedef struct
{
  word operation;
  S16  attenn_dbfs;
  word attack_time;
  word release_time;
  word mode; 
}T_DSP_CMD_VB_ASP_EP;   

typedef struct
{
  word mode;
}T_DSP_CMD_VB_HF_SET_GAIN;

typedef struct
{
  word Switch;
  word nr_sw_2;
  word nr_u_fak_0;
  word nr_u_fak;
}T_DSP_CMD_VB_RX_NR_CONFIG;

typedef struct
{
  word mode;
}T_DSP_CMD_VB_DAI_PAR;

typedef struct
{
#if defined (STEON2_PROJECT)  
 word  Tx_Switch;
 word  Rx_Switch;
#else
 word Switch;
#endif
  word  SI2Sx_SCEL;
  word  SI2Sx_NUM0;
  word  SI2Sx_DEN0;
  word  SI2Sx_NUM1;
  word  SI2Sx_DEN1;
  word  SI2Sx_RXCONF;
  word  SI2Sx_TXCONF;
  word  SI2Sx_I2s2_Rate;
  word  SI2Sx_I2s2_Mode;
#if defined (STEON2_PROJECT)  
  word I2S2_TX_PPM;
  word HW_SOURCE_ALLOC;
 #endif 
} T_DSP_CMD_VB_I2S2_PAR;

typedef struct
{
  word  mode;
  word  sample_rate_headroom;
  word  midi_data_shared_mem_address;
} T_DSP_CMD_MIDI;

#define DSP_ASYNC_VB_RESET \
      {dsp_add_async_msg_2_dsp(DSP_CMD_VB_RESET, \
                         DSP_CMD_ID_LEN,  \
                         NULL);}
						 
#define DSP_ASYNC_HF_SET_PAR(p_msg_para) \
      {dsp_add_async_msg_2_dsp(DSP_CMD_HF_SET_PAR, \
                         (sizeof(T_DSP_CMD_HF_SET_PAR) / 2) + DSP_CMD_ID_LEN,  \
                         (word*)p_msg_para);}

#if PS_RAT_GSM						 
#define DSP_ASYNC_HF_ON(p_msg_para) \
      {dsp_add_async_msg_2_dsp(DSP_CMD_HF_ON, \
                         (sizeof(T_DSP_CMD_HF_ON_PAR) / 2) + DSP_CMD_ID_LEN,  \
                         (word*)p_msg_para);}		

#define DSP_ASYNC_START_TONE \
      {dsp_add_async_msg_2_dsp(DSP_CMD_START_TONE, \
                         DSP_CMD_ID_LEN,  \
                         NULL);}
						 
#define DSP_ASYNC_STOP_TONE \
      {dsp_add_async_msg_2_dsp(DSP_CMD_STOP_TONE, \
                         DSP_CMD_ID_LEN,  \
                         NULL);}			

#define DSP_ASYNC_READ_DURATION \
      {dsp_add_async_msg_2_dsp(DSP_CMD_READ_DURATION, \
                         DSP_CMD_ID_LEN,  \
                         NULL);}	

#define DSP_ASYNC_VB_DAI(p_msg_para) \
      {dsp_add_async_msg_2_dsp(DSP_CMD_VB_DAI, \
                         (sizeof(T_DSP_CMD_VB_DAI_PAR) / 2) + DSP_CMD_ID_LEN,  \
                         (word*)p_msg_para);}	

#define DSP_ASYNC_VB_SET_BIQUAD(p_msg_para) \
      {dsp_add_async_msg_2_dsp(DSP_CMD_VB_SET_BIQUAD, \
                         (sizeof(T_DSP_CMD_VB_SET_BIQUAD_PAR) / 2) + DSP_CMD_ID_LEN,  \
                         (word*)p_msg_para);}		

#define DSP_ASYNC_VB_SET_GAIN(p_msg_para) \
      {dsp_add_async_msg_2_dsp(DSP_CMD_VB_SET_GAIN, \
                         (sizeof(T_DSP_CMD_VB_SET_GAIN_PAR) / 2) + DSP_CMD_ID_LEN,  \
                         (word*)p_msg_para);}	

#define DSP_ASYNC_VB_HW(p_msg_para) DSP_vb_on_cmd(p_msg_para)
#endif

#define DSP_ASYNC_VB_SET_FIR(p_msg_para) \
      {DSP_vb_set_fir_cmd(p_msg_para);}
	  
#define DSP_ASYNC_VM_CMD(p_msg_para) \
      {dsp_add_async_msg_2_dsp(DSP_CMD_VM_CMD, \
                         (sizeof(T_DSP_CMD_VM_SET_COEFF_PAR) / 2) + DSP_CMD_ID_LEN,  \
                         (word*)p_msg_para);}
						 
#define DSP_ASYNC_CBUF_GAIN(p_msg_para) \
      {dsp_add_async_msg_2_dsp(DSP_CMD_CBUF_GAIN, \
                       (sizeof(T_DSP_CMD_CBUF_GAIN) / 2) + DSP_CMD_ID_LEN,  \
                       (word*)p_msg_para);}

#define DSP_VB_SYNC(p_msg_para) \
      {dsp_add_async_msg_2_dsp(DSP_CMD_VB_SYNC, \
                         (sizeof(T_DSP_CMD_VB_SYNC) / 2) + DSP_CMD_ID_LEN,  \
                         (word*)p_msg_para);}

extern VOID POW_l1g_sleep_disable(UINT8 id);
extern VOID POW_l1g_sleep_enable(UINT8 id);
extern VOID dsp_add_async_msg_2_dsp ( word msg_id, word msg_length, word* p_msg_par );
extern VOID DSP_vb_i2s2_cmd(T_DSP_CMD_VB_I2S2_PAR *p_msg_para);
extern VOID DSP_synth_cmd(T_DSP_CMD_MIDI *p_msg_para);
extern VOID DSP_vb_on_cmd(T_DSP_CMD_VB_HW_PAR *p_msg_para);
extern VOID DSP_vb_set_fir_cmd(T_DSP_CMD_VB_SET_FIR *p_msg_para);

extern T_TONE_DATA	*p_l1d_tone_data;
extern T_VM_DATA	*p_l1d_vm_data;
extern T_TONE_FADOUT_DUR                *p_l1d_sm_tone_fadout_dur;
extern T_TONE_FADIN_DUR	*p_l1d_sm_tone_fadin_dur;
extern T_SYNTH_DATA	*p_l1d_sm_synth_data;


#endif //_DRVS_TEAK_H
