/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Contains variables for audio data structures + offset values to audio
 *   EEP static values
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_data.c
 *   Version: \main\98
 *   Date: 2007-10-02 09:06:42
 *   Responsible: johansek
 *   Comment:
 *     Removed compiler warning.
 */

/*******************************************************************************
*
*                               Include files
*
*******************************************************************************/
#include "drvs_general.h"
//#include "scttypes.h"           /* must be included in all files */
//#include "ms.h"                 /* must be included in all files */
#include "bastypes.h"           /* must be included in all files */
//#include "dsp.h"                /* for DSP command types */
//#include "platform_cnf.h"       /* for PCL_pad and related enums */
#include "aud_drv.h"            /* audio driver interface types and prototypes */
#include "aud_com.h"
#include "aud_data.h"           /* header file for this file */
#include "aud_path_control.h"   /* aud_path_settings_result - used for SM power amp */
#include "aud_i2s.h"
//#include "aud_ext_amplifiers.h"
//#include "REG_SGOLD_Regs.h"
//#include "pmu_hal.h"            /* SM power amplifier */
#if defined (INTERNAL_POLYRINGER)
#include "aud_intern_midilib.h"
#endif
#include "drvs_ramlog.h"


/*******************************************************************************
*
*                               Uplink filters
*
*******************************************************************************/
 T_DSP_CMD_VB_SET_BIQUAD_PAR uplink_mic_filter_8kHz =
{   /* filter:              */  0,
    /* in1[5]               */  0x3A1E, 0x343C, 0x0000, 0x0000, 0x743C,
    /* in2[5]               */  0x98EF, 0x8D60, 0x6711, 0x6952, 0x6711
};
 T_DSP_CMD_VB_SET_BIQUAD_PAR uplink_mic_filter_16kHz =
{   /* filter:              */  0,
    /* in1[5]               */  0x3A1E, 0x343C, 0x0000, 0x0000, 0x743C,
    /* in2[5]               */  0x98EF, 0x8D60, 0x6711, 0x6952, 0x6711
};
 T_DSP_CMD_VB_SET_BIQUAD_PAR uplink_mic_filter_48kHz =
{   /* filter:              */  0,
    /* in1[5]               */  0x3A1E, 0x343C, 0x0000, 0x0000, 0x743C,
    /* in2[5]               */  0x98EF, 0x8D60, 0x6711, 0x6952, 0x6711
};
 T_DSP_CMD_VB_SET_BIQUAD_PAR uplink_pass_through_filter =
{   /* filter:              */  0,
    /* in1[5]               */  0x0000, 0x0000, 0x0000, 0x0000, 0x7FFF,
    /* in2[5]               */  0x0000, 0x0000, 0x0000, 0x0000, 0x7FFF
};

/*******************************************************************************
*
*                              Downlink filters
*
*******************************************************************************/
 T_DSP_CMD_VB_SET_BIQUAD_PAR downlink_norm_earpiece_filter_8kHz =
{   /* filter:              */  1,
    /* out1[5]              */  0x8A75, 0x8AF4, 0x758B, 0x6C14, 0x758B,
    /* out2[5]              */  0x6778, 0x61A4, 0x6778, 0x5A80, 0x6778
};
 T_DSP_CMD_VB_SET_BIQUAD_PAR downlink_norm_earpiece_filter_16kHz =
{   /* filter:              */  1,
    /* out1[5]              */  0x8A75, 0x8AF4, 0x758B, 0x6C14, 0x758B,
    /* out2[5]              */  0x6778, 0x61A4, 0x6778, 0x5A80, 0x6778
};
 T_DSP_CMD_VB_SET_BIQUAD_PAR downlink_pass_through_filter =
{   /* filter:              */  1,
    /* out1[5]              */  0x0000, 0x0000, 0x0000, 0x0000, 0x7FFF,
    /* out2[5]              */  0x0000, 0x0000, 0x0000, 0x0000, 0x7FFF
};

/*******************************************************************************
*
*                                CBuf filters
*
*******************************************************************************/
 T_DSP_CMD_VB_SET_BIQUAD_PAR downlink_normal_cbuf =
{   /* cbuf_filter:         */  2,
    /* cbuf1[5]             */  0xE216, 0xB0EE, 0x14C9, 0x36E1, 0x37EB,
    /* cbuf2[5]             */  0x0000, 0x0000, 0x0000, 0x0000, 0x7FFF
};
 T_DSP_CMD_VB_SET_BIQUAD_PAR cbuf_pass_through_filter =
{   /* cbuf_filter:         */  2,
    /* cbuf1[5]             */  0x0000, 0x0000, 0x0000, 0x0000, 0x7FFF,
    /* cbuf2[5]             */  0x0000, 0x0000, 0x0000, 0x0000, 0x7FFF
};

/*******************************************************************************
*
*                                FIR filters
*
*******************************************************************************/
 aud_fir_filter_type fir_filter_pass_through =
{
    0x7FFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000 /* h[0], ...h[i]..., h[64] */
};
 aud_fir_filter_type uplink_fir_filter_1 = /* not calibrated! */
{
    0x7FFF, 0x0001, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0010, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0020, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0030, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0040 /* h[0], ...h[i]..., h[64] */
};
 aud_fir_filter_type downlink_fir_filter_1 = /* not calibrated! */
{
    0x7FFF, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0010, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0020, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0030, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0040 /* h[0], ...h[i]..., h[64] */
};
 aud_fir_filter_type cbuf_fir_filter_1 = /* not calibrated! */
{
    0x7FFF, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0010, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0020, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0030, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0040 /* h[0], ...h[i]..., h[64] */
};

/*******************************************************************************
*
*                            Hands-free settings
*
*******************************************************************************/
 aud_hf_type hf_parm_handset_mic =
{
    /* hf_algorithm_init    */  0x018D,
    /* hf_algorithm_restart */  0x010E,
    /* step_width           */  2200,
    /* lms_length           */  250,
    /* lms_offset           */  8,
    /* block_length         */  5,
    /* rxtx_relation        */  -200,
    /* add_atten            */  0,
    /* min_atten            */  0,
    /* max_atten            */  500,
    /* nr_sw_2              */  0x4000,
    /* nr_u_fak_0           */  0x4000,
    /* nr_u_fak             */  0x4000
};
 aud_hf_type hf_parm_headset_mic =
{
    /* hf_algorithm_init    */  0x018D,
    /* hf_algorithm_restart */  0x010E,
    /* step_width           */  2200,
    /* lms_length           */  250,
    /* lms_offset           */  8,
    /* block_length         */  5,
    /* rxtx_relation        */  150,
    /* add_atten            */  0,
    /* min_atten            */  0,
    /* max_atten            */  500,
    /* nr_sw_2              */  0x4000,
    /* nr_u_fak_0           */  0x4000,
    /* nr_u_fak             */  0x4000
};
 aud_hf_type hf_parm_dthf_mic =
{
    /* hf_algorithm_init    */  0x018D,
    /* hf_algorithm_restart */  0x010E,
    /* step_width           */  2200,
    /* lms_length           */  250,
    /* lms_offset           */  8,
    /* block_length         */  5,
    /* rxtx_relation        */  -400,
    /* add_atten            */  0,
    /* min_atten            */  0,
    /* max_atten            */  500,
    /* nr_sw_2              */  0x4000,
    /* nr_u_fak_0           */  0x4000,
    /* nr_u_fak             */  0x4000
};
 aud_hf_type hf_parm_tty =
{
    /* hf_algorithm_init    */  0, /* disable hands-free */
    /* hf_algorithm_restart */  0, /* disable hands-free */
    /* step_width           */  2200,
    /* lms_length           */  250,
    /* lms_offset           */  8,
    /* block_length         */  5,
    /* rxtx_relation        */  -400,
    /* add_atten            */  0,
    /* min_atten            */  0,
    /* max_atten            */  500,
    /* nr_sw_2              */  0x4000,
    /* nr_u_fak_0           */  0x4000,
    /* nr_u_fak             */  0x4000
};

/*******************************************************************************
*
*                    Settings for acoustic shock protection
*
*******************************************************************************/
 aud_asp_ul_type asp_uplink_1 = /* not calibrated! */
{
    /* attennuation_dbfs */  -10,  /* -1 dB */
    /* attack_time       */  10,
    /* release_time      */  100,
    /* mode              */  0,    /* energy limiter */
    /* ul_speech_gain    */  0     /* 18 dB extra gain disabled */
};

/*******************************************************************************
*
*                    Settings for downlink noise reduction
*
*******************************************************************************/
 aud_dl_nr_type dl_nr_1 = /* not calibrated! */
{
    /* nr_sw_2           */  0x4000,
    /* nr_u_fak_0        */  0x4000,
    /* nr_u_fak          */  0x4000
};

/*******************************************************************************
*
*                                Uplink paths
*
*******************************************************************************/
 aud_uplink_gain_cells_type aud_handset_mic_gains =
{
    /* scal_mic             */  0x17ff,TRUE,
    /* lambda0              */  0x7FFF,TRUE,
    /* gamma0               */  0x7FFF,TRUE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};

/*now all paths use i2s1 interface in fact.[Begin] [lvwenhua-2010/9/19]*/
 aud_uplink_gain_cells_type aud_I2S1_rx_gains =
{
    /* scal_mic             */  0x2000,TRUE,
    /* lambda0              */  0x7FFF,TRUE,
    /* gamma0               */  0x7FFF,TRUE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};
#ifdef _USE_TEAK_AFE
aud_uplink_parms_type aud_handset_mic_data =
{
    /* name */                  "Handset mic",
    /* uplink_gain_cells    */  &aud_handset_mic_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_handset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x0006,TRUE, /* afe_30db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_SG_AFEIIS_UL,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
#else
aud_uplink_parms_type aud_handset_mic_data =
{
    /* name */                  "Handset mic",
    /* uplink_gain_cells    */  &aud_I2S1_rx_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_headset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x0006,TRUE, /* afe_18db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
#endif

aud_uplink_parms_type aud_handset_mic_data_afei2s =
{
    /* name */                  "Handset mic",
    /* uplink_gain_cells    */  &aud_handset_mic_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_handset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x0006,TRUE, /* afe_30db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_SG_AFEIIS_UL,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
aud_uplink_parms_type aud_handset_mic_data_i2s1 =
{
    /* name */                  "Handset mic",
    /* uplink_gain_cells    */  &aud_I2S1_rx_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_headset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x0006,TRUE, /* afe_18db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};





 aud_uplink_gain_cells_type aud_headset_mic_gains =
{
    /* scal_mic             */  0x17FF,TRUE,
    /* lambda0              */  0x7FFF,TRUE,
    /* gamma0               */  0x7FFF,TRUE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};

#ifdef _USE_TEAK_AFE
aud_uplink_parms_type aud_headset_mic_data =
{
    /* name */                  "Headset mic",
    /* uplink_gain_cells    */  &aud_headset_mic_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_headset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x0006,TRUE, /* afe_30db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_SG_AFEIIS_UL,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
#else
aud_uplink_parms_type aud_headset_mic_data =
{
    /* name */                  "Headset mic",
    /* uplink_gain_cells    */  &aud_I2S1_rx_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_headset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x0006,TRUE, /* afe_18db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
#endif
/*[End] [lvwenhua-2010/9/19]*/

aud_uplink_parms_type aud_headset_mic_data_afei2s =
{
    /* name */                  "Headset mic",
    /* uplink_gain_cells    */  &aud_headset_mic_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_headset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x0006,TRUE, /* afe_30db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_SG_AFEIIS_UL,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
aud_uplink_parms_type aud_headset_mic_data_i2s1 =
{
    /* name */                  "Headset mic",
    /* uplink_gain_cells    */  &aud_I2S1_rx_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_headset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x0006,TRUE, /* afe_18db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};



aud_uplink_parms_type aud_I2S1_rx_data =
{
    /* name */                  "I2S1 rx",
    /* uplink_gain_cells    */  &aud_I2S1_rx_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_headset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x0006,TRUE, /* afe_18db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
 aud_uplink_gain_cells_type aud_tty_uplink_gains =
{
    /* scal_mic             */  0x2000,TRUE,
    /* lambda0              */  0x7FFF,TRUE,
    /* gamma0               */  0x7FFF,TRUE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_tty_uplink_data =
{
    /* name */                  "TTY uplink",
    /* uplink_gain_cells    */  &aud_tty_uplink_gains,
    /* biquad uplink_8kHz   */  &uplink_pass_through_filter,
    /* biquad uplink_16kHz  */  &uplink_pass_through_filter,
    /* biquad uplink_48kHz  */  &uplink_pass_through_filter,
    /* fir_filter_ul        */  &fir_filter_pass_through,
    /* hf_parms             */  &hf_parm_tty,
    /* asp_ul               */  NULL,
    /* mic_gain             */  0x0006,TRUE, /* afe_18db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_MIC2_TO_RIGHT,
    /* ext_hw_blocks        */  0,//AUD_HEADSET_AMP,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
 aud_uplink_gain_cells_type aud_I2S1_inband_rx_gains =
{
    /* scal_mic             */  0x2000,FALSE,
    /* lambda0              */  0x7FFF,FALSE,
    /* gamma0               */  0x7FFF,FALSE,
    /* scal_afe             */  0x2000,TRUE,
    /* scal_mic2            */  0x2000,TRUE,
    /* afe_tone             */  0x4000,TRUE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_I2S1_inband_rx_data =
{
    /* name */                  "I2S1 inband rx",
    /* uplink_gain_cells    */  &aud_I2S1_inband_rx_gains,
    /* biquad uplink_8kHz   */  NULL,
    /* biquad uplink_16kHz  */  NULL,
    /* biquad uplink_48kHz  */  NULL,
    /* fir_filter_ul        */  NULL,
    /* hf_parms             */  NULL,
    /* asp_ul               */  NULL,
    /* mic_gain             */  0x0002,TRUE, /* afe_6db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1_INBAND_AFE_ON | AUD_HW_DEP_MIC2_TO_RIGHT,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
 aud_uplink_gain_cells_type aud_handset_mic_42dB_gains =
{
    /* scal_mic             */  0x17FF,TRUE,
    /* lambda0              */  0x7FFF,TRUE,
    /* gamma0               */  0x7FFF,TRUE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_handset_mic_42dB_data =
{
    /* name */                  "Handset mic 42dB",
    /* uplink_gain_cells    */  &aud_handset_mic_42dB_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_handset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x000E,TRUE, /* afe_42db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_MIC1_TO_LEFT,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_uplink_gain_cells_type aud_handset_dthf_uplink_gains =
{
    /* scal_mic             */  0x17FF,TRUE,
    /* lambda0              */  0x7FFF,TRUE,
    /* gamma0               */  0x7FFF,TRUE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_handset_dthf_uplink_data =
{
    /* name */                  "Handset dthf uplink",
    /* uplink_gain_cells    */  &aud_handset_dthf_uplink_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_dthf_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x000A,TRUE, /* afe_30db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_MIC1_TO_LEFT,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_uplink_gain_cells_type aud_mic_mute_gains =
{
    /* scal_mic             */  0,TRUE,
    /* lambda0              */  0,TRUE,
    /* gamma0               */  0x7FFF,FALSE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_mic_mute_data =
{
    /* name */                  "Mic mute",
    /* uplink_gain_cells    */  &aud_mic_mute_gains,
    /* biquad uplink_8kHz   */  NULL,
    /* biquad uplink_16kHz  */  NULL,
    /* biquad uplink_48kHz  */  NULL,
    /* fir_filter_ul        */  NULL,
    /* hf_parms             */  &hf_parm_handset_mic,
    /* asp_ul               */  NULL,
    /* mic_gain             */  0x0005,FALSE, /* afe_15db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_MIC1_TO_LEFT,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_uplink_gain_cells_type aud_handset_mic_slidedown_gains =
{
    /* scal_mic             */  0x17FF,TRUE,
    /* lambda0              */  0x7FFF,TRUE,
    /* gamma0               */  0x7FFF,TRUE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_handset_mic_slidedown_data =
{
    /* name */                  "Handset mic slidedown",
    /* uplink_gain_cells    */  &aud_handset_mic_slidedown_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_handset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x0005,TRUE, /* afe_15db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_MIC1_TO_LEFT,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_uplink_gain_cells_type aud_handset_mic_loopback_gains =
{
    /* scal_mic             */  0x1FFF,TRUE,
    /* lambda0              */  0,FALSE,
    /* gamma0               */  0,FALSE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_handset_mic_loopback_data =
{
    /* name */                  "Handset mic loopback",
    /* uplink_gain_cells    */  &aud_handset_mic_loopback_gains,
    /* biquad uplink_8kHz   */  &uplink_pass_through_filter,
    /* biquad uplink_16kHz  */  &uplink_pass_through_filter,
    /* biquad uplink_48kHz  */  &uplink_pass_through_filter,
    /* fir_filter_ul        */  &fir_filter_pass_through,
    /* hf_parms             */  NULL,
    /* asp_ul               */  NULL,
    /* mic_gain             */  0,TRUE, /* afe_0db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_MIC1_TO_LEFT,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_uplink_gain_cells_type aud_I2S1_rx_loopback_gains =
{
    /* scal_mic             */  0x1FFF,TRUE,
    /* lambda0              */  0,FALSE,
    /* gamma0               */  0,FALSE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_I2S1_rx_loopback_data =
{
    /* name */                  "I2S1 Rx loopback",
    /* uplink_gain_cells    */  &aud_I2S1_rx_loopback_gains,
    /* biquad uplink_8kHz   */  &uplink_pass_through_filter,
    /* biquad uplink_16kHz  */  &uplink_pass_through_filter,
    /* biquad uplink_48kHz  */  &uplink_pass_through_filter,
    /* fir_filter_ul        */  &fir_filter_pass_through,
    /* hf_parms             */  NULL,
    /* asp_ul               */  NULL,
    /* mic_gain             */  0,TRUE, /* afe_0db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
 aud_uplink_gain_cells_type aud_media_to_uplink_gains =
{
    /* scal_mic             */  0x2000,FALSE,
    /* lambda0              */  0x7FFF,FALSE,
    /* gamma0               */  0x7FFF,FALSE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  TRUE /* media to uplink */
};
aud_uplink_parms_type aud_media_to_uplink_data =
{
    /* name */                  "Media to uplink",
    /* uplink_gain_cells    */  &aud_media_to_uplink_gains,
    /* biquad uplink_8kHz   */  NULL,
    /* biquad uplink_16kHz  */  NULL,
    /* biquad uplink_48kHz  */  NULL,
    /* fir_filter_ul        */  NULL,
    /* hf_parms             */  NULL,
    /* asp_ul               */  NULL,
    /* mic_gain             */  0x0000,FALSE, /* 0dB */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
// no const warnning
aud_uplink_gain_cells_type aud_stereo_mic_gains =
{
    /* scal_mic             */  0x2000,TRUE,
    /* lambda0              */  0x7FFF,FALSE,
    /* gamma0               */  0x7FFF,FALSE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_stereo_mic_data =
{
    /* name */                  "Hi-fi stereo mic",
    /* uplink_gain_cells    */  &aud_stereo_mic_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  NULL,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x000A,TRUE, /* 30dB */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_MIC1_TO_LEFT | AUD_HW_DEP_MIC2_TO_RIGHT,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_uplink_gain_cells_type aud_scheduler_8kHz_gains =
{   /* used for both 8, 16, and 48 kHz */
    /* scal_mic             */  0,FALSE,
    /* lambda0              */  0,FALSE,
    /* gamma0               */  0,FALSE,
    /* scal_afe             */  0,FALSE,
    /* scal_mic2            */  0,FALSE,
    /* afe_tone             */  0,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_scheduler_8kHz_data =
{
    /* name */                  "Audio scheduler 8kHz",
    /* uplink_gain_cells    */  &aud_scheduler_8kHz_gains,
    /* biquad uplink_8kHz   */  NULL,
    /* biquad uplink_16kHz  */  NULL,
    /* biquad uplink_48kHz  */  NULL,
    /* fir_filter_ul        */  NULL,
    /* hf_parms             */  NULL,
    /* asp_ul               */  NULL,
    /* mic_gain             */  0,FALSE,
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  0,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  AUD_SAMPLE_RATE_8KHZ_MONO,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
aud_uplink_parms_type aud_scheduler_16kHz_data =
{
    /* name */                  "Audio scheduler 16kHz",
    /* uplink_gain_cells    */  &aud_scheduler_8kHz_gains,
    /* biquad uplink_8kHz   */  NULL,
    /* biquad uplink_16kHz  */  NULL,
    /* biquad uplink_48kHz  */  NULL,
    /* fir_filter_ul        */  NULL,
    /* hf_parms             */  NULL,
    /* asp_ul               */  NULL,
    /* mic_gain             */  0,FALSE,
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  0,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  AUD_SAMPLE_RATE_16KHZ_MONO,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_16KHZ_MONO
};
aud_uplink_parms_type aud_scheduler_48kHz_data =
{
    /* name */                  "Audio scheduler 48kHz",
    /* uplink_gain_cells    */  &aud_scheduler_8kHz_gains,
    /* biquad uplink_8kHz   */  NULL,
    /* biquad uplink_16kHz  */  NULL,
    /* biquad uplink_48kHz  */  NULL,
    /* fir_filter_ul        */  NULL,
    /* hf_parms             */  NULL,
    /* asp_ul               */  NULL,
    /* mic_gain             */  0,FALSE,
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  0,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  AUD_SAMPLE_RATE_48KHZ_STEREO,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_uplink_gain_cells_type aud_external_stereo_input_gains =
{
    /* scal_mic             */  0x17FF,TRUE,
    /* lambda0              */  0,FALSE,
    /* gamma0               */  0,FALSE,
    /* scal_afe             */  0,FALSE,
    /* scal_mic2            */  0,FALSE,
    /* afe_tone             */  0,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_external_stereo_input_data =
{
    /* name */                  "External stereo input",
    /* uplink_gain_cells    */  &aud_external_stereo_input_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  NULL,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x000A,TRUE, /* 30dB */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_AUX_STEREO2_SINGLE_ENDED | AUD_HW_DEP_AUX_STEREO_TO_LEFT | AUD_HW_DEP_AUX_STEREO_TO_RIGHT,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_uplink_gain_cells_type aud_headset_mic_42dB_gains =
{
    /* scal_mic             */  0x17FF,TRUE,
    /* lambda0              */  0x7FFF,TRUE,
    /* gamma0               */  0x7FFF,TRUE,
    /* scal_afe             */  0x0000,FALSE,
    /* scal_mic2            */  0x0000,FALSE,
    /* afe_tone             */  0x0000,FALSE,
    /* mix_pcmrec           */  FALSE
};
aud_uplink_parms_type aud_headset_mic_42dB_data =
{
    /* name */                  "Headset mic 42dB",
    /* uplink_gain_cells    */  &aud_headset_mic_42dB_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz,
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz,
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_headset_mic,
    /* asp_ul               */  &asp_uplink_1,
    /* mic_gain             */  0x000E,TRUE, /* afe_42db_gain */
    /* tx_dither            */  0,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_MIC2_TO_RIGHT,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_uplink_gain_cells_type aud_uplink_source_default_gains =
{
    /* scal_mic             */  0x2000,TRUE,
    /* lambda0              */  0x7FFF,TRUE,
    /* gamma0               */  0x7FFF,TRUE,
    /* scal_afe             */  0x0000,TRUE,
    /* scal_mic2            */  0x0000,TRUE,
    /* afe_tone             */  0x0000,TRUE,
    /* mix_pcmrec           */  FALSE
};
  aud_uplink_parms_type aud_uplink_source_default_data =
{   /* DEFAULT */
    /* name */                  "Default uplink",
    /* uplink_gain_cells    */  &aud_uplink_source_default_gains,
    /* biquad uplink_8kHz   */  &uplink_mic_filter_8kHz,  /* NULL=don't care */
    /* biquad uplink_16kHz  */  &uplink_mic_filter_16kHz, /* NULL=don't care */
    /* biquad uplink_48kHz  */  &uplink_mic_filter_48kHz, /* NULL=don't care */
    /* fir_filter_ul        */  &uplink_fir_filter_1,
    /* hf_parms             */  &hf_parm_handset_mic,     /* NULL=don't care */
    /* asp_ul               */  NULL,
    /* mic_gain             */  0x0000,TRUE, /* 0dB */
    /* tx_dither            */  0,TRUE,
    /* afe_dsp_blocks       */  0,
    /* ext_hw_blocks        */  0,
    /* required_sample_rate */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};

/*******************************************************************************
*
*                               Downlink paths
*
*******************************************************************************/
//no const wanrnning
 aud_downlink_gain_cells_type aud_normal_earpiece_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};

/*now all paths use i2s1 interface in fact.[Begin] [lvwenhua-2010/9/19]*/
 aud_downlink_gain_cells_type aud_I2S1_tx_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};

#ifdef _USE_TEAK_AFE
aud_downlink_parms_type aud_normal_earpiece_data =
{
    /* name */                  "Normal earpiece",
    /* uplink_gain_cells    */  &aud_normal_earpiece_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE, /*If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_SG_AFEIIS_DL,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
#else
aud_downlink_parms_type aud_normal_earpiece_data =
{
    /* name */                  "Normal earpiece",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
#endif

aud_downlink_parms_type aud_normal_earpiece_data_afei2s =
{
    /* name */                  "Normal earpiece",
    /* uplink_gain_cells    */  &aud_normal_earpiece_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE, /*If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_SG_AFEIIS_DL,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
aud_downlink_parms_type aud_normal_earpiece_data_i2s1 =
{
    /* name */                  "Normal earpiece",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};



 aud_downlink_gain_cells_type aud_mono_headset_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};
#ifdef _USE_TEAK_AFE
aud_downlink_parms_type aud_mono_headset_data =
{
    /* name */                  "Mono headset",
    /* uplink_gain_cells    */  &aud_mono_headset_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_SG_AFEIIS_DL,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
#else
aud_downlink_parms_type aud_mono_headset_data =
{
    /* name */                  "Mono headset",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
#endif

aud_downlink_parms_type aud_mono_headset_data_afei2s =
{
    /* name */                  "Mono headset",
    /* uplink_gain_cells    */  &aud_mono_headset_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_SG_AFEIIS_DL,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
aud_downlink_parms_type aud_mono_headset_data_i2s1 =
{
    /* name */                  "Mono headset",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};


 aud_downlink_gain_cells_type aud_stereo_headset_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};
#ifdef _USE_TEAK_AFE
aud_downlink_parms_type aud_stereo_headset_data =
{
    /* name */                  "Stereo headset",
    /* uplink_gain_cells    */  &aud_stereo_headset_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_AFE_OUTPUT_STEREO | AUD_HW_DEP_SG_AFEIIS_DL,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
#else
aud_downlink_parms_type aud_stereo_headset_data =
{
    /* name */                  "Stereo headset",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
#endif

aud_downlink_parms_type aud_stereo_headset_data_afei2s =
{
    /* name */                  "Stereo headset",
    /* uplink_gain_cells    */  &aud_stereo_headset_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_AFE_OUTPUT_STEREO | AUD_HW_DEP_SG_AFEIIS_DL,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
aud_downlink_parms_type aud_stereo_headset_data_i2s1 =
{
    /* name */                  "Stereo headset",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};


 aud_downlink_gain_cells_type aud_backspeaker_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};
#ifdef _USE_TEAK_AFE
aud_downlink_parms_type aud_backspeaker_data =
{   /* mono */
    /* name */                  "Backspeaker",
    /* uplink_gain_cells    */  &aud_backspeaker_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_SG_AFEIIS_DL,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
#else
aud_downlink_parms_type aud_backspeaker_data =
{
    /* name */                  "Backspeaker",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
#endif
aud_downlink_parms_type aud_backspeaker_data_afei2s =
{   /* mono */
    /* name */                  "Backspeaker",
    /* uplink_gain_cells    */  &aud_backspeaker_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_SG_AFEIIS_DL,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
aud_downlink_parms_type aud_backspeaker_data_i2s1 =
{
    /* name */                  "Backspeaker",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};


#ifdef _USE_TEAK_AFE
aud_downlink_parms_type aud_backspeaker_stereo_data =
{
    /* name */                  "Backspeaker stereo",
    /* uplink_gain_cells    */  &aud_stereo_headset_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_AFE_OUTPUT_STEREO | AUD_HW_DEP_SG_AFEIIS_DL,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
#else
aud_downlink_parms_type aud_backspeaker_stereo_data =
{
    /* name */                  "Backspeaker stereo",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
#endif
/*[End] [lvwenhua-2010/9/19]*/

aud_downlink_parms_type aud_backspeaker_stereo_data_afei2s =
{
    /* name */                  "Backspeaker stereo",
    /* uplink_gain_cells    */  &aud_stereo_headset_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_AFE_OUTPUT_STEREO | AUD_HW_DEP_SG_AFEIIS_DL,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
aud_downlink_parms_type aud_backspeaker_stereo_data_i2s1 =
{
    /* name */                  "Backspeaker stereo",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};


aud_downlink_parms_type aud_I2S1_tx_data =
{
    /* name */                  "I2S1 tx",
    /* uplink_gain_cells    */  &aud_I2S1_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
 aud_downlink_gain_cells_type aud_tty_downlink_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};
aud_downlink_parms_type aud_tty_downlink_data =
{
    /* name */                  "TTY downlink",
    /* uplink_gain_cells    */  &aud_tty_downlink_gains,
    /* biquad downlink_8kHz */  &downlink_pass_through_filter,
    /* biquad downlink_16kHz*/  &downlink_pass_through_filter,
    /* biquad_cbuf          */  &cbuf_pass_through_filter,
    /* fir_filter_dl        */  &fir_filter_pass_through,
    /* fir_filter_cbuf      */  &fir_filter_pass_through,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  0,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_DAC1_EPPA1,
    /* ext_hw_blocks        */  0,//AUD_HEADSET_AMP,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
 aud_downlink_gain_cells_type aud_backspeaker_path_downlink_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};
aud_downlink_parms_type aud_backspeaker_path_downlink_data =
{
    /* name */                  "Backspeaker path",
    /* uplink_gain_cells    */  &aud_backspeaker_path_downlink_gains,
    /* biquad downlink_8kHz */  &downlink_pass_through_filter,
    /* biquad downlink_16kHz*/  &downlink_pass_through_filter,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &fir_filter_pass_through,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  0,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_downlink_gain_cells_type aud_earpiece_path_downlink_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};
aud_downlink_parms_type aud_earpiece_path_downlink_data =
{
    /* name */                 "Earpiece path",
    /* uplink_gain_cells    */  &aud_earpiece_path_downlink_gains,
    /* biquad downlink_8kHz */  &downlink_pass_through_filter,
    /* biquad downlink_16kHz*/  &downlink_pass_through_filter,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &fir_filter_pass_through,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  0,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_downlink_gain_cells_type aud_I2S1_inband_tx_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};
aud_downlink_parms_type aud_I2S1_inband_tx_data =
{
    /* name */                  "I2S1 inband",
    /* uplink_gain_cells    */  &aud_I2S1_inband_tx_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  0,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
#if 0
const aud_downlink_gain_cells_type aud_fmradio_backspeaker_gains =
{
    /* gain_out             */  0x2000,FALSE,
    /* kappa0               */  0x7FFF,FALSE,
    /* mix_afe              */  TRUE, FALSE
};
aud_downlink_parms_type aud_fmradio_backspeaker_data =
{
    /* name */                  "FM radio backspeaker",
    /* uplink_gain_cells    */  &aud_fmradio_backspeaker_gains,
    /* biquad downlink_8kHz */  NULL,
    /* biquad downlink_16kHz*/  NULL,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  NULL,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  0,FALSE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_AUX_STEREO_DIFFERENTIAL | AUD_HW_DEP_LNA3_EPPA1 | AUD_HW_DEP_LNA4_EPPA2,
    /* ext_hw_blocks        */  AUD_FM_RADIO,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
const aud_downlink_gain_cells_type aud_fmradio_headset_gains =
{
    /* gain_out             */  0x2000,FALSE,
    /* kappa0               */  0x7FFF,FALSE,
    /* mix_afe              */  TRUE, FALSE
};
aud_downlink_parms_type aud_fmradio_headset_data =
{
    /* name */                  "FM radio headset",
    /* uplink_gain_cells    */  &aud_fmradio_headset_gains,
    /* biquad downlink_8kHz */  NULL,
    /* biquad downlink_16kHz*/  NULL,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  NULL,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  0,FALSE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_AUX_STEREO_DIFFERENTIAL | AUD_HW_DEP_LNA3_EPPA1 | AUD_HW_DEP_LNA4_EPPA2,
    /* ext_hw_blocks        */  AUD_FM_RADIO,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
const aud_downlink_gain_cells_type aud_smpower_backspeaker_gains =
{
    /* gain_out             */  0x0000,FALSE,
    /* kappa0               */  0x7FFF,FALSE,
    /* mix_afe              */  TRUE, FALSE
};
aud_downlink_parms_type aud_smpower_backspeaker_data =
{
    /* name */                  "SM Power backspeaker",
    /* uplink_gain_cells    */  &aud_smpower_backspeaker_gains,
    /* biquad downlink_8kHz */  NULL,
    /* biquad downlink_16kHz*/  NULL,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  NULL,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  0,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  0,
    /* ext_hw_blocks        */  AUD_SM_AMP,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
#endif
 aud_downlink_gain_cells_type aud_normal_earpiece_loopback_gains =
{
    /* gain_out             */  0,TRUE,
    /* kappa0               */  0,FALSE,
    /* mix_afe              */  FALSE,TRUE //mute media to downlink
};
aud_downlink_parms_type aud_normal_earpiece_loopback_data =
{
    /* name */                  "Norm. earpc. loopback",
    /* uplink_gain_cells    */  &aud_normal_earpiece_loopback_gains,
    /* biquad downlink_8kHz */  &downlink_pass_through_filter,
    /* biquad downlink_16kHz*/  &downlink_pass_through_filter,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &fir_filter_pass_through,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  5787,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE | AUD_HW_DEP_DAC1_EPP1EPN1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_downlink_gain_cells_type aud_I2S1_tx_loopback_gains =
{
    /* gain_out             */  0,TRUE,
    /* kappa0               */  0,FALSE,
    /* mix_afe              */  FALSE,TRUE //mute media to downlink
};
aud_downlink_parms_type aud_I2S1_tx_loopback_data =
{
    /* name */                  "I2S1 Tx loopback",
    /* uplink_gain_cells    */  &aud_I2S1_tx_loopback_gains,
    /* biquad downlink_8kHz */  &downlink_pass_through_filter,
    /* biquad downlink_16kHz*/  &downlink_pass_through_filter,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  &fir_filter_pass_through,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  5787,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_I2S1,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO
};
 aud_downlink_gain_cells_type aud_media_to_downlink_mute_gains =
{
    /* gain_out             */  0x2000,FALSE,
    /* kappa0               */  0x7FFF,FALSE,
    /* mix_afe              */  FALSE,TRUE //mute media to downlink
};
aud_downlink_parms_type aud_media_to_downlink_mute_data =
{
    /* name */                  "Mute media to downlnk",
    /* uplink_gain_cells    */  &aud_media_to_downlink_mute_gains,
    /* biquad downlink_8kHz */  NULL,
    /* biquad downlink_16kHz*/  NULL,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  NULL,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  0,FALSE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,FALSE,
    /* afe_dsp_blocks       */  0,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_downlink_gain_cells_type aud_sidetone_loopback_gains =
{
    /* gain_out             */  0,FALSE,
    /* kappa0               */  0,FALSE,
    /* mix_afe              */  TRUE, FALSE
};
aud_downlink_parms_type aud_sidetone_loopback_data =
{
    /* name */                  "Sidetone loopback",
    /* uplink_gain_cells    */  &aud_sidetone_loopback_gains,
    /* biquad downlink_8kHz */  NULL,
    /* biquad downlink_16kHz*/  NULL,
    /* biquad_cbuf          */  NULL,
    /* fir_filter_dl        */  NULL,
    /* fir_filter_cbuf      */  NULL,
    /* dl_nr                */  NULL,
    /* side_tone_fact       */  500,TRUE, /*If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,FALSE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_downlink_gain_cells_type aud_I2S2_external_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};
aud_downlink_parms_type aud_I2S2_external_data =
{
    /* name */                  "I2S2 external",
    /* uplink_gain_cells    */  &aud_I2S2_external_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz,
    /* biquad_cbuf          */  &downlink_normal_cbuf,
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  &dl_nr_1,
    /* side_tone_fact       */  500,TRUE, /*If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_6dB,TRUE,
    /* afe_dsp_blocks       */  AUD_HW_DEP_SG_AFE,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};
 aud_downlink_gain_cells_type aud_downlink_source_default_gains =
{
    /* gain_out             */  0x2000,TRUE,
    /* kappa0               */  0x7FFF,TRUE,
    /* mix_afe              */  TRUE, FALSE
};
 aud_downlink_parms_type aud_downlink_source_default_data =
{   /* DEFAULT */
    /* name */                  "Downlink default",
    /* uplink_gain_cells    */  &aud_downlink_source_default_gains,
    /* biquad downlink_8kHz */  &downlink_norm_earpiece_filter_8kHz,  /* NULL=don't care */
    /* biquad downlink_16kHz*/  &downlink_norm_earpiece_filter_16kHz, /* NULL=don't care */
    /* biquad_cbuf          */  &downlink_normal_cbuf,                /* NULL=don't care */
    /* fir_filter_dl        */  &downlink_fir_filter_1,
    /* fir_filter_cbuf      */  &cbuf_fir_filter_1,
    /* dl_nr                */  NULL, /* downlink noise reduction inactive by default */
    /* side_tone_fact       */  500,TRUE,  /* If muting is wanted - use 0. */
    /* sm_pwer_gain         */  PMU_AUD_GAIN_0dB,TRUE,
    /* afe_dsp_blocks       */  0,
    /* ext_hw_blocks        */  0,
    /* ma_hw_blocks         */  0,
    /* allowed_sample_rates */  AUD_SAMPLE_RATE_8KHZ_MONO | AUD_SAMPLE_RATE_16KHZ_MONO | AUD_SAMPLE_RATE_48KHZ_STEREO
};

/*******************************************************************************
*
*                              Path parallelism
*
*******************************************************************************/
U32 aud_Parallel_Uplink_Paths[] =
{
    /* Note that I2S1 Rx and AFE Tx can NOT run in parallel */
    /* Note that aud_scheduler_8kHz, aud_scheduler_16kHz and aud_scheduler_48kHz may not run in parallel.
        This is why many configurations below exist in three variants. */
    /* All except the hifi paths may run at 8 kHz */
#if defined (STEON2_PROJECT)
    1<<aud_headset_mic /*| 1<<aud_media_to_uplink*/                                 | 1<<aud_scheduler_8kHz,
    1<<aud_tty_uplink /*| 1<<aud_media_to_uplink*/                                  | 1<<aud_scheduler_8kHz,
    1<<aud_I2S1_rx | 1<<aud_I2S1_inband_rx /*| 1<<aud_media_to_uplink*/             | 1<<aud_scheduler_8kHz,
    1<<aud_handset_mic_42dB /*| 1<<aud_media_to_uplink*/                            | 1<<aud_scheduler_8kHz,
    1<<aud_handset_dthf_uplink | 1<<aud_handset_mic /*| 1<<aud_media_to_uplink*/    | 1<<aud_scheduler_8kHz,
    1<<aud_mic_mute /*| 1<<aud_media_to_uplink*/                                    | 1<<aud_scheduler_8kHz,
    1<<aud_handset_mic_slidedown /*| 1<<aud_media_to_uplink*/                       | 1<<aud_scheduler_8kHz,
    1<<aud_handset_mic_loopback /*| 1<<aud_media_to_uplink*/                        | 1<<aud_scheduler_8kHz,
    1<<aud_I2S1_rx_loopback /*| 1<<aud_media_to_uplink*/                            | 1<<aud_scheduler_8kHz,
    1<<aud_headset_mic_42dB /*| 1<<aud_media_to_uplink*/                            | 1<<aud_scheduler_8kHz,
#else /* STEON2_PROJECT */
    1<<aud_headset_mic | 1<<aud_media_to_uplink                                 | 1<<aud_scheduler_8kHz,
    1<<aud_tty_uplink | 1<<aud_media_to_uplink                                  | 1<<aud_scheduler_8kHz,
    1<<aud_I2S1_rx | 1<<aud_I2S1_inband_rx | 1<<aud_media_to_uplink             | 1<<aud_scheduler_8kHz,
    1<<aud_handset_mic_42dB | 1<<aud_media_to_uplink                            | 1<<aud_scheduler_8kHz,
    1<<aud_handset_dthf_uplink | 1<<aud_handset_mic | 1<<aud_media_to_uplink    | 1<<aud_scheduler_8kHz,
    1<<aud_mic_mute | 1<<aud_media_to_uplink                                    | 1<<aud_scheduler_8kHz,
    1<<aud_handset_mic_slidedown | 1<<aud_media_to_uplink                       | 1<<aud_scheduler_8kHz,
    1<<aud_handset_mic_loopback | 1<<aud_media_to_uplink                        | 1<<aud_scheduler_8kHz,
    1<<aud_I2S1_rx_loopback | 1<<aud_media_to_uplink                            | 1<<aud_scheduler_8kHz,
    1<<aud_headset_mic_42dB | 1<<aud_media_to_uplink                            | 1<<aud_scheduler_8kHz,
#endif /* STEON2_PROJECT */
    /* I2S1, Media to uplink and TTY do not work in 16 kHz */
    1<<aud_headset_mic                                                          | 1<<aud_scheduler_16kHz,
    1<<aud_handset_mic_42dB                                                     | 1<<aud_scheduler_16kHz,
    1<<aud_handset_dthf_uplink | 1<<aud_handset_mic                             | 1<<aud_scheduler_16kHz,
    1<<aud_mic_mute                                                             | 1<<aud_scheduler_16kHz,
    1<<aud_handset_mic_slidedown                                                | 1<<aud_scheduler_16kHz,
    1<<aud_handset_mic_loopback                                                 | 1<<aud_scheduler_16kHz,
    1<<aud_headset_mic_42dB                                                     | 1<<aud_scheduler_16kHz,
    /* I2S1 and TTY do not work in 48 kHz */
#if defined (STEON2_PROJECT)
    1<<aud_headset_mic /*| 1<<aud_media_to_uplink*/                                 | 1<<aud_scheduler_48kHz,
    1<<aud_handset_mic_42dB /*| 1<<aud_media_to_uplink*/                            | 1<<aud_scheduler_48kHz,
    1<<aud_handset_dthf_uplink | 1<<aud_handset_mic /*| 1<<aud_media_to_uplink*/    | 1<<aud_scheduler_48kHz,
    1<<aud_mic_mute /*| 1<<aud_media_to_uplink*/                                    | 1<<aud_scheduler_48kHz,
    1<<aud_handset_mic_slidedown /*| 1<<aud_media_to_uplink*/                       | 1<<aud_scheduler_48kHz,
    1<<aud_handset_mic_loopback /*| 1<<aud_media_to_uplink*/                        | 1<<aud_scheduler_48kHz,
    1<<aud_stereo_mic /*| 1<<aud_media_to_uplink*/                                  | 1<<aud_scheduler_48kHz,
    1<<aud_external_stereo_input /*| 1<<aud_media_to_uplink*/                       | 1<<aud_scheduler_48kHz,
    1<<aud_headset_mic_42dB /*| 1<<aud_media_to_uplink*/                            | 1<<aud_scheduler_48kHz,
#else /* STEON2_PROJECT */
    1<<aud_headset_mic | 1<<aud_media_to_uplink                                 | 1<<aud_scheduler_48kHz,
    1<<aud_handset_mic_42dB | 1<<aud_media_to_uplink                            | 1<<aud_scheduler_48kHz,
    1<<aud_handset_dthf_uplink | 1<<aud_handset_mic | 1<<aud_media_to_uplink    | 1<<aud_scheduler_48kHz,
    1<<aud_mic_mute | 1<<aud_media_to_uplink                                    | 1<<aud_scheduler_48kHz,
    1<<aud_handset_mic_slidedown | 1<<aud_media_to_uplink                       | 1<<aud_scheduler_48kHz,
    1<<aud_handset_mic_loopback | 1<<aud_media_to_uplink                        | 1<<aud_scheduler_48kHz,
    1<<aud_stereo_mic | 1<<aud_media_to_uplink                                  | 1<<aud_scheduler_48kHz,
    1<<aud_external_stereo_input | 1<<aud_media_to_uplink                       | 1<<aud_scheduler_48kHz,
    1<<aud_headset_mic_42dB | 1<<aud_media_to_uplink                            | 1<<aud_scheduler_48kHz,
#endif /* STEON2_PROJECT */
    0 /* Terminator */
};

U32 aud_Parallel_Downlink_Paths[] =
{
    /* Note that I2S1 Tx and AFE Rx can run in parallel */
    /* Assumption: it makes sense that the same audio signals can be played back by multiple speakers */
    /* Special case: TTY must run alone and at 8 kHz */
#if defined (STEON2_PROJECT)
    1<<aud_tty_downlink /*| 1<<aud_media_to_downlink_mute*/,
    /* Special case: SM Power backspeaker used for non-baseband audio */
    1<<aud_smpower_backspeaker /*| 1<<aud_media_to_downlink_mute*/,
    /* Special case: Test paths that must run alone (or with media to downlink muted) */
    1<<aud_backspeaker_path_downlink /*| 1<<aud_media_to_downlink_mute*/,
    1<<aud_earpiece_path_downlink /*| 1<<aud_media_to_downlink_mute*/,
    1<<aud_normal_earpiece_loopback /*| 1<<aud_media_to_downlink_mute*/,
    1<<aud_I2S1_tx_loopback /*| 1<<aud_media_to_downlink_mute*/,
    /* All other paths may run in parallel */
    /* - exception: aud_stereo_headset, aud_mono_headset, aud_backspeaker may not run in parallel */
    1<<aud_normal_earpiece | 1<<aud_mono_headset | 1<<aud_I2S1_tx | 1<<aud_I2S1_inband_tx | 1<<aud_fmradio_backspeaker | 1<<aud_fmradio_headset | 1<<aud_sidetone_loopback | 1<<aud_I2S2_external /*| 1<<aud_media_to_downlink_mute*/,
    1<<aud_normal_earpiece | 1<<aud_stereo_headset | 1<<aud_I2S1_tx | 1<<aud_I2S1_inband_tx | 1<<aud_fmradio_backspeaker | 1<<aud_fmradio_headset | 1<<aud_sidetone_loopback | 1<<aud_I2S2_external /*| 1<<aud_media_to_downlink_mute*/,
    1<<aud_normal_earpiece | 1<<aud_backspeaker | 1<<aud_I2S1_tx | 1<<aud_I2S1_inband_tx | 1<<aud_fmradio_backspeaker | 1<<aud_fmradio_headset | 1<<aud_sidetone_loopback | 1<<aud_I2S2_external /*| 1<<aud_media_to_downlink_mute*/,
#else /* STEON2_PROJECT */
    1<<aud_tty_downlink | 1<<aud_media_to_downlink_mute,
    /* Special case: SM Power backspeaker used for non-baseband audio */
    1<<aud_smpower_backspeaker | 1<<aud_media_to_downlink_mute,
    /* Special case: Test paths that must run alone (or with media to downlink muted) */
    1<<aud_backspeaker_path_downlink | 1<<aud_media_to_downlink_mute,
    1<<aud_earpiece_path_downlink | 1<<aud_media_to_downlink_mute,
    1<<aud_normal_earpiece_loopback | 1<<aud_media_to_downlink_mute,
    1<<aud_I2S1_tx_loopback | 1<<aud_media_to_downlink_mute,
    /* All other paths may run in parallel */
    1<<aud_normal_earpiece | 1<<aud_backspeaker | 1<<aud_I2S1_tx | 1<<aud_I2S1_inband_tx | 1<<aud_backspeaker_stereo | 1<<aud_fmradio_headset | 1<<aud_sidetone_loopback | 1<<aud_I2S2_external | 1<<aud_media_to_downlink_mute,
    /* - exception: aud_stereo_headset, aud_mono_headset, aud_backspeaker may not run in parallel */
    1<<aud_normal_earpiece | 1<<aud_mono_headset | 1<<aud_I2S1_tx | 1<<aud_I2S1_inband_tx | 1<<aud_fmradio_backspeaker | 1<<aud_fmradio_headset | 1<<aud_sidetone_loopback | 1<<aud_I2S2_external | 1<<aud_media_to_downlink_mute,
    1<<aud_normal_earpiece | 1<<aud_stereo_headset | 1<<aud_I2S1_tx | 1<<aud_I2S1_inband_tx | 1<<aud_fmradio_backspeaker | 1<<aud_fmradio_headset | 1<<aud_sidetone_loopback | 1<<aud_I2S2_external | 1<<aud_media_to_downlink_mute,
    1<<aud_normal_earpiece | 1<<aud_backspeaker | 1<<aud_I2S1_tx | 1<<aud_I2S1_inband_tx | 1<<aud_fmradio_backspeaker | 1<<aud_fmradio_headset | 1<<aud_sidetone_loopback | 1<<aud_I2S2_external | 1<<aud_media_to_downlink_mute,
#endif /* STEON2_PROJECT */
    0 /* Terminator */
};

/*******************************************************************************
*
*                              Available paths
*
*******************************************************************************/
aud_setting_type aud_setting =
{
    {
        &aud_handset_mic_data, /* 0 */
        &aud_headset_mic_data,
        &aud_I2S1_rx_data,
        &aud_tty_uplink_data,
        NULL, /* aud_hfcarkit_mic_data, */
        &aud_I2S1_inband_rx_data, /* 5 */
        &aud_handset_mic_42dB_data,
        &aud_handset_dthf_uplink_data,
        &aud_mic_mute_data,
        &aud_handset_mic_slidedown_data,
        &aud_handset_mic_loopback_data, /* 10 */
        &aud_I2S1_rx_loopback_data,
#if defined (STEON2_PROJECT)
        NULL, /* &aud_media_to_uplink_data, */ /* not available on Steon2 (gain cell used by I2S2 Rx resource mute) */
#else
        &aud_media_to_uplink_data,
#endif /* STEON2_PROJECT */
        NULL, /* aud_media_to_uplink_hifi */
        &aud_stereo_mic_data,
        &aud_scheduler_8kHz_data, /* 15 */
        &aud_scheduler_16kHz_data,
        &aud_scheduler_48kHz_data,
        &aud_external_stereo_input_data,
        &aud_headset_mic_42dB_data,
        &aud_uplink_source_default_data },{
        &aud_normal_earpiece_data, /* 0 */
        &aud_mono_headset_data,
        &aud_stereo_headset_data,
        &aud_backspeaker_data,
        &aud_I2S1_tx_data,
        &aud_tty_downlink_data, /* 5 */
        NULL, /* aud_mono_headset_external_ringer   */
        NULL, /* aud_stereo_headset_external_ringer */
        &aud_backspeaker_path_downlink_data,
        &aud_earpiece_path_downlink_data,
        NULL, /* aud_backspeaker_external_ringer */ /* 10 */
        NULL, /* aud_hfcarkit_speaker */
        &aud_I2S1_inband_tx_data, /*Special path used for routing inband audio (like ringtones) to the bt headset*/
        /*[Begin] [lvwenhua-2010/9/21]*/
#if 0
        NULL, /* aud_backspeaker_stereo */
#endif
        &aud_backspeaker_stereo_data, /* aud_backspeaker_stereo */
        /*[End] [lvwenhua-2010/9/21]*/
        NULL,//&aud_fmradio_backspeaker_data,
        NULL,//&aud_fmradio_headset_data, /* 15 */
        NULL, /* aud_companion_mono_headset */
        NULL, /* aud_companion_stereo_headset */
        NULL, /* aud_companion_mono_backspeaker */
        NULL, /* aud_companion_stereo_backspeaker */
        NULL,//&aud_smpower_backspeaker_data, /* 20 */ /*Special path to backspeaker for non-baseband audio*/
        &aud_normal_earpiece_loopback_data,
        &aud_I2S1_tx_loopback_data,
#if defined (STEON2_PROJECT)
        NULL, /* &aud_media_to_downlink_mute_data, */ /* not available on Steon2 (gain cell used by I2S2 Rx resource mute) */
#else
        &aud_media_to_downlink_mute_data,
#endif /* STEON2_PROJECT */
        &aud_sidetone_loopback_data,
        &aud_I2S2_external_data, /* 25 */
        NULL, /* aud_tmp_downlink_path */
        &aud_downlink_source_default_data
    }
};

aud_setting_type aud_setting_afei2s =
{
    {
        &aud_handset_mic_data_afei2s, /* 0 */
        &aud_headset_mic_data_afei2s,
        &aud_I2S1_rx_data,
        &aud_tty_uplink_data,
        NULL, /* aud_hfcarkit_mic_data, */
        &aud_I2S1_inband_rx_data, /* 5 */
        &aud_handset_mic_42dB_data,
        &aud_handset_dthf_uplink_data,
        &aud_mic_mute_data,
        &aud_handset_mic_slidedown_data,
        &aud_handset_mic_loopback_data, /* 10 */
        &aud_I2S1_rx_loopback_data,
#if defined (STEON2_PROJECT)
        NULL, /* &aud_media_to_uplink_data, */ /* not available on Steon2 (gain cell used by I2S2 Rx resource mute) */
#else
        &aud_media_to_uplink_data,
#endif /* STEON2_PROJECT */
        NULL, /* aud_media_to_uplink_hifi */
        &aud_stereo_mic_data,
        &aud_scheduler_8kHz_data, /* 15 */
        &aud_scheduler_16kHz_data,
        &aud_scheduler_48kHz_data,
        &aud_external_stereo_input_data,
        &aud_headset_mic_42dB_data,
        &aud_uplink_source_default_data
    }
    ,{
        &aud_normal_earpiece_data_afei2s, /* 0 */
        &aud_mono_headset_data_afei2s,
        &aud_stereo_headset_data_afei2s,
        &aud_backspeaker_data_afei2s,
        &aud_I2S1_tx_data,
        &aud_tty_downlink_data, /* 5 */
        NULL, /* aud_mono_headset_external_ringer   */
        NULL, /* aud_stereo_headset_external_ringer */
        &aud_backspeaker_path_downlink_data,
        &aud_earpiece_path_downlink_data,
        NULL, /* aud_backspeaker_external_ringer */ /* 10 */
        NULL, /* aud_hfcarkit_speaker */
        &aud_I2S1_inband_tx_data, /*Special path used for routing inband audio (like ringtones) to the bt headset*/
        /*[Begin] [lvwenhua-2010/9/21]*/
#if 0
        NULL, /* aud_backspeaker_stereo */
#endif
        &aud_backspeaker_stereo_data_afei2s, /* aud_backspeaker_stereo */
        /*[End] [lvwenhua-2010/9/21]*/
        NULL,//&aud_fmradio_backspeaker_data,
        NULL,//&aud_fmradio_headset_data, /* 15 */
        NULL, /* aud_companion_mono_headset */
        NULL, /* aud_companion_stereo_headset */
        NULL, /* aud_companion_mono_backspeaker */
        NULL, /* aud_companion_stereo_backspeaker */
        NULL,//&aud_smpower_backspeaker_data, /* 20 */ /*Special path to backspeaker for non-baseband audio*/
        &aud_normal_earpiece_loopback_data,
        &aud_I2S1_tx_loopback_data,
#if defined (STEON2_PROJECT)
        NULL, /* &aud_media_to_downlink_mute_data, */ /* not available on Steon2 (gain cell used by I2S2 Rx resource mute) */
#else
        &aud_media_to_downlink_mute_data,
#endif /* STEON2_PROJECT */
        &aud_sidetone_loopback_data,
        &aud_I2S2_external_data, /* 25 */
        NULL, /* aud_tmp_downlink_path */
        &aud_downlink_source_default_data
    }
};

aud_setting_type aud_setting_i2s1 =
{
    {
        &aud_handset_mic_data_i2s1, /* 0 */
        &aud_headset_mic_data_i2s1,
        &aud_I2S1_rx_data,
        &aud_tty_uplink_data,
        NULL, /* aud_hfcarkit_mic_data, */
        &aud_I2S1_inband_rx_data, /* 5 */
        &aud_handset_mic_42dB_data,
        &aud_handset_dthf_uplink_data,
        &aud_mic_mute_data,
        &aud_handset_mic_slidedown_data,
        &aud_handset_mic_loopback_data, /* 10 */
        &aud_I2S1_rx_loopback_data,
#if defined (STEON2_PROJECT)
        NULL, /* &aud_media_to_uplink_data, */ /* not available on Steon2 (gain cell used by I2S2 Rx resource mute) */
#else
        &aud_media_to_uplink_data,
#endif /* STEON2_PROJECT */
        NULL, /* aud_media_to_uplink_hifi */
        &aud_stereo_mic_data,
        &aud_scheduler_8kHz_data, /* 15 */
        &aud_scheduler_16kHz_data,
        &aud_scheduler_48kHz_data,
        &aud_external_stereo_input_data,
        &aud_headset_mic_42dB_data,
        &aud_uplink_source_default_data
    }
    ,{
        &aud_normal_earpiece_data_i2s1, /* 0 */
        &aud_mono_headset_data_i2s1,
        &aud_stereo_headset_data_i2s1,
        &aud_backspeaker_data_i2s1,
        &aud_I2S1_tx_data,
        &aud_tty_downlink_data, /* 5 */
        NULL, /* aud_mono_headset_external_ringer   */
        NULL, /* aud_stereo_headset_external_ringer */
        &aud_backspeaker_path_downlink_data,
        &aud_earpiece_path_downlink_data,
        NULL, /* aud_backspeaker_external_ringer */ /* 10 */
        NULL, /* aud_hfcarkit_speaker */
        &aud_I2S1_inband_tx_data, /*Special path used for routing inband audio (like ringtones) to the bt headset*/
        /*[Begin] [lvwenhua-2010/9/21]*/
#if 0
        NULL, /* aud_backspeaker_stereo */
#endif
        &aud_backspeaker_stereo_data_i2s1, /* aud_backspeaker_stereo */
        /*[End] [lvwenhua-2010/9/21]*/
        NULL,//&aud_fmradio_backspeaker_data,
        NULL,//&aud_fmradio_headset_data, /* 15 */
        NULL, /* aud_companion_mono_headset */
        NULL, /* aud_companion_stereo_headset */
        NULL, /* aud_companion_mono_backspeaker */
        NULL, /* aud_companion_stereo_backspeaker */
        NULL,//&aud_smpower_backspeaker_data, /* 20 */ /*Special path to backspeaker for non-baseband audio*/
        &aud_normal_earpiece_loopback_data,
        &aud_I2S1_tx_loopback_data,
#if defined (STEON2_PROJECT)
        NULL, /* &aud_media_to_downlink_mute_data, */ /* not available on Steon2 (gain cell used by I2S2 Rx resource mute) */
#else
        &aud_media_to_downlink_mute_data,
#endif /* STEON2_PROJECT */
        &aud_sidetone_loopback_data,
        &aud_I2S2_external_data, /* 25 */
        NULL, /* aud_tmp_downlink_path */
        &aud_downlink_source_default_data
    }
};
/*******************************************************************************
*
*                               Available resources
*
*******************************************************************************/
const aud_hw_parms_type aud_hw_parms =
{
    AUD_HW_AVAILABLE_SPEECH |
    AUD_HW_AVAILABLE_TONE_GENERATOR |
    AUD_HW_AVAILABLE_FM_RADIO |
    AUD_HW_AVAILABLE_RECORDING_VM |
    AUD_HW_AVAILABLE_PLAYBACK_VM |
#if defined (aud_old_I2S_interface)
    AUD_HW_AVAILABLE_I2S_PCM |
#endif /* aud_old_I2S_interface */
    AUD_HW_AVAILABLE_INTERNAL_MIDI |
    AUD_HW_AVAILABLE_TTY |
    AUD_HW_AVAILABLE_PLAYBACK_PCM |
    AUD_HW_AVAILABLE_RECORD_PCM |
    AUD_HW_AVAILABLE_INBAND |
    AUD_HW_AVAILABLE_SBC_ENCODER |
    AUD_HW_AVAILABLE_I2S2_RX |
    AUD_HW_AVAILABLE_I2S2_TX
};

/*******************************************************************************
*
*                            Constant gain values
*
*******************************************************************************/
const aud_constant_gain_values_type aud_constant_gain_values =
{
    0x7FFF, /* alpha0 */
    0x7FFF, /* alpha1 */
    0x7FFF, /* beta0 */
    0x7FFF, /* gamma1 */
    0x7FFF, /* delta0 */
    0x7FFF, /* delta1 */
    0x7FFF, /* lambda1 */
    0x7FFF, /* speech_mix_ul */
    0x7FFF, /* speech_mix_dl */
    0x7FFF, /* ton_mix_ul */
    0x7FFF, /* ton_mix_dl */
    0x3FFF  /* mix_pcmrec */
};

#if defined (INTERNAL_POLYRINGER)
/* select sample rate for instrument - 16/32kHz. */
const U16 aud_int_poly_instrument_sample_rate = MIDI_USE_32kHz_INSTRUMENTS;
#endif

/*******************************************************************************
*
*                              I2S configuration
*
*******************************************************************************/
/* Structure containing the I2S1 configuration for all modes */
aud_i2s1_configuration_type aud_i2s1_configuration[] =
{
    /* aud_I2Sx_mode1 */
    {
        aud_I2Sx_mode1,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 |
        AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK1SEL_Fractional_devider_0, /* csel */
        0x0cb2, /* den0 */
        0x0cb2, /* den1 */
        0x0011 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
        0x0011 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
        AUD_I2S_CONF_RX_CLK1_OUT_IS_LOW | AUD_I2S_CONF_RX_CLK1_CONT_STOPS | AUD_I2S_CONF_RX_WA1_LEN_1_CYCLE, /* rxconf */
        AUD_I2S_CONF_TX_CLK0_OUT_IS_LOW | AUD_I2S_CONF_TX_CLK0_CONT_STOPS | AUD_I2S_CONF_TX_WA0_LEN_1_CYCLE, /* txconf */
        AUD_I2S_HW_MODE_BURST,
        AUD_I2S_CHANNEL_MODE_MONO
    },
#if 0//old  //edit by xuxinqiang
    /* aud_I2Sx_mode2 */
    {
        aud_I2Sx_mode2,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK0SEL_external |
        AUD_I2S_CSEL_RXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK1SEL_external, /* csel */
        0x0002, /* den0 */
        0x0002, /* den1 */
        0x0001, /* num0 */
        0x0001, /* num1 */
        AUD_I2S_CONF_RX_CLK1_OUT_IS_LOW | AUD_I2S_CONF_RX_CLK1_CONT_STOPS | AUD_I2S_CONF_RX_WA1_LEN_1_CYCLE, /* rxconf */
        AUD_I2S_CONF_TX_CLK0_OUT_IS_LOW | AUD_I2S_CONF_TX_CLK0_CONT_STOPS | AUD_I2S_CONF_TX_WA0_LEN_1_CYCLE, /* txconf */
        AUD_I2S_HW_MODE_BURST,
        AUD_I2S_CHANNEL_MODE_MONO
    },
#else
    /* aud_I2Sx_mode2 */
    {
        aud_I2Sx_mode2,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK0SEL_external |
        AUD_I2S_CSEL_RXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK1SEL_external, /* csel */
        0x0659, /* den0 */
        0x0659, /* den1 */
        0x0010 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
        0x0010 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
        AUD_I2S_CONF_RX_CLK1_OUT_IS_LOW | AUD_I2S_CONF_RX_CLK1_CONT_STOPS | AUD_I2S_CONF_RX_WA1_LEN_1_CYCLE, /* rxconf */
        AUD_I2S_CONF_TX_CLK0_OUT_IS_LOW | AUD_I2S_CONF_TX_CLK0_CONT_STOPS | AUD_I2S_CONF_TX_WA0_LEN_1_CYCLE, /* txconf */
        AUD_I2S_HW_MODE_BURST,
        AUD_I2S_CHANNEL_MODE_MONO
    },
#endif
    /* aud_I2Sx_mode25 */
    {
        aud_I2Sx_mode25,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 |
        AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK1SEL_Fractional_devider_1, /* csel */
        0x0659, /* den0 */
        0x0659, /* den1 */
        0x1010 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
        0x1010 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
        AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_POL_WA_HIGH_IS_LEFT, /* rxconf */
        AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_POL_WA_HIGH_IS_LEFT | AUD_I2S_CONF_EDGE_RISING | AUD_I2S_TRANSFER_MODE_LEFT, /* txconf */
        AUD_I2S_HW_MODE_NORMAL,
        AUD_I2S_CHANNEL_MODE_DUALMONOL
    }
};

/* Structure containing the I2S2 configuration for all modes */
const U16 aud_number_of_i2s1_modes = (sizeof(aud_i2s1_configuration)/sizeof(aud_i2s1_configuration[0]));


/*[Begin] [lvwenhua-2010/11/5]*/
/* Structure containing the I2S1 configuration for all modes */
aud_afei2s_configuration_type aud_afei2s_configuration[] =
{
    /* aud_I2Sx_mode1 */
    {
        aud_I2Sx_mode1,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 |
        AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK1SEL_Fractional_devider_0, /* csel */
        0x0cb2, /* den0 */
        0x0cb2, /* den1 */
        0x0011 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
        0x0011 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
        AUD_I2S_CONF_RX_CLK1_OUT_IS_LOW | AUD_I2S_CONF_RX_CLK1_CONT_STOPS | AUD_I2S_CONF_RX_WA1_LEN_1_CYCLE, /* rxconf */
        AUD_I2S_CONF_TX_CLK0_OUT_IS_LOW | AUD_I2S_CONF_TX_CLK0_CONT_STOPS | AUD_I2S_CONF_TX_WA0_LEN_1_CYCLE, /* txconf */
        AUD_I2S_HW_MODE_BURST,
        AUD_I2S_CHANNEL_MODE_MONO,
        aud_I2S_samplerate_08000
    },
    /* aud_I2Sx_mode2 */
    {
        aud_I2Sx_mode2,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK0SEL_external |
        AUD_I2S_CSEL_RXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK1SEL_external, /* csel */
        0x0002, /* den0 */
        0x0002, /* den1 */
        0x0001, /* num0 */
        0x0001, /* num1 */
        AUD_I2S_CONF_RX_CLK1_OUT_IS_LOW | AUD_I2S_CONF_RX_CLK1_CONT_STOPS |
        AUD_I2S_CONF_RX_WA1_LEN_1_CYCLE, /* rxconf */
        AUD_I2S_CONF_TX_CLK0_OUT_IS_LOW | AUD_I2S_CONF_TX_CLK0_CONT_STOPS | AUD_I2S_CONF_TX_WA0_LEN_1_CYCLE, /* txconf */
        AUD_I2S_HW_MODE_BURST,
        AUD_I2S_CHANNEL_MODE_MONO,
        aud_I2S_samplerate_08000
    },
#if 1
    /* aud_I2Sx_mode3 16 bit 8 kHz Master, Normal Mode, Mono */
    {
        aud_I2Sx_mode3,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 |
        AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK1SEL_Fractional_devider_1, /* csel */
        0x0659, /* den0 */
        0x0659, /* den1 */
        0x0010 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
        0x0010 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
        AUD_I2S_CONF_EDGE_RISING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT, /* rxconf */
        AUD_I2S_CONF_EDGE_FALLING | AUD_I2S_CONF_DEL_1_bit_DELAY| AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT
        | AUD_I2S_TRANSFER_MODE_RIGHT | AUD_I2S_CONF_TX_MUTE_L_MUTED | AUD_I2S_CONF_TX_MUTE_R_ACTIVE,/* txconf */
        AUD_I2S_HW_MODE_NORMAL,
        AUD_I2S_CHANNEL_MODE_DUALMONOR,
        aud_I2S_samplerate_08000
    },
#else
    /* aud_I2Sx_mode3 32 bit 8 kHz Master, Normal Mode, Mono */
    {
        aud_I2Sx_mode3, 		/* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 |
        AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK1SEL_Fractional_devider_1, /* csel */
        0x0659, /* den0 */
        0x0659, /* den1 */
        0x0020 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
        0x0020 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
        AUD_I2S_CONF_EDGE_RISING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_64 | AUD_I2S_CONF_WIDTH_32 | AUD_I2S_CONF_ALIGN_LEFT, /* rxconf */
        AUD_I2S_CONF_EDGE_FALLING | AUD_I2S_CONF_DEL_1_bit_DELAY| AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_64 | AUD_I2S_CONF_WIDTH_32 | AUD_I2S_CONF_ALIGN_LEFT
        | AUD_I2S_TRANSFER_MODE_RIGHT | AUD_I2S_CONF_TX_MUTE_L_MUTED | AUD_I2S_CONF_TX_MUTE_R_ACTIVE,/* txconf */
        AUD_I2S_HW_MODE_NORMAL,
        AUD_I2S_CHANNEL_MODE_DUALMONOR,
        aud_I2S_samplerate_08000
    },
#endif
#if 0//edit by xuxinqiang
    /* aud_I2Sx_mode4 16 bit 8 kHz Slave, Normal Mode, Mono */
    {
        aud_I2Sx_mode4,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK0SEL_external |
        AUD_I2S_CSEL_RXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK1SEL_external, /* csel */
        0x0002, /* den0 */
        0x0002, /* den1 */
        0x0001, /* num0 */
        0x0001, /* num1 */
        AUD_I2S_CONF_EDGE_RISING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT, /* rxconf */
        AUD_I2S_CONF_EDGE_FALLING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT
        | AUD_I2S_TRANSFER_MODE_RIGHT | AUD_I2S_CONF_TX_MUTE_L_MUTED | AUD_I2S_CONF_TX_MUTE_R_ACTIVE,/* txconf */
        AUD_I2S_HW_MODE_NORMAL,
        AUD_I2S_CHANNEL_MODE_DUALMONOR,
        aud_I2S_samplerate_08000
    },
#else
#if 0
    /* aud_I2Sx_mode4 16 bit 8 kHz Slave, Normal Mode, Mono */
    {
        aud_I2Sx_mode4,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK0SEL_external |
        AUD_I2S_CSEL_RXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK1SEL_external, /* csel */
        0x0659, /* den0 */
        0x0659, /* den1 */
        0x0018 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
        0x0018 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
        AUD_I2S_CONF_EDGE_RISING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT, /* rxconf */
        AUD_I2S_CONF_EDGE_FALLING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT
        | AUD_I2S_TRANSFER_MODE_RIGHT | AUD_I2S_CONF_TX_MUTE_L_MUTED | AUD_I2S_CONF_TX_MUTE_R_ACTIVE,/* txconf */
        AUD_I2S_HW_MODE_NORMAL,
        AUD_I2S_CHANNEL_MODE_DUALMONOR,
        aud_I2S_samplerate_08000
    },
#else
 
    /* aud_I2Sx_mode4 16 bit 8 kHz Slave, Normal Mode, Mono*/
    {
        aud_I2Sx_mode4,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK0SEL_external |
        AUD_I2S_CSEL_RXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK1SEL_external, /* csel */
        0x0002, /* den0 */
        0x0002, /* den1 */
        0x0001, /* num0 */
        0x0001, /* num1 */
        AUD_I2S_CONF_EDGE_RISING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_64 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT, /* rxconf */
        AUD_I2S_CONF_EDGE_FALLING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_64 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT
        | AUD_I2S_TRANSFER_MODE_RIGHT | AUD_I2S_CONF_TX_MUTE_L_MUTED | AUD_I2S_CONF_TX_MUTE_R_ACTIVE,/* txconf */
        AUD_I2S_HW_MODE_NORMAL,
        AUD_I2S_CHANNEL_MODE_DUALMONOR,
        aud_I2S_samplerate_08000
    },
#endif

#endif
    /* aud_I2Sx_mode13 16 bit 48 kHz Master, Normal Mode, Mono */
    {
        aud_I2Sx_mode13,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 |
        AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK1SEL_Fractional_devider_1, /* csel */
        0x0659, /* den0 */
        0x0659, /* den1 */
        0x0060 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
        0x0060 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
        AUD_I2S_CONF_EDGE_FALLING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_RIGHT, /* rxconf */
        AUD_I2S_CONF_EDGE_RISING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_RIGHT
        | AUD_I2S_TRANSFER_MODE_STEREO | AUD_I2S_CONF_TX_MUTE_L_ACTIVE | AUD_I2S_CONF_TX_MUTE_R_ACTIVE,/* txconf */
        AUD_I2S_HW_MODE_NORMAL,
        AUD_I2S_CHANNEL_MODE_MONO,
        aud_I2S_samplerate_48000
    },
    /* aud_I2Sx_mode14 16 bit 48 kHz Master, Normal Mode, Stereo */
    {
        aud_I2Sx_mode14,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 |
        AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK1SEL_Fractional_devider_1, /* csel */
        0x0659, /* den0 */
        0x0659, /* den1 */
        0x0060 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
        0x0060 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
        AUD_I2S_CONF_EDGE_FALLING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_RIGHT, /* rxconf */
        AUD_I2S_CONF_EDGE_RISING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
        | AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_RIGHT
        | AUD_I2S_TRANSFER_MODE_STEREO | AUD_I2S_CONF_TX_MUTE_L_ACTIVE | AUD_I2S_CONF_TX_MUTE_R_ACTIVE,/* txconf */
        AUD_I2S_HW_MODE_NORMAL,
        AUD_I2S_CHANNEL_MODE_MONO,
        aud_I2S_samplerate_48000
    },
    /* aud_I2Sx_mode25 */
    {
        aud_I2Sx_mode25,         /* mode allowed or not on platform */
        AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 |
        AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK1SEL_Fractional_devider_1, /* csel */
        0x0659, /* den0 */
        0x0659, /* den1 */
        0x1010 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
        0x1010 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
        AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_POL_WA_HIGH_IS_LEFT, /* rxconf */
        AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_POL_WA_HIGH_IS_LEFT | AUD_I2S_CONF_EDGE_RISING | AUD_I2S_TRANSFER_MODE_LEFT, /* txconf */
        AUD_I2S_HW_MODE_NORMAL,
        AUD_I2S_CHANNEL_MODE_DUALMONOL,
        aud_I2S_samplerate_08000
    }
};

const U16 aud_number_of_afei2s_modes = (sizeof(aud_afei2s_configuration)/sizeof(aud_afei2s_configuration[0]));
/*[End] [lvwenhua-2010/11/5]*/



#ifdef _USE_CUT_TEAKLIT_CODE
/* Structure containing the I2S2 configuration for all modes */
const BOOL aud_i2s_validation_matrix[aud_I2S_entry_point_end][aud_I2S_Master_Slave_end][aud_I2S_mode_end][aud_I2S_transmission_mode_end][aud_I2S_samplerate_end] =
    /*    08000,11025,12000,16000,22050,24000,32000,44100,48000*/
{
    {
        {
            {   { TRUE,FALSE,FALSE, TRUE,FALSE,FALSE,FALSE,FALSE,FALSE}
                , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_mono     , aud_I2S_master, aud_I2S_entry_point_MMS     */
                { TRUE,FALSE,FALSE, TRUE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }
            , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_mono     , aud_I2S_master, aud_I2S_entry_point_MMS     */
            {   { TRUE,FALSE,FALSE, TRUE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_dual_mono, aud_I2S_master, aud_I2S_entry_point_MMS     */
                { TRUE,FALSE,FALSE, TRUE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_dual_mono, aud_I2S_master, aud_I2S_entry_point_MMS     */
            {   {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_stereo   , aud_I2S_master, aud_I2S_entry_point_MMS     */
                {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }
        }
        , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_stereo   , aud_I2S_master, aud_I2S_entry_point_MMS     */
        {   {   {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_mono     , aud_I2S_slave , aud_I2S_entry_point_MMS     */
                {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_mono     , aud_I2S_slave , aud_I2S_entry_point_MMS     */
            {   {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_dual_mono, aud_I2S_slave , aud_I2S_entry_point_MMS     */
                {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_dual_mono, aud_I2S_slave , aud_I2S_entry_point_MMS     */
            {   {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_stereo   , aud_I2S_slave , aud_I2S_entry_point_MMS     */
                {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }
        }
    }
    , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_stereo   , aud_I2S_slave , aud_I2S_entry_point_MMS     */
    {   {   {   { TRUE,FALSE,FALSE, TRUE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_mono     , aud_I2S_master, aud_I2S_entry_point_MMS_FB     */
                { TRUE,FALSE,FALSE, TRUE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_mono     , aud_I2S_master, aud_I2S_entry_point_MMS_FB     */
            {   { TRUE,FALSE,FALSE, TRUE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_dual_mono, aud_I2S_master, aud_I2S_entry_point_MMS_FB     */
                { TRUE,FALSE,FALSE, TRUE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_dual_mono, aud_I2S_master, aud_I2S_entry_point_MMS_FB     */
            {   {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_stereo   , aud_I2S_master, aud_I2S_entry_point_MMS_FB     */
                {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }
        }  , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_stereo   , aud_I2S_master, aud_I2S_entry_point_MMS_FB     */
        {   {   {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_mono     , aud_I2S_slave , aud_I2S_entry_point_MMS_FB     */
                {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_mono     , aud_I2S_slave , aud_I2S_entry_point_MMS_FB     */
            {   {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_dual_mono, aud_I2S_slave , aud_I2S_entry_point_MMS_FB     */
                {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_dual_mono, aud_I2S_slave , aud_I2S_entry_point_MMS_FB     */
            {   {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_stereo   , aud_I2S_slave , aud_I2S_entry_point_MMS_FB     */
                {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }
        }
    } , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_stereo   , aud_I2S_slave , aud_I2S_entry_point_MMS_FB     */
    {   {   {   { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_mono     , aud_I2S_master, aud_I2S_entry_point_External*/
                { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_mono     , aud_I2S_master, aud_I2S_entry_point_External*/
            {   {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_dual_mono, aud_I2S_master, aud_I2S_entry_point_External*/
                {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_dual_mono, aud_I2S_master, aud_I2S_entry_point_External*/
            {   { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_stereo   , aud_I2S_master, aud_I2S_entry_point_External*/
                { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}
            }
        }  , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_stereo   , aud_I2S_master, aud_I2S_entry_point_External*/
        {   {   { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_mono     , aud_I2S_slave , aud_I2S_entry_point_External*/
                { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_mono     , aud_I2S_slave , aud_I2S_entry_point_External*/
            {   {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_dual_mono, aud_I2S_slave , aud_I2S_entry_point_External*/
                {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_dual_mono, aud_I2S_slave , aud_I2S_entry_point_External*/
            {   { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_stereo   , aud_I2S_slave , aud_I2S_entry_point_External*/
                { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}
            }
        }
    } , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_stereo   , aud_I2S_slave , aud_I2S_entry_point_External*/
    {   {   {   { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_mono     , aud_I2S_master, aud_I2S_entry_point_DAI     */
                { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_mono     , aud_I2S_master, aud_I2S_entry_point_DAI     */
            {   { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_dual_mono, aud_I2S_master, aud_I2S_entry_point_DAI     */
                { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_dual_mono, aud_I2S_master, aud_I2S_entry_point_DAI     */
            {   { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_stereo   , aud_I2S_master, aud_I2S_entry_point_DAI     */
                { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}
            }
        }  , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_stereo   , aud_I2S_master, aud_I2S_entry_point_DAI     */
        {   {   { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_mono     , aud_I2S_slave , aud_I2S_entry_point_DAI     */
                { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_mono     , aud_I2S_slave , aud_I2S_entry_point_DAI     */
            {   { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_dual_mono, aud_I2S_slave , aud_I2S_entry_point_DAI     */
                { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}
            }   , /*aud_I2S_transmission_mode_normal, aud_I2S_mode_dual_mono, aud_I2S_slave , aud_I2S_entry_point_DAI     */
            {   { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}    , /*aud_I2S_transmission_mode_PCM   , aud_I2S_mode_stereo   , aud_I2S_slave , aud_I2S_entry_point_DAI     */
                { TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE}
            }
        }
    }
}
; /*aud_I2S_transmission_mode_normal, aud_I2S_mode_stereo   , aud_I2S_slave , aud_I2S_entry_point_DAI     */

const aud_I2S2_default_settings_type aud_I2S2_default_settings[aud_I2S_setting_end] =
{
    /*Normal settings*/
    {   /*avaliable*/  TRUE,
        /*RXCONF   */  AUD_I2S_CONF_EDGE_RISING |AUD_I2S_CONF_DEL_1_bit_DELAY|AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT|
        AUD_I2S_CONF_ALIGN_LEFT|AUD_I2S_CONF_RX_CLK1_OUT_IS_LOW|AUD_I2S_CONF_RX_CLK1_CONT_STOPS|
        AUD_I2S_CONF_RX_WA1_LEN_1_CYCLE,
        /*TXCONF   */  AUD_I2S_CONF_EDGE_FALLING|AUD_I2S_CONF_DEL_1_bit_DELAY|AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT|
        AUD_I2S_CONF_ALIGN_LEFT|AUD_I2S_CONF_TX_MUTE_L_ACTIVE|AUD_I2S_CONF_TX_MUTE_R_ACTIVE|
        AUD_I2S_CONF_TX_CLK0_OUT_IS_LOW|AUD_I2S_CONF_TX_CLK0_CONT_STOPS|AUD_I2S_CONF_TX_WA0_LEN_1_CYCLE,
        /*FREF_clk0*/  AUD_I2S_NUM_FREF_104MHz,
        /*FREF_clk1*/  AUD_I2S_NUM_FREF_104MHz
    },
    /*Special case 1*/
    {   /*avaliable*/  FALSE,
        /*RXCONF   */  0,//xiu 
        /*TXCONF   */  0,
        /*FREF_clk0*/  0,
        /*FREF_clk1*/  0
    },
    /*Special case 2*/
    {   /*avaliable*/  FALSE,
        /*RXCONF   */  0,
        /*TXCONF   */  0,
        /*FREF_clk0*/  0,
        /*FREF_clk1*/  0//xiu 
    }
};
#endif
#if 1 /* Made power optimal for SGold3 globe board */
#ifdef _USE_CUT_TEAKLIT_CODE
S32 const AUD_PAD_I2S2_RX_OFF   = PCL_ENABLE | PCL_PD | PCL_GPIO | PCL_GPIO_IN;
S32 const AUD_PAD_I2S2_TX_OFF   = PCL_ENABLE | PCL_PD | PCL_GPIO | PCL_GPIO_IN;
S32 const AUD_PAD_I2S2_CLK0_OFF = PCL_ENABLE | PCL_PD | PCL_GPIO | PCL_GPIO_IN;
S32 const AUD_PAD_I2S2_CLK1_OFF = PCL_ENABLE | PCL_PD | PCL_GPIO | PCL_GPIO_IN;
S32 const AUD_PAD_I2S2_WA0_OFF  = PCL_ENABLE | PCL_PD | PCL_GPIO | PCL_GPIO_IN;
S32 const AUD_PAD_I2S2_WA1_OFF  = PCL_ENABLE | PCL_PD | PCL_GPIO | PCL_GPIO_IN;
#endif
#else /* All pins tristated when not used */
S32 const AUD_PAD_I2S2_RX_OFF   = PCL_TRISTATE;
S32 const AUD_PAD_I2S2_TX_OFF   = PCL_TRISTATE;
S32 const AUD_PAD_I2S2_CLK0_OFF = PCL_TRISTATE;
S32 const AUD_PAD_I2S2_CLK1_OFF = PCL_TRISTATE;
S32 const AUD_PAD_I2S2_WA0_OFF  = PCL_TRISTATE;
S32 const AUD_PAD_I2S2_WA1_OFF  = PCL_TRISTATE;
#endif

#if 1 /* Made power potimal for SGold3 globe board */
#ifdef _USE_CUT_TEAKLIT_CODE
S32 const AUD_PAD_I2S1_CLK0_OFF = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_GPIO  | PCL_GPIO_OUT | PCL_GPIO_D0;
S32 const AUD_PAD_I2S1_RX_OFF   = PCL_TRISTATE;
S32 const AUD_PAD_I2S1_TX_OFF   = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_GPIO  | PCL_GPIO_OUT | PCL_GPIO_D0;
S32 const AUD_PAD_I2S1_WA0_OFF  = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_GPIO  | PCL_GPIO_OUT | PCL_GPIO_D0;
S32 const AUD_PAD_I2S1_CLK1_OFF = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_GPIO  | PCL_GPIO_OUT | PCL_GPIO_D0;
S32 const AUD_PAD_I2S1_WA1_OFF  = PCL_ENABLE | PCL_NO_PUPD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1)    | PCL_OS(0);
#endif
#else /* All pins tristated when not used */
#define const AUD_PAD_I2S1_CLK0_OFF = PCL_TRISTATE;
#define const AUD_PAD_I2S1_RX_OFF   = PCL_TRISTATE;
#define const AUD_PAD_I2S1_TX_OFF   = PCL_TRISTATE;
#define const AUD_PAD_I2S1_WA0_OFF  = PCL_TRISTATE;
#define const AUD_PAD_I2S1_CLK1_OFF = PCL_TRISTATE;
#define const AUD_PAD_I2S1_WA1_OFF  = PCL_TRISTATE;
#endif

#if defined (aud_old_I2S_interface)
#ifdef _USE_CUT_TEAKLIT_CODE
const aud_i2s2_temp_configuration_type aud_i2s2_temp_configuration [] =
{
    {
        aud_I2Sx_mode3,
        aud_I2S_master,
        aud_I2S_samplerate_08000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_dual_mono,
        aud_I2S_entry_point_MMS,
        aud_I2S2_clk0
    }
    ,{
        aud_I2Sx_mode4,
        aud_I2S_slave,
        aud_I2S_samplerate_08000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_dual_mono,
        aud_I2S_entry_point_MMS,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode5,
        aud_I2S_master,
        aud_I2S_samplerate_16000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_dual_mono,
        aud_I2S_entry_point_MMS,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode6,
        aud_I2S_slave,
        aud_I2S_samplerate_16000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_dual_mono,
        aud_I2S_entry_point_MMS,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode7,
        aud_I2S_master,
        aud_I2S_samplerate_32000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_mono,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode8,
        aud_I2S_master,
        aud_I2S_samplerate_32000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode9,
        aud_I2S_slave,
        aud_I2S_samplerate_32000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_mono,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode10,
        aud_I2S_master,
        aud_I2S_samplerate_44100,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_mono,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode11,
        aud_I2S_master,
        aud_I2S_samplerate_44100,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode12,
        aud_I2S_slave,
        aud_I2S_samplerate_44100,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_mono,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode13,
        aud_I2S_master,
        aud_I2S_samplerate_48000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_mono,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode14,
        aud_I2S_master,
        aud_I2S_samplerate_48000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode15,
        aud_I2S_slave,
        aud_I2S_samplerate_48000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_mono,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2S2_mode_dai, /*These settings needs update*/
        aud_I2S_master,
        aud_I2S_samplerate_16000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_mono,
        aud_I2S_entry_point_DAI,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode16,
        aud_I2S_master,
        aud_I2S_samplerate_08000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode17,
        aud_I2S_master,
        aud_I2S_samplerate_11025,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode18,
        aud_I2S_master,
        aud_I2S_samplerate_12000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode19,
        aud_I2S_master,
        aud_I2S_samplerate_16000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode20,
        aud_I2S_master,
        aud_I2S_samplerate_22050,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode21,
        aud_I2S_master,
        aud_I2S_samplerate_24000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode22,
        aud_I2S_master,
        aud_I2S_samplerate_32000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode23,
        aud_I2S_master,
        aud_I2S_samplerate_44100,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    },{
        aud_I2Sx_mode24,
        aud_I2S_master,
        aud_I2S_samplerate_48000,
        aud_I2S_sample_width_16,
        aud_I2S_transmission_mode_normal,
        aud_I2S_setting_normal,
        aud_I2S_mode_stereo,
        aud_I2S_entry_point_External,
        aud_I2S2_clk0
    }
};

const U16 aud_number_of_temp_i2s2_modes = (sizeof(aud_i2s2_temp_configuration)/sizeof(aud_i2s2_temp_configuration[0]));
#endif
#endif /* aud_old_I2S_interface */


//add by xuxinqiang 20160408
SINT32 zDrvAud_DspSetAudSetting( BOOL useAfeI2s)
{

    SINT32  ret = DRV_SUCCESS;
    if (useAfeI2s == TRUE)
    {
       aud_setting = aud_setting_afei2s;
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAud_DspSetAudSetting select aud_setting_afei2s.\n");
	   
	}
	else
	{
       aud_setting = aud_setting_i2s1;
       zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAud_DspSetAudSetting select aud_setting_i2s1.\n");
	   
	}
    



    return ret;
}





/*[Begin] no use[lvwenhua-2012/4/11]*/
#if 0
/*******************************************************************************
*
*                              Action functions
*
*******************************************************************************/
/* define that maps action definitions (aud_action_defs.h) into functions that are implemented below */
#define AUD_DECLARE_ACTION_FUNC(_actionid) static void _actionid##_FUNC(U32 ACTION_PARAM)

/*------------------------------------------------------------------------------
* Function...: AUD_AFE_DSP_FUNC
* Return.....: - (static void)
* Parameters.: U32 ACTION_PARAM
* Description: Action function used by path control system.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
AUD_DECLARE_ACTION_FUNC(AUD_AFE_DSP)
{
    /* declared as dummy - the path control system calls aud_path_afe_dsp_programming when this action is reached */
}

/*------------------------------------------------------------------------------
* Function...: AUD_HEADSET_AMP_FUNC
* Return.....: - (static void)
* Parameters.: U32 ACTION_PARAM
* Description: Action function (power-up/down) for the headset amplifier.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
AUD_DECLARE_ACTION_FUNC(AUD_HEADSET_AMP)
{
    /* not implemented - depends on actual hardware */
}

/*------------------------------------------------------------------------------
* Function...: AUD_SM_AMP_FUNC
* Return.....: - (static void)
* Parameters.: U32 ACTION_PARAM: 0=power-down, 1=power-up
* Description: Action function (power-up/down) for the SM Power amplifier.
* Modified...: 27.09.2007 by KBJ (support for path dependant gain)
------------------------------------------------------------------------------*/
AUD_DECLARE_ACTION_FUNC(AUD_SM_AMP)
{
    if (ACTION_PARAM)
    {
        PMU_set_mono_amp_anti_pop(PMU_APP_ON);
        PMU_set_mono_amp_fast_start(PMU_APP_OFF);
        PMU_set_mono_amp_tristate(PMU_APP_OFF); /* Enable amplifier */
        PMU_set_amp_gain((PMU_AUD_AMP_GAIN_T)aud_path_settings_result.downlink_parms.sm_pwer_gain);
        PMU_set_amp_cmv(PMU_AUD_CMV_1V6);
    }
    else
    {
        PMU_set_mono_amp_anti_pop(PMU_APP_ON);
        PMU_set_mono_amp_fast_start(PMU_APP_OFF);
        PMU_set_mono_amp_tristate(PMU_APP_ON); /* Disable amplifier */
        PMU_set_amp_gain(PMU_AUD_GAIN_0dB);
        PMU_set_amp_cmv(PMU_AUD_CMV_1V6);
    }
}

/*------------------------------------------------------------------------------
* Function...: AUD_EXT_RINGER_AMP_FUNC
* Return.....: - (static void)
* Parameters.: U32 ACTION_PARAM: 0=disable, 1=enable
* Description: Action function (power-up/down) for the external ringer amplifier.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
AUD_DECLARE_ACTION_FUNC(AUD_EXT_RINGER_AMP)
{
#if defined (AUD_EXTERNAL_RINGER)
    if (ACTION_PARAM)
    {
        AudRingerSM(E_amp_enable, NULL);
    }
    else
    {
        AudRingerSM(E_amp_disable, NULL);
    }
#endif /* AUD_EXTERNAL_RINGER */
}

/*------------------------------------------------------------------------------
* Function...: AUD_FM_RADIO_FUNC
* Return.....: - (static void)
* Parameters.: U32 ACTION_PARAM: 0=enable, 1=disable
* Description: Action function (power-up/down) for the FM radio.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
AUD_DECLARE_ACTION_FUNC(AUD_FM_RADIO)
{
#if defined(FM_RADIO_PRESENT)
    if (ACTION_PARAM)
    {
        PCL_96 = 0x0700;
        AUD_control_fm_radio_amp(aud_enable);
    }
    else
    {
        PCL_96 = 0x0500;
        AUD_control_fm_radio_amp(aud_disable);
    }
#endif /* FM_RADIO_PRESENT */
}

/*******************************************************************************
*
*          Backspeaker action function - illustrates slow power-down
*
*******************************************************************************/
/* Variables and helper functions for the AUD_BACKSPKR_AMP action function.   */
/* The functionality is not fully implemented, but is added here to           */
/* illustrate how a slow power-down might be implemented.                     */
#include "drvs_rtt.h"                                                /* includes timer functionality */
static NU_HISR aud_bs_timer_HISR;                               /* OS interrupt */
static rtt_timer_list_type* aud_rtt_timer_handle_bs_timer=NULL; /* real-time timer */

#if defined(__ARMCC_VERSION) /*rvct*/
__align(8) static CHAR aud_bs_timer_stack[((400)+7)&0xFFFFFFF8];/* stack for data for the timer */
#elif defined(__GNUC__) /* gcc */
__attribute__((aligned(8))) static CHAR aud_bs_timer_stack[((400)+7)&0xFFFFFFF8];/* stack for data for the timer */
#else
#error This file must be compiled in arm mode, either gcc or arm-rvct !!
#endif
/* The function that is called when the timer interrupt occurs. */
static void aud_bs_timer_LISR(void *p)
{
    NU_Activate_HISR(&aud_bs_timer_HISR); /* send a mail to activate the HISR level function */
}

/* This function is indirectly called by the aud_bs_timer_LISR function. */
/* The implementation should either send a mail which results in aud_bs_true_power_down to be called */
/* or call aud_actions[BACKSPKR_AMP_BN].action(0xfe); directly. */
static void aud_bs_timer_HISR_func(void)
{
    /* call the action function in one way or the other */
}

/* Calls the action function for powering down. */
/* Called from timer interrupt or through a dispatcher in case of event. */
void aud_bs_true_power_down(void)
{
    aud_actions[AUD_BACKSPKR_AMP_BN].action(0xfe);
}

/*------------------------------------------------------------------------------
* Function...: AUD_BACKSPKR_AMP_FUNC
* Return.....: - (static void)
* Parameters.: U32 ACTION_PARAM: 0xfe=function called by timer,
*              0=start power-down, 1=power-up
* Description: Action function (power-up/down) for the backspeaker amplifier.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
AUD_DECLARE_ACTION_FUNC(AUD_BACKSPKR_AMP)
{   /* This one is used for delayed power-down */
    static BOOL Power_down_on_going=FALSE;

    if (0xfe == ACTION_PARAM) /* This is only called by timer */
    {
        if (Power_down_on_going)
        {
            /* Stop the backspeaker by calling power-down sequence (or call the module responsible for the hw) */
            Power_down_on_going = FALSE;
        }
        return;
    }

    if (Power_down_on_going)
    {
        if (ACTION_PARAM)
        {
            Power_down_on_going = FALSE; /* We are going up again */
            RTT_stop_timer(aud_rtt_timer_handle_bs_timer); /* So disable timer */
        } /* else we are already going down, so actually called by mistake  */
        return;
    }

    if (ACTION_PARAM)
    {
        /* Start the backspeaker by calling power-up sequence (or call the module responsible for the hw) */
    }
    else
    {
        if (NULL == aud_rtt_timer_handle_bs_timer)
        {
            aud_rtt_timer_handle_bs_timer = RTT_create_timer(aud_bs_timer_LISR, 0, rtt_common, rtt_repetitive);
            NU_Create_HISR(&aud_bs_timer_HISR, "AUD_BS_TIM", aud_bs_timer_HISR_func, 2, aud_bs_timer_stack, 400);
        }
        if (RTT_start_timer(aud_rtt_timer_handle_bs_timer, 10*1000000/*10 secs*/)) /* Start timer (wait for real power-down) */
        {
            Power_down_on_going = TRUE;
        }
    }
}

/*******************************************************************************
*
*                           Actions and exceptions
*
*******************************************************************************/
#if defined (AUD_DEF_ACTION)
#undef AUD_DEF_ACTION
#endif
/* the action function associated with each action definition */
#define AUD_DEF_ACTION(_actionid) { _actionid, _actionid##_FUNC },
const aud_action_definition_type aud_actions[] =
{
#include "aud_action_defs.h"
};

/* which actions to be taken in one particular (exceptional) state transition */
const aud_exception_action_table_type aud_exception1[] =
{
    { /* param */ 0,/* action */ AUD_BACKSPKR_AMP_BN}
    , /* Power off backspeaker */
    { /* param */ 1,/* action */ AUD_FM_RADIO_BN},     /* Power on FM radio */
    { /* param */ 0,/* action */ AUD_AFE_DSP_BN},      /* Program DSP/AFE. Param DC */
    { /* param */ 1,/* action */ AUD_BACKSPKR_AMP_BN}, /* Power back on the backspeaker */
    { 0xffffffff, AUD_LAST_ACTION_BN} /* <-- Table terminator!! */
};

/* state transitions that should be handled differently compared to the order defined in aud_action_defs.h */
const aud_exception_type aud_exception_table[] =
{
    {
        /* current_state */   AUD_BACKSPKR_AMP,
        /* new_state     */   AUD_BACKSPKR_AMP | AUD_FM_RADIO,
        /* p_table       */   aud_exception1
    },
    { 0,0,(void *)0} /* <-- Table terminator!! */
};
#endif
/*[End] [lvwenhua-2012/4/11]*/
