/**************************************************************************
*
*             Protocol Stack Adapter Layer Telephone Interface
*
*                  Copyright (c) 2011 ZTE Corporation.
*
***************************************************************************
*
*   汾 :   ͨѶɷ޹˾ ֻҵ 
*   ģ   :   PSI
*      :   zpsi_api.h
*   ļʶ :   
*   ļ : 
*   ʵֹ :   PSIϵͳƽ̨Ӧýӿ
*        :   
*        :   
*    :   2011.04.06
*   ˵ :
**************************************************************************/
#ifndef ZPSI_API_H
#define ZPSI_API_H

#define ZATI2_SM_IPV4_PDPADDR_LEN   4
#define ZATI2_SM_IPV6_PDPADDR_LEN   16

#define ZATI2_SM_MAX_PDPADDR_LEN   (ZATI2_SM_IPV4_PDPADDR_LEN + ZATI2_SM_IPV6_PDPADDR_LEN)

/* ṹ嶨 */
typedef struct {
    UINT8                                         iCid;
    UINT8                                         iPdpType;   /*
                                                             * 0x01-PPP
                                                             * 0x21-IPv4
                                                             * 0x57-IPv6
                                                             */
    UINT8                                         iPdpAddr[ZATI2_SM_MAX_PDPADDR_LEN]; /* ȫ0ʾʹöַ̬10.40.63.4ʾΪ
                                                                                          iPdpAddr[0]=10,iPdpAddr[1]=40,iPdpAddr[2]=63,iPdpAddr[3]=4*/
    UINT8                                         iGateWay[ZATI2_SM_MAX_PDPADDR_LEN]; /* ͬ */
    UINT8                                         iPrimaryDns[ZATI2_SM_MAX_PDPADDR_LEN]; /* ͬ */
    UINT8                                         iSecondaryDns[ZATI2_SM_MAX_PDPADDR_LEN];  /* ͬ */
}T_ZAti_SmIpDnsInfo;

typedef enum
{
    ZATI2_CHIND_AT = 0,      /* ָʾǰΪAT*/
    ZATI2_CHIND_PSD,         /* ָʾǰΪPSD*/
    ZATI2_CHIND_PSDV6,       /* ָʾǰΪPSDV6*/
    ZATI2_CHIND_CSD,         /* ָʾǰΪCSD*/
    ZATI2_CHIND_TURN_AT,     /* ָʾǰͨ״̬лΪ̬ЯЧ*/
    ZATI2_CHIND_TURN_PSD,    /* ָʾǰͨ״̬лΪPSDЯЧ*/
    ZATI2_CHIND_TURN_CSD,    /* ָʾǰͨ״̬лΪCSDЯЧ*/
    ZATI2_CHIND_MAX
}
T_zAti2_CtrmChInd;

typedef enum
{
    ZATI2_CHANNEL_SRV_MODE_INVAL = 0,
    ZATI2_CHANNEL_SRV_MODE_CMD,
    ZATI2_CHANNEL_SRV_MODE_DATA
}T_zAti2_ChnlSrvModeType;

typedef SINT32 (*T_ZAti2_AtRecvFunc)(UINT8 channelId, UINT8* pDataPtr, UINT16 iDataLen, T_zAti2_CtrmChInd iFlag);
typedef  BOOL (*OutputIpPacket_CB)(UINT8 chId ,VOID  *packet, SINT32 packetLen, UINT8 flag);
typedef BYTE (*T_zAti_AtChannelFunc)(UINT8 PsId);
#ifdef Z_DUALCARD_DUALSTANDBY
typedef SINT32 (*ZUSAT_SENDATCMDTOACCESSCHANNEL_FUNC)(UINT32 devId, UINT8 *data, UINT16 dataLen);
#else
typedef SINT32 (*ZUSAT_SENDATCMDTOACCESSCHANNEL_FUNC)(UINT8 *data, UINT16 dataLen);
#endif
/**************************************************************************
* ƣ zPsi_RegOutputIpPacketCb
*  
* ˵ 
*   ֵ ɹZATI2_SUCCESS
* ˵ ΰ岻ɱ޸ģ뿽                            
**************************************************************************/ 
SINT32 zPsi_RegOutputIpPacketCb(OutputIpPacket_CB recvFunc);

/**************************************************************************
*  : zAti2_Open
*  : ͨ
* ˵ : (IN)
*            iChnelId     ͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷشͣ
* ˵ : ܽͨ
*            ͬһͨ
**************************************************************************/
SINT32 zAti2_Open(UINT8 iChnelId);

/**************************************************************************
*  : zAti2_Close
*  : رͨ
* ˵ : (IN)
*            iChnelId     ͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷZATI2_FAULSE
* ˵ : ܽͨ
*            ͬһܹͨر
**************************************************************************/
SINT32 zAti2_Close(UINT8 iChnelId);
/**************************************************************************
*  : zAti2_RegRecvCb
*  : עص
* ˵ : (IN)
*            recvFunc     ص
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷشԭ
* ˵ : ṩûӿ
*            ָtypedef SINT32 (*T_ZAti2_RecvCb)(UINT8 channelId,
*            UINT8* pDataPtr, UINT16 iDataLen, UINT8 iFlag);
**************************************************************************/
SINT32 zAti2_RegRecvCb(T_ZAti2_AtRecvFunc recvFunc);
/**************************************************************************
*  : zAti2_AtChannelFunc
*  : עص
* ˵ : (IN)
*            recvFunc     ص
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷشԭ
* ˵ : ṩûӿ
**************************************************************************/
SINT32 zAti2_AtChannelFunc(T_zAti_AtChannelFunc pChannelFunc);

/**************************************************************************
*  : zAti2_SetAlwaysAtReportChannel
*  : ʼϱATͨעصصרͨš
*           רͨЧʱϱǷ/Ӱ죬ڴͨϱ
* ˵ : (IN)
*            pChannelFunc - صصרͨš      
*   ֵ :
* ˵ : ṩοƵĺӿ
**************************************************************************/
SINT32 zAti2_SetAlwaysAtReportChannel(T_zAti_AtChannelFunc pChannelFunc);

/**************************************************************************
*  : zAti2_Send
*  : ͨͨAT
* ˵ : (IN)
*            iChnelId     ص
*            pDataPtr      ָ
*            iDataLen      ݳ
*            iFlag         
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷشԭ
* ˵ : ṩûӿ
**************************************************************************/
SINT32 zAti2_Send(UINT8 iChnelId, UINT8 *pDataPtr, UINT16 iDataLen, T_zAti2_CtrmChInd iFlag);

/**************************************************************************
*  : zAti2_IsAtChReady
*  : ȷָͨ״̬
* ˵ : (IN)
*            chID     ͨID
*            (OUT)
*   ֵ : ͨ÷OK,򷵻FALSE
* ˵ : ṩûӿ
**************************************************************************/
BOOL  zAti2_IsAtChReady(UINT8 chID);

/**************************************************************************
*  : zAt_AutoTestInit
*  : ϵԶ
**************************************************************************/
UINT32 zAt_AutoTestInit(VOID);

/**********************************************************************
*:zAti_SmIpPdpActReq
*:ȡCIDĵַϢ
*˵:
*             iChnelId   ͨID
*             pAddr   (OUT)ַϢ
*********************************************************************/
BOOL zAti_SmIpPdpActReq(UINT8 iChnelId, T_ZAti_SmIpDnsInfo* pAddr);
VOID zUsat_RegisterSendMsgFun(ZUSAT_SENDATCMDTOACCESSCHANNEL_FUNC tmpFun);
void zUsat_SendAtCmd(UINT32 dev_fd, const UINT8 *strAtCmd, UINT16 atCmdLen, UINT32 extData);
extern BYTE zAti_PppGetCid(BYTE  bChnelId);

/**************************************************************************
*  : zAti_GetEMCellInfo
*  : ȡģʽСϢ
* ˵ : pEmInfo: ṹT_zEM_EmInfo_Ind
*            bInstanceIdx: ʵ,0ʾ11ʾ2
*                         汾0˫汾ʵʴд01
*   ֵ : ɹZATI2_SUCCESS (0)
* ˵ : ṩûӿڣʧ˵ʱûлȡ
**************************************************************************/
SINT32 zAti_GetEMCellInfo(UINT8 *pEmInfo, UINT8 bInstanceIdx);
#endif

