/*************************************************************************
*
*                 Media Multimedia File Play Interface
*
*                  Copyright (c) 2008 ZTE Corporation.
*
**************************************************************************
*
*   汾 :   ͨѶɷ޹˾ ֻҵ ƽ̨ܹ
*   ģ   :   
*      :   zmmf_api.h
*   ļʶ :   
*   ļ : 
*   ʵֹ :   ýϵͳṩӿ
*                1.ļšָֹͣͣ
*                2.tonešָֹͣͣ
*                3.ӵ绰
*                4.ý
*                5.¼ʼָֹͣͣ
*                6.¼ʼָֹͣͣ
*                7.
*               
*        :   
*        :   1.0
*    :   2008/03/17
*   ˵ :
*
*   ޸ļ¼ :
*        :
*     ޸ĺ :
*     ޸ :         
*        :
*
***************************************************************************
*
*   ļ
*   ----------------
*   
*
**************************************************************************/
#ifndef _ZMMF_API_H_
#define _ZMMF_API_H_

#ifdef __cplusplus
   extern "C"
   {
#endif  
/**************************************************************************
* ļ                                                                *
**************************************************************************/
#include "zmmf_pub.h" /* ýϵͳķϢ */

/**************************************************************************
*                                                                     *
**************************************************************************/

/**************************************************************************
* 궨                                                                  *
**************************************************************************/
#define ZMMF_OPER_TYPE_VT                "ZMMF_OPER_TYPE_VT"                /* VT */
#define ZMMF_OPER_TYPE_STREAM            "ZMMF_OPER_TYPE_STREAM"            /* STREAM */
#define ZMMF_OPER_TYPE_ALARM_BATTERY     "ZMMF_OPER_TYPE_ALARM_BATTERY"     /* 澯 */
#define ZMMF_OPER_TYPE_ALARM_OTHER       "ZMMF_OPER_TYPE_ALARM_OTHER"       /* 澯 */
#define ZMMF_OPER_TYPE_NOTIFY_CALL       "ZMMF_OPER_TYPE_NOTIFY_CALL"       /*  */
#define ZMMF_OPER_TYPE_NOTIFY_MESSAGE    "ZMMF_OPER_TYPE_NOTIFY_MESSAGE"    /*  */
#define ZMMF_OPER_TYPE_NOTIFY_MINUTE     "ZMMF_OPER_TYPE_NOTIFY_MINUTE"     /* ʾ */
#define ZMMF_OPER_TYPE_NOTIFY_CONNECTED  "ZMMF_OPER_TYPE_NOTIFY_CONNECTED"  /* ͨʾ */
#define ZMMF_OPER_TYPE_NOTIFY_CLOCK      "ZMMF_OPER_TYPE_NOTIFY_CLOCK"      /* ʾ */
#define ZMMF_OPER_TYPE_NOTIFY_OTHER      "ZMMF_OPER_TYPE_NOTIFY_OTHER"      /* ʾ */
#define ZMMF_OPER_TYPE_PLAYER            "ZMMF_OPER_TYPE_PLAYER"            /*  */
#define ZMMF_OPER_TYPE_TONE              "ZMMF_OPER_TYPE_TONE"              /* Tone  */
#define ZMMF_OPER_TYPE_PREVIEW_RING      "ZMMF_OPER_TYPE_PREVIEW_RING"      /* Ԥ */
#define ZMMF_OPER_TYPE_WEB               "ZMMF_OPER_TYPE_WEB"               /* ҳ */
#define ZMMF_OPER_TYPE_JAVA              "ZMMF_OPER_TYPE_JAVA"              /* java */
#define ZMMF_OPER_TYPE_MMS               "ZMMF_OPER_TYPE_MMS"               /*  */
#define ZMMF_OPER_TYPE_SYS_ON            "ZMMF_OPER_TYPE_SYS_ON"            /*  */
#define ZMMF_OPER_TYPE_SYS_OFF           "ZMMF_OPER_TYPE_SYS_OFF"           /* ػ */
#define ZMMF_OPER_TYPE_RECORD            "ZMMF_OPER_TYPE_RECORD"            /* ¼ */
#define ZMMF_OPER_TYPE_PHONERECORD       "ZMMF_OPER_TYPE_PHONERECORD"       /* 绰 ¼ */
#define ZMMF_OPER_TYPE_VIDEORECORD       "ZMMF_OPER_TYPE_VIDEORECORD"       /* ¼ */
#define ZMMF_OPER_TYPE_CAMERA            "ZMMF_OPER_TYPE_CAMERA"            /*  */
#define ZMMF_OPER_TYPE_OTHER             "ZMMF_OPER_TYPE_OTHER"             /*  */

/**************************************************************************
*                                                                 *
**************************************************************************/

/*  */
typedef enum
{
    ZMMF_FILE_OPT_FILENAME = 100,    /* ļCHAR* */
    ZMMF_FILE_OPT_CYCLEMODE,         /* ѭģʽT_ZMmf_PlayMode */
    ZMMF_FILE_OPT_DISPLAYMODE,       /* ʾģʽT_ZMmf_DisplayMode */
    ZMMF_FILE_OPT_AUDIOPATH,         /* ƵͨT_ZMmf_OutputPath */
    ZMMF_FILE_OPT_AUDIOVOL,          /* ƵT_ZMmf_OutputVolLevel */
    ZMMF_FILE_OPT_AUDIOMUTE,         /* þT_ZMmf_AudioMute */
    ZMMF_FILE_OPT_AUDIO3DEFFECT,     /* ƵѡT_ZMmf_Audio_3deffectSwitch */
    ZMMF_FILE_OPT_AUDIOEQMODE,       /* ƵžѡT_ZMmf_Audio_EqMode*/
    ZMMF_FILE_OPT_VIDEORECT,         /* ƵʾλT_ZMmf_DisplayRect */
    ZMMF_FILE_OPT_VIDEOALPHA,        /* Ƶ͸(ݲ֧)SINT32 */
    ZMMF_FILE_OPT_VIDEOHIDE,         /* Ƶ (ݲ֧)*/
    ZMMF_FILE_OPT_PLAYPOS,           /* λ(λ:)   SINT32 */
    ZMMF_FILE_OPT_PLAYTOTAL,         /* ܳ(λ:)ֻܻȡֵ,  SINT32 */
    ZMMF_FILE_OPT_VIDEOIMAGE,        /* Ƶʾimageؼ */
    ZMMF_FILE_OPT_ATTRIBUTE          /* ļС */  
} T_ZMmf_FilePropOpt;

/* Tone Ų*/
typedef enum
{
    ZMMF_TONE_OPT_FREQ = 200,   /* ToneƵ(349 -5274)Hz    UINT32 */
    ZMMF_TONE_OPT_AMP,          /* Tone <= 127 */
    ZMMF_TONE_OPT_PATH,         /* ͨT_ZMmf_OutputPath */
    ZMMF_TONE_OPT_VOL,          /* T_ZMmf_OutputVolLevel */
    ZMMF_TONE_OPT_DURATION      /* ʱUINT32 */
} T_ZMmf_TonePropOpt;

/* ¼ */
typedef enum
{
    ZMMF_RECORD_OPT_FILENAME = 500,   /* ļ CHAR* */
    ZMMF_RECORD_OPT_WORKMODE,         /* ģʽѡT_ZMmf_RcdMode */  
    ZMMF_RECORD_OPT_PATH,             /* ͨ T_ZMmf_InputPath */
    ZMMF_RECORD_OPT_VOL,              /*  T_ZMmf_InputVolLevel(¼ǰ¼Ч) */
    ZMMF_RECORD_OPT_SAMPLE,           /*  UINT32(0-7)(8000hz - 44.1khz) ǹ̶ֵû */
    ZMMF_RECORD_OPT_MAXSIZE,          /* ¼ߴ(¼иıС) */
} T_ZMmf_RecordPropOpt;

/* Ԥ()*/
typedef enum
{    
    ZMMF_PREVIEW_OPT_DISPLCD,        /* ʾLCD      T_ZMmf_PreviewDispLcdId */
    ZMMF_PREVIEW_OPT_SENSOR,         /* ͷѡT_ZMmf_PreviewSensorId */
    ZMMF_PREVIEW_OPT_IMGSIZE,        /* ԤߴT_ZMmf_PreviewImgSize */
    ZMMF_PREVIEW_OPT_ZOOM,           /* ŵȼT_ZMmf_PreviewZoomLevel */
    ZMMF_PREVIEW_OPT_ROTATE,         /* תǶT_ZMmf_PreviewRotateType */
    ZMMF_PREVIEW_OPT_EFFECT,         /* ԤЧT_ZMmf_PreviewEffectType */
    ZMMF_PREVIEW_OPT_MIRROR,         /* þЧT_ZMmf_PreviewMirrorType */
    ZMMF_PREVIEW_OPT_BRIGHTNESS,     /* T_ZMmf_PreviewBrightnessLevel */
    ZMMF_PREVIEW_OPT_CONTRAST,       /* öԱȶT_ZMmf_PreviewContrastLevel */    
    ZMMF_PREVIEW_OPT_WHITEBALANCE,   /* ðƽT_ZMmf_PreviewWhiteBalance */
    ZMMF_PREVIEW_OPT_SCENEMODE ,     /* óģʽT_ZMmf_PreviewSceneMode */

    ZMMF_PREVIEW_OPT_MAX_ID
}T_ZMmf_PreviewPropOpt;

/* ¼*/
typedef enum
{
    ZMMF_VIDEORECORD_OPT_SENSOR = 600,   /* ͷѡ */
    ZMMF_VIDEORECORD_OPT_FILEFORMAT,     /* ļʽѡ */
    ZMMF_VIDEORECORD_OPT_FILENAME ,      /* ļ CHAR* */
    ZMMF_VIDEORECORD_OPT_WORKMODE,       /* ͷģʽ(Ԥ) */
    ZMMF_VIDEORECORD_OPT_VIDEOTYPE,      /* Ƶļı */
    ZMMF_VIDEORECORD_OPT_BITRATE,        /* λ */
    ZMMF_VIDEORECORD_OPT_FRAMERATE,      /* ֡ */
    ZMMF_VIDEORECORD_OPT_MAXSTREAMSIZE,  /* С(û¼иıС) */    
    ZMMF_VIDEORECORD_OPT_AUDIOENABLE,    /* ¼ */
    ZMMF_VIDEORECORD_OPT_AUDIOTYPE,      /* Ƶļı */
    ZMMF_VIDEORECORD_OPT_AUDIOFROM,      /* Ƶ豸 */
    ZMMF_VIDEORECORD_OPT_AUDIOBITRATE,   /* ¼λ */
    ZMMF_VIDEORECORD_OPT_VOLUME          /* ¼(¼ǰ¼Ч) */
} T_ZMmf_VideoRecordPropOpt;

/* ղ*/
typedef enum
{
    ZMMF_CAMERACHIP_OPT_FILENAME = 800, /* ļ CHAR* */ 
    ZMMF_CAMERACHIP_OPT_SENSORID,       /* ͷϢ */
    ZMMF_CAMERACHIP_OPT_WORKMODE,       /* չģʽ(աԤ) */
    ZMMF_CAMERACHIP_OPT_CAMCHOICE,      /* capturesnapshotѡ */
    ZMMF_CAMERACHIP_OPT_IMGSIZE,        /* ͼƬСT_ZMmf_PreviewImgSize* */   
    ZMMF_CAMERACHIP_OPT_CAMQUALITY,     /* ͼT_ZMmf_CamQuality*  */ 
    ZMMF_CAMERACHIP_OPT_SNAPSHOTSET,    /* ͼСϢ */ 
    ZMMF_CAMERACHIP_OPT_SNAPSHOTDISP    /* ջ */ 
} T_ZMmf_CameraPropOpt;

/* ӵ绰*/
typedef enum
{
    ZMMF_VT_OPT_OUTPUTPATH = 300,  /* Ƶͨ   T_ZMmf_OutputPath */
    ZMMF_VT_OPT_INPUTPATH,         /* Ƶ       T_ZMmf_OutputVolLevel */
    ZMMF_VT_OPT_OUTPUTVOL,
    ZMMF_VT_OPT_INPUTVOL,
    ZMMF_VT_OPT_LCDDSPRECT,        /* Ƶʾλ   T_ZMmf_DisplayRect */
    ZMMF_VT_OPT_CAMRECT,           /* camʾλ    T_ZMmf_DisplayRect */
    ZMMF_VT_OPT_CAMEFFECT,
    ZMMF_VT_OPT_CAMROTATE
} T_ZMmf_VtPropOpt;

/* ý*/
typedef enum
{
    ZMMF_STREAM_OPT_OUTPUTPATH = 400,  /* Ƶͨ   T_ZMmf_OutputPath */
    ZMMF_STREAM_OPT_OUTPUTVOL,
    ZMMF_STREAM_OPT_LCDDSPRECT         /* Ƶʾλ   T_ZMmf_DisplayRect */
} T_ZMmf_StreamPropOpt;

/**************************************************************************
* ԭ                                                                *
**************************************************************************/
/**************************************************************************
* ƣ  zMmf_FileOpen
*   ļųʼӿ
* ˵  (IN)pOperTypeμгpOper_type˵
*                          "ZMMF_OPER_TYPE_NOTIFY_CALL",          
*                          "ZMMF_OPER_TYPE_ALARM_BATTERY_LOW",    澯
*                          "ZMMF_OPER_TYPE_ALARM_NORMAL",         澯
*                          "ZMMF_OPER_TYPE_NOTIFY_MESSAGE",       
*                          "ZMMF_OPER_TYPE_NOTIFY_MINUTE",        ʾ
*                          "ZMMF_OPER_TYPE_NOTIFY_CONNECTED",     ͨʾ
*                          "ZMMF_OPER_TYPE_NOTIFY_CLOCK",         ʾ
*                          "ZMMF_OPER_TYPE_PLAYER",               
*                          "ZMMF_OPER_TYPE_PREVIEW_RING",         Ԥ
*                          "ZMMF_OPER_TYPE_WEB",                  ҳ
*                          "ZMMF_OPER_TYPE_JAVA",                 java
*                          "ZMMF_OPER_TYPE_MMS",                  
*                          "ZMMF_OPER_TYPE_NOTIFY_SYS_ON",        
*                          "ZMMF_OPER_TYPE_NOTIFY_SYS_OFF",       ػ
*                          "ZMMF_OPER_TYPE_RECORD"                ¼
*                          "ZMMF_OPER_TYPE_PHONERECORD"           绰¼
*                          "ZMMF_OPER_TYPE_VIDEORECORD"           ¼
*                          "ZMMF_OPER_TYPE_CAMERA"                
*                          "ZMMF_OPER_TYPE_OTHER"                 
*                iMediaSrcýԴT_ZMmf_MediaSource       
*                          ZMMF_MEDIASOURCE_FILE_MID       midļ
*                          ZMMF_MEDIASOURCE_FILE_AMR       amrļ
*                          ZMMF_MEDIASOURCE_FILE_MP3       mp3ļ
*                          ZMMF_MEDIASOURCE_FILE_AAC       aacļ
*                          ZMMF_MEDIASOURCE_FILE_H263      h263ļ
*                          ZMMF_MEDIASOURCE_FILE_YUV       yuvļ
*                          ZMMF_MEDIASOURCE_FILE_3GP       3GPļ
*                          ZMMF_MEDIASOURCE_TONE           tone
*                iChannelId: ͨ
*            (OUT)
*   ֵ  ǸֵMMFž
*             ZMMF_FAILED-1 ʼʧ
* ˵: ֵ09ѭʹ, zMmf_FileOpenȡĸֵֻFile,
* ûѴֵڳļ.
*
**************************************************************************/
SINT32 zMmf_FileOpen(const CHAR *pOperType,T_ZMmf_MediaSource iMediaSrc, SINT32 iChannelId);

/**************************************************************************
* ƣzMmf_GetVideoDrvFd
* ȡƵ
* ˵(IN)  
*           (OUT)
*   ֵɹ豸
*           ֵʾʧ
* ˵
**************************************************************************/
SINT32 zMmf_GetVideoDrvFd(VOID);

/**************************************************************************
* ƣzMmf_GetCameraFd
* ȡ
* ˵(IN)  
*           (OUT)
*   ֵɹ豸
*           ֵʾʧ
* ˵
**************************************************************************/
SINT32 zMmf_GetCameraFd(VOID);

/**************************************************************************
* ƣzMmf_FileClose
* ļŹر
* ˵(IN)iHandle:MMFž
*           (OUT)
*   ֵZMMF_SUCCESSļŹرϢͳɹ
*                           ZMMF_FAILEDļŹرϢ쳣
* ˵
**************************************************************************/
SINT32 zMmf_FileClose(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_FilePlay
*   ļŽӿ
* ˵  (IN)iHandle: MMFž
*             (OUT)
*   ֵ  ZMMF_SUCCESSļϢͳɹ
*                             ZMMF_FAILEDļϢ쳣
* ˵: 
**************************************************************************/
SINT32 zMmf_FilePlay(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_FileStop
*   ֹͣ
* ˵  (IN)iHandleMMFž
*             (OUT)
*   ֵ  ZMMF_SUCCESSֹͣϢͳɹ
*                             ZMMF_FAILEDֹͣϢ쳣
* ˵:  
**************************************************************************/
SINT32 zMmf_FileStop(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_FilePause
*   ͣ
* ˵  (IN)iHandleMMFž
*             (OUT)
*   ֵ  ZMMF_SUCCESSͣϢͳɹ
*                             ZMMF_FAILEDͣϢ쳣
* ˵:  
**************************************************************************/
SINT32 zMmf_FilePause(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_FileResume
*   ָ
* ˵  (IN)iHandleMMFž
*             (OUT)
*   ֵ  ZMMF_SUCCESSָϢͳɹ
*                             ZMMF_FAILEDָϢ쳣
* ˵:  
**************************************************************************/
SINT32 zMmf_FileResume(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_FileSetOpt
*   ļò
* ˵  (IN)iHandle    MMFž
*                 iOptType   
*                 pOption    
*                 iOptionSizeС
*             (OUT)
*   ֵ  ZMMF_SUCCESSļϢͳɹ
*                             ZMMF_FAILEDļϢ쳣
* ˵:  
**************************************************************************/
SINT32 zMmf_FileSetOpt(UINT32 iHandle, T_ZMmf_FilePropOpt iOptType, VOID *pOption, UINT32 iOptionSize);

/**************************************************************************
* ƣ  zMmf_FileQuery
*   ļѯ
* ˵  (IN)iHandle     MMFò
*                 iOptType   ѯļ,T_ZMmf_FilePropOpt
*                 pOption    
*                 iOptionSizeС
*             (OUT)
*   ֵ  ZMMF_SUCCESSļѯϢͳɹ
*                             ZMMF_FAILEDļѯϢ쳣
* ˵:  
**************************************************************************/
SINT32 zMmf_FileQuery(UINT32 iHandle, T_ZMmf_FilePropOpt iOptType, VOID *pOption, UINT32 iOptionSize);

/**************************************************************************
* ƣ  zMmf_FileSeek
*   ضλ
* ˵  (IN)iHandleMMFž
*                 iSecond
*                 seekMode:ضλģʽƵֻܴӵǰλضλòЧ
*             (OUT)
*   ֵ  ZMMF_SUCCESSضλϢͳɹ
*                             ZMMF_FAILEDضλϢ쳣
* ˵:  ֵʾǰضλֵʾضλ
*            ضλʱ䳬ļʱλļβͷ
**************************************************************************/
SINT32 zMmf_FileSeek(UINT32 iHandle, SINT32 iSecond,T_ZMmfVide_SeekMode seekMode);

/**************************************************************************
===========================================================================
===========================================================================
===========================================================================
**************************************************************************/

/**************************************************************************
* ƣ  zMmf_ToneOpen
*   toneųʼ
* ˵  (IN)pOperTypeμгpOper_type˵
*                iMediaSrcμT_ZMmf_MediaSource˵
*                iChannelId: ͨ
*             (OUT)
*   ֵ  ǸֵMMFž
*                             ZMMF_FAILED-1 ʼʧ
* ˵: zMmf_ToneOpenȡĸֵֻTone,
* ûѴֵڳTone.
**************************************************************************/
SINT32 zMmf_ToneOpen(const CHAR *pOperType,T_ZMmf_MediaSource iMediaSrc, SINT32 iChannelId);

/**************************************************************************
* ƣ zMmf_ToneClose
*  toneŹر
* ˵(IN)iHandle:MMFž
*           (OUT)
*   ֵZMMF_SUCCESStoneŹرϢͳɹ
*                           ZMMF_FAILEDtoneŹرϢ쳣
* ˵
**************************************************************************/
SINT32 zMmf_ToneClose(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_TonePlay
*   toneŽӿ
* ˵  (IN)iHandle:MMFž
*             (OUT)
*   ֵ  ZMMF_SUCCESStoneϢͳɹ
*                             ZMMF_FAILEDtoneϢ쳣
* ˵:   ˽ӿʱ,ԺǷ,ûʹ
**************************************************************************/
SINT32 zMmf_TonePlay(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_ToneStop
*   toneֹͣ
* ˵  (IN)iHandle:MMFž
*                                 (OUT)
*   ֵ  ZMMF_SUCCESStoneֹͣϢͳɹ
*                             ZMMF_FAILEDtoneֹͣϢ쳣
* ˵:  
**************************************************************************/
SINT32 zMmf_ToneStop(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_ToneSetOpt
*   toneò
* ˵  (IN)iHandle    MMFž
*                 iOptType   
*                 pOption    
*                 iOptionSizeС
*   ֵ  ZMMF_SUCCESStoneòϢͳɹ
*                             ZMMF_FAILEDtoneòϢ쳣
* ˵:  
**************************************************************************/
SINT32 zMmf_ToneSetOpt(UINT32 iHandle, T_ZMmf_TonePropOpt iOptType, VOID *pOption, UINT32 iOptionSize);

/**************************************************************************
===========================================================================
===========================================================================
===========================================================================
**************************************************************************/

/*******************************************************************
* ƣ  zMmf_VtOpen
*   ӵ绰ųʼ
* ˵  (IN)pOperType"ZMMF_MEDIA_ID_VT"
*                 iMediaSrcZMMF_MEDIASOURCE_VT_AUDIO
*                            ZMMF_MEDIASOURCE_VT_VIDEO
*                            ZMMF_MEDIASOURCE_VT_ALL
*                 iMmcId:MMC IDʶûò-1;
*                 iChannelId: ͨ
*             (OUT)
*   ֵ  ɹMMC IDʶʧܷظֵýӿΪӿڣ
* ˵:   
*******************************************************************/
SINT32 zMmf_VtOpen(const CHAR *pOperType,T_ZMmf_MediaSource iMediaSrc, SINT32 iMmcId,SINT32 iChannelId);

/*******************************************************************
* ƣ  zMmf_VtPlay
*   ӵ绰ʼӿ
* ˵  (IN)iHandle:MMFž
*                 iMediaSrc:ýԴͣƵ/Ƶ
*             (OUT)
*   ֵ  ZMMF_SUCCESSɹ
*             ZMMF_FAILED쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_VtPlay(UINT32 iHandle,T_ZMmf_MediaSource iMediaSrc);

/*******************************************************************
* ƣ  zMmf_VtStop
*   ӵ绰ֹͣӿ
* ˵  (IN)iHandle:MMFž
*                 iMediaSrc:ýԴ
*             (OUT)
*   ֵ  ZMMF_SUCCESSɹ
*             ZMMF_FAILED쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_VtStop(UINT32 iHandle,T_ZMmf_MediaSource iMediaSrc);

/*******************************************************************
* ƣ zMmf_VtClose
*  ӵ绰Źر
* ˵(IN)iHandle:MMFž
*               iMediaSrc:ýԴ
*           (OUT)
*   ֵZMMF_SUCCESSɹ
*           ZMMF_FAILED쳣
* ˵  
*******************************************************************/
SINT32 zMmf_VtClose(UINT32 iHandle,T_ZMmf_MediaSource iMediaSrc);

/*******************************************************************
* ƣ  zMmf_VtSetOpt
*   ӵ绰ò
* ˵  (IN)iHandle  MMFž
*                iOptTypeT_ZMmf_VtPropOpt
*                iMediaSrc:ýԴ
*                pOption:ò
*                iOptionSizeС
*   ֵ ZMMF_SUCCESSɹ
*            ZMMF_FAILED쳣
* ˵: 
*******************************************************************/
SINT32 zMmf_VtSetOpt(UINT32 iHandle, T_ZMmf_VtPropOpt iOptType, T_ZMmf_MediaSource iMediaSrc,VOID *pOption, UINT32 iOptionSize);

/*******************************************************************
* ƣ  zMmf_VtSetCodec
*   ӵ绰ñ
* ˵  (IN)iHandle:MMFž
*                iMediaSrcýԴ
*                iCodecType:T_ZMmf_CodecType
*                pInitParam:ò
*   ֵ ZMMF_SUCCESSɹ
*            ZMMF_FAILED쳣
* ˵:ýӿΪӿ
*******************************************************************/
SINT32 zMmf_VtSetCodec(UINT32 iHandle, T_ZMmf_MediaSource iMediaSrc,T_ZMmf_CodecType iCodecType, VOID* pInitParam);

/*******************************************************************
* ƣ  zMmf_VtWrite
*   ӵ绰ݲ
* ˵  (IN)iHandleMMFž
*                 pBuf:ݻ
*                 iSize:ݴС
*                 iMediaSrc:ýT_ZMmf_MediaSource
*                 iTimeStampʱЧ
*   ֵ дֵֽʾʧܣ
* ˵:ƵÿαΪһ֡֡ͷAMR IF2ʽƵ֧ⳤȣh.263mpeg4ʽ
*******************************************************************/
SINT32 zMmf_VtWrite(UINT32 iHandle, CHAR *pBuf, SINT32 iSize,T_ZMmf_MediaSource iMediaSrc, UINT32 iTimeStamp);

/*******************************************************************
* ƣ  zMmf_VtRead
*   ӵ绰ݽӿ
* ˵  (IN)iHandleMMFž
*                 pBuf:ݻ
*                 iSize ݴС
*                 iMediaSrc:ýԴ
*                 iTimeStampʱЧ
*   ֵ ֵֽʾʧ
* ˵: ƵʱpBufĿռ2Aֽ
*******************************************************************/
SINT32 zMmf_VtRead(UINT32 iHandle, CHAR *pBuf, SINT32 iSize, T_ZMmf_MediaSource iMediaSrc, UINT32 iTimeStamp);

/**************************************************************************
===========================================================================
===========================================================================
===========================================================================
**************************************************************************/

/*******************************************************************
* ƣ  zMmf_StreamOpen
*   ý岥ųʼ
* ˵  (IN)pOperType"ZMMF_MEDIA_ID_STREAM"
*                iMediaSrcZMMF_MEDIASOURCE_VT_AUDIO
*                           ZMMF_MEDIASOURCE_VT_VIDEO
*                           ZMMF_MEDIASOURCE_VT_ALL
*                iMmcId:MMC ID,û -1
*                iChannelId: ͨ
*             (OUT)
*   ֵɹMMC IDʧܷظֵ
* ˵ýӿΪӿ
*******************************************************************/
SINT32 zMmf_StreamOpen(const CHAR *pOperType,T_ZMmf_MediaSource iMediaSrc, SINT32 iMmcId,SINT32 iChannelId);

/*******************************************************************
* ƣ  zMmf_StreamPlay
*   ý忪ʼŽӿ
* ˵  (IN)iHandle:MMFž
*                iMediaSrc:ý
*             (OUT)
*   ֵ  ZMMF_SUCCESSɹ
*             ZMMF_FAILED쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_StreamPlay(UINT32 iHandle,T_ZMmf_MediaSource iMediaSrc);

/*******************************************************************
* ƣ  zMmf_StreamPause
*   ýͣ
* ˵  (IN)iHandleMMFž
*                iMediaSrc:ý
*             (OUT)
*   ֵ  ZMMF_SUCCESSɹ
*             ZMMF_FAILED쳣
* ˵:   
*******************************************************************/
SINT32 zMmf_StreamPause(UINT32 iHandle,T_ZMmf_MediaSource iMediaSrc);

/*******************************************************************
* ƣ  zMmf_StreamSeek
*   ýضλ
* ˵  (IN)iHandleMMFž
*                 iMediaSrc:ý
*                 iTimeضλʱλ
*             (OUT)
*   ֵ  ZMMF_SUCCESSɹ
*             ZMMF_FAILED쳣
* ˵:  ýضλŽӿǷڶýۣʱûʵ 
*******************************************************************/
SINT32 zMmf_StreamSeek(UINT32 iHandle, T_ZMmf_MediaSource iMediaSrc,UINT32 iTime);

/*******************************************************************
* ƣ  zMmf_StreamStop
*   ýֹͣ
* ˵  (IN)iHandle:MMFž
*                 iMediaSrc:ý
*             (OUT)
*   ֵ  ZMMF_SUCCESSɹ
*             ZMMF_FAILED쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_StreamStop(UINT32 iHandle,T_ZMmf_MediaSource iMediaSrc);

/*******************************************************************
* ƣ zMmf_StreamClose
*  ӵ绰Źر
* ˵(IN)iHandle:MMFž
*               iMediaSrc:ý
*           (OUT)
*   ֵZMMF_SUCCESSɹ
*           ZMMF_FAILED쳣
* ˵  
*******************************************************************/
SINT32 zMmf_StreamClose(UINT32 iHandle,T_ZMmf_MediaSource iMediaSrc);

/*******************************************************************
* ƣ  zMmf_StreamSetOpt
*   ý岥ò
* ˵  (IN)iHandle:MMFž
*                 iOptType:T_ZMmf_StreamPropOpt
*                 pOption:ֵ
*                 iOptionSizeС
*   ֵ ZMMF_SUCCESSɹ
*            ZMMF_FAILED쳣
* ˵: 
*******************************************************************/
SINT32 zMmf_StreamSetOpt(UINT32 iHandle, T_ZMmf_StreamPropOpt iOptType, VOID *pOption, UINT32 iOptionSize);

/*******************************************************************
* ƣ  zMmf_StreamSetCodec
*   ý岥ñ
* ˵  (IN)iHandle:MMFž
*                 iCodecType:
*                 pInitParam:ʼ
*   ֵ ZMMF_SUCCESSɹ
*            ZMMF_FAILED쳣
* ˵:ýĿǰֻ֧h.263ʽԸýӿʱЧ
*******************************************************************/
SINT32 zMmf_StreamSetCodec(UINT32 iHandle, T_ZMmf_CodecType iCodecType, VOID* pInitParam);

/*******************************************************************
* ƣ  zMmf_StreamWrite
*   дýƵ/Ƶݽӿ
* ˵  (IN)iHandleMMFž
*                 pBuf:ݻ
*                 iSize:ݳ
*                 iMediaSrc:ý
*                 iTimeStampʱЧ
*   ֵ ɹ򷵻дֵֽʾʧܣ
* ˵:ӿڣƵΪһ֡֡ͷƵ֧ⳤ
*******************************************************************/
SINT32 zMmf_StreamWrite(UINT32 iHandle, CHAR *pBuf, SINT32 iSize,T_ZMmf_MediaSource iMediaSrc, UINT32 iTimeStamp);

/**************************************************************************
===========================================================================
===========================================================================
===========================================================================
**************************************************************************/
/**************************************************************************
* ƣ  zMmf_RecordOpen
*   ¼ʼ
* ˵  (IN)pOperTypeμгpOper_type˵
*                iMediaSrcμT_ZMmf_MediaSource˵
*                iChannelId: ͨ
*             (OUT)
*   ֵ  ǸֵMMFž
*                             ZMMF_FAILED-1 ʼʧ
* ˵: zMmf_RecordOpenȡĸֵֻ¼,
* ûѴֵڳ¼.
**************************************************************************/
SINT32 zMmf_RecordOpen(const CHAR *pOperType,T_ZMmf_MediaSource iMediaSrc, SINT32 iChannelId);

/*******************************************************************
* ƣ  zMmf_RecordSetOpt
*   ¼ò
* ˵  (IN)iHandle  MMFž
*                iOptTypeT_ZMmf_RecordPropOpt
*                pOption 
*                iOptionSizeС
*   ֵ ZMMF_SUCCESS¼òϢͳɹ
*                            ZMMF_FAILED¼òϢ쳣
* ˵: 
*******************************************************************/
SINT32 zMmf_RecordSetOpt(UINT32 iHandle, T_ZMmf_RecordPropOpt iOptType, VOID *pOption, UINT32 iOptionSize);

/*******************************************************************
* ƣ  zMmf_RecordSetCodec
*   ¼ñ
* ˵  (IN)iHandle  MMFž
*                iCodecType
*                pInitParam ʼ
*   ֵ ZMMF_SUCCESS¼ñϢͳɹ
*                            ZMMF_FAILED¼ñϢ쳣
* ˵:
*******************************************************************/
SINT32 zMmf_RecordSetCodec(UINT32 iHandle, UINT32 iCodecType, VOID* pInitParam);

/*******************************************************************
* ƣ  zMmf_RecordStart
*   ¼
* ˵  (IN)iHandle:MMF¼
*             (OUT)
*   ֵ  ZMMF_SUCCESS¼Ϣͳɹ
*                             ZMMF_FAILED¼Ϣ쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_RecordStart(UINT32 iHandle);

/*******************************************************************
* ƣ  zMmf_RecordPause
*   ͣ¼
* ˵  (IN)iHandleMMF¼
*             (OUT)
*   ֵ  ZMMF_SUCCESSͣ¼Ϣͳɹ
*                             ZMMF_FAILEDͣ¼Ϣ쳣
* ˵:   
*******************************************************************/
SINT32 zMmf_RecordPause(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_RecordResume
*   ָ¼
* ˵  (IN)iHandleMMFž
*             (OUT)
*   ֵ  ZMMF_SUCCESSָ¼Ϣͳɹ
*                             ZMMF_FAILEDָ¼Ϣ쳣
* ˵:  
**************************************************************************/
SINT32 zMmf_RecordResume(UINT32 iHandle);

/*******************************************************************
* ƣ  zMmf_RecordStop
*   ֹͣ¼
* ˵  (IN)iHandle:MMFž
*             (OUT)
*   ֵ  ZMMF_SUCCESSֹͣ¼Ϣͳɹ
*                             ZMMF_FAILEDֹͣ¼Ϣ쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_RecordStop(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_RecordClose
*  ¼ر
* ˵(IN)iHandle:MMFž
*           (OUT)
*   ֵZMMF_SUCCESS¼رϢͳɹ
*                           ZMMF_FAILED¼رϢ쳣
* ˵  
*******************************************************************/
SINT32 zMmf_RecordClose(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_RecordQuery
*   ¼ѯ
* ˵  (IN)iHandle     MMFò
*                 iOptType   
*                 pOption    
*                 iOptionSizeС
*             (OUT)
*   ֵ  ZMMF_SUCCESS¼ѯϢͳɹ
*                             ZMMF_FAILED¼ѯϢ쳣
* ˵:  
**************************************************************************/
SINT32 zMmf_RecordQuery(UINT32 iHandle, T_ZMmf_RecordPropOpt iOptType, VOID *pOption, UINT32 iOptionSize);

/**************************************************************************
===========================================================================
===========================================================================
===========================================================================
**************************************************************************/
/**************************************************************************
* ƣ  zMmf_CameraChipPreviewOpen
*   Ԥʼ
* ˵  (IN)pOperTypeμгpOper_type˵
*                iMediaSrcμT_ZMmf_MediaSource˵
*                iChannelId: ͨ
*             (OUT)
*   ֵ  ǸֵMMFž
*                             ZMMF_FAILED-1 ʼʧ
* ˵: zMmf_CameraChipPreviewOpenȡĸֵֻյ,
* ûѴֵڳղ.
**************************************************************************/
SINT32 zMmf_CameraChipPreviewOpen(const CHAR *pOperType,T_ZMmf_MediaSource iMediaSrc, SINT32 iChannelId);

/*******************************************************************
* ƣ  zMmf_CameraChipPreviewSetOpt
*   Ԥò
* ˵  (IN)iHandle  MMFž
*                iOptTypeT_ZMmf_PreviewPropOpt
*                pOption 
*                iOptionSizeС
*   ֵ ZMMF_SUCCESSԤòϢͳɹ
*                            ZMMF_FAILEDԤòϢ쳣
* ˵: 
*******************************************************************/
/* begin modify by 053076*/
SINT32 zMmf_CameraChipPreviewSetOpt(UINT32 iHandle, T_ZMmf_PreviewPropOpt iOptType, VOID *pOption, UINT32 iOptionSize);

/*******************************************************************
* ƣ  zMmf_CameraChipPreview
*   Ԥ
* ˵  (IN)iHandle:MMFԤ
*             (OUT)
*   ֵ  ZMMF_SUCCESSԤϢͳɹ
*                             ZMMF_FAILEDԤϢ쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_CameraChipPreviewStart(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_CameraChipPreviewStop
*  ֹͣԤ
* ˵(IN)iHandle:MMF¼
*           (OUT)
*   ֵZMMF_SUCCESSֹͣԤϢͳɹ
*                           ZMMF_FAILEDֹͣԤϢ쳣
* ˵  
*******************************************************************/
SINT32 zMmf_CameraChipPreviewStop(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_CameraChipPreviewClose
*  Ԥر
* ˵(IN)iHandle:MMFž
*           (OUT)
*   ֵZMMF_SUCCESSԤرϢͳɹ
*                           ZMMF_FAILEDԤرϢ쳣
* ˵  
*******************************************************************/
SINT32 zMmf_CameraChipPreviewClose(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_CameraOpen
*   ճʼ
* ˵  (IN)pOperTypeμгpOper_type˵
*                iMediaSrcμT_ZMmf_MediaSource˵
*                iChannelId: ͨ
*             (OUT)
*   ֵ  ǸֵMMFž
*                              ZMMF_FAILED-1 ʼʧ
* ˵: 
**************************************************************************/
SINT32 zMmf_CameraOpen(const CHAR *pOperType,T_ZMmf_MediaSource iMediaSrc, SINT32 iChannelId);

/*******************************************************************
* ƣ  zMmf_CameraSetOpt
*   ò
* ˵  (IN)iHandle  MMFž
*                iOptTypeT_ZMmf_CameraOpt
*                          T_ZMmf_VideoOpt
*                pOption 
*                iOptionSizeС
*   ֵ ZMMF_SUCCESSϢͳɹ
*                            ZMMF_FAILEDϢ쳣
* ˵: 
*******************************************************************/
SINT32 zMmf_CameraSetOpt(UINT32 iHandle, T_ZMmf_CameraPropOpt iOptType, VOID *pOption, UINT32 iOptionSize);

/*******************************************************************
* ƣ  zMmf_CameraSetCodec
*   ñ(ʱʹ)
* ˵  (IN)iHandle  MMFž
*                iCodecType
*                pInitParam ʼ
*   ֵ ZMMF_SUCCESSϢͳɹ
*                            ZMMF_FAILEDϢ쳣
* ˵:ʱʹãӲʱô˽ӿ
*******************************************************************/
SINT32 zMmf_CameraSetCodec(UINT32 iHandle, UINT32 iCodecType, VOID* pInitParam);

/*******************************************************************
* ƣ  zMmf_CameraStart
*   տʼ
* ˵  (IN)iHandle:MMF¼
*             (OUT)
*   ֵ  ZMMF_SUCCESSϢͳɹ
*                             ZMMF_FAILEDϢ쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_CameraStart(UINT32 iHandle);

/*******************************************************************
* ƣ  zMmf_CameraDisplay
*   ջ
* ˵  (IN)iHandle:MMF¼
*             (OUT)
*   ֵ  ZMMF_SUCCESSϢͳɹ
*                             ZMMF_FAILEDϢ쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_CameraDisplay(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_CameraClose
*  չر
* ˵(IN)iHandle:MMFž
*           (OUT)
*   ֵZMMF_SUCCESSϢͳɹ
*                           ZMMF_FAILEDϢ쳣
* ˵  
*******************************************************************/
SINT32 zMmf_CameraClose(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_VideoRecordPreviewOpen
*   ¼Ԥʼ
* ˵  (IN)pOperTypeμгpOper_type˵
*                iMediaSrcμT_ZMmf_MediaSource˵
*                iChannelId: ͨ
*             (OUT)
*   ֵ  ǸֵMMFž
*                             ZMMF_FAILED-1 ʼʧ
* ˵: zMmf_VideoRecordPreviewOpenȡĸֵֻ¼,
* ûѴֵڳ¼.
**************************************************************************/
SINT32 zMmf_VideoRecordPreviewOpen(const CHAR *pOperType,T_ZMmf_MediaSource iMediaSrc, SINT32 iChannelId);

/*******************************************************************
* ƣ  zMmf_VideoRecordPreviewSetOpt
*   ¼Ԥò
* ˵  (IN)iHandle  MMFž
*                iOptTypeT_ZMmf_PreviewOpt
*                          T_ZMmf_VideoOpt
*                pOption 
*                iOptionSizeС
*   ֵ ZMMF_SUCCESSϢͳɹ
*                            ZMMF_FAILEDϢ쳣
* ˵: 
*******************************************************************/
SINT32 zMmf_VideoRecordPreviewSetOpt(UINT32 iHandle, T_ZMmf_PreviewPropOpt iOptType, VOID *pOption, UINT32 iOptionSize);

/*******************************************************************
* ƣ  zMmf_VideoRecordPreviewStart
*   ¼Ԥʼ
* ˵  (IN)iHandle:MMF¼
*             (OUT)
*   ֵ  ZMMF_SUCCESS¼ԤʼϢͳɹ
*                             ZMMF_FAILED¼ԤʼϢ쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_VideoRecordPreviewStart(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_VideoRecordPreviewStop
*  ֹͣ¼Ԥ
* ˵(IN)iHandle:MMF¼
*           (OUT)
*   ֵZMMF_SUCCESSֹͣ¼ԤϢͳɹ
*                           ZMMF_FAILEDֹͣ¼ԤϢ쳣
* ˵  
*******************************************************************/
SINT32 zMmf_VideoRecordPreviewStop(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_VideoRecordPreviewClose
*  ¼Ԥر
* ˵(IN)iHandle:MMFž
*           (OUT)
*   ֵZMMF_SUCCESS¼ԤرϢͳɹ
*                           ZMMF_FAILED¼ԤرϢ쳣
* ˵  
*******************************************************************/
SINT32 zMmf_VideoRecordPreviewClose(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_VideoRecordOpen
*   ¼ʼ
* ˵  (IN)pOperTypeμгpOper_type˵
*                iMediaSrcμT_ZMmf_MediaSource˵
*                iChannelId: ͨ
*             (OUT)
*   ֵ  ǸֵMMFž
*                             ZMMF_FAILED-1 ʼʧ
* ˵: ˽ӿѷ,ûʹ
**************************************************************************/
SINT32 zMmf_VideoRecordOpen(const CHAR *pOperType,T_ZMmf_MediaSource iMediaSrc, SINT32 iChannelId);

/*******************************************************************
* ƣ  zMmf_VideoRecordSetOpt
*   ¼ò
* ˵  (IN)iHandle  MMFž
*                iOptTypeT_ZMmf_CameraOpt
*                          T_ZMmf_VideoOpt
*                pOption 
*                iOptionSizeС
*   ֵ ZMMF_SUCCESS¼òϢͳɹ
*                            ZMMF_FAILED¼òϢ쳣
* ˵: 
*******************************************************************/
SINT32 zMmf_VideoRecordSetOpt(UINT32 iHandle, T_ZMmf_VideoRecordPropOpt iOptType, VOID *pOption, UINT32 iOptionSize);

/*******************************************************************
* ƣ  zMmf_VideoRecordSetCodec
*   ¼ñ(ʱʹ)
* ˵  (IN)iHandle  MMFž
*                iCodecType
*                pInitParam ʼ
*   ֵ ZMMF_SUCCESSϢͳɹ
*                            ZMMF_FAILEDϢ쳣
* ˵:ʱʹãӲʱô˽ӿ
*******************************************************************/
SINT32 zMmf_VideoRecordSetCodec(UINT32 iHandle, UINT32 iCodecType, VOID* pInitParam);

/*******************************************************************
* ƣ  zMmf_VideoRecordStart
*   ¼
* ˵  (IN)iHandle:MMF¼
*             (OUT)
*   ֵ  ZMMF_SUCCESS¼Ϣͳɹ
*                             ZMMF_FAILED¼Ϣ쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_VideoRecordStart(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_VideoRecordStop
*  ֹͣ¼
* ˵(IN)iHandle:MMF¼
*           (OUT)
*   ֵZMMF_SUCCESSֹͣ¼Ϣͳɹ
*                           ZMMF_FAILEDֹͣ¼Ϣ쳣
* ˵  
*******************************************************************/
SINT32 zMmf_VideoRecordStop(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_VideoRecordPause
*  ͣ¼
* ˵(IN)iHandle:MMF¼
*           (OUT)
*   ֵZMMF_SUCCESSͣ¼Ϣͳɹ
*                           ZMMF_FAILEDͣ¼Ϣ쳣
* ˵  
*******************************************************************/
SINT32 zMmf_VideoRecordPause(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_VideoRecordResume
*  ָ¼
* ˵(IN)iHandle:MMF¼
*           (OUT)
*   ֵZMMF_SUCCESSָ¼Ϣͳɹ
*                           ZMMF_FAILEDָ¼Ϣ쳣
* ˵  
*******************************************************************/
SINT32 zMmf_VideoRecordResume(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_VideoRecordClose
*  ¼ر
* ˵(IN)iHandle:MMFž
*           (OUT)
*   ֵZMMF_SUCCESS¼رϢͳɹ
*                           ZMMF_FAILED¼رϢ쳣
* ˵˽ӿѷ,ûʹ  
*******************************************************************/
SINT32 zMmf_VideoRecordClose(UINT32 iHandle);

/*******************************************************************
* ƣ zMmf_QueryIsBusy
*  鿴MMFģǷ
* ˵(IN)
*           (OUT)
*   ֵTRUEMMFв
*                 FALSEMMFûв
* ˵  
*******************************************************************/
BOOL zMmf_QueryIsBusy(VOID);

/**************************************************************************
* ƣ  zMmf_ToneSynPlay
*   toneͬŽӿ
* ˵  (IN)iHandle:MMFž
*             (OUT)
*   ֵ  ZMMF_SUCCESStoneϢͳɹ
*                             ZMMF_FAILEDtoneϢ쳣
* ˵:  ˽ӿѷ,ûʹ 
**************************************************************************/
SINT32 zMmf_ToneSynPlay(UINT32 iHandle);

/**************************************************************************
* ƣ  zMmf_PlayTone
*   toneŽӿ
* ˵  (IN)tToneArg: ToneŲ
*             (OUT)
*   ֵ  
* ˵:   
**************************************************************************/
VOID zMmf_TonePlayEx(T_ZMmf_PlayToneArg tToneArg);

/**************************************************************************
* ƣzMmf_FileSynClose
* ļͬر
* ˵(IN)iHandle:MMFž
*           (OUT)
*   ֵZMMF_SUCCESSļŹرϢͳɹ
*           ZMMF_FAILED ļŹرϢ쳣
* ˵
**************************************************************************/
SINT32 zMmf_FileSynClose(UINT32 iHandle);

/**************************************************************************
* ƣzMmf_FileSynPause
* ļͬر
* ˵(IN)iHandle:MMFž
*           (OUT)
*   ֵZMMF_SUCCESSļͣϢͳɹ
*           ZMMF_FAILED ļͣϢ쳣
* ˵
**************************************************************************/
SINT32 zMmf_FileSynPause(UINT32 iHandle);


/**************************************************************************
* ƣzMmf_GetOutputPath
* صǰͨ
* ˵(IN)
*           (OUT)
*   ֵڵ0ʾصǰͨ
*           -1ʾǰͨûбռ
* ˵
**************************************************************************/
SINT32 zMmf_GetOutputPath(VOID);

/**************************************************************************
* ƣzMmf_BeginNotifyClock
* Ӳſʼ֪ͨӿ
* ˵(IN)
*           (OUT)
*   ֵڵ0ʾصǰͨ
*           -1ʾǰͨûбռ
* ˵
**************************************************************************/
SINT32 zMmf_BeginNotifyClock(VOID);

/**************************************************************************
* ƣzMmf_zMmf_EndNotifyClock
* ļͬر
* ˵(IN)
*           (OUT)
*   ֵڵ0ʾصǰͨ
*           -1ʾǰͨûбռ
* ˵
**************************************************************************/
SINT32 zMmf_zMmf_EndNotifyClock(VOID);

/**************************************************************************
* ƣzMmf_SynNotifyResume
* ָ֪ͬͨӿ
* ˵(IN)uiHandle: MMFž
*           (OUT)
*   ֵ1: ָɹ
*           0: ָʧܣΪMMF״̬ΪIDLE״̬
*           -1:ָʧܣײ豸ʧܣ
*           -2:(Ϣʧܡǰв
*              ҵ񡢴ҵָҵһ)
* ˵Ƶšա¼ҵ񣬵
*           ʱMMFĲƻὫԶ𣬲
*           ״̬ΪINCOMINGALARMINGǵӽ
*           ʱMMFûEV_ZMMF_INFO_STATUS_IDLE_RSP
*           ϢûյϢʱҪô˽ӿ֪ͨMMF
*           ָ
**************************************************************************/
SINT32  zMmf_SynNotifyResume(UINT32 uiHandle);
#ifdef __cplusplus
   } 
#endif
#endif /*_ZMMF_API_H_*/

