/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : sup_shell_thread.c
* ļ : 
* ʵֹ : ̡߳CPUռͳصshell
*      : 
*      : V1.0
*  : 2019-01-10
* ˵ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "sup_shell.h"
#include "sup_shell_cmd.h"
#include "sup_except.h"
#include "osa.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#ifdef _OS_WIN
#ifndef PROCESS
#define PROCESS ZOSS_THREAD_ID
#endif
#endif

#define SHELL_SIGN  "\t================================================================================================================="

/**************************************************************************
* ݽṹ
**************************************************************************/
 
/**************************************************************************
* ֲԭ
**************************************************************************/
static VOID Shell_ShowThread(T_ZOsa_ThreadUserArea *pThreadInfo);
static VOID Shell_ShowThreadTitle(VOID);

#ifdef _OS_LINUX
void linux_thread_sched_stat(int type);
#endif

/**************************************************************************
* ȫֳ/
**************************************************************************/
ZOSS_TIMER_ID   gShell_UpdataCpuTimerId = NULL; /* cpuռʶʱ */
ZOSS_TIMER_ID   gShell_FreshCpuTimerId  = NULL; /* ʾcpuռʶʱ */

#ifdef _OS_LINUX
extern void *linux_get_threadID_by_name(const char *name);
extern void linux_reset_cpupinfo(void);
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/
static VOID Shell_ThreadCPU(SINT32 para)
{
    if(OSA_IdentifyThread((ZOSS_THREAD_ID)para) == ZOSS_SUCCESS)
    {        
        Osa_DisplayThreadExecInfo((PROCESS)para);
    }
    else
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t̲߳");
    }
}

static VOID Shell_ThreadsCPU(SINT32 para)
{
    Osa_DisplayThreadsExecInfo((UINT32)para);
}

static VOID Shell_ThreadSetFlagUse(const CHAR *cmd)
{    
    zOss_AssertExN(cmd != NULL);
    zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t÷:%s   m", cmd);
    zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\tmȡֵ[0-1]");
    zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t m = 0ʾرռ¼߳cpuʱ俪");
    zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t m = 1ʾ򿪼¼߳cpuʱ俪");
}

static VOID Shell_PrintSysCPU(VOID)
{
#ifdef _OS_LINUX
    UINT32 rate = 0;
    rate = 100 - Osa_GetProcessCPU(linux_get_threadID_by_name(EXCEP_IDLETHREADNAME));
    zOss_AssertExN(rate <= 100);
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tϵͳCPUռΪ[%u%%]", rate);
    rate = 100 - rate;
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tϵͳCPUΪ[%u%%]", rate);    
#else
    FLOAT rate = 0;
    rate = 100 - Osa_GetProcessCPU(zOss_GetThreadIDByName(EXCEP_IDLETHREADNAME));
    zOss_AssertExN(rate <= 100);
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tϵͳCPUռΪ[%.2f%%]", rate);
    rate = 100 - rate;
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tϵͳCPUΪ[%.2f%%]", rate);
#endif
}

/**************************************************************************
* ƣ Shell_UpdateCpuTimerCallBack
*  ʱCPUʱص
* ˵
   (IN)
   arg:ʱص
*   ֵ
* ˵
**************************************************************************/
static VOID Shell_UpdateCpuTimerCallBack(SINT32 arg)
{
    Osa_UpdateCpu();
}

/**************************************************************************
* ƣ Shell_SetCpuUpdateTime
*  ޸ļCPUʱ
* ˵
   (IN)
   time_in_second:೤ʱһ߳CPU(λ),Χ2-10
*   ֵ
* ˵
**************************************************************************/
static VOID Shell_SetCpuUpdateTime(UINT32 time_in_second)
{
    UINT32 ret          = ZOSS_ERROR;
    UINT32 freshTime    = 0;
    
    if(NULL == gShell_UpdataCpuTimerId)
    {
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\t¼߳CPUʱ俪δ򿪣˹ܽ");
        return;
    }
    
    ret = zOss_StopTimer(gShell_UpdataCpuTimerId);  /* ֹͣʱ */
    if(ZOSS_ERROR == ret)
    {
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\tˢʱʧ");
        return;
    }
    
    freshTime = time_in_second * 1000;
    
    ret = zOss_StartTimer(gShell_UpdataCpuTimerId, freshTime, Shell_UpdateCpuTimerCallBack, 0); /* ʱ */
    if(ZOSS_ERROR == ret)
    {
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\tˢʱʧ");
    }
    else
    {
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\tˢʱóɹ");
    }
}

/**************************************************************************
* : Shell_ShowThread
* :
* ˵: (IN)
            pThreadInfo:߳ϸϢṹָ
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
static VOID Shell_ShowThread(T_ZOsa_ThreadUserArea *pThreadInfo)
{
    UINT8 index;
    CHAR status[][10] = {"RUN","READY","BLOCK","UNKNOW"};
    
    zOss_AssertExN(pThreadInfo != NULL);

    index = (pThreadInfo->runstatus)/2;
    if (index >= (sizeof(status) / sizeof(status[0])))
        index = (sizeof(status) / sizeof(status[0])) - 1;

    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-40s%p%11s%8u%10.2f%10u%10u%12u%8u%10u",
                pThreadInfo->threadname, pThreadInfo->threadid, status[index], 
                pThreadInfo->priority, pThreadInfo->cpupercent, pThreadInfo->stacksize, 
                pThreadInfo->maxstack, pThreadInfo->RunTimeInMs, pThreadInfo->msgnum, pThreadInfo->runcount);
}

/**************************************************************************
* : Shell_ShowThreadTitle
* :
* ˵: (IN)
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
static VOID Shell_ShowThreadTitle(VOID)
{
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-40s%-10s%11s%10s%12s%10s%10s%12s%8s%10s",
                "ThreadName", "ThreadID", "Status", "Priority", "CpuPercent", "StackSize", "MaxStack",
                "RunTimeInMs", "MsgNum", "RunCount");
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* : OSS_DbgShowThreadInfo
* :
* ˵: (IN) 
			CmdMsg:shell
			(OUT)
*   ֵ:
* ˵:
**************************************************************************/
VOID OSS_DbgShowThreadInfo(T_Shell_CommandMessage *CmdMsg)
{
	UINT32					thread_num			= 0;	/* ߳				*/
	ZOSS_THREAD_ID			*AllThreadIdArray	= NULL; /* ߳IDָ	*/
	T_ZOsa_ThreadUserArea	*pThreadInfo		= NULL; /* ߳UAָ			*/
	ZOSS_THREAD_ID			thread_id			= NULL;
	UINT32					i					= 0;
	
	zOss_AssertExN(CmdMsg != NULL);
	
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tThread Info");
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, SHELL_SIGN);
	
	switch (CmdMsg->paraCount)
	{
	case 0: 	/* ʾ߳Ϣ */
		{
#ifdef _OS_LINUX
			linux_thread_sched_stat(0);
#else
			Shell_ShowThreadTitle();
			thread_num = Osa_GetAllThreadId(&AllThreadIdArray); /* ռ */
			
			if (0 == thread_num)
			{
				break;
			}
			
			for (i = 0; i < thread_num; i++)
			{
				pThreadInfo = Osa_GetThreadUserArea(AllThreadIdArray[i], TRUE);
				if (pThreadInfo)
				{
					Shell_ShowThread(pThreadInfo);
				}
			}
			zOss_Free(AllThreadIdArray);
#endif
			break;
		}
	default:
		{
			if (CmdMsg->paraCount == 1 && 0 == strcmp((char *)CmdMsg->para[0], "help"))
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s : ʾ߳Ϣ", CmdMsg->cmd);
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\t %s  [thread_id]", CmdMsg->cmd);
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\t thread_idΪָ߳id,ָ,ʾ߳Ϣ");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tʾ˵:");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ThreadName:Ϊ߳");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ThreadID:߳ID");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t Status:״̬");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t Priority:߳ȼ");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t CpuPercent:߳ʹ");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t StackSize:ջС");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t MaxStack:ջʹ");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t RunTimeInMs:߳ջʱ");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t MsgNum:Ϣг");
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t RunCount:д");
			}
			else
			{
#ifdef  _OS_LINUX
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tLinuxϲֲ֧");
				return;
#else
				Shell_ShowThreadTitle();
				
				for (i = 0; i < CmdMsg->paraCount; i++)
				{
					if (-1 == Shell_StrisNumber(CmdMsg->para[i]))
					{
						zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tthread_idμ%s help\n", CmdMsg->cmd);
						return;
					} 
					thread_id = (ZOSS_THREAD_ID)strtoul((char *)CmdMsg->para[i], NULL, 0);
					if (NULL == thread_id)
					{
						zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tthread_idμ%s help\n", CmdMsg->cmd);
						return;
					}
					
					if (OSA_IdentifyThread(thread_id) != ZOSS_SUCCESS)
					{
						zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, " The thread 0x%08x is not exist!",thread_id);
						break;
					}
					
					pThreadInfo = Osa_GetThreadUserArea(thread_id, TRUE);
					if (pThreadInfo)
					{
						Shell_ShowThread(pThreadInfo);
					}
				}
#endif
			}
			break;
		}
	}
	
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, SHELL_SIGN);
}

VOID OSS_DbgShowTaskInfo(T_Shell_CommandMessage *CmdMsg)
{
    ZOSS_TASK_ID    *task_id_arr        = NULL;
    T_OSS_PARAM     *pPlatCfg           = NULL;
    ZOSS_TASK_ID    task_id             = NULL;
    T_ZOss_TCB      pCurTCB             = {0};
    UINT32          task_num            = 0;
    UINT32          i                   = 0;
    UINT32          nRet                = 0;
    UINT32          current_ticks       = 0;
    CHAR            run_stat_str[][6]   = {"ͣ","","",""};
    
    zOss_AssertExN(CmdMsg != NULL);

    if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:ʾϢ\n\t %s [taskname]:ʾϢ", CmdMsg->cmd, CmdMsg->cmd);
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ָʾϢSDL");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ʾ˵:");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t TaskName:Ϊ");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t TaskID:ID");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t Prior:ȼ");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ThreadID:ڵ߳ID");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t RunState:״̬ΪͣУ֮һ");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t LifeTime:Դڵtick");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t RunTimeInMs:ʱ");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t CpuPencent:cpuռ");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t MsgCounts:ϢлδϢ");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t RunCounts:񱻴һִеĴ");
        return;
    }
    
    current_ticks = zOss_GetTickCount();
    if (1 == CmdMsg->paraCount)
    {
        task_id = zOss_GetTaskID(CmdMsg->para[0]);
        
        if (task_id == ZOSS_INVALID_TASK_ID)
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t[ʧ]Ϊ%s !", CmdMsg->para[0]);
            return;
        }
        
        nRet = zOss_GetTaskInfo(task_id, &pCurTCB);
        if (nRet == ZOSS_ERROR)
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t[ʧ]ȡ%sϢʧ !", CmdMsg->para[0]);
            return;
        }
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tTask Info");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t===============================================================================================");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-30s %-10s %8s %-10s %10s %10s %10s %10s %10s %10s","TaskName","TaskID","Prior","ThreadID","RunState","LifeTime","RunTimeInMs","CpuPencent","MsgCounts","RunCounts");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-30s %p%8u  %-10p%8s%10u%10u%10f%10u%10u", pCurTCB.task_name, pCurTCB.task_id, pCurTCB.priority,
                    pCurTCB.thread_id, run_stat_str[pCurTCB.run_status - 1], current_ticks - pCurTCB.time, pCurTCB.runtime / 1000, pCurTCB.cpupercent, zOss_ListCount(&pCurTCB.msg_queue), pCurTCB.count);
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t===============================================================================================");
    }
    
    if (0 == CmdMsg->paraCount)
    {
        pPlatCfg = zOss_GetOssCfg();
        task_id_arr = (ZOSS_TASK_ID *)zOss_Malloc(pPlatCfg->TaskCfg.max_task_num * sizeof(ZOSS_TASK_ID));
        if (NULL == task_id_arr)
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tzOss_Malloc for task_id_arr failed!");
            return;
        }
        task_num = zOss_GetAllTaskID(task_id_arr);
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tTask Info");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t===============================================================================================");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-30s %-10s %8s %-10s %10s %10s %10s %10s %10s %10s","TaskName","TaskID","Prior","ThreadID","RunState","LifeTime","RunTimeInMs","CpuPencent","MsgCounts","RunCounts");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t===============================================================================================");
        
        for (i = 0; i < task_num; i++)
        {
            nRet = zOss_GetTaskInfo(task_id_arr[i], &pCurTCB);
            if (nRet == ZOSS_ERROR)
            {
                continue;   /* SDLҲǷش */
            }
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-30s %p%8u   %-10p%8s%10u%10u%10f%10u%10u", pCurTCB.task_name, pCurTCB.task_id, pCurTCB.priority,
                              pCurTCB.thread_id, run_stat_str[pCurTCB.run_status - 1],  current_ticks-pCurTCB.time, pCurTCB.runtime, pCurTCB.cpupercent, zOss_ListCount(&pCurTCB.msg_queue), pCurTCB.count);
        }
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t=============================================================================================");
        zOss_Free(task_id_arr);
    }
    return;
}

VOID OSS_DbgDisplayThreadExecInfo(T_Shell_CommandMessage *CmdMsg)
{
    ZOSS_THREAD_ID          tid         = ZOSS_INVALID_THREAD_ID;
    static ZOSS_TIMER_ID    freshTimer = NULL;
    
    zOss_AssertExN(CmdMsg != NULL);

    if(FALSE == gOsa_SwapTimeFlag)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t¼߳CPUʱ俪δ򿪣˹ܽ");
        return;
    }

    if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t÷:%s   ߳ID [time]", CmdMsg->cmd);
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t߳ID1016(ǰ׺0x0X)");    
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t timeΪѡʾˢʱ(λ:)Χ[1~10]timeֹͣˢ");
        return;
    }
    else if(1 == CmdMsg->paraCount || 2 == CmdMsg->paraCount)
    {
        if (-1 == Shell_StrisNumber(CmdMsg->para[0]))
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t");
            return;
        }                         
        tid = (ZOSS_THREAD_ID)strtoul((char *)CmdMsg->para[0], NULL, 0);
        if (ZOSS_INVALID_THREAD_ID == tid)
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t");
            return;
        }
        
        if (1 == CmdMsg->paraCount)
        {
            Shell_ThreadCPU((SINT32)tid);
            if (NULL != freshTimer)
            {
                zOss_KillTimer(freshTimer);
                freshTimer = NULL;
            }
            return;
        }
        
        if (2 == CmdMsg->paraCount)
        {
            UINT32 freshTime = 0;
            
            if (-1 == Shell_StrisNumber(CmdMsg->para[1]))
            {         
                return;
            }
            
            freshTime = strtoul((char *)CmdMsg->para[1], (char **)NULL, 0);
            if (freshTime < 1 || freshTime > 10)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t");
                return;
            }
            if (NULL != freshTimer)
            {
                zOss_KillTimer(freshTimer);
                freshTimer = NULL;
            }
            freshTimer = zOss_CreateTimer("Timer_ThreadCPUPrint", (ZOSS_TIMER_FUN)Shell_ThreadCPU, (SINT32)tid, TRUE);
            if (NULL == freshTimer)
            {
                return;
            }
            if (ZOSS_ERROR == zOss_StartTimer(freshTimer, (freshTime * 1000), (ZOSS_TIMER_FUN)Shell_ThreadCPU, (SINT32)tid))
            {
                zOss_KillTimer(freshTimer);
                freshTimer = NULL;
            }
        }
    }
    else
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t");
    }
}


VOID OSS_DbgDisplayThreadsExecInfo(T_Shell_CommandMessage *CmdMsg)
{
    UINT32                  type        = 0;
    UINT32                  timeLen     = 0;
    
    zOss_AssertExN(CmdMsg != NULL);
    
    if (FALSE == gOsa_SwapTimeFlag)
    {
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\t¼߳CPUʱ俪δ򿪣˹ܽ");
        return;
    }
    
    if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
    {
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t÷:%s live/lazy/all time1 [time2]", CmdMsg->cmd);
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t live:ֻʾ̣߳lazy:ֻʾ̣߳all:ʾ߳");    
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t time1ĳʱִ߳(λ:)Χ[0~10](oseƽ̨޸ù,Ϊ0), 0ʾȫʱڵִ߳");
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t time2Ϊѡʾˢʱ(λ:,time1Ϊ0ʱЧ)Χ[1~10]time2ֹͣˢ");
        return;
    }
    else if (2 == CmdMsg->paraCount || 3 == CmdMsg->paraCount)
    {
        if (0 == strcmp((char *)CmdMsg->para[0], "live"))
        {
            type |= SUP_THREAD_LIVE_BIT; /* ֻʾ߳     */
        }
        else if (0 == strcmp((char *)CmdMsg->para[0], "lazy"))
        {
            type |= SUP_THREAD_LAZY_BIT; /* ֻʾ߳   */
        }
        else if (0 == strcmp((char *)CmdMsg->para[0], "all"))
        {
            type = 0;                   /* ʾ߳         */
        }
        else
        {
            zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\t");
            return;
        }
        
        if (-1 == Shell_StrisNumber(CmdMsg->para[1]))
        {
            zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t");
            return;
        }                                     
        timeLen = strtoul((char *)CmdMsg->para[1], (char **)NULL, 0);

        if (1 <= timeLen && 10 >= timeLen)
        {
            type |= SUP_THREAD_STATISTIC_INFO_BIT;
        }
        else if (0 != timeLen)
        {
            zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\t");
            return;            
        }        
            
        if (2 == CmdMsg->paraCount)
        {
            if (0 != timeLen)
            {
#ifdef TOS_STATISTIC_TIMESLICE
                zOss_StatisticTimesliceStart(timeLen * 1000, type);
#endif
            }
            else
            {
                Shell_ThreadsCPU((SINT32)type);
            }
            
            if (NULL != gShell_FreshCpuTimerId)
            {
                zOss_KillTimer(gShell_FreshCpuTimerId);
                gShell_FreshCpuTimerId = NULL;
            }        
            return;
        }
        
        if (3 == CmdMsg->paraCount)
        {
            UINT32 freshTime = 0;
            
            if (0 != timeLen || -1 == Shell_StrisNumber(CmdMsg->para[2]))
            {
                zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t");
                return;
            }                                     
            freshTime = strtoul((char *)CmdMsg->para[2], (char **)NULL, 0);
            if (freshTime < 1 || freshTime > 10)
            {
                zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\t");
                return;
            }
            if (NULL != gShell_FreshCpuTimerId)
            {
                zOss_KillTimer(gShell_FreshCpuTimerId);
                gShell_FreshCpuTimerId = NULL;
            }
            gShell_FreshCpuTimerId = zOss_CreateTimer("Timer_ThreadsCPUPrint", (ZOSS_TIMER_FUN)Shell_ThreadsCPU, (long)type, TRUE);
            if (NULL == gShell_FreshCpuTimerId)
            {
                return;
            }
            if (ZOSS_ERROR == zOss_StartTimer(gShell_FreshCpuTimerId, (freshTime * 1000), (ZOSS_TIMER_FUN)Shell_ThreadsCPU, (long)type))
            {
                zOss_KillTimer(gShell_FreshCpuTimerId);
                gShell_FreshCpuTimerId = NULL;
            }
        }  
    }
    else
    {
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\t");
    }      
}

VOID OSS_DbgSetUpdateCPUTime(T_Shell_CommandMessage *CmdMsg)
{
    UINT32 new_time = 0;
    zOss_AssertExN(CmdMsg != NULL);

    if(FALSE == gOsa_SwapTimeFlag)
    {
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\t¼߳CPUʱ俪δ򿪣˹ܽ");
        return;
    }

    if (1 == CmdMsg->paraCount)
    {
        if (0 == strcmp((char *)CmdMsg->para[0], "help"))
        {
            zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t÷:%s time", CmdMsg->cmd);
            zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\t time:ˢʱҪ[1-10]֮");    
            return;
        }
        else if (0 == Shell_StrisNumber(CmdMsg->para[0]))
        {
            new_time = strtoul((char *)CmdMsg->para[0], NULL, 0);
            if (new_time >= 1 && new_time <= 10)
            {
                Shell_SetCpuUpdateTime(new_time);
                return;
            }
        }
    }
    
    zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\thelpѯ÷");

}

VOID OSS_DbgThreadSetFlag(T_Shell_CommandMessage *CmdMsg)
{
    BOOL        enableRunTime   = FALSE;
    T_OSS_PARAM *pPlatCfg       = NULL;
    
    zOss_AssertExN(CmdMsg != NULL);
    
    if (1 != CmdMsg->paraCount)
    {
        Shell_ThreadSetFlagUse(CmdMsg->cmd);
        return;
    }
    if (-1 == Shell_StrisNumber(CmdMsg->para[0]))
    {
        Shell_ThreadSetFlagUse(CmdMsg->cmd);
        return;
    }

    enableRunTime = (BOOL)strtoul((char *)CmdMsg->para[0], NULL, 0);

    Osa_SwapCtl(enableRunTime);
    
    if (enableRunTime)
    {
        UINT32 freshTime = 0;

        pPlatCfg    = zOss_GetOssCfg();
        freshTime   = pPlatCfg->ExcepCfg.UpdateCPUTime;
        
#ifdef _OS_TOS
# ifdef CYGOPT_KERNEL_EXTEND_CLOCK_STATISTIC_TIMESLICE
        cyg_set_statistic_counter_flag(TRUE);
# endif
# ifdef CYGOPT_KERNEL_EXTEND_THREAD_STATISTIC_TIMESLICE
        cyg_thread_set_statistic_timeslice_flag(TRUE);
# endif
#endif
        if (NULL != gShell_UpdataCpuTimerId)
        {
            zOss_KillTimer(gShell_UpdataCpuTimerId);
            gShell_UpdataCpuTimerId = NULL;
        }
        gShell_UpdataCpuTimerId = zOss_CreateTimer("Shell_UpdateCpuTimer", Shell_UpdateCpuTimerCallBack, 0, TRUE);
        if (NULL == gShell_UpdataCpuTimerId)
        {
            zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\t򿪼¼߳cpuʱ俪ʧ");
            return;
        }
        if (ZOSS_ERROR == zOss_StartTimer(gShell_UpdataCpuTimerId, freshTime, Shell_UpdateCpuTimerCallBack, 0))
        {
            zOss_KillTimer(gShell_UpdataCpuTimerId);
            gShell_UpdataCpuTimerId = NULL;
            zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_ABNORMAL, "\t򿪼¼߳cpuʱ俪ʧ");
        }
        else
        {
            zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\tɹ򿪼¼߳cpuʱ俪");
        }
        
    }
    else
    {
        UINT32                  i                   = 0;
        UINT32                  totalNum            = 0;
        T_ZOss_TCB              *pTCB               = NULL;
        ZOSS_TASK_ID            *taskIdArray        = NULL;
        ZOSS_THREAD_ID          *allThreadIdArray   = NULL;
        T_ZOsa_ThreadUserArea   *pThreadInfo        = NULL;

        if (NULL != gShell_UpdataCpuTimerId)
        {
            zOss_KillTimer(gShell_UpdataCpuTimerId);
            gShell_UpdataCpuTimerId = NULL;
        }
        if(NULL != gShell_FreshCpuTimerId)
        {
            zOss_KillTimer(gShell_FreshCpuTimerId);
            gShell_FreshCpuTimerId = NULL;
        }
#ifdef _OS_TOS
# ifdef CYGOPT_KERNEL_EXTEND_CLOCK_STATISTIC_TIMESLICE
        cyg_set_statistic_counter_flag(FALSE);
        cyg_zero_statistic_counter_value();
# endif
# ifdef CYGOPT_KERNEL_EXTEND_THREAD_STATISTIC_TIMESLICE
        cyg_thread_set_statistic_timeslice_flag(FALSE);
        cyg_thread_zero_all_statistic_timeslice();
# endif
#endif

#ifdef _OS_LINUX
        linux_reset_cpupinfo();
#else
        totalNum = Osa_GetAllThreadId(&allThreadIdArray);                
        for (i = 0; i < totalNum; i++)
        {
            pThreadInfo = Osa_GetThreadUserArea(allThreadIdArray[i], TRUE);
            if (pThreadInfo)
            {
                pThreadInfo->cputime        = 0;
                pThreadInfo->runtime        = 0;
                pThreadInfo->RunTimeInMs    = 0;
                pThreadInfo->runcount       = 0;
                pThreadInfo->cpupercent     = 0;
            }
        }
        zOss_Free(allThreadIdArray);
        
        pPlatCfg    = zOss_GetOssCfg();
        taskIdArray = (ZOSS_TASK_ID *)zOss_Malloc(pPlatCfg->TaskCfg.max_task_num * sizeof(ZOSS_TASK_ID));
        totalNum    = zOss_GetAllTaskID(taskIdArray);
        for (i = 0; i < totalNum; i++)
        {
            pTCB = (T_ZOss_TCB *)taskIdArray[i];
            if (pTCB != pTCB->task_id)
            {
                continue;
            }
            pTCB->cputime       = 0;
            pTCB->cpupercent    = 0;
            pTCB->runtime       = 0;
        }
        zOss_Free(taskIdArray);
#endif
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "\tɹرռ¼߳cpuʱ俪");
    }
}

VOID OSS_DbgGetSysCPU(T_Shell_CommandMessage *CmdMsg)
{
    static ZOSS_TIMER_ID sys_timer = NULL;
    
    zOss_AssertExN(CmdMsg != NULL);
    
    if(FALSE == gOsa_SwapTimeFlag)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t¼߳CPUʱ俪δ򿪣˹ܽ");
        return;
    }

    switch (CmdMsg->paraCount)
    {
    case 0:
        {
            Shell_PrintSysCPU();
            if (NULL != sys_timer)
            {
                zOss_KillTimer(sys_timer);
                sys_timer = NULL;
            }
            break;
        }   
    case 1:
        {
            UINT32 freshTime = 0;
            if (0 == strcmp((char *)CmdMsg->para[0], "help"))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t÷:%s [time]", CmdMsg->cmd);
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t timeΪѡʾˢʱ(λ:)Χ[1~10]timeֹͣˢ");
                break;
            }

            if (-1 == Shell_StrisNumber(CmdMsg->para[0]))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t");
                break;
            }
            freshTime = strtoul((char *)CmdMsg->para[0], (char **)NULL, 0);
            if (freshTime < 1 || freshTime > 10)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t");
                break;
            }
            if (NULL != sys_timer)
            {
                zOss_KillTimer(sys_timer);
                sys_timer = NULL;
            }
            sys_timer = zOss_CreateTimer("Timer_SysCPUPrint", (ZOSS_TIMER_FUN)Shell_PrintSysCPU, 0, TRUE);
            if (NULL == sys_timer)
            {
                break;
            }
            if (ZOSS_ERROR == zOss_StartTimer(sys_timer, (freshTime * 1000), (ZOSS_TIMER_FUN)Shell_PrintSysCPU, 0))
            {
                zOss_KillTimer(sys_timer);
                sys_timer = NULL;
            }
            break;
        }
    default:
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t");
            break;
        }
    }
}

/**************************************************************************
* : OSS_StartDaemonTask
* ˵:     
*           (IN)  CmdMsg: shellϢָ
*           (OUT) 
*   ֵ: 
* ˵: 
**************************************************************************/
VOID OSS_StartDaemonTask(T_Shell_CommandMessage *CmdMsg)
{
    if(0 == strcmp(CmdMsg->para[0], "help") && CmdMsg->paraCount == 1)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ѭ⣬;");
        return;
    }

    if (CmdMsg->paraCount != 0)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ;");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t %s help鿴Ĺ;", CmdMsg->cmd);
        return;
    }

    if(ZOSS_SUCCESS == EXCEP_StartDaemonTask())
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:ɹ", CmdMsg->cmd);

    }
    else
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:ʧ", CmdMsg->cmd);
    }

    return;
}

#ifdef __cplusplus
}
#endif

