/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       V1.0
 * Author:        wuhui
 * Date:          2016-9-6
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_CAM_H
#define _DRVS_CAM_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_general.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/
//#define ZDRV_DEV_CAMERA    "camera"       /* device name of camera */

typedef UINT32 PhyAddr;
typedef UINT8 *  T_HalCam_Buff_Addr;

/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum
{
	HAL_CAM_BUF_FREE= 0,	/* Buffer isn't full filled */
	HAL_CAM_BUF_READY= 1,
	HAL_CAM_BUF_BUSY= 2,
	MAX_HAL_CAM_BUF_FLAG =3
}T_HalCam_EBufFlag;
#if defined(_USE_RAW_BUFFER)
typedef struct
{
	T_HalCam_Buff_Addr	bufaddr;
	T_HalCam_EBufFlag	bufflag;
} T_HalSensor_Buff;
#endif
/* sensors */
typedef enum
{
	SENSOR_MAIN,	   /* main sensor */
	SENSOR_SUB, 	   /* sub sensor */
	MAX_SENSOR_ID
} T_ZDrv_SensorId;
typedef enum
{
    //SENSOR_OV9656,
    //SENSOR_OV7670,
    //SENSOR_MT9D113,
    //SENSOR_MT9V113,
    //SENSOR_HI704,
    #if defined(_USE_TYPE_GC6133)
	SENSOR_GC6133,
	#endif
	#if defined(_USE_TYPE_BF3A01CS)
	SENSOR_BF3A01CS,
	#endif
    MAX_SENSOR_DEV_TYPE
} T_ZDrv_Sensor_DevType;

/* sensor info */
typedef struct
{
	T_ZDrv_Sensor_DevType tDevType;	    /* the sensor now using*/
	T_ZDrv_SensorId tActivedSensor; 	/* the sensor now using*/
	UINT16			uiWidth;	  /* max pixel width of the actived sensor */
	UINT16			uiHeight;	  /* max pixel height of the actived sensor */
	UINT16          pixelBytes;
	BOOL 			fucSetZoom;            /*whether to support set_zoom function */
	BOOL 			fucSetImgSize; 		  /*whether to support set_img_Size function */
	BOOL 			fucSetEffect;          /*whether to support set_effect function */
	BOOL 			fucSetMirrorFlip;		/*whether to support set MirrorFlip function */
	BOOL 			fucSetBrightness;		/*whether to support set Brightness function */
	BOOL 			fucSetContrast;		/*whether to support SetContrast function */
	BOOL 			fucSetSaturation;		/*whether to support SetSaturation function */
	BOOL 			fucSetWhiteBalance;	/*whether to support SetWhiteBalance function */
	BOOL 			fucSetLightMode;		/*whether to support SetLightMode function */
	BOOL 			fucSetNightMode;		/*whether to support SetNightMode function */
	BOOL 			fucSetFrameRate;		/*whether to support SetFrameRate function */

	//BOOL            funcSetExposureCompensation;	/*whether to support ExposureCompensation function */
	BOOL            funcSetAntiFlicker; 

} T_ZDrv_SensorInfo;
/* camera frame rate*/
typedef enum
{
    Fps714  = 0,
    Fps75      ,
    Fps143     ,
    Fps15      ,
    Fps25      ,
    Fps30      ,
   
    MAX_FPS_SIZE
} T_ZDrv_CamFps;

/* output size */
typedef enum
{
    OUTPUT_IMG_SXGA =0,
    OUTPUT_IMG_VGA,
    OUTPUT_IMG_QVGA,
    OUTPUT_IMG_QQVGA,
    OUTPUT_IMG_CIF ,
    OUTPUT_IMG_QCIF,
    OUTPUT_IMG_QQCIF ,
    OUTPUT_IMG_USVGA,

    MAX_OUTPUT_IMG_SIZE
} T_ZDrv_CamOutputSize;

/* night mode */
typedef enum
{
    NIGHT_MODE_0,             /* level 0*/
    NIGHT_MODE_1,             /* level 1 */
    NIGHT_MODE_2,             /* level 2 */    

    MAX_NIGHT_MODE
} T_ZDrv_CamNightMode;

/* zomm level */
typedef enum
{
    ZOOM_LEVEL_0,             /* level 0  */
    ZOOM_LEVEL_1,             /* level 1 */
    ZOOM_LEVEL_2,             /* level 2 */
    ZOOM_LEVEL_3,             /* level 3 */
    ZOOM_LEVEL_4,             /* level 4 */

    MAX_ZOOM_LEVEL
} T_ZDrv_CamZoom;

/* brightness level */
typedef enum
{
    BRI_LEVEL_0 = 0,             /* level 0 (darkest) */
    BRI_LEVEL_1,             /* level 1 */
    BRI_LEVEL_2,             /* level 2 */
    BRI_LEVEL_3,             /* level 3 */
    BRI_LEVEL_4,             /* level 4  */
    BRI_LEVEL_5,			 /* level 5  */
    BRI_LEVEL_6,			 /* level 6  */

    MAX_BRI_LEVEL
} T_ZDrv_CamBrightness;

/* contrast level*/
typedef enum
{
    CON_LEVEL_0 = 0,           /* level 0 (thinnest) */
    CON_LEVEL_1,           /* level 1 */
    CON_LEVEL_2,           /* level 2 */
    CON_LEVEL_3,           /* level 3 */
    CON_LEVEL_4,           /* level 4 */
    CON_LEVEL_5,           /* level 5 */
    CON_LEVEL_6,           /* level 6 (sharpest) */
    
    MAX_CON_LEVEL
} T_ZDrv_CamContrast;

/* saturation level */
typedef enum
{
    SAT_LEVEL_0,
    SAT_LEVEL_1,
    SAT_LEVEL_2,
    SAT_LEVEL_3,
    SAT_LEVEL_4,
    
    MAX_SAT_LEVEL
} T_ZDrv_CamSaturation;

/* camera effect */
typedef enum
{
    EFF_NORMAL = 0,
    EFF_ANTIQUE,
    EFF_BLUISH,
    EFF_GREENISH,
    EFF_REDISH,
    EFF_YELLOW,
    EFF_NEGATIVE,
    EFF_BLACK_AND_WHITE,
    EFF_BW_NEGATIVE,
    EFF_SEPIA_GREEN,
    
    MAX_EFF_TYPE
} T_ZDrv_CamEffect;

/* camera whiteblance */
typedef enum
{
    WB_AUTO = 0,
    WB_INSCANDSENCE,
    WB_FLUORESCENT,//CWF
   // WB_FLUORECWF, //cool white FLUORESCENT
    WB_TUNGSTEN,
    WB_SUNNY,    
    WB_CLOUDY,

    MAX_WB_MODE
} T_ZDrv_CamWhiteBalance;

/* camera light mode */
typedef enum
{
    LIGTH_AUTO,     /* auto */
    LIGTH_SUNNY,    /* sunny */
    LIGTH_CLOUDY,   /* cloudy */
    LIGTH_OFFICE,   /* office */
    LIGTH_HOME,     /* home */
    LIGTH_NIGHT,    /* night */

    MAX_LIGTH_MODE
} T_ZDrv_CamLightMode;

/* exposure compesation  level */
typedef enum
{
    EV_NEG_4_3 = 0,               /*  EV -2    */
    EV_NEG_3_3,           	  /*  EV -1.5 */
    EV_NEG_2_3,            	  /*  EV -1    */
    EV_NEG_1_3,            	  /*  EV -0.5 */
    EV_ZERO,            	  /*  EV 0      */
    EV_POS_1_3,            	  /*  EV +0.5 */
	EV_POS_2_3, 			  /*  EV +1    */
	EV_POS_3_3,            	  /*  EV +1.5 */
	EV_POS_4_3,            	  /*  EV +2 */

    MAX_EV_LEVEL
} T_ZDrv_CamExpCom;

typedef enum
{
    HAL_CAM_WORD_MODE_YUV,
    HAL_CAM_WORD_MODE_RGB,
    
    MAX_HAL_CAM_WORD_MODE
}T_HalCam_EWorkMode;

typedef struct
{
   PhyAddr *Y;
   PhyAddr *Cb;
   PhyAddr *Cr;  
}T_ZDrv_YuvBuf;

/* Image data buffer */
typedef union
{
    T_ZDrv_YuvBuf  YuvBuf;
    PhyAddr *streamDataBuf;
    PhyAddr*ARGBdataBuf;
} T_ZDrv_ImageDataBuf;
/* Pixel format. */
typedef enum
{
    PIXEL_YCbCr400,
    PIXEL_YCbCr420,
    PIXEL_YUYV,
//    PIXEL_YCbCr422 = PIXEL_YUYV,
//    PIXEL_YCbCr422H = PIXEL_YUYV,
//    PIXEL_YCbCr422V = PIXEL_YUYV,
    PIXEL_YCbCr444,
    PIXEL_RGB_PLANAR,
    PIXEL_RGB555,
    PIXEL_RGB565,
    PIXEL_RGB666,
    PIXEL_RGB888,
    PIXEL_ARGB888,
    
    MAX_PIXEL_FORMAT
} T_ZDrv_PixelFmt;

/* camera data info */
typedef struct
{
    T_ZDrv_ImageDataBuf  dataBuf;  /* image data buffer */
    UINT32 Width;                  /* image width */
    UINT32 Height;                 /* image height */
    T_ZDrv_PixelFmt  pixeFmt;      /* pixel format */
} T_ZDrv_CamDataInfo;

typedef struct
{
    UINT32     ySize;
    UINT32     uSize;
    UINT32     vSize;
   
} T_ZDrv_YuvBufSize;

/* Image buffer size */
typedef union
{
    T_ZDrv_YuvBufSize  YuvBufSize;
    UINT32   streamBufSize;
    UINT32   ARGBBufSize;
} T_ZDrv_ImageBufSzie;

/* mirror type */
typedef enum
{
    MIR_NONE,
    MIR_V,
    MIR_H,
    MIR_V_H,
    
    MAX_MIR_TYPE
} T_ZDrv_MirrorType;

typedef enum
{
    FLICKER_50HZ,
	FLICKER_60HZ,
   
    MAX_FLICKER_TYPE
} T_ZDrv_AntiFlicker;


/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/


#endif/*_FILENAME_H*/

